/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.rest;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.jetbrains.bundle.hub_client.util.validation.ErrorInfo;
import com.jetbrains.bundle.hub_client.util.validation.ValidationException;
import com.jetbrains.bundle.hub_client.util.validation.ValidationResult;
import com.jetbrains.installer.model.BundleDefaults;
import com.jetbrains.installer.model.StepsInfo;
import com.jetbrains.installer.model.WizardBackendConfig;
import com.jetbrains.installer.model.WizardInfo;
import com.jetbrains.installer.model.blocks.AdditionalKeystoreWrapper;
import com.jetbrains.installer.model.blocks.LicenseKeyInfo;
import com.jetbrains.installer.model.blocks.UpgradeSettings;
import com.jetbrains.installer.model.blocks.UpgradeSource;
import com.jetbrains.installer.validation.BundleUpgradeHelper;
import com.jetbrains.installer.validation.TypeDetectionResult;
import com.jetbrains.installer.validation.UpgradeSourceValidationResult;
import com.jetbrains.installer.validation.UpgradeValidationException;
import com.jetbrains.installer.validation.ValidationError;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.util.Collections;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(produces={"application/json"}, value={"/wizard/upgrade-source"})
public class UpgradeSourceResource {
    public static final String ID = "upgrade-source";
    @Resource(name="upgradeSource")
    private UpgradeSource upgradeSource;
    @Resource(name="upgradeSettings")
    private UpgradeSettings upgradeSettings;
    @Resource(name="defaultUpgradeSettings")
    private UpgradeSettings defaultUpgradeSettings;
    @Resource(name="defaultUpgradeLicenseKeyInfo")
    private LicenseKeyInfo defaultUpgradeLicenseKeyInfo;
    @Resource(name="licenseKeyInfo")
    LicenseKeyInfo licenseKeyInfo;
    @Resource(name="upgradeMode")
    private AtomicBoolean upgradeMode;
    @Autowired
    WizardBackendConfig config;
    @Autowired
    BundleDefaults bundleDefaults;
    @Autowired
    private BundleUpgradeHelper upgradeHelper;
    @Autowired
    private StepsInfo stepsInfo;
    @Autowired
    private OldUpgradeDataInfo oldUpgradeDataInfo;
    @Autowired
    private WizardBackendConfig wizardBackendConfig;
    @Autowired
    private WizardInfo wizardInfo;
    @Autowired
    private AdditionalKeystoreWrapper additionalKeystoreWrapper;
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public synchronized UpgradeSource post(@RequestBody UpgradeSource data) throws IOException {
        this.upgradeMode.set(true);
        String location = data.getSourceLocation();
        UpgradeSource.Type type = this.getUpgradeSourceType(location);
        UpgradeSourceValidationResult result = this.upgradeHelper.validate(type, location);
        ValidationResult errors = result.getValidationResult();
        if (errors.hasErrors()) {
            throw new ValidationException(errors);
        }
        Path preparedLocation = result.getPreparedSourceLocation();
        if (preparedLocation == null) {
            ValidationResult validationResult = new ValidationResult();
            String errorMessage = "Prepared upgrade source location not defined!";
            ErrorInfo errorInfo = ValidationError.UPGRADE_LOCATION_PROCESSING_ERROR.toErrorInfo(Collections.singletonMap("error", errorMessage), errorMessage, "sourceLocation");
            validationResult.addError(errorInfo);
            throw new ValidationException(validationResult);
        }
        UpgradeSettings settings = this.upgradeHelper.extractSettings(type, preparedLocation, result.getProperties(), errors);
        if (settings == null || errors.hasErrors()) {
            throw new ValidationException(errors);
        }
        try {
            this.additionalKeystoreWrapper.getKeystore().importKeyStore(settings.getContext().getKeystorePath(), settings.getContext().getKeystorePassword());
        }
        catch (KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            this.LOG.warn("Failed to import keystore from upgrade source", (Throwable)e);
        }
        this.upgradeSource.setPreparedSourceLocation(preparedLocation);
        this.upgradeSource.setType(type);
        this.upgradeSource.setSourceLocation(location);
        this.defaultUpgradeSettings.copyFrom(settings);
        Properties extractedProperties = settings.getContext().getExtractedProperties();
        LicenseKeyInfo extractedKeysInfo = LicenseKeyInfo.resolveKnownKeysFromProperties(extractedProperties, this.licenseKeyInfo);
        this.defaultUpgradeLicenseKeyInfo.clearKey();
        this.defaultUpgradeLicenseKeyInfo.addKeysFrom(extractedKeysInfo);
        this.licenseKeyInfo.updateKeysFrom(extractedKeysInfo);
        this.upgradeSettings.copyFrom(settings);
        this.stepsInfo.markChanged(ID);
        return this.upgradeSource;
    }

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public UpgradeSource get() {
        return this.upgradeSource;
    }

    @RequestMapping(value={"/check"}, method={RequestMethod.GET})
    @ResponseBody
    public synchronized void checkPath(@RequestParam(value="path") String path, @RequestParam(value="property") String property) throws ValidationException {
        UpgradeSource.Type type = this.getUpgradeSourceType(path);
        ValidationResult validationResult = this.upgradeHelper.checkPath(type, path);
        if (validationResult.hasErrors()) {
            throw new ValidationException(validationResult);
        }
    }

    @NotNull
    private UpgradeSource.Type getUpgradeSourceType(@RequestParam(value="path") String path) {
        TypeDetectionResult typeDetectionResult = this.upgradeHelper.detectType(path);
        if (typeDetectionResult.getValidationResult().hasErrors()) {
            throw new ValidationException(typeDetectionResult.getValidationResult());
        }
        UpgradeSource.Type type = typeDetectionResult.getType();
        if (type == null) {
            ValidationResult validationResult = new ValidationResult();
            validationResult.addError(ValidationError.CANNOT_DETECT_UPGRADE_LOCATION_TYPE.toErrorInfo("type"));
            throw new ValidationException(validationResult);
        }
        return type;
    }

    @RequestMapping(value={"/clean"}, method={RequestMethod.POST})
    @ResponseBody
    public OldUpgradeDataInfo cleanOldUpgradeData() {
        if (this.oldUpgradeDataInfo.getCompleted()) {
            ValidationResult validationResult = new ValidationResult();
            validationResult.addError(ValidationError.OLD_UPGRADE_DATA_ALREADY_REMOVED.toErrorInfo("sourceLocation"));
            throw new ValidationException(validationResult);
        }
        try {
            Path installationDir = Paths.get(this.wizardBackendConfig.getInstallationDirectory(), new String[0]);
            String backupPathString = this.oldUpgradeDataInfo.getBackupPath();
            Path backupPath = backupPathString != null ? Paths.get(backupPathString, new String[0]) : null;
            this.upgradeHelper.backupAndCleanOldUpgradeData(installationDir, backupPath);
            this.oldUpgradeDataInfo.setCompleted(true);
            this.wizardInfo.revalidateDetectedUpgradeSource(this.upgradeHelper);
            return this.oldUpgradeDataInfo;
        }
        catch (UpgradeValidationException e) {
            ValidationResult validationResult = new ValidationResult();
            validationResult.addError(e.getErrorInfo());
            throw new ValidationException(validationResult);
        }
    }

    @RequestMapping(value={"/clean"}, method={RequestMethod.GET})
    @ResponseBody
    public OldUpgradeDataInfo getOldUpgradeDataInfo() {
        return this.oldUpgradeDataInfo;
    }

    public static class OldUpgradeDataInfo {
        public static final String ID = "clean";
        public static final String COMPLETED_PROPERTY = "completed";
        public static final String BACKUP_PATH_PROPERTY = "backupPath";
        @JsonIgnore
        private boolean completed = false;
        @JsonProperty(value="backupPath")
        private String backupPath;

        @JsonProperty(value="completed")
        public boolean getCompleted() {
            return this.completed;
        }

        @JsonIgnore
        public void setCompleted(boolean completed) {
            this.completed = completed;
        }

        public String getBackupPath() {
            return this.backupPath;
        }

        public void setBackupPath(String backupPath) {
            this.backupPath = backupPath;
        }
    }
}

