/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.rest;

import com.jetbrains.bundle.hub_client.util.validation.ValidationException;
import com.jetbrains.bundle.hub_client.util.validation.ValidationResult;
import com.jetbrains.installer.model.BundleDefaults;
import com.jetbrains.installer.model.TestEndpoint;
import com.jetbrains.installer.model.WizardBackendConfig;
import com.jetbrains.installer.model.blocks.BasicSettings;
import com.jetbrains.installer.model.blocks.BlockService;
import com.jetbrains.installer.model.blocks.DumpContext;
import com.jetbrains.installer.model.blocks.DumpableBlock;
import com.jetbrains.installer.model.blocks.UpgradeSettings;
import com.jetbrains.installer.model.blocks.UpgradeSource;
import com.jetbrains.installer.validation.BundleUpgradeHelper;
import com.jetbrains.installer.validation.ValidationEndpointsManager;
import com.jetbrains.installer.validation.ValidationError;
import com.jetbrains.service.util.BundleProperty;
import com.jetbrains.service.util.SecureMode;
import com.jetbrains.service.util.UrlUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(produces={"application/json"}, value={"/wizard/wait"})
public class WaitResource {
    public static final String ID = "wait";
    @Resource(name="isFinished")
    private AtomicBoolean isFinished;
    @Resource(name="upgradeMode")
    private AtomicBoolean upgradeMode;
    @Resource(name="basicSettings")
    private BasicSettings basicSettings;
    @Autowired
    private BlockService service;
    @Autowired
    WizardBackendConfig wizardBackendConfig;
    @Autowired
    private BundleUpgradeHelper upgradeHelper;
    @Autowired
    ValidationEndpointsManager validationEndpointsManager;
    @Resource(name="upgradeSettings")
    private UpgradeSettings upgradeSettings;
    @Resource(name="upgradeSource")
    private UpgradeSource upgradeSource;
    @Resource(name="defaultUpgradeSettings")
    private UpgradeSettings defaultUpgradeSettings;
    @Autowired
    private BundleDefaults bundleDefaults;
    private String urlToShowAfterCompletionDerivedFromBaseUrl;
    private String urlToShowAfterCompletionDerivedFromUrlUserOpenedWizardBy;
    private String listenAddress;
    private String listenPort;
    private String secureMode;

    @RequestMapping(value={"/dump"}, method={RequestMethod.POST})
    @ResponseBody
    public Map<String, String> dump(HttpServletRequest request) throws IOException {
        if (this.upgradeMode.get()) {
            ValidationResult validationResult = new ValidationResult();
            Path preparedSourceLocation = this.upgradeSource.getPreparedSourceLocation();
            if (preparedSourceLocation == null) {
                String message = "Invalid upgrade source location";
                validationResult.addError(ValidationError.UPGRADE_LOCATION_PROCESSING_ERROR.toErrorInfo(Collections.singletonMap("error", message), "dataDir"));
                throw new ValidationException(validationResult);
            }
            validationResult = this.upgradeHelper.prepareUpdate(this.upgradeSource.getType(), this.upgradeSettings, preparedSourceLocation);
            if (validationResult.hasErrors()) {
                throw new ValidationException(validationResult);
            }
        }
        HashMap<String, String> result = new HashMap<String, String>();
        if (!this.isFinished.get()) {
            this.releaseTemporaryResources();
            List<DumpableBlock> blocks = this.getDumpableBlocks(request);
            this.service.persist(blocks);
            this.isFinished.set(true);
        }
        result.put("dump", "success");
        return result;
    }

    @NotNull
    private List<DumpableBlock> getDumpableBlocks(final HttpServletRequest request) {
        List<DumpableBlock> blocks = this.service.getBlocks(this.upgradeMode.get());
        blocks.add(new DumpableBlock(){

            @Override
            public void dump(@NotNull Properties properties, @NotNull DumpContext dumpContext) {
                String referer = request.getHeader("Referer");
                if (referer != null) {
                    properties.put("wizard-actual-client-url", referer);
                }
            }
        });
        return blocks;
    }

    private void releaseTemporaryResources() {
        this.upgradeHelper.clearTemporaryFiles();
        this.validationEndpointsManager.stopAllEndpoints();
    }

    @RequestMapping(value={"/ping"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, String> ping() throws IOException {
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("ping", "success");
        return result;
    }

    @RequestMapping(value={"/url"}, method={RequestMethod.GET})
    @ResponseBody
    public Map<String, Object> getUrlToShowAfterCompletion(HttpServletRequest request) throws IOException {
        TestEndpoint.State testEndpointState;
        TestEndpoint.BaseUrlBackendAccessState baseUrlBackendAccessState;
        boolean isBaseUrlAccessibleFromWizard;
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (this.urlToShowAfterCompletionDerivedFromBaseUrl == null || this.urlToShowAfterCompletionDerivedFromUrlUserOpenedWizardBy == null || this.listenAddress == null || this.listenPort == null || this.secureMode == null) {
            List<DumpableBlock> blocks = this.getDumpableBlocks(request);
            Properties configuredProperties = this.service.dump(blocks);
            this.urlToShowAfterCompletionDerivedFromBaseUrl = this.resolveUrlToShowAfterCompletion(configuredProperties);
            this.urlToShowAfterCompletionDerivedFromUrlUserOpenedWizardBy = this.resolveUrlToShowAfterCompletionDerivedFromUrlUserAccessWizardBy(configuredProperties, request);
            this.listenAddress = configuredProperties.containsKey(BundleProperty.LISTEN_ADDRESS.getPrefixedName()) ? configuredProperties.getProperty(BundleProperty.LISTEN_ADDRESS.getPrefixedName()) : this.bundleDefaults.getListenAddress();
            this.listenPort = configuredProperties.containsKey(BundleProperty.LISTEN_PORT.getPrefixedName()) ? configuredProperties.getProperty(BundleProperty.LISTEN_PORT.getPrefixedName()) : this.bundleDefaults.getBundleListenPort();
            this.secureMode = configuredProperties.containsKey(BundleProperty.SECURE_MODE.getPrefixedName()) ? configuredProperties.getProperty(BundleProperty.SECURE_MODE.getPrefixedName()) : this.bundleDefaults.getSecureMode().getName();
        }
        result.put("urlToShowAfterCompletion", this.urlToShowAfterCompletionDerivedFromBaseUrl);
        result.put("urlToShowAfterCompletionContext", this.wizardBackendConfig.getUrlToShowAfterCompletionContext());
        result.put("urlToShowAfterCompletionDerivedFromUrlUserOpenedWizardBy", this.urlToShowAfterCompletionDerivedFromUrlUserOpenedWizardBy);
        if (this.upgradeMode.get()) {
            isBaseUrlAccessibleFromWizard = this.upgradeSettings.getBaseUrlAccessibleFromWizard();
            baseUrlBackendAccessState = this.upgradeSettings.getBaseUrlBackendAccessState();
            testEndpointState = this.upgradeSettings.getTestEndpointState();
        } else {
            isBaseUrlAccessibleFromWizard = this.basicSettings.getBaseUrlAccessibleFromWizard();
            baseUrlBackendAccessState = this.basicSettings.getBaseUrlBackendAccessState();
            testEndpointState = this.basicSettings.getTestEndpointState();
        }
        result.put("baseUrlAccessibleFromWizard", Boolean.TRUE.equals(isBaseUrlAccessibleFromWizard));
        if (baseUrlBackendAccessState != null) {
            result.put("baseUrlBackendAccessState", baseUrlBackendAccessState.name());
        }
        if (testEndpointState != null) {
            result.put("testEndpointState", testEndpointState.name());
        }
        result.put("listenAddressAfterCompletion", this.listenAddress);
        result.put("listenPortAfterCompletion", this.listenPort);
        result.put("secureMode", this.secureMode);
        return result;
    }

    String resolveUrlToShowAfterCompletion(Properties configuredProperties) throws MalformedURLException {
        URL resultRedirectUrl;
        URL predefinedRedirectUrl = new URL(this.wizardBackendConfig.getUrlToShowAfterCompletion());
        if (configuredProperties.containsKey(BundleProperty.BASE_URL.getPrefixedName())) {
            String predefinedRedirectUrlContext = this.wizardBackendConfig.getUrlToShowAfterCompletionContext();
            URL baseUrlSetByUser = new URL(configuredProperties.getProperty(BundleProperty.BASE_URL.getPrefixedName()));
            resultRedirectUrl = new URL(baseUrlSetByUser.getProtocol(), baseUrlSetByUser.getHost(), baseUrlSetByUser.getPort(), UrlUtil.ensureEndsWithSlash((String)baseUrlSetByUser.getFile()) + UrlUtil.ensureStartsWithoutSlash((String)predefinedRedirectUrlContext));
        } else {
            resultRedirectUrl = this.wizardBackendConfig.isUrlToShowDependsOnBundlePort() && configuredProperties.containsKey(BundleProperty.LISTEN_PORT.getPrefixedName()) ? new URL(predefinedRedirectUrl.getProtocol(), predefinedRedirectUrl.getHost(), Integer.parseInt(configuredProperties.getProperty(BundleProperty.LISTEN_PORT.getPrefixedName())), predefinedRedirectUrl.getFile()) : predefinedRedirectUrl;
        }
        return resultRedirectUrl.toString();
    }

    String resolveUrlToShowAfterCompletionDerivedFromUrlUserAccessWizardBy(@NotNull Properties configuredProperties, HttpServletRequest request) throws MalformedURLException {
        String configuredListenPort;
        int port = configuredProperties.containsKey(BundleProperty.LISTEN_PORT.getPrefixedName()) ? ((configuredListenPort = configuredProperties.getProperty(BundleProperty.LISTEN_PORT.getPrefixedName())).equals(this.bundleDefaults.getBundleListenPort()) ? request.getServerPort() : Integer.parseInt(configuredListenPort)) : request.getServerPort();
        String predefinedRedirectUrlContext = this.wizardBackendConfig.getUrlToShowAfterCompletionContext();
        String filePath = configuredProperties.containsKey(BundleProperty.BASE_URL.getPrefixedName()) ? UrlUtil.ensureEndsWithSlash((String)new URL(configuredProperties.getProperty(BundleProperty.BASE_URL.getPrefixedName())).getFile()) + UrlUtil.ensureStartsWithoutSlash((String)predefinedRedirectUrlContext) : UrlUtil.ensureStartsWithoutSlash((String)new URL(this.wizardBackendConfig.getUrlToShowAfterCompletion()).getFile());
        URL resultRedirectUrl = new URL(this.isTlsEnabled(configuredProperties) ? "https" : request.getScheme(), request.getServerName(), port, filePath);
        return resultRedirectUrl.toString();
    }

    private boolean isTlsEnabled(@NotNull Properties configuredProperties) {
        return SecureMode.TLS.getName().equals(configuredProperties.getProperty(BundleProperty.SECURE_MODE.getPrefixedName()));
    }
}

