/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.util;

import com.jetbrains.service.util.DeleteFileVisitor;
import java.io.IOException;
import java.nio.file.DirectoryNotEmptyException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TreeConverter {
    private static final Logger LOG = LoggerFactory.getLogger((String)TreeConverter.class.getName());
    private TreeMap<Path, Path> rules = new TreeMap(new ChildrenFirstPathComparator());

    public TreeConverter(@NotNull Map<Path, Path> rules) {
        for (Path path : rules.keySet()) {
            Path srcPath;
            Path destPath = rules.get(path);
            if (destPath != null) {
                if (destPath.getParent() == null) {
                    throw new IllegalArgumentException(String.format("Cannot use file system root as destination path in the rule: '%s'", destPath));
                }
                destPath = destPath.toAbsolutePath();
            }
            if ((srcPath = path.toAbsolutePath()).getParent() == null) {
                throw new IllegalArgumentException(String.format("Cannot use file system root as source path in the rule: '%s'", srcPath));
            }
            this.rules.put(srcPath, destPath);
        }
    }

    public void convert() throws IOException {
        if (this.isEqualConversion()) {
            LOG.debug("Skipping equivalent conversion with the following rules: " + this.rules.toString());
            return;
        }
        TreeMap<Path, Path> inverseRules = new TreeMap<Path, Path>(new ParentsFirstPathComparator());
        NavigableSet<Path> srcPaths = this.rules.navigableKeySet();
        for (Path srcPath : srcPaths) {
            Path destPath = this.rules.get(srcPath);
            if (destPath == null) continue;
            if (inverseRules.get(destPath = destPath.toAbsolutePath()) != null) {
                throw new IllegalStateException(String.format("Collision: at least 2 paths converted to the same destination '%s'", destPath));
            }
            inverseRules.put(destPath, srcPath);
        }
        NavigableSet<Path> destPaths = inverseRules.navigableKeySet();
        TreeMap<Path, Path> srcToTmp = new TreeMap<Path, Path>(new ChildrenFirstPathComparator());
        Iterator<Path> iterator = srcPaths.iterator();
        while (iterator.hasNext()) {
            Path srcPath;
            Path independentParent = srcPath = iterator.next();
            Path destPath = this.rules.get(srcPath);
            if (destPath != null) {
                SortedSet<Path> parentAndUnrelatedSrcPaths = srcPaths.tailSet(independentParent);
                boolean newParentFound = true;
                block11: while (newParentFound) {
                    newParentFound = false;
                    for (Path path : parentAndUnrelatedSrcPaths) {
                        if (independentParent.equals(path) || !independentParent.startsWith(path)) continue;
                        independentParent = path;
                        parentAndUnrelatedSrcPaths = srcPaths.tailSet(independentParent);
                        newParentFound = true;
                        continue block11;
                    }
                }
                for (Path path : destPaths) {
                    if (!independentParent.startsWith(path)) continue;
                    independentParent = path;
                }
                if (Files.isRegularFile(independentParent, new LinkOption[0])) {
                    independentParent = independentParent.getParent();
                }
                Path tmpPath = independentParent.resolve(srcPath.getFileName() + ".tmp_" + UUID.randomUUID());
                srcToTmp.put(srcPath, tmpPath);
                Files.createDirectories(tmpPath.getParent(), new FileAttribute[0]);
                this.moveOrCopyAndDelete(srcPath, tmpPath, srcToTmp.values());
                continue;
            }
            this.deleteFileOrFolder(srcPath, srcToTmp.values());
        }
        for (Path destPath : destPaths) {
            Path srcPath = (Path)inverseRules.get(destPath);
            Path tmpPath = (Path)srcToTmp.get(srcPath);
            if (Files.exists(destPath, new LinkOption[0])) {
                String message;
                if (Files.isDirectory(tmpPath, new LinkOption[0])) {
                    if (Files.isDirectory(destPath, new LinkOption[0])) {
                        if (!TreeConverter.isEmptyDirectory(destPath, srcToTmp.values())) {
                            message = String.format("Collision: directory '%s' ('%s') cannot be moved, destination '%s' exists and it is not empty directory", tmpPath, srcPath, destPath);
                            throw new IllegalStateException(message);
                        }
                        DirectoryStream<Path> stream = Files.newDirectoryStream(tmpPath);
                        Throwable throwable = null;
                        try {
                            for (Path child : stream) {
                                Path relativeChild = child.isAbsolute() ? tmpPath.relativize(child) : child;
                                this.moveOrCopyAndDelete(tmpPath.resolve(relativeChild), destPath.resolve(relativeChild));
                            }
                            Files.deleteIfExists(tmpPath);
                            continue;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            if (stream == null) continue;
                            if (throwable != null) {
                                try {
                                    stream.close();
                                }
                                catch (Throwable throwable3) {
                                    throwable.addSuppressed(throwable3);
                                }
                                continue;
                            }
                            stream.close();
                            continue;
                        }
                    }
                    message = String.format("Collision: directory '%s' ('%s') cannot be moved, destination '%s' exists", tmpPath, srcPath, destPath);
                    throw new IllegalStateException(message);
                }
                message = String.format("Collision: file '%s' ('%s') cannot be moved, destination '%s' exists", tmpPath, srcPath, destPath);
                throw new IllegalStateException(message);
            }
            Files.createDirectories(destPath.getParent(), new FileAttribute[0]);
            this.moveOrCopyAndDelete(tmpPath, destPath);
        }
        for (Path srcPath : srcPaths) {
            if (!Files.exists(srcPath, new LinkOption[0]) || !Files.isDirectory(srcPath, new LinkOption[0]) || !TreeConverter.isEmptyDirectory(srcPath, null) || this.isMountPoint(srcPath) || destPaths.contains(srcPath)) continue;
            Files.deleteIfExists(srcPath);
        }
    }

    boolean isEqualConversion() {
        for (Path sourcePath : this.rules.navigableKeySet()) {
            if (sourcePath.equals(this.rules.get(sourcePath))) continue;
            return false;
        }
        return true;
    }

    private void deleteFileOrFolder(@NotNull Path srcPath, @Nullable Collection<Path> exclusions) throws IOException {
        if (Files.isDirectory(srcPath, new LinkOption[0])) {
            if (this.isMountPoint(srcPath)) {
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(srcPath, TreeConverter.getExclusionsFilter(exclusions));){
                    for (Path child : stream) {
                        this.deleteFileOrFolder(child, exclusions);
                    }
                }
            } else {
                Files.walkFileTree(srcPath, (FileVisitor<? super Path>)new DeleteFileVisitor(exclusions));
            }
        } else {
            Files.deleteIfExists(srcPath);
        }
    }

    private void moveOrCopyAndDelete(@NotNull Path srcPath, @NotNull Path destPath) throws IOException {
        this.moveOrCopyAndDelete(srcPath, destPath, null);
    }

    private void moveOrCopyAndDelete(final @NotNull Path srcPath, final @NotNull Path destPath, @Nullable Collection<Path> exclusions) throws IOException {
        block32: {
            if (this.isMountPoint(srcPath)) {
                Files.createDirectories(destPath, new FileAttribute[0]);
                try (DirectoryStream<Path> stream = Files.newDirectoryStream(srcPath, TreeConverter.getExclusionsFilter(exclusions));){
                    for (Path child : stream) {
                        Path relativeChild = child.isAbsolute() ? srcPath.relativize(child) : child;
                        this.moveOrCopyAndDelete(srcPath.resolve(relativeChild), destPath.resolve(relativeChild));
                    }
                }
                return;
            }
            try {
                if (!destPath.equals(srcPath) && destPath.startsWith(srcPath)) {
                    if (Files.isDirectory(srcPath, new LinkOption[0])) {
                        Files.createDirectories(destPath, new FileAttribute[0]);
                    }
                    try (DirectoryStream<Path> stream = Files.newDirectoryStream(srcPath, TreeConverter.getExclusionsFilter(exclusions));){
                        for (Path child : stream) {
                            Path relativeChild = child.isAbsolute() ? srcPath.relativize(child) : child;
                            this.moveOrCopyAndDelete(srcPath.resolve(relativeChild), destPath.resolve(relativeChild));
                        }
                        break block32;
                    }
                }
                Files.createDirectories(destPath.getParent(), new FileAttribute[0]);
                Files.move(srcPath, destPath, StandardCopyOption.REPLACE_EXISTING);
            }
            catch (DirectoryNotEmptyException e) {
                LOG.debug(String.format("Cannot move %s to %s because of DirectoryNotEmptyException. Will try to copy and delete method.", srcPath, destPath));
                Files.walkFileTree(srcPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path directory, BasicFileAttributes attrs) throws IOException {
                        Path targetDirectory = destPath.resolve(srcPath.relativize(directory));
                        if (!Files.exists(targetDirectory, new LinkOption[0])) {
                            Files.copy(directory, targetDirectory, StandardCopyOption.COPY_ATTRIBUTES, LinkOption.NOFOLLOW_LINKS);
                        }
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Path targetFile = destPath.resolve(srcPath.relativize(file));
                        if (!Files.exists(targetFile, new LinkOption[0])) {
                            Files.copy(file, destPath.resolve(srcPath.relativize(file)), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
                Files.walkFileTree(srcPath, (FileVisitor<? super Path>)new DeleteFileVisitor());
            }
        }
    }

    private boolean isMountPoint(@NotNull Path path) throws IOException {
        Path parent = path.getParent();
        return Files.isDirectory(path, new LinkOption[0]) && (parent == null || !Files.getFileStore(path).equals(Files.getFileStore(parent)));
    }

    private static boolean isEmptyDirectory(@NotNull Path dir, @Nullable Collection<Path> exclusions) throws IOException {
        DirectoryStream.Filter<Path> filter = TreeConverter.getExclusionsFilter(exclusions);
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir, filter);){
            boolean bl = !stream.iterator().hasNext();
            return bl;
        }
    }

    @NotNull
    private static DirectoryStream.Filter<Path> getExclusionsFilter(final @Nullable Collection<Path> exclusions) {
        return new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path pathname) {
                return exclusions == null || !exclusions.contains(pathname);
            }
        };
    }

    public static class ParentsFirstPathComparator
    implements Comparator<Path> {
        @Override
        public int compare(Path path1, Path path2) {
            if (path1 == null || path2 == null) {
                throw new NullPointerException("Paths must not be null.");
            }
            Path p1 = path1.toAbsolutePath();
            Path p2 = path2.toAbsolutePath();
            return p1.compareTo(p2);
        }
    }

    public static class ChildrenFirstPathComparator
    implements Comparator<Path> {
        @Override
        public int compare(Path path1, Path path2) {
            if (path1 == null || path2 == null) {
                throw new NullPointerException("Paths must not be null.");
            }
            Path p1 = path1.toAbsolutePath();
            Path p2 = path2.toAbsolutePath();
            return -p1.compareTo(p2);
        }
    }
}

