/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.util;

import com.jetbrains.bundle.hub_client.util.HubClientProvider;
import com.jetbrains.bundle.hub_client.util.HubUtil;
import com.jetbrains.bundle.hub_client.util.validation.HubUrlValidator;
import com.jetbrains.installer.model.WizardBackendConfig;
import com.jetbrains.installer.model.blocks.BasicSettings;
import com.jetbrains.service.util.UrlUtil;
import java.util.List;
import javax.annotation.Resource;
import jetbrains.jetpass.client.accounts.ServiceClient;
import jetbrains.jetpass.client.hub.HubClient;
import jetbrains.jetpass.rest.dto.ServiceJSON;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;

public class WizardHubUtil {
    @Autowired
    private WizardBackendConfig wizardBackendConfig;
    @Autowired
    HubClientProvider hubClientProvider;
    @Resource(name="basicSettings")
    BasicSettings basicSettings;

    @Nullable
    public ServiceJSON getService(@NotNull ServiceClient serviceClient, @NotNull String serviceId) {
        return serviceClient.getService(serviceId, null);
    }

    @NotNull
    public ServiceJSON createService(ServiceClient serviceClient, String serviceId, String serviceSecret, String name, List<String> redirectUris) {
        return HubUtil.createService((ServiceClient)serviceClient, (String)serviceId, (String)serviceSecret, (String)name, null, null, null, redirectUris);
    }

    @NotNull
    public ServiceClient getServiceClientByIdAndSecret(HubClient hubClient, String serviceId, String serviceSecret) {
        return HubUtil.getAccountsClientByIdAndSecret((HubClient)hubClient, (String)serviceId, (String)serviceSecret).getServiceClient();
    }

    @NotNull
    public HubUrlValidator getHubUrlValidatorForCleanInstallation() {
        return this.getHubUrlValidatorForBaseUrl(this.basicSettings.getBaseUrl());
    }

    @NotNull
    public HubUrlValidator getHubUrlValidatorForBaseUrl(@Nullable String baseUrl) {
        return new HubUrlValidator(this.hubClientProvider, baseUrl != null && UrlUtil.isSecuredUrl((String)baseUrl), this.wizardBackendConfig.getProductName());
    }
}

