/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.validation;

import com.jetbrains.bundle.BundleEnvironment;
import com.jetbrains.bundle.BundleInstallationType;
import com.jetbrains.bundle.hub_client.util.validation.ErrorInfo;
import com.jetbrains.bundle.hub_client.util.validation.ValidationResult;
import com.jetbrains.bundle.util.CompressUtil;
import com.jetbrains.bundle.util.DiskSpaceUtil;
import com.jetbrains.installer.model.BundleDefaults;
import com.jetbrains.installer.model.KeyStoreContent;
import com.jetbrains.installer.model.SecureContent;
import com.jetbrains.installer.model.WizardBackendConfig;
import com.jetbrains.installer.model.blocks.HttpModeSettings;
import com.jetbrains.installer.model.blocks.HttpsModeSettings;
import com.jetbrains.installer.model.blocks.ServerConnectorModeSettings;
import com.jetbrains.installer.model.blocks.UpgradeSettings;
import com.jetbrains.installer.model.blocks.UpgradeSettingsContext;
import com.jetbrains.installer.model.blocks.UpgradeSource;
import com.jetbrains.installer.util.PathFilter;
import com.jetbrains.installer.util.TreeConverter;
import com.jetbrains.installer.validation.BundleUpgradeHelper;
import com.jetbrains.installer.validation.TypeDetectionResult;
import com.jetbrains.installer.validation.UpgradeSourceValidationResult;
import com.jetbrains.installer.validation.UpgradeValidationException;
import com.jetbrains.installer.validation.ValidationError;
import com.jetbrains.installer.validation.folder.impl.CleanDataFolderValidator;
import com.jetbrains.installer.validation.folder.impl.FolderWriteAccessValidator;
import com.jetbrains.service.util.BundleProperty;
import com.jetbrains.service.util.ConfiguratorUtils;
import com.jetbrains.service.util.DeleteFileVisitor;
import com.jetbrains.service.util.SecureMode;
import com.jetbrains.service.util.SystemUtil;
import com.jetbrains.service.util.Version;
import com.jetbrains.service.util.properties.impl.PropertiesBasedConfigurationHelper;
import com.jetbrains.service.util.ssl.KeystoreUtil;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.AclEntry;
import java.nio.file.attribute.AclFileAttributeView;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFileAttributeView;
import java.nio.file.attribute.PosixFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import org.bouncycastle.util.encoders.Base64;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

abstract class BaseUpgradeHelper
implements BundleUpgradeHelper {
    protected final Logger LOG = LoggerFactory.getLogger((String)this.getClass().getName());
    private static final Path DEFAULT_RELATIVE_ADDITIONAL_KEYSTORE_PATH = BundleEnvironment.getAdditionalKeystoreRelativePath();
    private final ConcurrentMap<PathKey, Future<PrepareResult>> cache = new ConcurrentHashMap<PathKey, Future<PrepareResult>>();
    @Autowired
    protected FolderWriteAccessValidator writeAccessValidator;
    @Autowired
    protected BundleDefaults bundleDefaults;
    @Autowired
    protected WizardBackendConfig wizardBackendConfig;
    @Autowired
    CleanDataFolderValidator cleanDataFolderValidator;

    BaseUpgradeHelper() {
    }

    @Override
    @NotNull
    public UpgradeSourceValidationResult validate(@Nullable UpgradeSource.Type type, @Nullable String location) {
        UpgradeSourceValidationResult result = new UpgradeSourceValidationResult();
        String property = "sourceLocation";
        if (location == null) {
            result.getValidationResult().addError(ValidationError.PROPERTY_MUST_NOT_BE_EMPTY.toErrorInfo(property));
            return result;
        }
        Path sourceLocation = Paths.get(location, new String[0]);
        result.setPreparedSourceLocation(sourceLocation);
        if (sourceLocation == null) {
            result.getValidationResult().addError(ValidationError.PROPERTY_MUST_NOT_BE_EMPTY.toErrorInfo(property));
            return result;
        }
        if (type == null) {
            throw new IllegalArgumentException("Parameter type should be not null if location is not null");
        }
        ValidationResult validationResult = this.checkPath(type, location);
        result.getValidationResult().updateFrom(validationResult);
        if (validationResult.hasErrors()) {
            return result;
        }
        try {
            switch (type) {
                case BACKUP_ARCHIVE: {
                    Path preparedLocation = this.prepareBackupArchive(sourceLocation);
                    result.setPreparedSourceLocation(preparedLocation);
                    this.validateBackupDir(preparedLocation, result.getProperties(), property, type);
                    break;
                }
                case BACKUP_UNCOMPRESSED: {
                    Path preparedLocation = this.prepareBackupDir(sourceLocation);
                    result.setPreparedSourceLocation(preparedLocation);
                    this.validateBackupDir(preparedLocation, result.getProperties(), property, type);
                    break;
                }
                case OLD_INSTALL_DIR: {
                    Path preparedLocation = this.prepareOldInstallationDir(sourceLocation);
                    result.setPreparedSourceLocation(preparedLocation);
                    this.validateOldInstallationDir(preparedLocation, result.getProperties(), property, sourceLocation);
                    break;
                }
                default: {
                    validationResult.addError(ValidationError.UNSUPPORTED_UPGRADE_TYPE.toErrorInfo("type"));
                    break;
                }
            }
        }
        catch (IOException e) {
            String message = String.format("Cannot validate upgrade source location: %s", e.toString());
            validationResult.addError(ValidationError.UPGRADE_LOCATION_PROCESSING_ERROR.toErrorInfo(Collections.singletonMap("error", message), property));
        }
        catch (UpgradeValidationException e) {
            validationResult.addError(e.getErrorInfo());
        }
        result.getValidationResult().updateFrom(validationResult);
        return result;
    }

    protected abstract void validateOldInstallationDir(@NotNull Path var1, @NotNull Properties var2, @NotNull String var3, @NotNull Path var4) throws UpgradeValidationException;

    final void checkDataDirResolvedFromOldInstallationIsNotEmpty(@NotNull Path dataDir, @NotNull String property, @NotNull Path sourceLocation) throws UpgradeValidationException {
        String sourceLocationPathString = sourceLocation.toAbsolutePath().toString();
        String dataDirPathString = dataDir.toString();
        if (!Files.exists(dataDir, new LinkOption[0]) || !Files.isDirectory(dataDir, new LinkOption[0])) {
            throw new UpgradeValidationException(this.constructNotAccessibleOrNotExistDataDirectoryFromOldInstallationError(dataDir, String.format("Bundle data directory %s found from %s not exists", dataDirPathString, sourceLocationPathString), property));
        }
        try {
            if (this.isEmptyDirectory(dataDir)) {
                throw new UpgradeValidationException(this.constructNotAccessibleOrEmptyDataDirectoryFromOldInstallationError(dataDir, String.format("Bundle data directory %s found from %s is empty", dataDirPathString, sourceLocationPathString), property));
            }
        }
        catch (Exception e) {
            throw new UpgradeValidationException(this.constructNotAccessibleOrEmptyDataDirectoryFromOldInstallationError(dataDir, String.format("Cannot process bundle data directory %s found from %s: %s", dataDirPathString, sourceLocationPathString, e.getMessage()), property));
        }
        this.checkReadWritePermissions(dataDir, property);
    }

    protected abstract void validateBackupDir(@NotNull Path var1, @NotNull Properties var2, @NotNull String var3, UpgradeSource.Type var4) throws UpgradeValidationException;

    @NotNull
    final List<Path> listFilteredPaths(@NotNull Path dir, @NotNull DirectoryStream.Filter<Path> filter) throws IOException {
        ArrayList<Path> result = new ArrayList<Path>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir, filter);){
            for (Path path : stream) {
                result.add(path);
            }
            ArrayList<Path> arrayList = result;
            return arrayList;
        }
    }

    @NotNull
    final List<Path> listPaths(@NotNull Path dir) throws IOException {
        ArrayList<Path> result = new ArrayList<Path>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            for (Path path : stream) {
                result.add(path);
            }
            ArrayList<Path> arrayList = result;
            return arrayList;
        }
    }

    private PrepareResult prepareAndCache(@NotNull Path keyPath, Callable<PrepareResult> prepare) throws IOException {
        FutureTask<PrepareResult> validationTask;
        PathKey key = new PathKey(keyPath);
        FutureTask<PrepareResult> result = (FutureTask<PrepareResult>)this.cache.get(key);
        if (result == null && (result = (Future)this.cache.putIfAbsent(key, validationTask = new FutureTask<PrepareResult>(prepare))) == null) {
            result = validationTask;
            validationTask.run();
        }
        try {
            return (PrepareResult)result.get();
        }
        catch (InterruptedException | CancellationException | ExecutionException e) {
            this.cache.remove(key, result);
            Throwable cause = e.getCause();
            ErrorInfo errorInfo = cause instanceof UpgradeValidationException ? ((UpgradeValidationException)cause).getErrorInfo() : ValidationError.UPGRADE_LOCATION_PROCESSING_ERROR.toErrorInfo(Collections.singletonMap("error", e.getMessage()), "sourceLocation");
            return new PrepareResult(errorInfo);
        }
    }

    @Override
    public void clearTemporaryFiles() {
        Set keys = this.cache.keySet();
        for (PathKey key : keys) {
            Future future = (Future)this.cache.get(key);
            if (future == null) continue;
            Path path = null;
            try {
                PrepareResult info = (PrepareResult)future.get();
                path = info.getPreparedSourceLocation();
                if (path != null) {
                    this.clearTemporaryFolder(path);
                }
            }
            catch (Exception e) {
                this.LOG.debug(String.format("Failed to remove temporary folder %s", path != null ? path : ""));
            }
            this.cache.remove(key);
        }
    }

    private void clearTemporaryFolder(Path path) throws IOException {
        Files.walkFileTree(path, (FileVisitor<? super Path>)new DeleteFileVisitor());
        Files.deleteIfExists(path);
    }

    @Override
    @NotNull
    public ValidationResult checkPath(@NotNull UpgradeSource.Type type, @NotNull String location) {
        ValidationResult result = new ValidationResult();
        Path sourceLocation = Paths.get(location, new String[0]);
        String property = "sourceLocation";
        if (StringUtils.isEmpty((Object)sourceLocation)) {
            result.addError(ValidationError.PROPERTY_MUST_NOT_BE_EMPTY.toErrorInfo("Upgrade source location not specified", property));
        } else if (!Files.exists(sourceLocation, new LinkOption[0]) || !Files.isReadable(sourceLocation)) {
            result.addError(this.writeAccessValidator.constructInaccessibleOrNotExistError(location, "Directory " + sourceLocation + " is either not accessible or doesn't exist", property));
        } else if (!(Files.isDirectory(sourceLocation, new LinkOption[0]) || Files.isRegularFile(sourceLocation, new LinkOption[0]) || Files.isSymbolicLink(sourceLocation))) {
            result.addError(ValidationError.LOCATION_MUST_BE_FILE_OR_DIRECTORY.toErrorInfo(property));
        }
        if (result.hasErrors()) {
            return result;
        }
        if (sourceLocation != null) {
            try {
                switch (type) {
                    case BACKUP_ARCHIVE: {
                        if (!Files.isRegularFile(sourceLocation, new LinkOption[0])) {
                            result.addError(ValidationError.LOCATION_MUST_BE_FILE.toErrorInfo(property));
                            break;
                        }
                        this.checkBackupArchivePath(sourceLocation, property);
                        break;
                    }
                    case BACKUP_UNCOMPRESSED: {
                        if (!Files.isDirectory(sourceLocation, new LinkOption[0])) {
                            result.addError(ValidationError.LOCATION_MUST_BE_DIRECTORY.toErrorInfo(property));
                            break;
                        }
                        this.checkUncompressedBackupPath(sourceLocation, property);
                        break;
                    }
                    case OLD_INSTALL_DIR: {
                        if (!Files.isDirectory(sourceLocation, new LinkOption[0])) {
                            result.addError(ValidationError.LOCATION_MUST_BE_DIRECTORY.toErrorInfo(property));
                            break;
                        }
                        this.checkOldInstallationDirPath(sourceLocation, property, type);
                    }
                }
            }
            catch (UpgradeValidationException e) {
                result.addError(e.getErrorInfo());
            }
        }
        return result;
    }

    private void checkProductName(String newProductName, @NotNull String oldProductName, String property, @NotNull UpgradeSource.Type type) throws UpgradeValidationException {
        if (!oldProductName.equals(newProductName)) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("oldProductName", oldProductName);
            parameters.put("expectedProductName", newProductName);
            throw new UpgradeValidationException(type == UpgradeSource.Type.OLD_INSTALL_DIR ? ValidationError.CANNOT_UPGRADE_FROM_OLD_INSTALLATION_OF_DIFFERENT_PRODUCT.toErrorInfo(parameters, property) : ValidationError.CANNOT_UPGRADE_FROM_BACKUP_OF_DIFFERENT_PRODUCT.toErrorInfo(parameters, property));
        }
    }

    void checkVersions(String newVersionString, String oldVersionString, @NotNull String property) throws UpgradeValidationException {
        Version newProductVersion = Version.parseVersion((String)newVersionString);
        if (newProductVersion == null) {
            throw new UpgradeValidationException(ValidationError.CANNOT_UPGRADE_VERSION_NOT_SUPPORTED.toErrorInfo(Collections.singletonMap("version", newVersionString), String.format("Upgrade to version %s is not supported", newVersionString), property));
        }
        Version oldProductVersion = Version.parseVersion((String)oldVersionString);
        if (oldProductVersion != null) {
            if (newProductVersion.isLesser(oldProductVersion)) {
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("oldVersion", oldVersionString);
                parameters.put("newVersion", newVersionString);
                throw new UpgradeValidationException(ValidationError.CANNOT_UPGRADE_TO_VERSION_FROM_VERSION.toErrorInfo(parameters, property));
            }
            this.checkIfUpgradeIsPossible(oldProductVersion, newProductVersion, property);
        }
    }

    private void checkIfUpgradeIsPossible(@NotNull Version oldProductVersion, @NotNull Version newProductVersion, @NotNull String uiProperty) throws UpgradeValidationException {
        Version minimalUpgradeVersion = this.wizardBackendConfig.getProductUpgradeMinimalVersion();
        if (minimalUpgradeVersion == null || minimalUpgradeVersion.equals((Object)Version.parseVersion((String)"0"))) {
            return;
        }
        Version newProductMajorMinorVersion = newProductVersion.toMajorMinorVersion();
        if (newProductMajorMinorVersion == null) {
            throw new UpgradeValidationException(ValidationError.CANNOT_UPGRADE_VERSION_NOT_SUPPORTED.toErrorInfo(Collections.singletonMap("version", newProductVersion.toString()), String.format("Upgrade to version %s has not been supported", newProductVersion.toString()), uiProperty));
        }
        if (minimalUpgradeVersion.isGreater(oldProductVersion.toMajorMinorVersion())) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("oldVersion", oldProductVersion.toString());
            parameters.put("newVersion", newProductVersion.toString());
            parameters.put("minimalUpgradeVersion", minimalUpgradeVersion.toString());
            parameters.put("product", this.wizardBackendConfig.getProductName());
            throw new UpgradeValidationException(ValidationError.CANNOT_UPGRADE_FROM_TOO_OLD_VERSION.toErrorInfo(parameters, String.format("Direct upgrade to version %s is not supported", newProductVersion.toString()), uiProperty));
        }
    }

    private void checkUncompressedBackupPath(Path sourceLocation, String property) throws UpgradeValidationException {
        this.validateBackupDir(sourceLocation, new Properties(), property, UpgradeSource.Type.BACKUP_UNCOMPRESSED);
    }

    private void checkBackupArchivePath(Path sourceLocation, String property) throws UpgradeValidationException {
        String sourceLocationLowerCase = sourceLocation.toString().toLowerCase();
        if (Files.isRegularFile(sourceLocation, new LinkOption[0]) && !sourceLocationLowerCase.endsWith(".tar.gz") && !sourceLocationLowerCase.endsWith(".zip")) {
            throw new UpgradeValidationException(ValidationError.UNSUPPORTED_TYPE_OF_BACKUP_ARCHIVE.toErrorInfo(property));
        }
    }

    protected void checkOldInstallationDirPath(@NotNull Path sourceLocation, @NotNull String property, @NotNull UpgradeSource.Type type) throws UpgradeValidationException {
        BundleEnvironment bundleEnv = new BundleEnvironment(sourceLocation);
        Properties bundleUpgradeProperties = this.loadUpgradePropertiesFromInstallationDir(bundleEnv, property);
        Properties bundleProperties = this.loadBundlePropertiesFromInstallationDir(bundleEnv, property);
        this.checkProductNameAndVersions(bundleUpgradeProperties, bundleProperties, property, type);
        String oldProductVersion = this.getOldProductVersionFromConfigs(bundleUpgradeProperties, bundleProperties);
        if (oldProductVersion == null) {
            throw new UpgradeValidationException(ValidationError.CANNOT_UPGRADE_VERSION_NOT_RECOGNIZED.toErrorInfo(property));
        }
        this.checkOldInstallationDirDbCompatibility(bundleEnv, oldProductVersion, property);
    }

    protected void checkOldInstallationDirDbCompatibility(@NotNull BundleEnvironment sourceLocationBundleEnv, @NotNull String oldProductVersion, @NotNull String property) throws UpgradeValidationException {
    }

    void checkProductNameAndVersions(@Nullable Properties bundleUpgradeProperties, @Nullable Properties bundleProperties, @NotNull String property, @NotNull UpgradeSource.Type type) throws UpgradeValidationException {
        String oldProductName = null;
        if (bundleUpgradeProperties != null) {
            oldProductName = bundleUpgradeProperties.getProperty("bundle.product.name");
        }
        if (oldProductName != null) {
            this.checkProductName(this.wizardBackendConfig.getProductName(), oldProductName, property, type);
        }
        String oldVersion = this.getOldProductVersionFromConfigs(bundleUpgradeProperties, bundleProperties);
        this.checkVersions(this.wizardBackendConfig.getProductFullVersion(), oldVersion, property);
    }

    @Nullable
    String getOldProductVersionFromConfigs(@Nullable Properties bundleUpgradeProperties, @Nullable Properties bundleProperties) {
        String oldVersion = null;
        if (bundleUpgradeProperties != null) {
            oldVersion = bundleUpgradeProperties.getProperty(BundleProperty.PREVIOUSLY_STARTED_PRODUCT_VERSION.getName());
        }
        if (oldVersion == null && bundleProperties != null) {
            oldVersion = bundleProperties.getProperty(BundleProperty.PRODUCT_VERSION.getName());
        }
        return oldVersion;
    }

    @Nullable
    Properties loadUpgradePropertiesFromInstallationDir(@NotNull BundleEnvironment bundleEnv, @NotNull String property) throws UpgradeValidationException {
        if (!Files.exists(bundleEnv.getApplicationDataRootDirectory(), new LinkOption[0])) {
            this.LOG.info("Invalid upgrade source location {}: root database directory {} does not exists!", (Object)bundleEnv.getBundleHome(), (Object)bundleEnv.getApplicationDataRootDirectory());
            throw new UpgradeValidationException(this.constructNotAccessibleOrNotExistAppDataRootDirectoryError(bundleEnv, "Root application data directory is not found", property));
        }
        Path upgradePropertiesPath = bundleEnv.getUpgradePropertiesFile();
        if (!Files.exists(upgradePropertiesPath, new LinkOption[0])) {
            return null;
        }
        try {
            return ConfiguratorUtils.loadPropertiesFile((File)upgradePropertiesPath.toFile());
        }
        catch (Exception e) {
            String message = String.format("Invalid upgrade source location - config file %s not accessible: %s", upgradePropertiesPath.toString(), e.getMessage());
            throw new UpgradeValidationException(ValidationError.BUNDLE_CONFIG_NOT_ACCESSIBLE.toErrorInfo(Collections.singletonMap("message", e.getMessage()), message, property));
        }
    }

    @Nullable
    Properties loadUpgradePropertiesFromBackupConfDir(@NotNull Path confDir, @NotNull String property) throws UpgradeValidationException {
        Path upgradePropertiesPath = confDir.resolve("internal").resolve("upgrade.properties");
        if (!Files.exists(upgradePropertiesPath, new LinkOption[0])) {
            return null;
        }
        try {
            return ConfiguratorUtils.loadPropertiesFile((File)upgradePropertiesPath.toFile());
        }
        catch (Exception e) {
            String message = String.format("Cannot load upgrade.properties config file from %s: %s", upgradePropertiesPath.toString(), e.getMessage());
            throw new UpgradeValidationException(ValidationError.BUNDLE_CONFIG_NOT_ACCESSIBLE.toErrorInfo(Collections.singletonMap("message", e.getMessage()), message, property));
        }
    }

    @Nullable
    Properties loadHubPropertiesFromConfDir(@NotNull Path confDir, @NotNull String property) throws UpgradeValidationException {
        Path hubPropertiesPath = confDir.resolve("internal").resolve("hub.properties");
        if (!Files.exists(hubPropertiesPath, new LinkOption[0])) {
            return null;
        }
        try {
            return ConfiguratorUtils.loadPropertiesFile((File)hubPropertiesPath.toFile());
        }
        catch (Exception e) {
            String message = String.format("Cannot load config file from %s: %s", hubPropertiesPath.toString(), e.getMessage());
            throw new UpgradeValidationException(ValidationError.BUNDLE_CONFIG_NOT_ACCESSIBLE.toErrorInfo(Collections.singletonMap("message", e.getMessage()), message, property));
        }
    }

    @NotNull
    Properties loadHubPropertiesFromInstallationDir(@NotNull BundleEnvironment bundleEnv, @NotNull String property) throws UpgradeValidationException {
        Path confDir = bundleEnv.getConfDir();
        Properties properties = this.loadHubPropertiesFromConfDir(confDir, property);
        if (properties == null) {
            String message = String.format("Bundle config file %s for %s cannot be determined", "hub.properties", bundleEnv.getBundleHome().toString());
            throw new UpgradeValidationException(ValidationError.BUNDLE_CONFIG_NOT_FOUND_FROM_OLD_INSTALLATION_SOURCE.toErrorInfo(message, property));
        }
        return properties;
    }

    @Nullable
    Properties loadBundlePropertiesFromConfDir(@NotNull Path confDir, @NotNull String property) throws UpgradeValidationException {
        Path bundlePropertiesPath = confDir.resolve("internal").resolve("bundle.properties");
        if (!Files.exists(bundlePropertiesPath, new LinkOption[0])) {
            return null;
        }
        try {
            return ConfiguratorUtils.loadPropertiesFile((File)bundlePropertiesPath.toFile());
        }
        catch (Exception e) {
            String message = String.format("Cannot load bundle.properties config file from %s: %s", bundlePropertiesPath.toString(), e.getMessage());
            throw new UpgradeValidationException(ValidationError.BUNDLE_CONFIG_NOT_ACCESSIBLE.toErrorInfo(Collections.singletonMap("message", e.getMessage()), message, property));
        }
    }

    void setHubServiceIdsAndSecretsFromHubProperties(UpgradeSettingsContext upgradeSettingsContext, Properties hubProperties) {
        HashMap<String, String> hubServiceIdToSecretMap = new HashMap<String, String>();
        for (String hubProperty : hubProperties.stringPropertyNames()) {
            if (!hubProperty.endsWith(".service.id")) continue;
            String bundledServiceId = hubProperty.substring(0, hubProperty.length() - ".service.id".length());
            if (!this.wizardBackendConfig.getEnabledProductServices().contains(bundledServiceId)) continue;
            hubServiceIdToSecretMap.put(hubProperties.getProperty(hubProperty), hubProperties.getProperty(bundledServiceId + ".service.secret"));
        }
        upgradeSettingsContext.setHubServiceIdsWithSecrets(hubServiceIdToSecretMap);
    }

    @NotNull
    Path prepareBackupDir(@NotNull Path backupDir) throws IOException, UpgradeValidationException {
        return backupDir;
    }

    @NotNull
    Path prepareBackupArchive(final @NotNull Path backupFile) throws IOException, UpgradeValidationException {
        long requiredSpace;
        String backupFileName = backupFile.toString();
        final Path targetFolder = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).resolve(this.getClass().getName() + "_" + UUID.randomUUID());
        PrepareResult prepareResult = null;
        long availableSpace = DiskSpaceUtil.getAvailableSpace((Path)targetFolder);
        if (backupFileName.toLowerCase().endsWith(".zip")) {
            requiredSpace = DiskSpaceUtil.getZipUncompressedSize((Path)backupFile);
            this.assertDiskSpaceForUncompressedBackup(backupFile, targetFolder, availableSpace, requiredSpace);
            prepareResult = this.prepareAndCache(backupFile, new Callable<PrepareResult>(){

                @Override
                public PrepareResult call() throws Exception {
                    CompressUtil.uncompressZip((Path)backupFile, (Path)targetFolder);
                    return new PrepareResult(targetFolder);
                }
            });
        } else if (backupFileName.toLowerCase().endsWith(".tar.gz")) {
            requiredSpace = DiskSpaceUtil.getTarGzUncompressedSize((Path)backupFile);
            this.assertDiskSpaceForUncompressedBackup(backupFile, targetFolder, availableSpace, requiredSpace);
            prepareResult = this.prepareAndCache(backupFile, new Callable<PrepareResult>(){

                @Override
                public PrepareResult call() throws Exception {
                    CompressUtil.uncompressTarGz((Path)backupFile, (Path)targetFolder);
                    return new PrepareResult(targetFolder);
                }
            });
        }
        if (prepareResult != null) {
            ErrorInfo errorInfo = prepareResult.getErrorInfo();
            if (errorInfo != null) {
                throw new UpgradeValidationException(errorInfo);
            }
            return prepareResult.getPreparedSourceLocation();
        }
        String message = String.format("Cannot uncompress backup: %s", backupFile.toString());
        throw new UpgradeValidationException(ValidationError.UPGRADE_LOCATION_PROCESSING_ERROR.toErrorInfo(Collections.singletonMap("error", message), "sourceLocation"));
    }

    private void assertDiskSpaceForUncompressedBackup(@NotNull Path backupFile, @NotNull Path targetFolder, long availableSpace, long requiredSpace) throws UpgradeValidationException {
        if (requiredSpace > availableSpace) {
            String message = String.format("Cannot uncompress backup - no enough disk space for content of %s on partition of %s", backupFile.toString(), targetFolder);
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("required", DiskSpaceUtil.getHumanSizeString((long)requiredSpace));
            parameters.put("available", DiskSpaceUtil.getHumanSizeString((long)availableSpace));
            parameters.put("path", targetFolder.toString());
            throw new UpgradeValidationException(ValidationError.NO_ENOUGH_DISK_SPACE_TO_UNCOMPRESS_BACKUP.toErrorInfo(parameters, message, "sourceLocation"));
        }
    }

    void assertDiskSpaceForDirCopy(@NotNull Path sourceDir, @NotNull Path targetDir) throws UpgradeValidationException {
        if (!sourceDir.equals(targetDir)) {
            try {
                long requiredSpace = DiskSpaceUtil.getDirectorySize((Path)sourceDir);
                long availableSpace = DiskSpaceUtil.getAvailableSpace((Path)targetDir);
                if (requiredSpace > availableSpace) {
                    String message = String.format("Cannot copy directory: %s", sourceDir.toString());
                    HashMap<String, String> parameters = new HashMap<String, String>();
                    parameters.put("required", DiskSpaceUtil.getHumanSizeString((long)requiredSpace));
                    parameters.put("available", DiskSpaceUtil.getHumanSizeString((long)availableSpace));
                    parameters.put("path", targetDir.toString());
                    throw new UpgradeValidationException(ValidationError.NO_ENOUGH_DISK_SPACE.toErrorInfo(parameters, message, "dataDir"));
                }
            }
            catch (IOException e) {
                String message = String.format("Cannot check disk space before coping %s", sourceDir);
                throw new UpgradeValidationException(ValidationError.UPGRADE_LOCATION_PROCESSING_ERROR.toErrorInfo(Collections.singletonMap("error", message), "dataDir"));
            }
        }
    }

    @NotNull
    Path prepareOldInstallationDir(@NotNull Path path) throws IOException {
        return path;
    }

    @Override
    public UpgradeSettings extractSettings(@NotNull UpgradeSource.Type type, @NotNull Path preparedLocation, @NotNull Properties extractedProperties, @NotNull ValidationResult validationResult) {
        try {
            UpgradeSettings upgradeSettings = null;
            switch (type) {
                case BACKUP_ARCHIVE: 
                case BACKUP_UNCOMPRESSED: {
                    upgradeSettings = this.extractSettingsFromBackup(preparedLocation, extractedProperties, type);
                    break;
                }
                case OLD_INSTALL_DIR: {
                    upgradeSettings = this.extractSettingsFromOldInstallation(preparedLocation, extractedProperties);
                    break;
                }
                default: {
                    validationResult.addError(ValidationError.UNSUPPORTED_UPGRADE_TYPE.toErrorInfo("type"));
                }
            }
            return upgradeSettings;
        }
        catch (UpgradeValidationException e) {
            validationResult.addError(e.getErrorInfo());
            return null;
        }
    }

    String getFromDefaultsIfNull(String propertyValue, String property) {
        return this.bundleDefaults.getFromDefaultsIfNull(propertyValue, property);
    }

    protected abstract UpgradeSettings extractSettingsFromOldInstallation(@NotNull Path var1, @NotNull Properties var2) throws UpgradeValidationException;

    protected abstract UpgradeSettings extractSettingsFromBackup(@NotNull Path var1, @NotNull Properties var2, UpgradeSource.Type var3) throws UpgradeValidationException;

    @Override
    @NotNull
    public ValidationResult prepareUpdate(@NotNull UpgradeSource.Type type, @NotNull UpgradeSettings upgradeSettings, @NotNull Path preparedLocation) {
        ValidationResult validationResult = new ValidationResult();
        try {
            switch (type) {
                case BACKUP_ARCHIVE: 
                case BACKUP_UNCOMPRESSED: {
                    this.prepareUpdateFromBackup(upgradeSettings, preparedLocation, type);
                    break;
                }
                case OLD_INSTALL_DIR: {
                    this.prepareUpdateFromOldInstallation(upgradeSettings, preparedLocation);
                    break;
                }
                default: {
                    validationResult.addError(ValidationError.UNSUPPORTED_UPGRADE_TYPE.toErrorInfo("type"));
                    break;
                }
            }
        }
        catch (UpgradeValidationException e) {
            validationResult.addError(e.getErrorInfo());
        }
        return validationResult;
    }

    private void copyConfWithReplacement(@NotNull Path source, @NotNull Path target) throws IOException {
        this.copyWithReplacement(source, target, new ConfFileFilter(source, target));
        this.applyWizardConfiguredPropertiesFromOldConfigs(source, target);
    }

    private void copyWithReplacement(@NotNull Path source, @NotNull Path target) throws IOException {
        this.copyWithReplacement(source, target, null);
    }

    private void copyWithReplacement(final @NotNull Path source, final @NotNull Path target, final @Nullable PathFilter fileFilter) throws IOException {
        Files.createDirectories(target.getParent(), new FileAttribute[0]);
        Files.walkFileTree(source, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult preVisitDirectory(Path directory, BasicFileAttributes attrs) throws IOException {
                Path targetDirectory = target.resolve(source.relativize(directory));
                if (!Files.exists(targetDirectory, new LinkOption[0])) {
                    Files.copy(directory, targetDirectory, StandardCopyOption.COPY_ATTRIBUTES, LinkOption.NOFOLLOW_LINKS);
                }
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                if (fileFilter == null || fileFilter.accept(file)) {
                    Files.copy(file, target.resolve(source.relativize(file)), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES);
                }
                return FileVisitResult.CONTINUE;
            }
        });
    }

    void extractKeystoreInfo(@NotNull UpgradeSettings upgradeSettings, @Nullable Properties bundleProperties, @NotNull SecureMode secureMode, @NotNull Path confDirectory, @NotNull UpgradeSettingsContext upgradeSettingsContext) {
        String keystorePassword;
        Path keystorePath = confDirectory.resolve(DEFAULT_RELATIVE_ADDITIONAL_KEYSTORE_PATH);
        String string = keystorePassword = bundleProperties != null ? bundleProperties.getProperty(BundleProperty.ADDITIONAL_KEYSTORE_PASSWORD.getName()) : null;
        if (Files.exists(keystorePath, new LinkOption[0]) && Files.isRegularFile(keystorePath, new LinkOption[0])) {
            upgradeSettingsContext.setKeystorePath(keystorePath);
            if (keystorePassword != null && this.isValidKeystoreAndPassword(keystorePath, keystorePassword)) {
                upgradeSettingsContext.setKeystorePassword(keystorePassword);
            }
        }
        this.fillSecureContent(upgradeSettings, keystorePath, keystorePassword, secureMode, upgradeSettingsContext);
    }

    void prepareUpdateFromOldInstallation(@NotNull UpgradeSettings upgradeSettings, @NotNull Path preparedLocation) throws UpgradeValidationException {
        BundleEnvironment oldBundleEnv = new BundleEnvironment(preparedLocation);
        String uiProperty = "dataDir";
        Path oldDataDir = this.resolveDirFromInstallation(preparedLocation, BundleProperty.DATA_DIR, "dataDir");
        this.checkDataDirResolvedFromOldInstallationIsNotEmpty(oldDataDir, "dataDir", preparedLocation);
        Path newDataDir = Paths.get(upgradeSettings.getDataDir(), new String[0]);
        this.assertDiskSpaceForDirCopy(oldDataDir, newDataDir);
        Path installationDirectory = Paths.get(this.wizardBackendConfig.getInstallationDirectory(), new String[0]);
        BundleEnvironment newBundleEnv = new BundleEnvironment(installationDirectory);
        Path newConfDir = newBundleEnv.getConfDir();
        Path oldConfDir = oldBundleEnv.getConfDir();
        this.prepareConfDir(oldConfDir, newConfDir, upgradeSettings);
        this.prepareDataDir(oldDataDir, newDataDir);
    }

    protected void prepareDataDir(final Path oldDataDir, Path newDataDir) throws UpgradeValidationException {
        if (!oldDataDir.equals(newDataDir)) {
            try {
                ErrorInfo errorInfo = this.cleanDataFolderValidator.checkPath(newDataDir.toString(), "dataDir");
                if (errorInfo != null) {
                    throw new UpgradeValidationException(errorInfo);
                }
                this.copyWithReplacement(oldDataDir, newDataDir, new PathFilter(){

                    @Override
                    public boolean accept(Path path) {
                        return BundleInstallationType.JAR != BaseUpgradeHelper.this.wizardBackendConfig.getInstallationType() || !path.startsWith(oldDataDir.resolve("conf"));
                    }
                });
            }
            catch (IOException e) {
                String message = String.format("Cannot copy data directory from %s to %s : %s", oldDataDir.toString(), newDataDir.toString(), e.getMessage());
                throw new UpgradeValidationException(ValidationError.UPGRADE_LOCATION_PROCESSING_ERROR.toErrorInfo(Collections.singletonMap("error", message), message, "dataDir"));
            }
        }
    }

    protected void prepareConfDir(@NotNull Path oldConfDir, @NotNull Path newConfDir, @NotNull UpgradeSettings upgradeSettings) throws UpgradeValidationException {
        if (!newConfDir.equals(oldConfDir)) {
            try {
                this.copyConfWithReplacement(oldConfDir, newConfDir);
            }
            catch (IOException e) {
                String message = String.format("Cannot copy conf directory from %s to %s: %s", oldConfDir.toString(), newConfDir.toString(), e.getMessage());
                throw new UpgradeValidationException(ValidationError.UPGRADE_LOCATION_PROCESSING_ERROR.toErrorInfo(Collections.singletonMap("error", message), message, "dataDir"));
            }
        } else {
            this.removeOldLicenseKeysFromWizardConfiguredProperties(newConfDir);
        }
        Path bundleLauncherConfig = this.findLauncherConfigInPath(newConfDir);
        if (bundleLauncherConfig != null) {
            this.patchLauncherConfig(bundleLauncherConfig, Paths.get(upgradeSettings.getLogsDir(), new String[0]));
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(newConfDir);){
            for (Path path : stream) {
                Path serviceLauncherConfig;
                if (!Files.isDirectory(path, new LinkOption[0]) || (serviceLauncherConfig = this.findLauncherConfigInPath(path)) == null) continue;
                this.patchLauncherConfig(serviceLauncherConfig, Paths.get(upgradeSettings.getLogsDir(), new String[0]).resolve(path.getFileName()));
            }
        }
        catch (IOException e) {
            this.LOG.debug(String.format("Failed to iterate through services conf subfolders in %s", newConfDir), (Throwable)e);
        }
    }

    private Path findLauncherConfigInPath(@NotNull Path newConfDir) {
        try {
            List<Path> launchConfig = this.listFilteredPaths(newConfDir, new DirectoryStream.Filter<Path>(){

                @Override
                public boolean accept(Path entry) {
                    return entry.toFile().getName().endsWith(".launch.config");
                }
            });
            if (launchConfig.size() == 1) {
                return launchConfig.get(0);
            }
        }
        catch (Exception e) {
            this.LOG.debug(String.format("Failed to find launch config file in %s", newConfDir), (Throwable)e);
        }
        return null;
    }

    final void patchLauncherConfig(@NotNull Path launchConfigPath, @NotNull Path newLogsDir) {
        if (Files.exists(launchConfigPath, new LinkOption[0])) {
            try {
                List<String> lines = Files.readAllLines(launchConfigPath, Charset.forName("UTF-8"));
                ArrayList<String> resultedLines = new ArrayList<String>();
                for (String line : lines) {
                    if (line.trim().startsWith("logs-dir=")) {
                        String logsDirLine = "logs-dir=" + newLogsDir.toString();
                        if (SystemUtil.isWindows()) {
                            logsDirLine = logsDirLine.replace("\\", "\\\\").replaceFirst(":", "\\\\:");
                        }
                        resultedLines.add(logsDirLine);
                        continue;
                    }
                    resultedLines.add(line);
                }
                Files.write(launchConfigPath, resultedLines, Charset.forName("UTF-8"), new OpenOption[0]);
            }
            catch (IOException e) {
                this.LOG.error("Failed patching launcher config", (Throwable)e);
            }
        }
        try {
            if (Files.isDirectory(newLogsDir, new LinkOption[0])) {
                List<Path> exitFlagFilePathList = this.listFilteredPaths(newLogsDir, new DirectoryStream.Filter<Path>(){

                    @Override
                    public boolean accept(Path entry) throws IOException {
                        return entry.toFile().getName().endsWith(".exit.flag");
                    }
                });
                for (Path exitFlagFilePath : exitFlagFilePathList) {
                    Files.delete(exitFlagFilePath);
                }
            }
        }
        catch (Exception e) {
            this.LOG.debug(String.format("Can't delete exit flag file from new logs directory %s", newLogsDir), (Throwable)e);
        }
    }

    private void applyWizardConfiguredPropertiesFromOldConfigs(@NotNull Path oldConfDir, @NotNull Path newConfDir) throws IOException {
        Path oldWizardPropertiesPath = this.getWizardConfiguredPropertiesPath(oldConfDir);
        if (Files.exists(oldWizardPropertiesPath, new LinkOption[0])) {
            Path tmpNewWizardPropertiesPath = newConfDir.resolve("internal").resolve("wizard-configured.properties_tmp");
            Files.copy(oldWizardPropertiesPath, tmpNewWizardPropertiesPath, StandardCopyOption.REPLACE_EXISTING);
            Properties properties = ConfiguratorUtils.loadPropertiesFile((File)tmpNewWizardPropertiesPath.toFile());
            properties.remove("wizard.configuration.finished");
            this.clearLicenseKeys(properties);
            ConfiguratorUtils.savePropertiesFile((File)tmpNewWizardPropertiesPath.toFile(), (Properties)properties);
            Path newWizardPropertiesPath = this.getWizardConfiguredPropertiesPath(newConfDir);
            Files.move(tmpNewWizardPropertiesPath, newWizardPropertiesPath, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    private void removeOldLicenseKeysFromWizardConfiguredProperties(@NotNull Path newConfDir) {
        Path newWizardPropertiesPath = this.getWizardConfiguredPropertiesPath(newConfDir);
        if (Files.exists(newWizardPropertiesPath, new LinkOption[0])) {
            Properties properties = ConfiguratorUtils.loadPropertiesFile((File)newWizardPropertiesPath.toFile());
            this.clearLicenseKeys(properties);
            ConfiguratorUtils.savePropertiesFile((File)newWizardPropertiesPath.toFile(), (Properties)properties);
        }
    }

    private void clearLicenseKeys(Properties properties) {
        Collection allServices = PropertiesBasedConfigurationHelper.getHelper().getServices((Object)properties);
        for (String serviceId : allServices) {
            properties.remove(PropertiesBasedConfigurationHelper.getHelper().getPrefixedPropertyName(serviceId, "license-user-name"));
            properties.remove(PropertiesBasedConfigurationHelper.getHelper().getPrefixedPropertyName(serviceId, "license-key"));
        }
    }

    @Nullable
    Properties getWizardConfiguredProperties(@NotNull BundleEnvironment bundleEnv, String uiProperty) throws UpgradeValidationException {
        Path wizardConfig = this.getWizardConfiguredPropertiesPath(bundleEnv);
        return this.getWizardConfiguredProperties(wizardConfig, uiProperty);
    }

    @Nullable
    Properties getWizardConfiguredProperties(@NotNull Path wizardConfig, String uiProperty) throws UpgradeValidationException {
        if (!Files.exists(wizardConfig, new LinkOption[0])) {
            return null;
        }
        try {
            return ConfiguratorUtils.loadPropertiesFile((File)wizardConfig.toFile());
        }
        catch (Exception e) {
            String message = String.format("Invalid upgrade source location - config file %s not accessible: %s", wizardConfig.toString(), e.getMessage());
            throw new UpgradeValidationException(ValidationError.BUNDLE_CONFIG_NOT_ACCESSIBLE.toErrorInfo(Collections.singletonMap("message", e.getMessage()), message, uiProperty));
        }
    }

    @NotNull
    private Path getWizardConfiguredPropertiesPath(BundleEnvironment bundleEnv) {
        return this.getWizardConfiguredPropertiesPath(bundleEnv.getConfDir());
    }

    @NotNull
    Path getWizardConfiguredPropertiesPath(@NotNull Path oldConfDir) {
        return oldConfDir.resolve("internal").resolve("wizard-configured.properties");
    }

    private boolean isValidKeystoreAndPassword(@NotNull Path oldKeystorePath, @NotNull String keystorePassword) {
        try {
            KeystoreUtil.loadKeyStore((Path)oldKeystorePath, (String)keystorePassword);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    protected abstract void prepareUpdateFromBackup(@NotNull UpgradeSettings var1, @NotNull Path var2, UpgradeSource.Type var3) throws UpgradeValidationException;

    @NotNull
    final Path toAbsoluteBundlePath(@NotNull Path path, @NotNull Path dataRootDirectory) {
        if (path.isAbsolute()) {
            return path;
        }
        return dataRootDirectory.resolve(path);
    }

    @NotNull
    private Path getAbsoluteBundleDir(@NotNull BundleEnvironment bundleEnv, @NotNull Properties bundleProperties, @NotNull BundleProperty dirProperty, @NotNull String property) throws UpgradeValidationException {
        Path dir;
        String directoryAsString = bundleProperties.getProperty(dirProperty.getName());
        if (directoryAsString == null) {
            String developerMessage = String.format("Bundle config for %s does not contain property %s", bundleEnv.getBundleHome().toString(), dirProperty.getName());
            throw new UpgradeValidationException(this.constructPropertyIsNotFoundInOldConfigsError(dirProperty, developerMessage, property));
        }
        try {
            dir = Paths.get(directoryAsString, new String[0]);
        }
        catch (Exception e) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("product", this.wizardBackendConfig.getProductName());
            parameters.put("dir", bundleEnv.getBundleHome().toString());
            parameters.put("error", e.getMessage());
            throw new UpgradeValidationException(ValidationError.BUNDLE_DATA_DIRECTORY_IS_INVALID.toErrorInfo(parameters, "Path is invalid: " + e.getMessage(), property));
        }
        if (!dir.isAbsolute()) {
            Path dataRoot = bundleEnv.getApplicationDataRootDirectory();
            dir = dataRoot.resolve(directoryAsString);
        }
        return dir;
    }

    @NotNull
    private Path getAbsoluteBundleDir(@NotNull BundleEnvironment bundleEnv, @NotNull BundleProperty dirProperty, @NotNull String property) throws UpgradeValidationException {
        Properties bundleProperties = this.loadBundlePropertiesFromInstallationDir(bundleEnv, property);
        return this.getAbsoluteBundleDir(bundleEnv, bundleProperties, dirProperty, property);
    }

    @NotNull
    Properties loadBundlePropertiesFromInstallationDir(@NotNull BundleEnvironment bundleEnv, @NotNull String property) throws UpgradeValidationException {
        Path confDir = bundleEnv.getConfDir();
        Properties properties = this.loadBundlePropertiesFromConfDir(confDir, property);
        if (properties == null) {
            String message = String.format("Bundle config for %s cannot be determined", bundleEnv.getBundleHome().toString());
            throw new UpgradeValidationException(ValidationError.BUNDLE_CONFIG_NOT_FOUND_FROM_OLD_INSTALLATION_SOURCE.toErrorInfo(message, property));
        }
        return properties;
    }

    @Nullable
    String getSuitableDirFromUpgradeSourceConfigs(@Nullable Properties bundleProperties, @NotNull BundleProperty bundleProperty) {
        if (bundleProperties == null || this.wizardBackendConfig.getInstallationType() == BundleInstallationType.DOCKER) {
            return null;
        }
        if (BundleInstallationType.JAR == this.wizardBackendConfig.getInstallationType() && BundleProperty.DATA_DIR == bundleProperty) {
            return null;
        }
        String oldDirectoryAsString = bundleProperties.getProperty(bundleProperty.getName());
        return oldDirectoryAsString != null && this.checkIfDirResolvedFromUpgradeSourceIsReusable(oldDirectoryAsString) ? oldDirectoryAsString : null;
    }

    final boolean checkIfDirResolvedFromUpgradeSourceIsReusable(@NotNull String oldDirectoryAsString) {
        Path oldDirectoryPath = null;
        try {
            oldDirectoryPath = Paths.get(oldDirectoryAsString, new String[0]);
        }
        catch (Exception e) {
            this.LOG.debug(String.format("Failed to parse directory %s taken from old upgrade source", oldDirectoryAsString));
        }
        return this.wizardBackendConfig.getInstallationType() != BundleInstallationType.DOCKER && oldDirectoryPath != null && oldDirectoryPath.isAbsolute() && this.checkIfExistingDirectoryOrCouldBeCreated(oldDirectoryPath);
    }

    private boolean checkIfExistingDirectoryOrCouldBeCreated(Path dir) {
        if (Files.exists(dir, new LinkOption[0]) && Files.isDirectory(dir, new LinkOption[0])) {
            return true;
        }
        if (!Files.exists(dir, new LinkOption[0])) {
            boolean result;
            boolean bl = result = dir.toFile().mkdirs() && Files.isDirectory(dir, new LinkOption[0]);
            if (dir.toFile().getName().equals("internal")) {
                try {
                    Files.delete(dir);
                }
                catch (IOException e) {
                    this.LOG.debug("Failed to remove folder " + dir, (Throwable)e);
                }
            }
            return result;
        }
        return false;
    }

    @Override
    @NotNull
    public Path getOldUpgradeDataBackupDirectory(@NotNull Path installationDir) throws UpgradeValidationException {
        Path backupsDir = this.resolveDirFromInstallation(installationDir, BundleProperty.BACKUPS_DIR, "backupPath");
        return backupsDir.resolve(".backup." + this.wizardBackendConfig.getProductPreviousFullVersion());
    }

    @NotNull
    final Path resolveDirFromInstallation(@NotNull BundleEnvironment bundleEnv, @NotNull BundleProperty directoryProperty, @NotNull String uiProperty) throws UpgradeValidationException {
        if (BundleInstallationType.DOCKER == this.wizardBackendConfig.getInstallationType()) {
            return Paths.get(this.getFromDefaultsIfNull(null, directoryProperty.getName()), new String[0]);
        }
        return this.getAbsoluteBundleDir(bundleEnv, directoryProperty, uiProperty);
    }

    @NotNull
    final Path resolveDirFromInstallation(@NotNull Path installationDir, @NotNull BundleProperty directoryProperty, @NotNull String uiProperty) throws UpgradeValidationException {
        BundleEnvironment bundleEnv = new BundleEnvironment(installationDir);
        return this.resolveDirFromInstallation(bundleEnv, directoryProperty, uiProperty);
    }

    @Override
    public void backupAndCleanOldUpgradeData(@NotNull Path installationDir, @Nullable Path backupPath) throws UpgradeValidationException {
        BundleEnvironment bundleEnv = new BundleEnvironment(installationDir);
        Path dataDir = this.resolveDirFromInstallation(bundleEnv, BundleProperty.DATA_DIR, "sourceLocation");
        Path confDir = bundleEnv.getConfDir();
        if (dataDir.startsWith(bundleEnv.getApplicationDataRootDirectory()) || BundleInstallationType.JAR == this.wizardBackendConfig.getInstallationType()) {
            Path newDataDir = null;
            if (backupPath != null) {
                newDataDir = backupPath.resolve("data");
                try {
                    Files.createDirectories(newDataDir, new FileAttribute[0]);
                }
                catch (IOException e) {
                    String message = String.format("Cannot create backup data folder: %s", e.getMessage());
                    throw new UpgradeValidationException(ValidationError.OLD_UPGRADE_DATA_BACKUP_FAILED_CANNOT_CREATE_DIR.toErrorInfo(Collections.singletonMap("message", message), "sourceLocation"));
                }
            }
            try {
                HashMap<Path, Path> rules = new HashMap<Path, Path>();
                if (confDir.startsWith(dataDir)) {
                    try (DirectoryStream<Path> stream = Files.newDirectoryStream(dataDir);){
                        for (Path child : stream) {
                            if (child.endsWith("conf")) continue;
                            Path relativeChild = child.isAbsolute() ? dataDir.relativize(child) : child;
                            rules.put(dataDir.resolve(relativeChild), newDataDir != null ? newDataDir.resolve(relativeChild) : null);
                        }
                    }
                } else {
                    rules.put(dataDir, newDataDir);
                }
                new TreeConverter(rules).convert();
            }
            catch (IOException e) {
                String message = String.format("Cannot move or delete old upgrade data: %s", e.getMessage());
                throw new UpgradeValidationException(ValidationError.OLD_UPGRADE_DATA_BACKUP_FAILED_CANNOT_MOVE_OR_DELETE_DIR.toErrorInfo(Collections.singletonMap("message", message), "sourceLocation"));
            }
        }
        try {
            Files.createDirectories(dataDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            String message = String.format("Cannot create new data folder: %s", e.getMessage());
            throw new UpgradeValidationException(ValidationError.OLD_UPGRADE_DATA_BACKUP_FAILED_CANNOT_CREATE_DIR.toErrorInfo(Collections.singletonMap("message", message), "sourceLocation"));
        }
        Path internalConfDir = bundleEnv.getInternalConfDir();
        Path launcherJvmOptions = bundleEnv.getConfDir().resolve(this.wizardBackendConfig.getProductName().toLowerCase() + ".jvmoptions");
        Path launcherConfig = bundleEnv.getConfDir().resolve(this.wizardBackendConfig.getProductName().toLowerCase() + ".launch.config");
        Path wizardConfiguredProperties = bundleEnv.getWizardConfiguredPropertiesFile();
        Path newConfDir = null;
        if (backupPath != null) {
            newConfDir = backupPath.resolve("conf");
        }
        try {
            if (newConfDir != null) {
                this.copyWithReplacement(confDir, newConfDir);
            }
            HashMap<Path, Path> rules = new HashMap<Path, Path>();
            rules.put(confDir, null);
            rules.put(internalConfDir, internalConfDir);
            if (Files.exists(launcherJvmOptions, new LinkOption[0])) {
                rules.put(launcherJvmOptions, launcherJvmOptions);
            }
            if (Files.exists(launcherConfig, new LinkOption[0])) {
                rules.put(launcherConfig, launcherConfig);
            }
            rules.put(wizardConfiguredProperties, null);
            Path distConfigsArchive = bundleEnv.getDistConfigs().toPath();
            if (Files.exists(distConfigsArchive, new LinkOption[0])) {
                Path distConfigsTmpDir = Paths.get(System.getProperty("java.io.tmpdir"), new String[0]).resolve(this.getClass().getName() + "_tmp_" + UUID.randomUUID());
                CompressUtil.uncompressZip((Path)distConfigsArchive, (Path)distConfigsTmpDir);
                rules.put(distConfigsTmpDir, confDir);
            }
            new TreeConverter(rules).convert();
        }
        catch (IOException e) {
            String message = String.format("Cannot copy or delete old upgrade configs: %s", e.getMessage());
            throw new UpgradeValidationException(ValidationError.OLD_UPGRADE_DATA_BACKUP_FAILED_CANNOT_MOVE_OR_DELETE_DIR.toErrorInfo(Collections.singletonMap("message", message), "sourceLocation"));
        }
    }

    void checkReadPermissions(@NotNull Path folder, @NotNull String property) throws UpgradeValidationException {
        boolean result;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(folder);){
            result = Files.isReadable(folder) && stream.iterator().hasNext();
        }
        catch (NotDirectoryException e) {
            throw new UpgradeValidationException(ValidationError.LOCATION_MUST_BE_DIRECTORY.toErrorInfo(property));
        }
        catch (SecurityException ignore) {
            result = false;
        }
        catch (IOException e) {
            throw new UpgradeValidationException(this.writeAccessValidator.constructInaccessibleError(folder.toString(), "Cannot check permissions of " + folder + ": " + e.getMessage(), property));
        }
        if (!result) {
            throw new UpgradeValidationException(this.writeAccessValidator.constructInaccessibleOrEmptyError(folder.toString(), String.format("Folder %s is empty or is not accessible", folder), property));
        }
    }

    void checkReadWritePermissions(@NotNull Path folder, @NotNull String property) throws UpgradeValidationException {
        this.checkReadPermissions(folder, property);
        try {
            ErrorInfo errorInfo = this.writeAccessValidator.checkPath(folder.toString(), property);
            if (errorInfo != null) {
                throw new UpgradeValidationException(errorInfo);
            }
        }
        catch (SecurityException e) {
            throw new UpgradeValidationException(this.writeAccessValidator.constructInaccessibleError(folder.toString(), "Cannot check permissions of " + folder + ": " + e.getMessage(), property));
        }
    }

    @Override
    @Nullable
    public String getMinimalCompatibleVersionForOldInstallationSource() {
        return null;
    }

    @Override
    @NotNull
    public TypeDetectionResult detectType(@Nullable String location) {
        TypeDetectionResult result = new TypeDetectionResult();
        ValidationResult validationResult = result.getValidationResult();
        String property = "sourceLocation";
        try {
            if (location == null || StringUtils.isEmpty((Object)location)) {
                validationResult.addError(ValidationError.PROPERTY_MUST_NOT_BE_EMPTY.toErrorInfo("Upgrade source location not specified", property));
                return result;
            }
            Path sourceLocation = Paths.get(location, new String[0]);
            if (!Files.exists(sourceLocation, new LinkOption[0]) || !Files.isReadable(sourceLocation)) {
                validationResult.addError(this.writeAccessValidator.constructInaccessibleOrNotExistError(location, "Directory " + sourceLocation + " is either not accessible or doesn't exist", property));
            } else if (!(Files.isDirectory(sourceLocation, new LinkOption[0]) || Files.isRegularFile(sourceLocation, new LinkOption[0]) || Files.isSymbolicLink(sourceLocation))) {
                validationResult.addError(ValidationError.LOCATION_MUST_BE_FILE_OR_DIRECTORY.toErrorInfo(property));
            }
            if (validationResult.hasErrors()) {
                return result;
            }
            if (Files.isRegularFile(sourceLocation, new LinkOption[0])) {
                result.setType(UpgradeSource.Type.BACKUP_ARCHIVE);
            } else if (Files.isDirectory(sourceLocation, new LinkOption[0])) {
                if (this.isOldInstallationDir(sourceLocation)) {
                    result.setType(UpgradeSource.Type.OLD_INSTALL_DIR);
                } else {
                    result.setType(UpgradeSource.Type.BACKUP_UNCOMPRESSED);
                }
            }
        }
        catch (Exception e) {
            String message = String.format("Cannot detect upgrade source location %s: %s", location, e.getMessage());
            validationResult.addError(ValidationError.CANNOT_DETECT_UPGRADE_LOCATION_TYPE.toErrorInfo(message, property));
        }
        return result;
    }

    private boolean isOldInstallationDir(@NotNull Path sourceLocation) {
        return Files.exists(sourceLocation.resolve("internal").resolve("conf"), new LinkOption[0]);
    }

    @NotNull
    private ErrorInfo constructNotAccessibleOrNotExistAppDataRootDirectoryError(@NotNull BundleEnvironment bundleEnvironment, @NotNull String developerMessage, @Nullable String property) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("appDataRoot", bundleEnvironment.getApplicationDataRootDirectory().toString());
        String installationUser = this.wizardBackendConfig.getInstallationUser();
        if (installationUser != null) {
            parameters.put("user", installationUser);
            return ValidationError.BUNDLE_ROOT_APP_DATA_DIRECTORY_NOT_EXIST_OR_NOT_ACCESSIBLE_BY_USER.toErrorInfo(parameters, developerMessage, property);
        }
        return ValidationError.BUNDLE_ROOT_APP_DATA_DIRECTORY_NOT_EXIST_OR_NOT_ACCESSIBLE.toErrorInfo(parameters, developerMessage, property);
    }

    @NotNull
    final ErrorInfo constructNotAccessibleOrNotExistDataDirectoryFromOldInstallationError(@NotNull Path dataDir, @NotNull String developerMessage, @Nullable String property) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("product", this.wizardBackendConfig.getProductName());
        parameters.put("dir", dataDir.toString());
        String installationUser = this.wizardBackendConfig.getInstallationUser();
        if (installationUser != null) {
            parameters.put("user", installationUser);
            return ValidationError.BUNDLE_DATA_DIRECTORY_NOT_EXIST_OR_NOT_ACCESSIBLE_BY_USER.toErrorInfo(parameters, developerMessage, property);
        }
        return ValidationError.BUNDLE_DATA_DIRECTORY_NOT_EXIST_OR_NOT_ACCESSIBLE.toErrorInfo(parameters, developerMessage, property);
    }

    @NotNull
    final ErrorInfo constructNotAccessibleOrEmptyDataDirectoryFromOldInstallationError(@NotNull Path dataDir, @NotNull String developerMessage, @Nullable String property) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("product", this.wizardBackendConfig.getProductName());
        parameters.put("dir", dataDir.toString());
        String installationUser = this.wizardBackendConfig.getInstallationUser();
        if (installationUser != null) {
            parameters.put("user", installationUser);
            return ValidationError.BUNDLE_DATA_DIRECTORY_IS_EMPTY_OR_NOT_ACCESSIBLE_BY_USER.toErrorInfo(parameters, developerMessage, property);
        }
        return ValidationError.BUNDLE_DATA_DIRECTORY_IS_EMPTY_OR_NOT_ACCESSIBLE.toErrorInfo(parameters, developerMessage, property);
    }

    @NotNull
    private ErrorInfo constructPropertyIsNotFoundInOldConfigsError(@NotNull BundleProperty bundleProperty, @NotNull String developerMessage, @Nullable String property) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("property", bundleProperty.getName());
        return ValidationError.BUNDLE_PROPERTY_IS_ABSENT_IN_OLD_CONFIGS.toErrorInfo(parameters, developerMessage, property);
    }

    @Override
    public boolean canBeOldDataDir(@NotNull Path location) {
        return false;
    }

    void extractConnectorSettings(UpgradeSettings upgradeSettings, @NotNull Properties bundleProperties) {
        String listenAddress = bundleProperties.getProperty(BundleProperty.LISTEN_ADDRESS.getName());
        String listenPort = bundleProperties.getProperty(BundleProperty.LISTEN_PORT.getName());
        String redirectFromHttpFlag = bundleProperties.getProperty(BundleProperty.TLS_REDIRECT_FROM_HTTP_FLAG.getName());
        String nonSecureRedirectListenPort = bundleProperties.getProperty(BundleProperty.TLS_REDIRECT_FROM_HTTP_LISTEN_PORT.getName());
        String secureMode = bundleProperties.getProperty(BundleProperty.SECURE_MODE.getName());
        this.extractConnectorSettings(upgradeSettings, listenAddress, listenPort, redirectFromHttpFlag, nonSecureRedirectListenPort, secureMode);
    }

    void extractConnectorSettings(UpgradeSettings upgradeSettings, String extractedListenAddress, String extractedListenPort, String extractedRedirectionFromHttpFlag, String extractedNonSecureRedirectListenPort, String extractedSecureMode) {
        ServerConnectorModeSettings serverConnectorModeSettings;
        ServerConnectorModeSettings settings;
        boolean defaultTlsRedirectionFromHttpFlag;
        String defaultSecureListenPort;
        String defaultNonSecureListenPort;
        String secureMode;
        String string = secureMode = extractedSecureMode != null ? extractedSecureMode : this.bundleDefaults.getSecureMode().getName();
        if (SecureMode.DISABLE.getName().equals(secureMode)) {
            defaultNonSecureListenPort = this.getFromDefaultsIfNull(extractedListenPort, "defaultNonSecureListenPort");
            defaultSecureListenPort = this.getFromDefaultsIfNull(null, "defaultSecureListenPort");
            defaultTlsRedirectionFromHttpFlag = Boolean.valueOf(this.getFromDefaultsIfNull(null, BundleProperty.TLS_REDIRECT_FROM_HTTP_FLAG.getName()));
            settings = new HttpModeSettings();
            ((HttpModeSettings)settings).setNonSecureListenPort(defaultNonSecureListenPort);
            serverConnectorModeSettings = settings;
        } else if (SecureMode.TLS.getName().equals(secureMode)) {
            defaultNonSecureListenPort = this.getFromDefaultsIfNull(extractedNonSecureRedirectListenPort, "defaultNonSecureListenPort");
            defaultSecureListenPort = this.getFromDefaultsIfNull(extractedListenPort, "defaultSecureListenPort");
            defaultTlsRedirectionFromHttpFlag = Boolean.valueOf(this.getFromDefaultsIfNull(extractedRedirectionFromHttpFlag, BundleProperty.TLS_REDIRECT_FROM_HTTP_FLAG.getName()));
            settings = new HttpsModeSettings();
            ((HttpsModeSettings)settings).setSecureListenPort(defaultSecureListenPort);
            ((HttpsModeSettings)settings).setNonSecureRedirectListenPort(defaultNonSecureListenPort);
            ((HttpsModeSettings)settings).setRedirectionFromHttpEnabled(defaultTlsRedirectionFromHttpFlag);
            serverConnectorModeSettings = settings;
        } else {
            throw new IllegalStateException("Unsupported secure mode: " + secureMode);
        }
        serverConnectorModeSettings.setDefaultSecureListenPort(defaultSecureListenPort);
        serverConnectorModeSettings.setDefaultNonSecureListenPort(defaultNonSecureListenPort);
        serverConnectorModeSettings.setDefaultRedirectionFromHttpFlag(defaultTlsRedirectionFromHttpFlag);
        String listenAddress = this.getFromDefaultsIfNull(extractedListenAddress, BundleProperty.LISTEN_ADDRESS.getName());
        serverConnectorModeSettings.setListenAddress(listenAddress);
        upgradeSettings.setServerConnectorModeSettings(serverConnectorModeSettings);
    }

    private void fillSecureContent(@NotNull UpgradeSettings upgradeSettings, @NotNull Path keystorePath, @Nullable String keystorePassword, @NotNull SecureMode secureMode, @NotNull UpgradeSettingsContext upgradeSettingsContext) {
        if (SecureMode.DISABLE != secureMode) {
            ValidationResult validationResult = new ValidationResult();
            SecureContent secureContent = this.extractSecureContent(keystorePath, keystorePassword, validationResult);
            if (!validationResult.hasErrors()) {
                secureContent.validate(validationResult);
            }
            upgradeSettingsContext.setExtractedSecureContent(secureContent, validationResult);
            upgradeSettings.setUseOldServerCertFlag(!validationResult.hasErrors());
            upgradeSettings.setSecureContent(secureContent.createEmptyContent());
        } else {
            upgradeSettings.setSecureContent(new KeyStoreContent());
        }
    }

    private SecureContent extractSecureContent(@NotNull Path keystorePath, @Nullable String keystorePassword, @NotNull ValidationResult validationResult) {
        KeyStoreContent keyStoreContent = new KeyStoreContent();
        String keyStoreFileContent = BaseUpgradeHelper.readKeyStore(keystorePath, validationResult);
        if (keyStoreFileContent != null) {
            keyStoreContent.setKeyStoreFileName("keystore.jks");
            keyStoreContent.setKeyStoreFile(keyStoreFileContent);
            keyStoreContent.setSecureKeystorePassword(keystorePassword);
            keyStoreContent.setSecureKeyStoreAlias("secureKeyStoreAlias");
            keyStoreContent.setAliasPassword(keystorePassword);
        }
        return keyStoreContent;
    }

    private static String readKeyStore(@NotNull Path path, @NotNull ValidationResult validationResult) {
        if (Files.exists(path, new LinkOption[0])) {
            try {
                return Base64.toBase64String((byte[])Files.readAllBytes(path));
            }
            catch (IOException e) {
                LoggerFactory.getLogger((String)SecureContent.class.getName()).debug("Failed to read from existing file " + path, (Throwable)e);
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("loadedEntityName", "keystore");
                parameters.put("message", path.getFileName().toString() + " doesn't exist");
                validationResult.addError(ValidationError.FAILED_TO_LOAD_FROM_FILE.toErrorInfo(parameters, "keyStoreFileName"));
            }
        } else {
            validationResult.addError(ValidationError.FILE_IS_MISSING.toErrorInfo(Collections.singletonMap("loadedEntityName", "keystore"), "keyStoreFileName"));
        }
        return null;
    }

    protected final boolean isEmptyDirectory(@NotNull Path dir) throws IOException {
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir);){
            boolean bl = !stream.iterator().hasNext();
            return bl;
        }
    }

    private static class ConfFileFilter
    implements PathFilter {
        @NotNull
        private final Path sourceConfPath;
        @NotNull
        private final Path targetConfPath;

        ConfFileFilter(@NotNull Path sourceConfPath, @NotNull Path targetConfPath) {
            this.sourceConfPath = sourceConfPath;
            this.targetConfPath = targetConfPath;
        }

        @Override
        public boolean accept(Path filePath) {
            Path targetFile = this.targetConfPath.resolve(this.sourceConfPath.relativize(filePath));
            if (filePath.getFileName().toString().endsWith("wizard-configured.properties")) {
                return false;
            }
            return !filePath.getFileName().toString().endsWith(".dist") && !filePath.endsWith(DEFAULT_RELATIVE_ADDITIONAL_KEYSTORE_PATH) || !Files.exists(targetFile, new LinkOption[0]);
        }
    }

    class PathKey {
        private final Logger LOG = LoggerFactory.getLogger(this.getClass());
        private final Path path;
        private int contentHashCode;

        public PathKey(Path path) throws IOException {
            this.path = path;
            Path normalizedPath = this.getNormalizedPath(path);
            boolean exists = Files.exists(normalizedPath, new LinkOption[0]);
            boolean isDirectory = Files.isDirectory(normalizedPath, new LinkOption[0]);
            if (!exists) {
                this.contentHashCode = normalizedPath.toAbsolutePath().hashCode();
            } else if (!isDirectory) {
                this.contentHashCode = this.calculateHashCode(normalizedPath);
            } else {
                Files.walkFileTree(normalizedPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                        Objects.requireNonNull(dir);
                        Objects.requireNonNull(attrs);
                        PathKey.this.contentHashCode = 61 * PathKey.this.contentHashCode + PathKey.this.calculateHashCode(dir);
                        return FileVisitResult.CONTINUE;
                    }

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Objects.requireNonNull(file);
                        Objects.requireNonNull(attrs);
                        PathKey.this.contentHashCode = 61 * PathKey.this.contentHashCode + PathKey.this.calculateHashCode(file);
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }

        Path getNormalizedPath(Path path) {
            Path normalizedPath = path;
            try {
                File file = path.toFile();
                Path canonicalPath = Paths.get(file.getCanonicalPath(), new String[0]);
                normalizedPath = canonicalPath.toRealPath(new LinkOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return normalizedPath;
        }

        private int calculateHashCode(Path p) {
            int result = p.hashCode();
            try {
                AclFileAttributeView aclView;
                result = 61 * result + Files.getLastModifiedTime(p, new LinkOption[0]).hashCode();
                boolean isDirectory = Files.isDirectory(p, new LinkOption[0]);
                result = 61 * result + (isDirectory ? 1 : 0);
                result = 61 * result + (Files.isRegularFile(p, new LinkOption[0]) ? 1 : 0);
                result = 61 * result + (Files.isSymbolicLink(p) ? 1 : 0);
                result = 61 * result + (Files.isReadable(p) ? 1 : 0);
                result = 61 * result + (Files.isWritable(p) ? 1 : 0);
                result = 61 * result + (Files.isExecutable(p) ? 1 : 0);
                result = 61 * result + Files.getOwner(p, new LinkOption[0]).hashCode();
                PosixFileAttributeView posixView = Files.getFileAttributeView(p, PosixFileAttributeView.class, new LinkOption[0]);
                if (posixView != null) {
                    PosixFileAttributes posixFileAttributes = posixView.readAttributes();
                    result = 61 * result + posixFileAttributes.group().hashCode();
                    result = 61 * result + posixFileAttributes.permissions().hashCode();
                }
                if ((aclView = Files.getFileAttributeView(p, AclFileAttributeView.class, new LinkOption[0])) != null) {
                    List<AclEntry> acl = aclView.getAcl();
                    result = 61 * result + acl.hashCode();
                }
            }
            catch (IOException e) {
                this.LOG.warn("IOException in getLocationHashCode: " + e.getMessage());
            }
            return result;
        }

        public Path getPath() {
            return this.path;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PathKey that = (PathKey)o;
            return this.contentHashCode == that.contentHashCode;
        }

        public int hashCode() {
            return this.contentHashCode;
        }
    }

    class PrepareResult {
        private final Path preparedSourceLocation;
        private final ErrorInfo errorInfo;

        PrepareResult(ErrorInfo errorInfo) {
            this.errorInfo = errorInfo;
            this.preparedSourceLocation = null;
        }

        PrepareResult(Path preparedSourceLocation) {
            this.preparedSourceLocation = preparedSourceLocation;
            this.errorInfo = null;
        }

        Path getPreparedSourceLocation() {
            return this.preparedSourceLocation;
        }

        @Nullable
        ErrorInfo getErrorInfo() {
            return this.errorInfo;
        }
    }
}

