/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.validation;

import com.jetbrains.bundle.BundleInstallationType;
import com.jetbrains.bundle.hub_client.util.validation.ErrorInfo;
import com.jetbrains.bundle.hub_client.util.validation.ValidationResult;
import com.jetbrains.installer.model.SupportedLocale;
import com.jetbrains.installer.model.WizardBackendConfig;
import com.jetbrains.installer.model.WizardInfo;
import com.jetbrains.installer.model.blocks.BasicSettings;
import com.jetbrains.installer.validation.BundlePropertiesValidator;
import com.jetbrains.installer.validation.ValidationError;
import com.jetbrains.installer.validation.folder.InstallPathValidator;
import com.jetbrains.installer.validation.folder.impl.CleanDataFolderValidator;
import com.jetbrains.installer.validation.folder.impl.EmptyPathValidator;
import com.jetbrains.installer.validation.folder.impl.FolderWriteAccessValidator;
import com.jetbrains.installer.validation.folder.impl.NonRootPathValidator;
import com.jetbrains.installer.validation.folder.impl.OldDataPathValidator;
import com.jetbrains.service.util.SecureMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BasicSettingsValidator
implements InstallPathValidator {
    @Autowired
    BundlePropertiesValidator bundlePropertiesValidator;
    @Autowired
    FolderWriteAccessValidator writeAccessValidator;
    @Autowired
    CleanDataFolderValidator cleanDataFolderValidator;
    @Autowired
    EmptyPathValidator emptyPathValidator;
    @Autowired
    NonRootPathValidator nonRootPathValidator;
    @Autowired
    OldDataPathValidator oldDataPathValidator;
    @Autowired
    private WizardInfo wizardInfo;
    @Autowired
    private WizardBackendConfig wizardBackendConfig;

    @NotNull
    public ValidationResult validate(@NotNull BasicSettings settings) {
        ValidationResult result = new ValidationResult();
        this.bundlePropertiesValidator.validateUrl(settings.getBaseUrl(), "baseUrl", result);
        settings.getServerConnectorModeSettings().validate(this.bundlePropertiesValidator, result);
        Collection<SupportedLocale> availableProductLocales = this.wizardInfo.getAvailableProductLocales();
        String selectedProductLocale = settings.getProductLocale();
        if (!availableProductLocales.isEmpty()) {
            if (selectedProductLocale == null) {
                result.addError(ValidationError.PROPERTY_MUST_NOT_BE_EMPTY.toErrorInfo("Locale cannot be empty", "productLocale"));
            } else if (!SupportedLocale.containsLocale(availableProductLocales, selectedProductLocale)) {
                result.addError(ValidationError.LOCALE_IS_NOT_SUPPORTED.toErrorInfo(Collections.singletonMap("locale", selectedProductLocale), "Locale '" + selectedProductLocale + "' is not supported", "productLocale"));
            }
        } else if (selectedProductLocale != null) {
            result.addError(ValidationError.LOCALE_IS_NOT_SUPPORTED.toErrorInfo(Collections.singletonMap("locale", selectedProductLocale), "Locale '" + selectedProductLocale + "' is not supported", "productLocale"));
        }
        this.checkPaths(settings, result);
        if (settings.getServerConnectorModeSettings().getSecureMode() != SecureMode.DISABLE && settings.getSecureContent() != null) {
            settings.getSecureContent().validate(result);
        }
        return result;
    }

    private void checkPaths(@NotNull BasicSettings settings, @NotNull ValidationResult result) {
        ArrayList<ErrorInfo> errors = new ArrayList<ErrorInfo>();
        ErrorInfo errorInfo = this.checkPath(settings.getDataDir(), "dataDir");
        if (errorInfo != null) {
            errors.add(errorInfo);
        }
        if ((errorInfo = this.checkPath(settings.getTempDir(), "tempDir")) != null) {
            errors.add(errorInfo);
        }
        if ((errorInfo = this.checkPath(settings.getLogsDir(), "logsDir")) != null) {
            errors.add(errorInfo);
        }
        if ((errorInfo = this.checkPath(settings.getBackupsDir(), "backupsDir")) != null) {
            errors.add(errorInfo);
        }
        for (ErrorInfo error : errors) {
            result.addError(error);
        }
    }

    @Override
    @Nullable
    public ErrorInfo checkPath(@NotNull String path, @NotNull String fieldName) {
        Collection<InstallPathValidator> validators = this.getFolderValidators(fieldName);
        if (validators != null && !validators.isEmpty()) {
            for (InstallPathValidator validator : validators) {
                ErrorInfo validatorResult = validator.checkPath(path, fieldName);
                if (validatorResult == null) continue;
                return validatorResult;
            }
        }
        return null;
    }

    public Collection<InstallPathValidator> getFolderValidators(@NotNull String property) {
        if ("dataDir".equals(property)) {
            return Arrays.asList(this.emptyPathValidator, this.nonRootPathValidator, this.oldDataPathValidator, this.cleanDataFolderValidator, this.writeAccessValidator);
        }
        return Arrays.asList(this.emptyPathValidator, this.writeAccessValidator);
    }

    public Set<String> getDisabledFields() {
        HashSet disabledFields = new HashSet();
        if (BundleInstallationType.DOCKER == this.wizardBackendConfig.getInstallationType()) {
            Collections.addAll(disabledFields, "backupsDir", "dataDir", "logsDir", "tempDir");
        } else if (BundleInstallationType.JAR == this.wizardBackendConfig.getInstallationType()) {
            Collections.addAll(disabledFields, "dataDir");
        }
        return Collections.unmodifiableSet(disabledFields);
    }
}

