/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.validation;

import com.jetbrains.bundle.hub_client.util.validation.ValidationResult;
import com.jetbrains.installer.model.BundleDefaults;
import com.jetbrains.installer.model.WizardBackendConfig;
import com.jetbrains.installer.model.WizardInfo;
import com.jetbrains.installer.validation.ValidationEndpointsManager;
import com.jetbrains.installer.validation.ValidationError;
import com.jetbrains.service.util.ServiceUtil;
import com.jetbrains.service.util.UrlUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BundlePropertiesValidator {
    @Autowired
    private WizardInfo wizardInfo;
    @Autowired
    WizardBackendConfig wizardBackendConfig;
    @Autowired
    BundleDefaults bundleDefaults;
    @Autowired
    ValidationEndpointsManager validationEndpointsManager;
    protected final Logger LOG = LoggerFactory.getLogger((String)this.getClass().getName());

    public void validateBundleRootPassword(String password, @NotNull ValidationResult result) {
        if (StringUtils.isEmpty((CharSequence)password)) {
            result.addError(ValidationError.PROPERTY_MUST_NOT_BE_EMPTY.toErrorInfo("Root password cannot be empty", "rootPassword"));
        }
    }

    public void validateUrl(String value, @NotNull String propertyName, @NotNull ValidationResult result) {
        URL newBaseUrl;
        if (StringUtils.isEmpty((CharSequence)value)) {
            result.addError(ValidationError.PROPERTY_MUST_NOT_BE_EMPTY.toErrorInfo("URL cannot be empty", propertyName));
            return;
        }
        try {
            newBaseUrl = new URL(value);
        }
        catch (MalformedURLException e) {
            result.addError(ValidationError.MALFORMED_BASE_URL.toErrorInfo(Collections.singletonMap("error", e.getMessage()), e.getMessage(), propertyName));
            return;
        }
        String wizardUrlAsString = this.wizardBackendConfig.getWizardBaseUrl();
        String baseUrlAsString = this.bundleDefaults.getBaseUrl();
        try {
            URL wizardUrl = new URL(wizardUrlAsString);
            String wizardContext = UrlUtil.trimSlashes((String)wizardUrl.getPath());
            URL baseUrl = new URL(baseUrlAsString);
            String baseUrlContext = UrlUtil.trimSlashes((String)baseUrl.getPath());
            if (!wizardContext.equals(baseUrlContext) && (baseUrlContext.isEmpty() || UrlUtil.isContextStartedWith((String)wizardContext, (String)baseUrlContext))) {
                String wizardOwnContext = wizardContext.substring(baseUrlContext.length(), wizardContext.length());
                if (newBaseUrl.getPath().contains(wizardContext)) {
                    result.addError(ValidationError.WIZARD_CRYPTIC_SUB_CONTEXT_IN_BASE_URL.toErrorInfo(Collections.singletonMap("entry", wizardOwnContext), "Base URL context path contains not allowed entry: " + wizardOwnContext, propertyName));
                }
            }
        }
        catch (MalformedURLException e) {
            this.LOG.debug("Either wizardUrl {} or baseUrl {} is malformed", (Object)wizardUrlAsString, (Object)baseUrlAsString);
        }
    }

    public void validateBundleRootUser(String userName, @NotNull ValidationResult result) {
        if (StringUtils.isEmpty((CharSequence)userName)) {
            result.addError(ValidationError.PROPERTY_MUST_NOT_BE_EMPTY.toErrorInfo("Root user cannot be empty", "rootUser"));
        } else if (userName.length() < 2) {
            result.addError(ValidationError.PROPERTY_TOO_SHORT.toErrorInfo(Collections.singletonMap("size", "2"), "Root user name is too short", "rootUser"));
        } else if (userName.length() > 32) {
            result.addError(ValidationError.PROPERTY_TOO_LONG.toErrorInfo(Collections.singletonMap("size", "32"), "Root user name is too long", "rootUser"));
        } else if (!userName.matches("^[\\w\\u00C0-\\u01BF\\u01C4-\\u024F\\u0400-\\u04FF@$+=|.-]+$")) {
            result.addError(ValidationError.PROPERTY_CONTAINS_INCORRECT_CHARACTERS.toErrorInfo("Root user name contains incorrect characters", "rootUser"));
        }
    }

    public void validateBundleListenAddressAndPort(String listenAddress, String listenPortAsString, @NotNull ValidationResult result, String jsonPropertyName) {
        Integer listenPort = this.validateListenPort(listenPortAsString, result, jsonPropertyName);
        if ((listenAddress = this.validateListenAddress(listenAddress, result)) != null && listenPort != null) {
            this.checkCanListenOn(listenAddress, listenPort, result, jsonPropertyName);
        }
    }

    @Nullable
    public String validateListenAddress(String listenAddress, @NotNull ValidationResult result) {
        if (listenAddress == null) {
            if (this.wizardBackendConfig.isListenAddressEditableFlag()) {
                result.addError(ValidationError.PROPERTY_MUST_NOT_BE_EMPTY.toErrorInfo("Listen address is required", "listenAddress"));
            } else {
                listenAddress = this.bundleDefaults.getListenAddress();
            }
        } else if (!listenAddress.equalsIgnoreCase(this.bundleDefaults.getListenAddress())) {
            this.checkCanListenOn(listenAddress, null, result, "listenAddress");
        }
        return listenAddress;
    }

    @Nullable
    public Integer validateListenPort(@Nullable String listenPortAsString, @NotNull ValidationResult result, @NotNull String jsonPropertyName) {
        Integer listenPort = null;
        if (listenPortAsString == null) {
            result.addError(ValidationError.PROPERTY_MUST_NOT_BE_EMPTY.toErrorInfo("Listen port is required", jsonPropertyName));
        } else {
            try {
                Integer tmpListenPort = Integer.parseInt(listenPortAsString);
                if (tmpListenPort < 1 || tmpListenPort > 65535) {
                    HashMap<String, String> parameters = new HashMap<String, String>();
                    parameters.put("from", Integer.toString(1, 10));
                    parameters.put("to", Integer.toString(65535, 10));
                    result.addError(ValidationError.LISTEN_PORT_IS_OUT_OF_BOUNDS.toErrorInfo(parameters, String.format("Listen port should be between %s and %s", 1, 65535), jsonPropertyName));
                } else {
                    listenPort = tmpListenPort;
                }
            }
            catch (NumberFormatException e) {
                result.addError(ValidationError.PROPERTY_MUST_BE_A_NUMBER.toErrorInfo(jsonPropertyName, "Listen port should be a number, but '" + listenPortAsString + "' was provided."));
            }
        }
        return listenPort;
    }

    public boolean checkCanListenOn(@NotNull String listenAddress, @Nullable Integer listenPort, @NotNull ValidationResult result, @NotNull String jsonPropertyName) {
        if (!this.wizardInfo.isListenAddressEditable() && listenPort == null) {
            return true;
        }
        if (listenPort != null && this.checkIfThereIsValidStartedEndpoint(listenAddress, listenPort)) {
            return true;
        }
        boolean checkResult = false;
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("address", listenAddress);
        int portForCheck = listenPort != null ? listenPort : 0;
        parameters.put("port", Integer.toString(portForCheck, 10));
        try {
            checkResult = ServiceUtil.isPortAvailable((String)listenAddress, (int)portForCheck, (boolean)true);
            if (!checkResult) {
                result.addError(ValidationError.COULD_NOT_LISTEN_ON_ADDRESS_AND_PORT.toErrorInfo(parameters, String.format("Could not listen on %s%s", listenAddress, listenPort != null ? ":" + listenPort : ""), jsonPropertyName));
            }
        }
        catch (Exception e) {
            result.addError(ValidationError.COULD_NOT_LISTEN_ON_ADDRESS_AND_PORT.toErrorInfo(parameters, String.format("Could not listen on %s%s%s", listenAddress, listenPort != null ? ":" + listenPort : "", e.getMessage() != null ? " : " + e.getMessage() : ""), jsonPropertyName));
        }
        return checkResult;
    }

    private boolean checkIfThereIsValidStartedEndpoint(@NotNull String listenAddress, @NotNull Integer listenPort) {
        boolean isOccupiedByWizardSinceStartup;
        boolean bl = isOccupiedByWizardSinceStartup = listenPort.equals(Integer.parseInt(this.bundleDefaults.getBundleListenPort())) || this.bundleDefaults.getTlsRedirectionFromHttpListenPort() != null && listenPort.equals(Integer.parseInt(this.bundleDefaults.getTlsRedirectionFromHttpListenPort()));
        if (isOccupiedByWizardSinceStartup) {
            return this.checkIfThereIsValidStartedEndpoint(listenAddress);
        }
        Set<ValidationEndpointsManager.EndpointKey> endpoints = this.validationEndpointsManager.getEndpointKeysByListenPort(listenPort.toString());
        for (ValidationEndpointsManager.EndpointKey endpoint : endpoints) {
            if (!this.checkIfThereIsValidStartedEndpoint(endpoint.getListenAddress())) continue;
            return true;
        }
        return false;
    }

    private boolean checkIfThereIsValidStartedEndpoint(@NotNull String listenAddress) {
        if (listenAddress.equals(this.bundleDefaults.getListenAddress())) {
            return true;
        }
        if ("0.0.0.0".equals(this.bundleDefaults.getListenAddress())) {
            return true;
        }
        return "0.0.0.0".equals(listenAddress);
    }
}

