/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.validation;

import com.jetbrains.bundle.BundleEnvironment;
import com.jetbrains.bundle.BundleInstallationType;
import com.jetbrains.bundle.hub_client.util.validation.ErrorInfo;
import com.jetbrains.installer.model.PathInfo;
import com.jetbrains.installer.model.blocks.UpgradeSettings;
import com.jetbrains.installer.model.blocks.UpgradeSettingsContext;
import com.jetbrains.installer.model.blocks.UpgradeSource;
import com.jetbrains.installer.validation.BaseUpgradeHelper;
import com.jetbrains.installer.validation.UpgradeValidationException;
import com.jetbrains.installer.validation.ValidationError;
import com.jetbrains.service.util.BundleProperty;
import com.jetbrains.service.util.properties.impl.PropertiesBasedConfigurationHelper;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

abstract class ConfBasedUpgradeHelper
extends BaseUpgradeHelper {
    private static final DirectoryStream.Filter<Path> FOLDERS_FILTER = new DirectoryStream.Filter<Path>(){

        @Override
        public boolean accept(Path entry) {
            return Files.isDirectory(entry, new LinkOption[0]);
        }
    };

    ConfBasedUpgradeHelper() {
    }

    @Override
    protected void validateOldInstallationDir(@NotNull Path installationDir, @NotNull Properties extractedProperties, @NotNull String property, @NotNull Path sourceLocation) throws UpgradeValidationException {
        Path dataDir = this.resolveDirFromInstallation(installationDir, BundleProperty.DATA_DIR, property);
        this.checkDataDirResolvedFromOldInstallationIsNotEmpty(dataDir, property, sourceLocation);
    }

    @Override
    protected final void validateBackupDir(@NotNull Path location, @NotNull Properties extractedProperties, @NotNull String property, @NotNull UpgradeSource.Type type) throws UpgradeValidationException {
        Path backupDir = this.findRootBackupDir(location, "sourceLocation");
        this.validateConfFromBackupDir(property, backupDir, type);
        this.validateDataFromBackupDir(property, backupDir);
    }

    protected final void validateConfFromBackupDir(@NotNull String property, @NotNull Path backupDir, @NotNull UpgradeSource.Type type) throws UpgradeValidationException {
        Path confDir = backupDir.resolve("conf");
        Properties bundleUpgradePropertiesFromConf = this.loadUpgradePropertiesFromBackupConfDir(confDir, property);
        Properties bundlePropertiesFromConf = this.loadBundlePropertiesFromConfDir(confDir, property);
        if (bundlePropertiesFromConf == null) {
            ErrorInfo errorInfo = this.getNoPropertiesFileInConfError(property, backupDir, type, "bundle.properties");
            throw new UpgradeValidationException(errorInfo);
        }
        this.checkProductNameAndVersions(bundleUpgradePropertiesFromConf, bundlePropertiesFromConf, property, type);
    }

    @NotNull
    private ErrorInfo getNoPropertiesFileInConfError(@NotNull String property, @NotNull Path backupDir, @NotNull UpgradeSource.Type type, @NotNull String propertiesFileName) {
        ErrorInfo errorInfo;
        if (type == UpgradeSource.Type.BACKUP_ARCHIVE) {
            String message = String.format("Cannot find config file %s in backup", propertiesFileName);
            errorInfo = ValidationError.BUNDLE_CONFIG_NOT_FOUND_IN_BACKUP_ARCHIVE.toErrorInfo(message, property);
        } else {
            String message = String.format("Cannot find config file %s in backup in directory %s", propertiesFileName, backupDir.toString());
            errorInfo = ValidationError.BUNDLE_CONFIG_NOT_FOUND_IN_UNCOMPRESSED_BACKUP.toErrorInfo(message, property);
        }
        return errorInfo;
    }

    protected abstract void validateDataFromBackupDir(@NotNull String var1, @NotNull Path var2) throws UpgradeValidationException;

    @NotNull
    protected final Path findRootBackupDir(@NotNull Path location, @NotNull String uiProperty) throws UpgradeValidationException {
        try {
            List<Path> subDirs = this.listFilteredPaths(location, FOLDERS_FILTER);
            if (subDirs.size() == 1 && this.looksLikeBackupDir(subDirs.get(0))) {
                return subDirs.get(0);
            }
            if (this.looksLikeBackupDir(location)) {
                return location;
            }
            String message = String.format("Cannot find data and conf directories in backup %s", location.toString());
            throw new UpgradeValidationException(ValidationError.INVALID_BACKUP_CONTENT.toErrorInfo(message, uiProperty));
        }
        catch (IOException e) {
            String message = String.format("Cannot process backup in directory %s: %s", location.toString(), e.getMessage());
            throw new UpgradeValidationException(this.writeAccessValidator.constructInaccessibleOrEmptyError(location.toString(), message, uiProperty));
        }
    }

    protected boolean looksLikeBackupDir(@NotNull Path path) {
        Path confDir = path.resolve("conf");
        Path buildTimeConfFile = path.resolve("internal").resolve("conf").resolve("bundle_build.properties");
        Path resolvedDataDir = this.resolveDataDirFromBackupDir(path);
        return resolvedDataDir != null && Files.exists(resolvedDataDir, new LinkOption[0]) && Files.isDirectory(resolvedDataDir, new LinkOption[0]) && Files.exists(confDir, new LinkOption[0]) && Files.isDirectory(confDir, new LinkOption[0]) && !Files.exists(buildTimeConfFile, new LinkOption[0]);
    }

    protected abstract Path resolveDataDirFromBackupDir(Path var1);

    @Override
    protected UpgradeSettings extractSettingsFromOldInstallation(@NotNull Path location, @NotNull Properties extractedProperties) throws UpgradeValidationException {
        UpgradeSettings upgradeSettings = new UpgradeSettings();
        UpgradeSettingsContext upgradeSettingsContext = new UpgradeSettingsContext();
        upgradeSettings.setContext(upgradeSettingsContext);
        BundleEnvironment bundleEnv = new BundleEnvironment(location);
        String property = "sourceLocation";
        Properties bundleProperties = this.loadBundlePropertiesFromInstallationDir(bundleEnv, property);
        Properties bundleUpgradeProperties = this.loadUpgradePropertiesFromInstallationDir(bundleEnv, property);
        Properties hubProperties = this.loadHubPropertiesFromInstallationDir(bundleEnv, property);
        String oldProductVersion = this.getOldProductVersionFromConfigs(bundleUpgradeProperties, bundleProperties);
        boolean isRestore = Objects.equals(this.wizardBackendConfig.getProductFullVersion(), oldProductVersion);
        String baseUrl = bundleProperties.getProperty(BundleProperty.BASE_URL.getName());
        String listenPort = bundleProperties.getProperty(BundleProperty.LISTEN_PORT.getName());
        if (this.wizardBackendConfig.getInstallationType() == BundleInstallationType.DOCKER) {
            listenPort = null;
        }
        String listenAddress = bundleProperties.getProperty(BundleProperty.LISTEN_ADDRESS.getName());
        if (this.wizardBackendConfig.getInstallationType() == BundleInstallationType.DOCKER) {
            listenAddress = null;
        }
        String suitableOldDataDir = this.getSuitableDirFromUpgradeSourceConfigs(bundleProperties, BundleProperty.DATA_DIR);
        String dataDir = this.getFromDefaultsIfNull(suitableOldDataDir, BundleProperty.DATA_DIR.getName());
        String suitableOldLogsDir = this.getSuitableDirFromUpgradeSourceConfigs(bundleProperties, BundleProperty.LOGS_DIR);
        String logsDir = this.getFromDefaultsIfNull(suitableOldLogsDir, BundleProperty.LOGS_DIR.getName());
        String suitableOldTempDir = this.getSuitableDirFromUpgradeSourceConfigs(bundleProperties, BundleProperty.TEMP_DIR);
        String tempDir = this.getFromDefaultsIfNull(suitableOldTempDir, BundleProperty.TEMP_DIR.getName());
        String suitableOldBackupsDir = this.getSuitableDirFromUpgradeSourceConfigs(bundleProperties, BundleProperty.BACKUPS_DIR);
        String backupsDir = this.getFromDefaultsIfNull(suitableOldBackupsDir, BundleProperty.BACKUPS_DIR.getName());
        baseUrl = this.getFromDefaultsIfNull(baseUrl, BundleProperty.BASE_URL.getName());
        boolean isExternalHubUsed = !PropertiesBasedConfigurationHelper.getHelper().isServiceEnabled((Object)bundleProperties, "hub");
        String externalHubUrl = isExternalHubUsed ? bundleProperties.getProperty(BundleProperty.HUB_URL.getName()) : null;
        String redirectionFromHttpFlag = bundleProperties.getProperty(BundleProperty.TLS_REDIRECT_FROM_HTTP_FLAG.getName());
        String nonSecureRedirectListenPort = bundleProperties.getProperty(BundleProperty.TLS_REDIRECT_FROM_HTTP_LISTEN_PORT.getName());
        String secureMode = bundleProperties.getProperty(BundleProperty.SECURE_MODE.getName());
        this.extractConnectorSettings(upgradeSettings, listenAddress, listenPort, redirectionFromHttpFlag, nonSecureRedirectListenPort, secureMode);
        this.extractKeystoreInfo(upgradeSettings, bundleProperties, upgradeSettings.getServerConnectorModeSettings().getSecureMode(), bundleEnv.getConfDir(), upgradeSettingsContext);
        upgradeSettings.setBaseUrl(baseUrl);
        upgradeSettings.setDataDir(PathInfo.ensureEndsAsDir(dataDir));
        upgradeSettings.setTempDir(PathInfo.ensureEndsAsDir(tempDir));
        upgradeSettings.setLogsDir(PathInfo.ensureEndsAsDir(logsDir));
        upgradeSettings.setBackupsDir(PathInfo.ensureEndsAsDir(backupsDir));
        upgradeSettingsContext.setExtractedProperties(extractedProperties);
        upgradeSettingsContext.setOldProductVersion(oldProductVersion);
        upgradeSettingsContext.setExternalHubUsed(isExternalHubUsed);
        upgradeSettings.setExternalHubUrl(externalHubUrl);
        upgradeSettingsContext.setIsRestore(isRestore);
        this.setHubServiceIdsAndSecretsFromHubProperties(upgradeSettingsContext, hubProperties);
        return upgradeSettings;
    }

    @Override
    protected UpgradeSettings extractSettingsFromBackup(@NotNull Path location, @NotNull Properties extractedProperties, @NotNull UpgradeSource.Type type) throws UpgradeValidationException {
        this.validateBackupDir(location, extractedProperties, "sourceLocation", type);
        String property = "sourceLocation";
        Path backupDir = this.findRootBackupDir(location, "sourceLocation");
        UpgradeSettings upgradeSettings = new UpgradeSettings();
        UpgradeSettingsContext upgradeSettingsContext = new UpgradeSettingsContext();
        upgradeSettings.setContext(upgradeSettingsContext);
        Path confDir = backupDir.resolve("conf");
        Properties bundleProperties = this.loadBundlePropertiesFromConfDir(confDir, property);
        if (bundleProperties == null) {
            ErrorInfo errorInfo = this.getNoPropertiesFileInConfError(property, backupDir, type, "bundle.properties");
            throw new UpgradeValidationException(errorInfo);
        }
        Properties hubProperties = this.loadHubPropertiesFromConfDir(confDir, property);
        if (hubProperties == null) {
            ErrorInfo errorInfo = this.getNoPropertiesFileInConfError(property, backupDir, type, "hub.properties");
            throw new UpgradeValidationException(errorInfo);
        }
        Properties bundleUpgradeProperties = this.loadUpgradePropertiesFromBackupConfDir(confDir, property);
        String oldProductVersion = this.getOldProductVersionFromConfigs(bundleUpgradeProperties, bundleProperties);
        boolean isRestore = Objects.equals(this.wizardBackendConfig.getProductFullVersion(), oldProductVersion);
        String baseUrl = bundleProperties.getProperty(BundleProperty.BASE_URL.getName());
        baseUrl = this.getFromDefaultsIfNull(baseUrl, BundleProperty.BASE_URL.getName());
        String suitableOldDataDir = this.getSuitableDirFromUpgradeSourceConfigs(bundleProperties, BundleProperty.DATA_DIR);
        String dataDir = this.getFromDefaultsIfNull(suitableOldDataDir, BundleProperty.DATA_DIR.getName());
        String suitableOldTempDir = this.getSuitableDirFromUpgradeSourceConfigs(bundleProperties, BundleProperty.TEMP_DIR);
        String tempDir = this.getFromDefaultsIfNull(suitableOldTempDir, BundleProperty.TEMP_DIR.getName());
        String suitableOldLogsDir = this.getSuitableDirFromUpgradeSourceConfigs(bundleProperties, BundleProperty.LOGS_DIR);
        String logsDir = this.getFromDefaultsIfNull(suitableOldLogsDir, BundleProperty.LOGS_DIR.getName());
        String suitableOldBackupsDir = this.getSuitableDirFromUpgradeSourceConfigs(bundleProperties, BundleProperty.BACKUPS_DIR);
        String backupsDir = this.getFromDefaultsIfNull(suitableOldBackupsDir, BundleProperty.BACKUPS_DIR.getName());
        boolean isExternalHubUsed = !PropertiesBasedConfigurationHelper.getHelper().isServiceEnabled((Object)bundleProperties, "hub");
        String externalHubUrl = isExternalHubUsed ? bundleProperties.getProperty(BundleProperty.HUB_URL.getName()) : null;
        this.extractConnectorSettings(upgradeSettings, bundleProperties);
        this.extractKeystoreInfo(upgradeSettings, bundleProperties, upgradeSettings.getServerConnectorModeSettings().getSecureMode(), confDir, upgradeSettingsContext);
        upgradeSettings.setBaseUrl(baseUrl);
        upgradeSettings.setDataDir(PathInfo.ensureEndsAsDir(dataDir));
        upgradeSettings.setTempDir(PathInfo.ensureEndsAsDir(tempDir));
        upgradeSettings.setLogsDir(PathInfo.ensureEndsAsDir(logsDir));
        upgradeSettings.setBackupsDir(PathInfo.ensureEndsAsDir(backupsDir));
        upgradeSettingsContext.setExtractedProperties(extractedProperties);
        upgradeSettingsContext.setOldProductVersion(oldProductVersion);
        upgradeSettingsContext.setExternalHubUsed(isExternalHubUsed);
        upgradeSettings.setExternalHubUrl(externalHubUrl);
        upgradeSettingsContext.setIsRestore(isRestore);
        this.setHubServiceIdsAndSecretsFromHubProperties(upgradeSettingsContext, hubProperties);
        return upgradeSettings;
    }

    @Override
    protected void prepareUpdateFromBackup(@NotNull UpgradeSettings upgradeSettings, @NotNull Path preparedLocation, UpgradeSource.Type type) throws UpgradeValidationException {
        Path backupDir = this.findRootBackupDir(preparedLocation, "dataDir");
        Path oldConfDir = backupDir.resolve("conf");
        Path oldDataDir = this.resolveDataDirFromBackupDir(backupDir);
        Path installationDirectory = Paths.get(this.wizardBackendConfig.getInstallationDirectory(), new String[0]);
        BundleEnvironment newBundleEnv = new BundleEnvironment(installationDirectory);
        Path newConfDir = newBundleEnv.getConfDir();
        Path newDataDir = Paths.get(upgradeSettings.getDataDir(), new String[0]).toAbsolutePath();
        this.assertDiskSpaceForDirCopy(oldDataDir, newDataDir);
        this.prepareConfDir(oldConfDir, newConfDir, upgradeSettings);
        this.prepareDataDir(oldDataDir, newDataDir);
    }
}

