/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.validation;

import com.jetbrains.bundle.hub_client.util.validation.ValidationResult;
import com.jetbrains.installer.model.blocks.HubBundleServiceInfo;
import com.jetbrains.installer.model.blocks.HubSettings;
import com.jetbrains.installer.util.WizardHubUtil;
import com.jetbrains.installer.validation.BundlePropertiesValidator;
import com.jetbrains.installer.validation.ValidationError;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class HubSettingsValidator {
    @Autowired
    WizardHubUtil wizardHubUtil;
    @Autowired
    BundlePropertiesValidator bundlePropertiesValidator;

    @NotNull
    public ValidationResult validate(HubSettings block, @Nullable HubBundleServiceInfo hubBundleServiceInfo) {
        ValidationResult result = new ValidationResult();
        if (block.getDisableInternalHub().booleanValue()) {
            String hubUrl = block.getHubUrl();
            this.wizardHubUtil.getHubUrlValidatorForCleanInstallation().validate(hubUrl, result, "hubUrl", false);
            if (hubBundleServiceInfo != null) {
                String hubUrlWithOrWithoutSlash;
                String verifiedHubUrl = hubBundleServiceInfo.getHubUrl();
                String originalHubUrl = hubBundleServiceInfo.getOriginalHubUrl();
                String string = hubUrlWithOrWithoutSlash = hubUrl.endsWith("/") ? hubUrl.substring(0, hubUrl.length() - 1) : hubUrl + "/";
                if (!(hubUrl.equals(verifiedHubUrl) || hubUrl.equals(originalHubUrl) || hubUrlWithOrWithoutSlash.equals(verifiedHubUrl) || hubUrlWithOrWithoutSlash.equals(originalHubUrl))) {
                    result.addError(ValidationError.HUB_URL_NOT_VERIFIED.toErrorInfo("Hub URL was changed after verification", "hubUrl"));
                } else if (!hubBundleServiceInfo.isTrusted()) {
                    result.addError(ValidationError.HUB_URL_NOT_VERIFIED.toErrorInfo("Hub URL is not verified", "hubUrl"));
                }
            }
        } else {
            this.bundlePropertiesValidator.validateBundleRootUser(block.getRootUser(), result);
            this.bundlePropertiesValidator.validateBundleRootPassword(block.getRootPassword(), result);
        }
        return result;
    }
}

