/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.validation;

import com.jetbrains.installer.database.ExodusExplorer;
import com.jetbrains.installer.validation.ConfBasedUpgradeHelper;
import com.jetbrains.installer.validation.UpgradeValidationException;
import com.jetbrains.installer.validation.ValidationError;
import com.jetbrains.service.util.DeleteFileVisitor;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;

public class HubUpgradeHelper
extends ConfBasedUpgradeHelper {
    @Autowired
    ExodusExplorer exodusExplorer;
    public static final DirectoryStream.Filter<Path> FILES_WITH_EXT_XD_FILTER = new DirectoryStream.Filter<Path>(){

        @Override
        public boolean accept(Path entry) throws IOException {
            return entry.toString().toLowerCase().endsWith(".xd");
        }
    };

    @Override
    protected void validateDataFromBackupDir(@NotNull String property, @NotNull Path backupDir) throws UpgradeValidationException {
        Path dataDir = this.resolveDataDirFromBackupDir(backupDir);
        if (dataDir == null) {
            throw new IllegalStateException("dataDir should has been defined to this moment");
        }
        Path hubDir = dataDir.resolve("hub");
        try {
            List<Path> xdFiles = this.listFilteredPaths(hubDir, FILES_WITH_EXT_XD_FILTER);
            if (xdFiles.isEmpty()) {
                String message = String.format("Cannot find '.xd' file in Hub data directory: %s", hubDir);
                throw new UpgradeValidationException(ValidationError.INVALID_BACKUP_CONTENT.toErrorInfo(message, property));
            }
        }
        catch (IOException e) {
            String message = String.format("Cannot process backup's data directory %s: %s", backupDir, e.getMessage());
            throw new UpgradeValidationException(this.writeAccessValidator.constructInaccessibleOrEmptyError(backupDir.toString(), message, property));
        }
    }

    @Override
    protected Path resolveDataDirFromBackupDir(Path backupDir) {
        Path hubDir;
        Path nestedHubDir;
        Path dataDir = backupDir.resolve("data");
        Path resolvedDataDir = Files.exists(dataDir, new LinkOption[0]) && Files.isDirectory(dataDir, new LinkOption[0]) ? (Files.exists(nestedHubDir = dataDir.resolve("hub"), new LinkOption[0]) && Files.isDirectory(nestedHubDir, new LinkOption[0]) ? dataDir : null) : (Files.exists(hubDir = backupDir.resolve("hub"), new LinkOption[0]) && Files.isDirectory(hubDir, new LinkOption[0]) ? backupDir : null);
        return resolvedDataDir;
    }

    @Override
    protected void prepareDataDir(Path oldDataDir, Path newDataDir) throws UpgradeValidationException {
        boolean shouldRemoveConfAfterCopying = !Files.exists(newDataDir.resolve("conf"), new LinkOption[0]) && Files.exists(oldDataDir.resolve("conf"), new LinkOption[0]);
        super.prepareDataDir(oldDataDir, newDataDir);
        if (shouldRemoveConfAfterCopying) {
            try {
                Files.walkFileTree(newDataDir.resolve("conf"), (FileVisitor<? super Path>)new DeleteFileVisitor());
            }
            catch (IOException e) {
                this.LOG.debug("Failed to remove conf folder from data directory after copying");
            }
        }
    }

    @Override
    public boolean canBeOldDataDir(@NotNull Path location) {
        return this.exodusExplorer.isExodusDatabase(location);
    }
}

