/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.validation;

import com.jetbrains.bundle.BundleInstallationType;
import com.jetbrains.bundle.hub_client.util.validation.ErrorInfo;
import com.jetbrains.bundle.hub_client.util.validation.HubUrlValidator;
import com.jetbrains.bundle.hub_client.util.validation.ValidationResult;
import com.jetbrains.installer.model.WizardBackendConfig;
import com.jetbrains.installer.model.WizardInfo;
import com.jetbrains.installer.model.blocks.ServerConnectorModeSettings;
import com.jetbrains.installer.model.blocks.UpgradeSettings;
import com.jetbrains.installer.model.blocks.UpgradeSource;
import com.jetbrains.installer.rest.UpgradeSourceResource;
import com.jetbrains.installer.util.WizardHubUtil;
import com.jetbrains.installer.validation.BundlePropertiesValidator;
import com.jetbrains.installer.validation.BundleUpgradeHelper;
import com.jetbrains.installer.validation.ValidationError;
import com.jetbrains.installer.validation.folder.impl.CleanDataFolderValidator;
import com.jetbrains.installer.validation.folder.impl.FolderWriteAccessValidator;
import com.jetbrains.service.util.SecureMode;
import com.jetbrains.service.util.SystemUtil;
import com.jetbrains.service.util.cmd.CmdUtil;
import com.jetbrains.service.util.cmd.ExecutionResult;
import java.io.File;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class UpgradeSettingsValidator {
    @Resource(name="upgradeSource")
    private UpgradeSource upgradeSource;
    @Autowired
    BundlePropertiesValidator bundlePropertiesValidator;
    @Autowired
    BundleUpgradeHelper upgradeHelper;
    @Autowired
    WizardBackendConfig wizardBackendConfig;
    @Autowired
    WizardInfo wizardInfo;
    @Autowired
    UpgradeSourceResource.OldUpgradeDataInfo oldUpgradeDataInfo;
    @Autowired
    WizardHubUtil wizardHubUtil;
    @Resource(name="defaultUpgradeSettings")
    private UpgradeSettings defaultUpgradeSettings;
    @Autowired
    CleanDataFolderValidator cleanDataFolderValidator;
    @Autowired
    protected FolderWriteAccessValidator writeAccessValidator;
    protected final Logger LOG = LoggerFactory.getLogger((String)this.getClass().getName());

    @NotNull
    public ValidationResult validate(@NotNull UpgradeSettings data) {
        ValidationResult result = new ValidationResult();
        this.validateLogsDirectory(result, data.getLogsDir());
        this.validateDirectory(result, data.getTempDir(), "tempDir");
        this.validateDirectory(result, data.getBackupsDir(), "backupsDir");
        this.bundlePropertiesValidator.validateUrl(data.getBaseUrl(), "baseUrl", result);
        this.validateListenAddressAndPort(data, result);
        this.validateExternalHubUrl(result, data);
        if (this.checkIfOldUpgradeDataShouldBeBackedUp()) {
            if (!result.hasErrors()) {
                result.addError(ValidationError.OLD_UPGRADE_DATA_MUST_BE_REMOVED.toErrorInfo("sourceLocation"));
            }
        } else {
            this.validateDirectory(result, data.getDataDir(), "dataDir");
        }
        if (data.getServerConnectorModeSettings().getSecureMode() != SecureMode.DISABLE && !data.isUseOldServerCertFlag()) {
            data.getSecureContent().validate(result);
        }
        return result;
    }

    private void validateExternalHubUrl(ValidationResult result, @NotNull UpgradeSettings data) {
        if (data.getContext().isExternalHubUsed()) {
            ValidationResult externalHubValidationResult = new ValidationResult();
            HubUrlValidator hubUrlValidator = this.wizardHubUtil.getHubUrlValidatorForBaseUrl(data.getBaseUrl());
            String hubUrl = hubUrlValidator.validate(data.getExternalHubUrl(), externalHubValidationResult, "externalHubUrl", true);
            if (!externalHubValidationResult.hasErrors()) {
                data.setExternalHubUrl(hubUrl);
                hubUrlValidator.checkServicesAreRegisteredInHub(hubUrl, data.getContext().getHubServiceIdsWithSecrets(), externalHubValidationResult, "externalHubUrl");
            }
            result.updateFrom(externalHubValidationResult);
        }
    }

    private void validateListenAddressAndPort(@NotNull UpgradeSettings data, @NotNull ValidationResult result) {
        ServerConnectorModeSettings serverConnectorModeSettings = data.getServerConnectorModeSettings();
        if (serverConnectorModeSettings != null) {
            serverConnectorModeSettings.validate(this.bundlePropertiesValidator, result);
            this.rewritePortValidationErrorIfNeeded(result, serverConnectorModeSettings, "nonSecureListenPort");
            this.rewritePortValidationErrorIfNeeded(result, serverConnectorModeSettings, "secureListenPort");
        }
    }

    private void rewritePortValidationErrorIfNeeded(@NotNull ValidationResult result, @NotNull ServerConnectorModeSettings serverConnectorModeSettings, @NotNull String portProperty) {
        ErrorInfo error = result.getErrorForField(portProperty);
        if (error != null && ValidationError.COULD_NOT_LISTEN_ON_ADDRESS_AND_PORT.checkErrorType(error) && !Collections.disjoint(serverConnectorModeSettings.getPorts(), this.defaultUpgradeSettings.getServerConnectorModeSettings().getPorts())) {
            result.removeErrorForField("nonSecureListenPort");
            result.removeErrorForField("secureListenPort");
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.putAll(error.getParameters() != null ? error.getParameters() : Collections.emptyMap());
            parameters.put("product", this.wizardInfo.getProductName());
            ErrorInfo newErrorMessage = ValidationError.COULD_NOT_LISTEN_ON_ADDRESS_AND_PORT_TAKEN_FROM_BACKUP.toErrorInfo(parameters, error.getDeveloperMessage() != null ? error.getDeveloperMessage() : "", portProperty);
            result.addError(newErrorMessage);
        }
    }

    private boolean checkIfOldUpgradeDataShouldBeBackedUp() {
        if (this.wizardBackendConfig.isUpgradeDetected() && this.upgradeSource != null && this.upgradeSource.getSourceLocation() != null) {
            Path installationDir = Paths.get(this.wizardBackendConfig.getInstallationDirectory(), new String[0]);
            Path sourceLocation = Paths.get(this.upgradeSource.getSourceLocation(), new String[0]);
            if (!UpgradeSource.Type.OLD_INSTALL_DIR.equals((Object)this.upgradeSource.getType()) || !installationDir.equals(sourceLocation)) {
                return !this.oldUpgradeDataInfo.getCompleted();
            }
        }
        return false;
    }

    private void validateLogsDirectory(@NotNull ValidationResult result, @Nullable String dir) {
        String uiProperty = "logsDir";
        this.validateDirectory(result, dir, uiProperty);
        if (dir != null && !result.hasErrorForField(uiProperty)) {
            this.checkLogsDirIsNotLockedByAnotherInstance(result, dir, uiProperty);
        }
    }

    private void checkLogsDirIsNotLockedByAnotherInstance(@NotNull ValidationResult result, @NotNull String dir, @NotNull String property) {
        Path bundleHome;
        String bundleHomePathAsString;
        Path logsLocation = Paths.get(dir, new String[0]);
        if (this.wizardBackendConfig.getBundleLogsDir().equals(logsLocation)) {
            return;
        }
        Path launcherHomeFile = logsLocation.resolve("launcher.home");
        if (!Files.exists(launcherHomeFile, new LinkOption[0])) {
            return;
        }
        try {
            bundleHomePathAsString = new String(Files.readAllBytes(launcherHomeFile), "UTF-8");
        }
        catch (IOException e) {
            this.LOG.debug(String.format("Failed to read file %s: %s", launcherHomeFile.toString(), e.getMessage()));
            return;
        }
        try {
            bundleHome = Paths.get(bundleHomePathAsString, new String[0]);
        }
        catch (InvalidPathException e) {
            this.LOG.debug(String.format("Product home path %s taken from file %s is invalid", bundleHomePathAsString, launcherHomeFile));
            return;
        }
        String scriptName = null;
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(bundleHome.resolve("bin"));){
            for (Path path : stream) {
                String fileName = path.getFileName().toString();
                if (!fileName.endsWith(".sh") && !fileName.endsWith(".bat")) continue;
                scriptName = fileName.substring(0, fileName.lastIndexOf("."));
            }
        }
        catch (IOException e) {
            this.LOG.debug(String.format("Failed to iterate through the content of directory %s", bundleHome.toString()));
            return;
        }
        if (scriptName != null) {
            ExecutionResult statusResult;
            String fullScriptName = CmdUtil.getScriptName((Path)bundleHome, (String)Paths.get("bin", new String[0]).resolve(scriptName).toString());
            try {
                statusResult = CmdUtil.executeCommandWithExitCode((String)fullScriptName, (Path)bundleHome, null, Collections.singletonList("status"), Collections.emptyList(), null);
            }
            catch (Exception e) {
                this.LOG.debug(String.format("Failed to execute status command in %s", bundleHome.toString()), (Throwable)e);
                return;
            }
            if (statusResult.exitCode != 0) {
                this.LOG.debug(String.format("product status command at %s returned with exit code %s", bundleHome.toString(), statusResult.exitCode));
            } else if (!statusResult.myCommandOutput.contains("shut down")) {
                result.addError(ValidationError.LOGS_DIRECTORY_IS_USED_BY_ANOTHER_INSTANCE.toErrorInfo(Collections.singletonMap("path", bundleHome.toString()), property));
            } else {
                this.LOG.debug(String.format("Log directory of another shut down instance is used: %s", dir));
            }
        }
    }

    public void validateDirectory(@NotNull ValidationResult result, @Nullable String dir, @NotNull String property) {
        Path path;
        if (StringUtils.isEmpty((Object)dir)) {
            result.addError(ValidationError.PROPERTY_MUST_NOT_BE_EMPTY.toErrorInfo("Directory must be specified", property));
            return;
        }
        try {
            path = Paths.get(dir, new String[0]);
        }
        catch (InvalidPathException e) {
            result.addError(ValidationError.INVALID_LOCATION.toErrorInfo(Collections.singletonMap("message", e.getMessage()), "Directory " + dir + " is invalid: " + e.getMessage(), property));
            return;
        }
        String error = SystemUtil.checkFolderIsWritable((File)path.toFile());
        if (error != null) {
            result.addError(this.writeAccessValidator.constructNoWriteAccessError(error, "Directory " + dir + " is not accessible: " + error, property));
            return;
        }
        if ("dataDir".equals(property)) {
            if (path.getParent() == null) {
                result.addError(ValidationError.LOCATION_MUST_NOT_BE_FILE_SYSTEM_ROOT.toErrorInfo(property));
                return;
            }
            ErrorInfo dataDirError = this.cleanDataFolderValidator.checkPath(path.toString(), property);
            if (dataDirError != null) {
                this.LOG.debug(String.format("Directory %s has not passed 'existing&empty' folder validation: %s", path, dataDirError.getDescription()));
                String sourceLocationString = this.upgradeSource.getSourceLocation();
                if (!StringUtils.isEmpty((Object)sourceLocationString) && UpgradeSource.Type.OLD_INSTALL_DIR.equals((Object)this.upgradeSource.getType())) {
                    Path oldDataDir = Paths.get(this.defaultUpgradeSettings.getDataDir(), new String[0]);
                    if (!path.equals(oldDataDir)) {
                        result.addError(ValidationError.DATA_DIRECTORY_MUST_BE_EMPTY_OR_FROM_OLD_INSTALLATION.toErrorInfo(Collections.singletonMap("dir", path.toString()), "Data directory " + path + "is not empty and not equals to data dir from old installation", property));
                    }
                } else if (!StringUtils.isEmpty((Object)sourceLocationString) && this.upgradeSource.getType().isBackup()) {
                    Path sourceLocation = Paths.get(sourceLocationString, new String[0]);
                    if (!Files.isDirectory(sourceLocation, new LinkOption[0]) || !sourceLocation.equals(path)) {
                        Path oldDataDirTakenFromBackup = Paths.get(this.defaultUpgradeSettings.getDataDir(), new String[0]);
                        if (path.equals(oldDataDirTakenFromBackup)) {
                            HashMap<String, String> parameters = new HashMap<String, String>();
                            parameters.put("dir", path.toString());
                            parameters.put("product", this.wizardInfo.getProductName());
                            result.addError(ValidationError.DATA_DIRECTORY_TAKEN_FROM_BACKUP_IS_NOT_EMPTY.toErrorInfo(parameters, "Data directory " + path + " was taken from backup, but it is not empty", property));
                        } else {
                            result.addError(ValidationError.DIRECTORY_MUST_BE_EMPTY.toErrorInfo("Directory " + path + " is not empty", property));
                        }
                    }
                } else {
                    result.addError(ValidationError.DIRECTORY_MUST_BE_EMPTY.toErrorInfo("Directory " + path + " is not empty", property));
                }
            }
        }
    }

    @NotNull
    public Set<String> getDisabledFields() {
        HashSet disabledFields = new HashSet();
        if (BundleInstallationType.DOCKER == this.wizardBackendConfig.getInstallationType()) {
            Collections.addAll(disabledFields, "backupsDir", "dataDir", "logsDir", "tempDir");
        } else if (BundleInstallationType.JAR == this.wizardBackendConfig.getInstallationType()) {
            Collections.addAll(disabledFields, "dataDir");
        }
        return Collections.unmodifiableSet(disabledFields);
    }
}

