/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.validation;

import com.jetbrains.bundle.BundleEnvironment;
import com.jetbrains.installer.validation.ConfBasedUpgradeHelper;
import com.jetbrains.installer.validation.UpgradeValidationException;
import com.jetbrains.installer.validation.ValidationError;
import com.jetbrains.service.util.BundleProperty;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpsourceUpgradeHelper
extends ConfBasedUpgradeHelper {
    private static final Logger LOG = LoggerFactory.getLogger((String)UpsourceUpgradeHelper.class.getName());
    public static final String CASSANDRA_FOLDER = "cassandra";
    public static final String BACKUP_FOLDER = ".backup";
    public static final DirectoryStream.Filter<Path> BACKUP_FOLDER_FILTER = new DirectoryStream.Filter<Path>(){

        @Override
        public boolean accept(Path entry) throws IOException {
            return Files.isDirectory(entry, new LinkOption[0]) && UpsourceUpgradeHelper.BACKUP_FOLDER.equals(entry.getFileName().toString());
        }
    };
    public static final DirectoryStream.Filter<Path> ACCEPT_ALL_FILTER = new DirectoryStream.Filter<Path>(){

        @Override
        public boolean accept(Path entry) throws IOException {
            return true;
        }
    };
    private static Object versionCheckerInstance;

    @Override
    protected void validateDataFromBackupDir(@NotNull String property, @NotNull Path backupDir) throws UpgradeValidationException {
        Path dataDir = this.resolveDataDirFromBackupDir(backupDir);
        this.checkReadPermissions(dataDir, property);
        this.validateBackupSubfolder(dataDir, property);
    }

    private void validateBackupSubfolder(Path dataDir, @NotNull String property) throws UpgradeValidationException {
        String dataDirPathString = dataDir.toString();
        try {
            List<Path> backupSubDirs = this.listFilteredPaths(dataDir, BACKUP_FOLDER_FILTER);
            if (backupSubDirs.size() != 1 || this.listFilteredPaths(backupSubDirs.get(0), ACCEPT_ALL_FILTER).isEmpty()) {
                String message = String.format("Cannot find '.backup' directory or it's empty: %s", dataDirPathString);
                throw new UpgradeValidationException(ValidationError.INVALID_BACKUP_CONTENT.toErrorInfo(message, property));
            }
        }
        catch (IOException e) {
            String message = String.format("Cannot process backup's data directory %s: %s", dataDirPathString, e.getMessage());
            throw new UpgradeValidationException(this.writeAccessValidator.constructInaccessibleOrEmptyError(dataDirPathString, message, property));
        }
    }

    @Override
    protected Path resolveDataDirFromBackupDir(Path backupDir) {
        return backupDir.resolve("data");
    }

    @Override
    @Nullable
    public String getMinimalCompatibleVersionForOldInstallationSource() {
        String productVersionString = this.wizardBackendConfig.getProductFullVersion();
        Object versionChecker = this.getVersionChecker();
        if (versionChecker != null) {
            Class<?> clazz = versionChecker.getClass();
            try {
                Method getMinimalCompatibleVersionMethod = clazz.getMethod("getMinimalCompatibleVersion", String.class);
                String versionString = (String)getMinimalCompatibleVersionMethod.invoke(versionChecker, productVersionString);
                if (versionString != null) {
                    return versionString;
                }
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                this.logException("Cannot get minimal compatible versions", e);
            }
        }
        return null;
    }

    private void logException(@NotNull String str, @NotNull Exception e) {
        String message = str + ": " + e.toString();
        if (e.getCause() != null) {
            message = message + " Reason: " + e.getCause().toString() + ": " + e.getCause().getMessage();
        }
        LOG.error(message);
    }

    private Object getVersionChecker() {
        if (versionCheckerInstance == null) {
            ClassLoader classLoader = UpsourceUpgradeHelper.class.getClassLoader();
            try {
                Class<?> clazz = classLoader.loadClass("com.jetbrains.upsource.GetDatabaseVersionByUpsourceVersion");
                versionCheckerInstance = clazz.newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                this.logException("Cannot instantiate class for verification of versions", e);
            }
        }
        return versionCheckerInstance;
    }

    private boolean isVersionCompatible(@NotNull String versionString) {
        Object versionChecker = this.getVersionChecker();
        if (versionChecker != null) {
            Class<?> clazz = versionChecker.getClass();
            try {
                String backupDbVersion;
                String productDbVersion;
                Method getDatabaseVersionMethod = clazz.getMethod("getDatabaseVersion", String.class);
                try {
                    productDbVersion = (String)getDatabaseVersionMethod.invoke(versionChecker, this.wizardBackendConfig.getProductFullVersion());
                }
                catch (InvocationTargetException e) {
                    this.logException("Cannot get db version for product", e);
                    return false;
                }
                try {
                    backupDbVersion = (String)getDatabaseVersionMethod.invoke(versionChecker, versionString);
                }
                catch (InvocationTargetException e) {
                    backupDbVersion = null;
                }
                return Objects.equals(productDbVersion, backupDbVersion);
            }
            catch (IllegalAccessException | NoSuchMethodException e) {
                this.logException("Cannot check versions", e);
                return false;
            }
        }
        return true;
    }

    @Override
    protected void validateOldInstallationDir(@NotNull Path installationDir, @NotNull Properties extractedProperties, @NotNull String property, @NotNull Path sourceLocation) throws UpgradeValidationException {
        super.validateOldInstallationDir(installationDir, extractedProperties, property, sourceLocation);
        Path installationDirectory = Paths.get(this.wizardBackendConfig.getInstallationDirectory(), new String[0]);
        Path dataDir = this.resolveDirFromInstallation(installationDir, BundleProperty.DATA_DIR, "sourceLocation");
        if (!this.isDataDirContainsCassandra(dataDir)) {
            if (installationDir.equals(installationDirectory) && this.isDataDirContainsBackup(dataDir)) {
                this.validateBackupSubfolder(dataDir, property);
            } else {
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("product", this.wizardBackendConfig.getProductName());
                parameters.put("dir", dataDir.toString());
                String message = String.format("Cannot find either 'cassandra' or '.backup' subfolder in %s", dataDir);
                throw new UpgradeValidationException(ValidationError.BUNDLE_DATA_DIRECTORY_DOES_NOT_CONTAIN_VALID_DATA.toErrorInfo(parameters, message, property));
            }
        }
    }

    @Override
    protected void checkOldInstallationDirDbCompatibility(@NotNull BundleEnvironment sourceLocationBundleEnv, @NotNull String oldProductVersion, @NotNull String uiProperty) throws UpgradeValidationException {
        Path installationDirectory = Paths.get(this.wizardBackendConfig.getInstallationDirectory(), new String[0]);
        Path dataDir = this.resolveDirFromInstallation(sourceLocationBundleEnv, BundleProperty.DATA_DIR, uiProperty);
        if (sourceLocationBundleEnv.getBundleHome().equals(installationDirectory) && !this.isDataDirContainsCassandra(dataDir)) {
            return;
        }
        String newProductVersion = this.wizardBackendConfig.getProductFullVersion();
        String minimalCompatibleVersion = this.getMinimalCompatibleVersionForOldInstallationSource();
        if (minimalCompatibleVersion == null) {
            String message = String.format("Cannot detect minimal compatible database version for current product version (%s)", newProductVersion);
            throw new UpgradeValidationException(ValidationError.CANNOT_UPGRADE_DATABASE_VERSION_NOT_RECOGNIZED.toErrorInfo(message, uiProperty));
        }
        if (!this.isVersionCompatible(oldProductVersion)) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("oldVersion", oldProductVersion);
            parameters.put("newVersion", newProductVersion);
            parameters.put("dir", dataDir.toString());
            throw new UpgradeValidationException(ValidationError.CANNOT_UPGRADE_TO_VERSION_FROM_VERSION_INCOMPATIBLE_DATABASE.toErrorInfo(parameters, uiProperty));
        }
    }

    private boolean isDataDirContainsCassandra(Path dataDir) throws UpgradeValidationException {
        Path path = dataDir.resolve(CASSANDRA_FOLDER);
        return Files.exists(path, new LinkOption[0]);
    }

    private boolean isDataDirContainsBackup(Path dataDir) throws UpgradeValidationException {
        Path path = dataDir.resolve(BACKUP_FOLDER);
        return Files.exists(path, new LinkOption[0]);
    }
}

