/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.validation;

import com.jetbrains.bundle.hub_client.util.validation.ErrorInfo;
import com.jetbrains.bundle.hub_client.util.validation.ValidationException;
import com.jetbrains.installer.filters.HttpServerCorsFilter;
import com.jetbrains.installer.model.KeyStoreContent;
import com.jetbrains.installer.model.KeyStoreHolder;
import com.jetbrains.installer.validation.ValidationError;
import com.jetbrains.service.util.UrlUtil;
import com.jetbrains.service.util.ssl.KeystoreUtil;
import com.sun.net.httpserver.HttpContext;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import com.sun.net.httpserver.HttpsConfigurator;
import com.sun.net.httpserver.HttpsServer;
import java.io.File;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.bouncycastle.util.encoders.Base64;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class ValidationEndpointsManager {
    public static final String CHECK_STATUS_RESPONSE = "{\"status\":\"Success\"}";
    private static final Map<EndpointKey, HttpServer> ENDPOINTS = new HashMap<EndpointKey, HttpServer>();
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());

    public synchronized SSLContext startServiceEndpoint(@NotNull String listenAddress, @NotNull String listenPort, @NotNull String contextPath, @Nullable KeyStoreHolder keyStoreHolder) {
        SSLContext sslContext;
        EndpointKey endpointKey = new EndpointKey(listenAddress, listenPort);
        HttpServer endpoint = ENDPOINTS.get(endpointKey);
        if (endpoint == null) {
            sslContext = keyStoreHolder != null ? this.buildSslContext(keyStoreHolder) : null;
            endpoint = this.startServiceEndpoint(listenAddress, listenPort, contextPath, sslContext);
            ENDPOINTS.put(endpointKey, endpoint);
        } else {
            sslContext = endpoint instanceof HttpsServer ? ((HttpsServer)endpoint).getHttpsConfigurator().getSSLContext() : null;
        }
        return sslContext;
    }

    private HttpServer startServiceEndpoint(@NotNull String listenAddress, @NotNull String listenPort, @NotNull String contextPath, @Nullable SSLContext sslContext) {
        HttpServer endpoint = null;
        try {
            if (sslContext != null) {
                endpoint = HttpsServer.create();
                HttpsConfigurator configurator = new HttpsConfigurator(sslContext);
                ((HttpsServer)endpoint).setHttpsConfigurator(configurator);
            } else {
                endpoint = HttpServer.create();
            }
            HttpContext httpContext = this.getTestHttpContext(contextPath, endpoint);
            httpContext.getFilters().add(new HttpServerCorsFilter());
            InetSocketAddress bindAddress = new InetSocketAddress(listenAddress, Integer.parseInt(listenPort));
            endpoint.bind(bindAddress, 5);
            endpoint.start();
            return endpoint;
        }
        catch (Exception e) {
            if (endpoint != null) {
                this.stopEndpoint(endpoint);
            }
            ErrorInfo errorInfo = this.constructValidationError(listenAddress, listenPort, sslContext != null ? "secureListenPort" : "nonSecureListenPort");
            throw new ValidationException(errorInfo);
        }
    }

    private HttpContext getTestHttpContext(@NotNull String contextPath, HttpServer endpoint) {
        return endpoint.createContext(UrlUtil.combineUrls((String)"", (String)contextPath), new HttpHandler(){

            @Override
            public void handle(HttpExchange httpExchange) throws IOException {
                ValidationEndpointsManager.this.logRequest(httpExchange);
                byte[] response = ValidationEndpointsManager.CHECK_STATUS_RESPONSE.getBytes("UTF-8");
                httpExchange.sendResponseHeaders(200, response.length);
                httpExchange.getResponseBody().write(response);
                httpExchange.close();
            }
        });
    }

    private void logRequest(HttpExchange httpExchange) {
        Object hostHeaders = httpExchange.getRequestHeaders().get("Host");
        String hostHeader = hostHeaders != null && !hostHeaders.isEmpty() ? (String)hostHeaders.get(0) : null;
        this.LOG.debug(String.format("Status request is received %s", hostHeader != null ? "from " + hostHeader : ""));
    }

    private ErrorInfo constructValidationError(@NotNull String listenAddress, @NotNull String listenPort, @NotNull String jsonPropertyName) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("address", listenAddress);
        parameters.put("port", listenPort);
        return ValidationError.COULD_NOT_LISTEN_ON_ADDRESS_AND_PORT.toErrorInfo(parameters, String.format("Can not listen on %s:%s", listenAddress, listenPort), jsonPropertyName);
    }

    private ErrorInfo constructInvalidKeystoreValidationError(@NotNull Exception e) {
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("message", e.getMessage());
        return ValidationError.KEYSTORE_FILE_INVALID.toErrorInfo(parameters, "baseUrl");
    }

    public SSLContext buildClientSslContext(@NotNull KeyStoreHolder keyStoreHolder) {
        try {
            KeystoreUtil.removeServerPrivateKey((KeyStore)keyStoreHolder.getKeyStore());
            return this.buildSslContext(keyStoreHolder);
        }
        catch (Exception e) {
            throw new ValidationException(this.constructInvalidKeystoreValidationError(e));
        }
    }

    @NotNull
    public SSLContext buildSslContext(@NotNull KeyStoreHolder keyStoreHolder) {
        try {
            KeyStore keyStore = keyStoreHolder.getKeyStore();
            SSLContext sslContext = SSLContext.getInstance("TLS");
            String defaultAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
            KeyManagerFactory keyStoreFactory = KeyManagerFactory.getInstance(defaultAlgorithm);
            if (keyStoreHolder.getKeyPassword().length > 0) {
                keyStoreFactory.init(keyStore, keyStoreHolder.getKeyPassword());
            } else {
                try {
                    keyStoreFactory.init(keyStore, keyStoreHolder.getPassword());
                }
                catch (UnrecoverableKeyException e) {
                    keyStoreFactory.init(keyStore, "".toCharArray());
                }
            }
            TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            trustFactory.init(keyStore);
            sslContext.init(keyStoreFactory.getKeyManagers(), trustFactory.getTrustManagers(), new SecureRandom());
            return sslContext;
        }
        catch (Exception e) {
            throw new ValidationException(this.constructInvalidKeystoreValidationError(e));
        }
    }

    public synchronized Set<EndpointKey> getEndpointKeysByListenPort(@NotNull String listenPort) {
        HashSet<EndpointKey> endpointKeys = new HashSet<EndpointKey>();
        for (EndpointKey endpointKey : ENDPOINTS.keySet()) {
            if (!endpointKey.listenPort.equals(listenPort)) continue;
            endpointKeys.add(endpointKey);
        }
        return endpointKeys;
    }

    public synchronized boolean stopEndpoint(@NotNull String listenAddress, @NotNull String listenPort) {
        EndpointKey endpointKey = new EndpointKey(listenAddress, listenPort);
        return this.stopEndpoint(endpointKey);
    }

    public synchronized void stopAllEndpoints() {
        try {
            for (EndpointKey endpointKey : ENDPOINTS.keySet()) {
                this.stopEndpoint(endpointKey);
            }
        }
        catch (Exception e) {
            this.LOG.debug("Can not stop HTTP endpoints used for validation", (Throwable)e);
        }
    }

    private boolean stopEndpoint(EndpointKey endpointKey) {
        HttpServer endpoint = ENDPOINTS.get(endpointKey);
        if (endpoint != null) {
            this.stopEndpoint(endpoint);
            ENDPOINTS.remove(endpointKey);
            return true;
        }
        return false;
    }

    private void stopEndpoint(@NotNull HttpServer endpoint) {
        try {
            endpoint.stop(0);
        }
        catch (Exception e) {
            this.LOG.debug("Can not stop HTTP endpoint used for validation", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        ValidationEndpointsManager validationEndpointsManager = new ValidationEndpointsManager();
        String listenAddress = "0.0.0.0";
        String listenPort = "443";
        try {
            KeyStoreContent keyStoreContent = new KeyStoreContent();
            keyStoreContent.setKeyStoreFileName(new File("C:\\Users\\alexey.barsov\\Downloads\\bnd_1644_keystore.jks").getAbsolutePath());
            byte[] bytes = Files.readAllBytes(Paths.get("C:\\Users\\alexey.barsov\\Downloads\\bnd_1644_keystore.jks", new String[0]));
            keyStoreContent.setKeyStoreFile(new String(Base64.encode((byte[])bytes), Charset.forName("UTF-8")));
            keyStoreContent.setAliasPassword("password");
            keyStoreContent.setSecureKeyStoreAlias("selfsigned");
            keyStoreContent.setSecureKeystorePassword("P@ssword");
            KeyStoreHolder keyStoreHolder = keyStoreContent.buildKeyStore();
            validationEndpointsManager.startServiceEndpoint("0.0.0.0", "443", "/api/wizard/connections/status", keyStoreHolder);
            System.out.println("Press any key to stop the service...");
            System.in.read();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            validationEndpointsManager.stopEndpoint("0.0.0.0", "443");
        }
    }

    public static class EndpointKey {
        private final String listenAddress;
        private final String listenPort;

        public EndpointKey(@NotNull String listenAddress, @NotNull String listenPort) {
            this.listenAddress = listenAddress;
            this.listenPort = listenPort;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            EndpointKey that = (EndpointKey)o;
            if (!this.listenAddress.equals(that.listenAddress)) {
                return false;
            }
            return this.listenPort.equals(that.listenPort);
        }

        public int hashCode() {
            int result = this.listenAddress.hashCode();
            result = 31 * result + this.listenPort.hashCode();
            return result;
        }

        public String getListenAddress() {
            return this.listenAddress;
        }

        public String getListenPort() {
            return this.listenPort;
        }
    }
}

