/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.validation;

import com.jetbrains.bundle.hub_client.util.validation.ErrorInfo;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.text.StrSubstitutor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum ValidationError {
    INVALID_LOCATION("Invalid location: ${message}"),
    LOCATION_MUST_NOT_BE_FILE_SYSTEM_ROOT("Directory must not be file system root"),
    LOCATION_NOT_WRITABLE_BY_USER("User ${user} does not have write access for the directory: ${message}"),
    LOCATION_NOT_WRITABLE("There is no write access for this directory: ${message}"),
    DIRECTORY_MUST_BE_EMPTY("Directory is not empty"),
    LOCATION_NOT_EXIST_OR_NOT_ACCESSIBLE_BY_USER("Path ${location} does not exist or is not accessible by user ${user}"),
    LOCATION_NOT_EXIST_OR_NOT_ACCESSIBLE("Path ${location} does not exist or is not accessible"),
    LOCATION_IS_EMPTY_OR_NOT_ACCESSIBLE_BY_USER("Directory ${location} is not accessible by user ${user} or is empty"),
    LOCATION_IS_EMPTY_OR_NOT_ACCESSIBLE("Directory ${location} is not accessible or is empty"),
    LOCATION_NOT_ACCESSIBLE_BY_USER("Directory ${location} is not accessible by user ${user}"),
    LOCATION_NOT_ACCESSIBLE("Directory ${location} is not accessible"),
    BUNDLE_ROOT_APP_DATA_DIRECTORY_NOT_EXIST_OR_NOT_ACCESSIBLE_BY_USER("Root application data directory ${appDataRoot} resolved from existing installation either does not exist or is not accessible by user ${user}"),
    BUNDLE_ROOT_APP_DATA_DIRECTORY_NOT_EXIST_OR_NOT_ACCESSIBLE("Root application data directory ${appDataRoot} resolved from existing installation either does not exist or is not accessible"),
    BUNDLE_DATA_DIRECTORY_IS_INVALID("${product} data directory ${dir} resolved from existing installation is invalid: ${error}"),
    BUNDLE_DATA_DIRECTORY_NOT_EXIST_OR_NOT_ACCESSIBLE_BY_USER("${product} data directory ${dir} resolved from existing installation either does not exist or is not accessible by user ${user}"),
    BUNDLE_DATA_DIRECTORY_NOT_EXIST_OR_NOT_ACCESSIBLE("${product} data directory ${dir} resolved from existing installation either does not exist or is not accessible"),
    BUNDLE_DATA_DIRECTORY_IS_EMPTY_OR_NOT_ACCESSIBLE_BY_USER("${product} data directory ${dir} resolved from existing installation is either empty or not accessible by user ${user}"),
    BUNDLE_DATA_DIRECTORY_IS_EMPTY_OR_NOT_ACCESSIBLE("${product} data directory ${dir} resolved from existing installation is either empty or not accessible"),
    BUNDLE_DATA_DIRECTORY_DOES_NOT_CONTAIN_VALID_DATA("${product} data directory ${dir} resolved from existing installation does not contain valid data"),
    LOCATION_MUST_BE_FILE_OR_DIRECTORY("Path must be either a file or a directory"),
    LOCATION_MUST_BE_FILE("Path must be a file"),
    LOCATION_MUST_BE_DIRECTORY("Path must be a directory"),
    DATA_DIRECTORY_MUST_BE_EMPTY_OR_FROM_OLD_INSTALLATION("Data directory ${dir} is not empty or is not the data directory from a previous installation"),
    TRY_TO_USE_UPGRADE_INSTEAD("Data directory ${dir} is not empty. If you are trying to upgrade, please, select 'Upgrade' instead of 'Set up' on first step."),
    DATA_DIRECTORY_TAKEN_FROM_BACKUP_IS_NOT_EMPTY("The backup contains a reference to a data directory ${dir} that is not empty. To continue with the upgrade, select an empty data directory location or move the data from the ${dir} directory to another location. Do not delete the data from this directory unless you have a current backup that you can use to restore the previous version of your ${product} installation."),
    PROPERTY_MUST_NOT_BE_EMPTY("Property must not be empty"),
    MALFORMED_BASE_URL("Base URL is malformed: ${error}"),
    WIZARD_CRYPTIC_SUB_CONTEXT_IN_BASE_URL("Base URL context path contains not allowed entry ${entry}"),
    LOCALE_IS_NOT_SUPPORTED("Locale ${locale} is not supported"),
    PROPERTY_TOO_SHORT("Value is too short. Expected value > ${size}"),
    PROPERTY_TOO_LONG("Value is too long. Expected value < ${size}"),
    PROPERTY_CONTAINS_INCORRECT_CHARACTERS("Property contains invalid characters"),
    PROPERTY_MUST_BE_A_NUMBER("Property must be a number"),
    LISTEN_PORT_IS_OUT_OF_BOUNDS("Value out of bounds. Expected value between ${from} and ${to}"),
    COULD_NOT_LISTEN_ON_ADDRESS_AND_PORT("Could not listen on address ${address} and port ${port}"),
    COULD_NOT_LISTEN_ON_ADDRESS_AND_PORT_TAKEN_FROM_BACKUP("Could not listen on address ${address} and port ${port}. Verify that the existing ${product} instance is stopped and that there are no other services that listen to the same address and port."),
    HUB_URL_NOT_VERIFIED("Hub URL is not verified"),
    HUB_BASIC_AUTHENTICATION_FAILED("Authentication failed, either login or password is incorrect"),
    HUB_BASIC_AUTHENTICATION_REQUIRED("Authentication required. Please, provide login and password!"),
    HUB_USER_HAS_NO_READ_SERVICE_PERMISSION("User doesn't have 'Read Service' permission"),
    HUB_USER_HAS_NO_UPDATE_SERVICE_PERMISSION("User doesn't have 'Update Service' permission"),
    LOCATION_DOES_NOT_CONTAIN_YOUTRACK_DB("Directory ${path} does not contain a valid YouTrack database"),
    BACKUP_ARCHIVE_DOES_NOT_CONTAIN_YOUTRACK_DB("Specified archive file does not contain a valid YouTrack database"),
    CANNOT_OPEN_YOUTRACK_DB("Cannot open database at ${path}. It may be locked by another YouTrack instance."),
    LOGS_DIRECTORY_IS_USED_BY_ANOTHER_INSTANCE("Logs directory is used by another product instance started from ${path}. Two different instances could not share the same logs directory. Either select another directory or stop the conflicting instance."),
    CANNOT_UPGRADE_VERSION_NOT_SUPPORTED("Upgrade to version ${version} is not supported"),
    CANNOT_UPGRADE_FROM_TOO_OLD_VERSION("${product} ${newVersion} does not support direct upgrade from version ${oldVersion} or earlier. Upgrade your installation to ${minimalUpgradeVersion} first, then continue with the upgrade to ${newVersion}."),
    CANNOT_UPGRADE_VERSION_NOT_RECOGNIZED("Previous version is not recognized"),
    CANNOT_UPGRADE_DATABASE_VERSION_NOT_RECOGNIZED("Database version is not recognized"),
    CANNOT_UPGRADE_TO_VERSION_FROM_VERSION("Existing product version (${oldVersion}) is later than the version of the product being installed (${newVersion})"),
    CANNOT_UPGRADE_TO_VERSION_FROM_VERSION_INCOMPATIBLE_DATABASE("The database in the ${dir} is from version ${oldVersion}. You cannot upgrade to version ${newVersion} from this source. To continue with this upgrade, change the upgrade source and select a backup copy of your existing installation. "),
    CANNOT_UPGRADE_HUB_PARAMETERS_NOT_FOUND("The service ID or secret for the existing Hub installation are not found in the database"),
    CANNOT_UPGRADE_HUB_URL_NOT_FOUND("External Hub URL is not found in the database"),
    UNSUPPORTED_TYPE_OF_BACKUP_ARCHIVE("Backup file must be a .zip or .tar.gz archive"),
    INVALID_BACKUP_CONTENT("Backup does not contain valid data"),
    VALID_UPGRADE_SOURCE_SHOULD_HAS_BEEN_SELECTED_FIRST("An attempt to get upgrade settings before a valid upgrade source was selected"),
    CANNOT_UPGRADE_FROM_BACKUP_OF_DIFFERENT_PRODUCT("Can not perform upgrade. Backup of a different product ('${oldProductName}') was provided. '${expectedProductName}' expected"),
    CANNOT_UPGRADE_FROM_OLD_INSTALLATION_OF_DIFFERENT_PRODUCT("Can not perform upgrade. Installation path for a different product ('${oldProductName}') was provided. '${expectedProductName}' expected"),
    UNSUPPORTED_UPGRADE_TYPE("Upgrade type not supported"),
    CANNOT_DETECT_UPGRADE_LOCATION_TYPE("Cannot detect upgrade location type"),
    BUNDLE_CONFIG_NOT_ACCESSIBLE("Configuration file is not accessible: ${message}"),
    BUNDLE_CONFIG_NOT_FOUND_FROM_OLD_INSTALLATION_SOURCE("Installation directory does not contain expected configuration files"),
    BUNDLE_USE_BACKUP_AS_AN_UPGRADE_SOURCE_INSTEAD_OF_OLD_INSTALLATION_DIR("Upgrade from selected installation directory is not possible, change the upgrade source and select a backup copy of your existing installation"),
    BUNDLE_CONFIG_NOT_FOUND_IN_UNCOMPRESSED_BACKUP("Selected directory is neither an existing installation folder nor a folder with uncompressed backup. It does not contain expected configuration files"),
    BUNDLE_CONFIG_NOT_FOUND_IN_BACKUP_ARCHIVE("Selected file is not a valid backup. It does not contain expected configuration files"),
    BUNDLE_DATA_WITHOUT_CONFIG_WAS_FOUND_IN_BACKUP_UNCOMPRESSED("The selected directory contains a valid ${product} database, but does not contain the expected configuration files. Please select an existing ${product} installation or a directory containing backup"),
    BUNDLE_DATA_WITHOUT_CONFIG_WAS_FOUND_IN_BACKUP_ARCHIVE("The selected archive file contains a valid ${product} database, but does not contain the expected configuration files. Please select an existing ${product} installation or a valid ${product} backup"),
    NO_HUB_FOLDER_WAS_FOUND_IN_BACKUP_ARCHIVE("The selected archive file contains a valid ${product} database, but does not contain data of built-in Hub. Please select an existing ${product} installation or a valid ${product} backup that contains Hub database"),
    NO_HUB_FOLDER_WAS_FOUND_IN_BACKUP_UNCOMPRESSED("The selected directory contains a valid ${product} database, but does not contain data of built-in Hub. Please select an existing ${product} installation or a valid ${product} backup that contains Hub database"),
    BUNDLE_PROPERTY_IS_ABSENT_IN_OLD_CONFIGS("Configuration property ${property} is not resolved from upgrade source"),
    UPGRADE_LOCATION_PROCESSING_ERROR("Cannot perform upgrade: ${error}"),
    OLD_UPGRADE_DATA_MUST_BE_REMOVED("Old upgrade data must be removed before upgrade"),
    OLD_UPGRADE_DATA_ALREADY_REMOVED("Old upgrade data already removed"),
    OLD_UPGRADE_DATA_BACKUP_FAILED_CANNOT_CREATE_DIR("Cannot create directory: ${message}"),
    OLD_UPGRADE_DATA_BACKUP_FAILED_CANNOT_MOVE_OR_DELETE_DIR("Cannot move or delete directory: ${message}"),
    NO_ENOUGH_DISK_SPACE_TO_UNCOMPRESS_BACKUP("No enough disk space to uncompress backup: ${required} required, but only ${available} available on ${path}"),
    NO_ENOUGH_DISK_SPACE("No enough disk space: ${required} required, but only ${available} available on ${path}"),
    TOO_MANY_FAILED_AUTHENTICATION_ATTEMPTS("Too many failed authentication attempts was performed"),
    INVALID_AUTH_TOKEN("Invalid authentication token"),
    SECURE_FILES_DUMP_PROCESSING_ERROR("The secure files could not be saved to the configuration files: ${message}"),
    KEYSTORE_FILE_INVALID("The keystore file is invalid: ${message}"),
    KEYSTORE_FILE_IS_EMPTY("The keystore file is empty"),
    KEYSTORE_PASSWORD_INVALID("The keystore password is invalid"),
    KEYSTORE_FILE_IS_NOT_UPLOADED("The keystore file is not uploaded"),
    KEYSTORE_FAILED_TO_GENERATE("The private key and certificate could not be converted to a keystore format: ${message}"),
    FAILED_TO_LOAD_FROM_FILE("Failed to load ${loadedEntityName} from file: ${message}"),
    FILE_IS_MISSING("The ${loadedEntityName} file is missing"),
    PRIVATE_KEY_INVALID_NO_DETAILS("The private key is invalid"),
    PRIVATE_KEY_INVALID("The private key is invalid: ${message}"),
    PRIVATE_KEY_DECRYPTION_FAILED("Failed to decrypt private key: ${message}"),
    PRIVATE_KEY_IS_NOT_UPLOADED("The private key is not uploaded"),
    CERTIFICATE_INVALID("The certificate is invalid: ${message}"),
    CERTIFICATE_EXPIRED("The certificate expired on ${NotAfter}"),
    CERTIFICATE_NOT_YET_VALID("The certificate will be valid after ${NotBefore}"),
    CERTIFICATE_IN_KEYSTORE_NOT_YET_VALID("The certificate in keystore will be valid after ${NotBefore}"),
    CERTIFICATE_IN_KEYSTORE_EXPIRED("The certificate in keystore expired on ${NotAfter}"),
    CERTIFICATE_IS_NOT_UPLOADED("The certificate is not uploaded"),
    CERTIFICATE_CHAIN_INVALID("The certificate chain is invalid: ${message}"),
    UNSUPPORTED_PRIVATE_KEY_TYPE("Unsupported type of private key: ${type}"),
    PRIVATE_KEY_AND_CERTIFICATE_SHOULD_MATCH("The private key does not match the certificate"),
    CANNOT_GENERATE_PUBLIC_KEY_FROM_PRIVATE_KEY("The public key was not generated from the private key: ${message}"),
    HOSTNAME_FROM_BASE_URL_DOES_NOT_MATCH_CERTIFICATE("Hostname ${hostname} taken from Base URL doesn't match server certificate"),
    CERTIFICATE_AND_CERTIFICATE_CHAIN_SHOULD_MATCH("The certificate does not match the certificate chain"),
    NO_EXIST_ALIAS("The specified alias either does not exist in the keystore file or does not identify server certificate"),
    ALIAS_DOES_NOT_IDENTIFY_ANY_PRIVATE_KEY("The specified alias does not identify any private key"),
    WRONG_ALIAS_PASSWORD("The alias password is invalid"),
    BASE_URL_IS_NOT_ACCESSIBLE_FROM_BACKEND("Service is not accessible by given Base URL from backend"),
    BASE_URL_IS_NOT_ACCESSIBLE_FROM_BACKEND_UNTRUSTED_CERTIFICATE("Service is not accessible by given Base URL from backend due to untrusted certificate");

    private static final String placeholderRegEx = "\\$\\{([^}]*)\\}";
    private Pattern placeholderPattern = Pattern.compile("\\$\\{([^}]*)\\}");
    private final Logger LOG = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private final String[] paramNames;
    private String descriptionTemplate;

    private ValidationError(String descriptionTemplate) {
        this.descriptionTemplate = descriptionTemplate;
        this.paramNames = this.extractParamNames(descriptionTemplate);
    }

    private String[] extractParamNames(@NotNull String descriptionTemplate) {
        HashSet<String> names = new HashSet<String>();
        Matcher matcher = this.placeholderPattern.matcher(descriptionTemplate);
        while (matcher.find()) {
            names.add(matcher.group(1));
        }
        return names.toArray(new String[names.size()]);
    }

    @NotNull
    public ErrorInfo toErrorInfo(@Nullable String property) {
        return this.toErrorInfo(Collections.emptyMap(), "", property);
    }

    @NotNull
    public ErrorInfo toErrorInfo(@NotNull String developerMessage, @Nullable String property) {
        return this.toErrorInfo(Collections.emptyMap(), developerMessage, property);
    }

    @NotNull
    public ErrorInfo toErrorInfo(@NotNull Map<String, String> parameters, @NotNull String developerMessage, @Nullable String property) {
        String description = this.formatDescription(parameters);
        return new ErrorInfo(this.name(), description, parameters, property, developerMessage, null, null);
    }

    @NotNull
    public ErrorInfo toErrorInfo(@NotNull Map<String, String> parameters, @Nullable String property) {
        return new ErrorInfo(this.name(), this.formatDescription(parameters), parameters, property, "", null, null);
    }

    public boolean checkErrorType(ErrorInfo errorInfo) {
        return errorInfo != null && this.name().equals(errorInfo.getError());
    }

    @NotNull
    private String formatDescription(Map<String, String> parameters) {
        try {
            int expectedNumOfParams = this.paramNames == null ? 0 : this.paramNames.length;
            int actualNumOfParams = parameters.size();
            if (expectedNumOfParams != actualNumOfParams) {
                throw new IllegalArgumentException(this.name() + " - Wrong number of parameters: expected " + expectedNumOfParams + ", but " + actualNumOfParams + " provided");
            }
            if (this.paramNames != null) {
                for (String name : this.paramNames) {
                    Set<String> actualNames = parameters.keySet();
                    if (actualNames.contains(name)) continue;
                    throw new IllegalArgumentException(this.name() + " - Parameter " + name + " not provided");
                }
            }
            StrSubstitutor sub = new StrSubstitutor(parameters);
            return sub.replace(this.descriptionTemplate);
        }
        catch (Exception e) {
            this.LOG.error("Cannot format error message: {}", (Object)e.getMessage(), (Object)e);
            return this.descriptionTemplate;
        }
    }
}

