/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.validation;

import com.jetbrains.bundle.BundleEnvironment;
import com.jetbrains.bundle.BundleInstallationType;
import com.jetbrains.bundle.hub_client.util.validation.ErrorInfo;
import com.jetbrains.installer.database.ExodusExplorer;
import com.jetbrains.installer.database.PersistedYouTrackProperty;
import com.jetbrains.installer.database.YouTrackInstallationType;
import com.jetbrains.installer.model.PathInfo;
import com.jetbrains.installer.model.blocks.UpgradeSettings;
import com.jetbrains.installer.model.blocks.UpgradeSettingsContext;
import com.jetbrains.installer.model.blocks.UpgradeSource;
import com.jetbrains.installer.validation.BaseUpgradeHelper;
import com.jetbrains.installer.validation.UpgradeValidationException;
import com.jetbrains.installer.validation.ValidationError;
import com.jetbrains.service.util.BundleProperty;
import com.jetbrains.service.util.ConfiguratorUtils;
import com.jetbrains.service.util.ServiceProperties;
import com.jetbrains.service.util.Version;
import com.jetbrains.service.util.properties.impl.PropertiesBasedConfigurationHelper;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class YouTrackUpgradeHelper
extends BaseUpgradeHelper {
    public static final Version YOUTRACK_6_0_LOWEST_VERSION = Version.parseVersion((String)"6.0");
    public static final Version YOUTRACK_6_5_LOWEST_VERSION = Version.parseVersion((String)"6.5");
    public static final Version YOUTRACK_7_0_LOWEST_VERSION = Version.parseVersion((String)"7.0");
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    public static final String YOUTRACK_FOLDER_NAME = "youtrack";
    private static final String HUB_FOLDER_NAME = "hub";
    private static final String CONF_FOLDER_NAME = "conf";
    private static final String RESULTED_BUNDLE_OLD_PRODUCT_FULL_VERSION_PROPERTY_NAME = "upgrade." + BundleProperty.PREVIOUSLY_STARTED_PRODUCT_VERSION.getName();
    private static final Set<String> LEGACY_WIZARD_CONFIGURED_PROPERTIES;
    @Autowired
    private ExodusExplorer exodusExplorer;

    @Override
    protected void validateOldInstallationDir(@NotNull Path installationDir, @NotNull Properties extractedProperties, @NotNull String property, @NotNull Path sourceLocation) throws UpgradeValidationException {
        String youTrackDataDirValue;
        BundleEnvironment bundleEnv = new BundleEnvironment(sourceLocation);
        Path dataDir = this.resolveDirFromInstallation(bundleEnv, BundleProperty.DATA_DIR, property);
        Properties oldWizardConfiguredProperties = this.getWizardConfiguredProperties(bundleEnv, property);
        if (oldWizardConfiguredProperties != null && (youTrackDataDirValue = PropertiesBasedConfigurationHelper.getHelper().getServiceProperty((Object)oldWizardConfiguredProperties, YOUTRACK_FOLDER_NAME, ServiceProperties.DATA_DIR_PROPERTY)) != null) {
            Path youTrackDataCustomizedPath;
            try {
                youTrackDataCustomizedPath = Paths.get(youTrackDataDirValue, new String[0]);
            }
            catch (InvalidPathException e) {
                HashMap<String, String> parameters = new HashMap<String, String>();
                parameters.put("product", this.wizardBackendConfig.getProductName());
                parameters.put("dir", youTrackDataDirValue);
                parameters.put("error", e.getMessage());
                throw new UpgradeValidationException(ValidationError.BUNDLE_DATA_DIRECTORY_IS_INVALID.toErrorInfo(parameters, "Path is invalid: " + e.getMessage(), property));
            }
            dataDir = this.toAbsoluteBundlePath(youTrackDataCustomizedPath, bundleEnv.getApplicationDataRootDirectory());
        }
        this.checkDataDirResolvedFromOldInstallationIsNotEmpty(dataDir, property, sourceLocation);
        this.checkYouTrackDatabaseLocation(dataDir, extractedProperties, property, UpgradeSource.Type.OLD_INSTALL_DIR);
        if (this.isSpecialInstallation(oldWizardConfiguredProperties)) {
            throw new UpgradeValidationException(ValidationError.BUNDLE_USE_BACKUP_AS_AN_UPGRADE_SOURCE_INSTEAD_OF_OLD_INSTALLATION_DIR.toErrorInfo(property));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkYouTrackServiceDb(@NotNull Path youTrackServiceDataBaseLocation, @NotNull Version oldProductVersion, @NotNull Properties extractedProperties, @NotNull String property) throws UpgradeValidationException {
        String productFullVersion = this.wizardBackendConfig.getProductFullVersion();
        Version newProductVersion = Version.parseVersion((String)productFullVersion);
        if (newProductVersion == null) {
            throw new UpgradeValidationException(ValidationError.CANNOT_UPGRADE_VERSION_NOT_SUPPORTED.toErrorInfo(Collections.singletonMap("version", productFullVersion), String.format("Upgrade to version %s has not been supported", productFullVersion), property));
        }
        String oldVersionString = oldProductVersion.toString();
        String newVersionString = newProductVersion.toString();
        extractedProperties.setProperty(RESULTED_BUNDLE_OLD_PRODUCT_FULL_VERSION_PROPERTY_NAME, oldVersionString);
        this.checkVersions(newVersionString, oldVersionString, property);
        YouTrackInstallationType oldInstallationType = this.exodusExplorer.getYouTrackInstallationType(youTrackServiceDataBaseLocation);
        if (oldInstallationType != null) {
            extractedProperties.setProperty(PersistedYouTrackProperty.BUNDLE_INSTALLATION_TYPE.getBundlePropName(), oldInstallationType.name());
        }
        String youTrackServiceIdInHub = this.exodusExplorer.readStringSimpleProperty(youTrackServiceDataBaseLocation, PersistedYouTrackProperty.SERVICE_ID_IN_HUB);
        String youTrackServiceSecretInHub = this.exodusExplorer.readStringSimpleProperty(youTrackServiceDataBaseLocation, PersistedYouTrackProperty.SECRET_IN_HUB);
        if (youTrackServiceIdInHub == null || youTrackServiceSecretInHub == null) {
            throw new UpgradeValidationException(ValidationError.CANNOT_UPGRADE_HUB_PARAMETERS_NOT_FOUND.toErrorInfo(youTrackServiceIdInHub == null ? "serviceId not found" : "secret not found", property));
        }
        extractedProperties.setProperty(PersistedYouTrackProperty.SERVICE_ID_IN_HUB.getBundlePropName(), youTrackServiceIdInHub);
        extractedProperties.setProperty(PersistedYouTrackProperty.SECRET_IN_HUB.getBundlePropName(), youTrackServiceSecretInHub);
        Boolean disableInternalHub = this.exodusExplorer.readBooleanSimpleProperty(youTrackServiceDataBaseLocation, PersistedYouTrackProperty.DISABLE_INTERNAL_HUB);
        if (Boolean.TRUE.equals(disableInternalHub)) {
            String hubUrl = this.exodusExplorer.readStringSimpleProperty(youTrackServiceDataBaseLocation, PersistedYouTrackProperty.HUB_URL);
            if (hubUrl == null) throw new UpgradeValidationException(ValidationError.CANNOT_UPGRADE_HUB_URL_NOT_FOUND.toErrorInfo(property));
            extractedProperties.setProperty(PersistedYouTrackProperty.HUB_URL.getBundlePropName(), hubUrl);
            extractedProperties.setProperty(PersistedYouTrackProperty.DISABLE_INTERNAL_HUB.getBundlePropName(), Boolean.TRUE.toString());
        } else {
            extractedProperties.setProperty(PersistedYouTrackProperty.DISABLE_INTERNAL_HUB.getBundlePropName(), Boolean.FALSE.toString());
        }
        this.addProperty(extractedProperties, PersistedYouTrackProperty.BUNDLE_BASE_URL_PROPERTY_NAME, youTrackServiceDataBaseLocation);
        this.addProperty(extractedProperties, PersistedYouTrackProperty.BUNDLE_LISTEN_PORT_PROPERTY_NAME, youTrackServiceDataBaseLocation);
        this.addProperty(extractedProperties, PersistedYouTrackProperty.BUNDLE_LISTEN_ADDRESS_PROPERTY_NAME, youTrackServiceDataBaseLocation);
        this.addProperty(extractedProperties, PersistedYouTrackProperty.SERVICE_YOUTRACK_TEMP_DIR, youTrackServiceDataBaseLocation);
        this.addProperty(extractedProperties, PersistedYouTrackProperty.SERVICE_YOUTRACK_LOGS_DIR, youTrackServiceDataBaseLocation);
        this.addProperty(extractedProperties, PersistedYouTrackProperty.SERVICE_YOUTRACK_BACKUPS_DIR, youTrackServiceDataBaseLocation);
        this.addProperty(extractedProperties, PersistedYouTrackProperty.LICENSE_USERNAME, youTrackServiceDataBaseLocation);
        this.addProperty(extractedProperties, PersistedYouTrackProperty.LICENSE_KEY, youTrackServiceDataBaseLocation);
    }

    @Override
    protected void validateBackupDir(@NotNull Path location, @NotNull Properties extractedProperties, @NotNull String property, @NotNull UpgradeSource.Type type) throws UpgradeValidationException {
        Path youTrackSubfolder = location.resolve(YOUTRACK_FOLDER_NAME);
        Path databaseDir = location;
        if (Files.exists(youTrackSubfolder, new LinkOption[0])) {
            databaseDir = youTrackSubfolder;
        }
        this.checkIfValidExodusDB(databaseDir, property, type);
        this.checkReadWritePermissions(location, property);
        this.checkYouTrackDatabaseLocation(location, extractedProperties, property, type);
        this.validateConfFromBackupDir(property, location, extractedProperties, type);
        this.checkIfBuiltInHubDatabaseExists(location, extractedProperties, property, type);
    }

    private void checkIfBuiltInHubDatabaseExists(@NotNull Path location, @NotNull Properties extractedProperties, @NotNull String property, @NotNull UpgradeSource.Type type) throws UpgradeValidationException {
        boolean oldProductUsesExternalHub;
        boolean bl = oldProductUsesExternalHub = Boolean.valueOf(extractedProperties.getProperty(PersistedYouTrackProperty.DISABLE_INTERNAL_HUB.getBundlePropName())) != false && extractedProperties.getProperty(PersistedYouTrackProperty.HUB_URL.getBundlePropName()) != null;
        if (!Files.isDirectory(location.resolve(HUB_FOLDER_NAME), new LinkOption[0]) && !oldProductUsesExternalHub) {
            ErrorInfo errorInfo = type == UpgradeSource.Type.BACKUP_ARCHIVE ? ValidationError.NO_HUB_FOLDER_WAS_FOUND_IN_BACKUP_ARCHIVE.toErrorInfo(Collections.singletonMap("product", this.wizardBackendConfig.getProductName()), String.format("The selected archive contains a valid %s database, but does not contain data of built-in Hub. Please select an existing installation directory or a valid %s backup that contains Hub database.", this.wizardBackendConfig.getProductName(), this.wizardBackendConfig.getProductName()), property) : ValidationError.NO_HUB_FOLDER_WAS_FOUND_IN_BACKUP_UNCOMPRESSED.toErrorInfo(Collections.singletonMap("product", this.wizardBackendConfig.getProductName()), String.format("The selected directory contains a valid %s database, but does not contain data of built-in Hub. Please select an existing installation directory or a directory containing backup with Hub database", this.wizardBackendConfig.getProductName()), property);
            throw new UpgradeValidationException(errorInfo);
        }
    }

    private void validateConfFromBackupDir(@NotNull String property, Path backupDir, @NotNull Properties extractedProperties, @NotNull UpgradeSource.Type type) throws UpgradeValidationException {
        Path confDir = backupDir.resolve(CONF_FOLDER_NAME);
        Properties bundlePropertiesFromConf = this.loadBundlePropertiesFromConfDir(confDir, property);
        if (bundlePropertiesFromConf == null) {
            String installationType = extractedProperties.getProperty(PersistedYouTrackProperty.BUNDLE_INSTALLATION_TYPE.getBundlePropName());
            if (YouTrackInstallationType.BUNDLE.name().equalsIgnoreCase(installationType)) {
                ErrorInfo errorInfo = type == UpgradeSource.Type.BACKUP_ARCHIVE ? ValidationError.BUNDLE_DATA_WITHOUT_CONFIG_WAS_FOUND_IN_BACKUP_ARCHIVE.toErrorInfo(Collections.singletonMap("product", this.wizardBackendConfig.getProductName()), String.format("The selected archive contains a valid %s database, but does not contain the expected configuration files. Please select an existing installation directory or a valid %s backup.", this.wizardBackendConfig.getProductName(), this.wizardBackendConfig.getProductName()), property) : ValidationError.BUNDLE_DATA_WITHOUT_CONFIG_WAS_FOUND_IN_BACKUP_UNCOMPRESSED.toErrorInfo(Collections.singletonMap("product", this.wizardBackendConfig.getProductName()), String.format("The selected directory contains a valid %s database, but does not contain the expected configuration files. Please select an existing installation directory or a directory containing backup.", this.wizardBackendConfig.getProductName()), property);
                throw new UpgradeValidationException(errorInfo);
            }
        }
    }

    @Override
    protected void checkOldInstallationDirPath(@NotNull Path sourceLocation, @NotNull String property, @NotNull UpgradeSource.Type type) throws UpgradeValidationException {
        if (this.extractFromOldInstallationConfigsRequired(sourceLocation)) {
            super.checkOldInstallationDirPath(sourceLocation, property, type);
        }
    }

    @Override
    protected UpgradeSettings extractSettingsFromOldInstallation(@NotNull Path location, @NotNull Properties extractedProperties) throws UpgradeValidationException {
        if (this.extractFromOldInstallationConfigsRequired(location)) {
            UpgradeSettings upgradeSettings = new UpgradeSettings();
            UpgradeSettingsContext upgradeSettingsContext = new UpgradeSettingsContext();
            upgradeSettings.setContext(upgradeSettingsContext);
            BundleEnvironment bundleEnv = new BundleEnvironment(location);
            String property = "sourceLocation";
            Properties bundleProperties = this.loadBundlePropertiesFromInstallationDir(bundleEnv, property);
            Properties bundleUpgradeProperties = this.loadUpgradePropertiesFromInstallationDir(bundleEnv, property);
            Properties hubProperties = this.loadHubPropertiesFromInstallationDir(bundleEnv, property);
            String oldProductVersion = this.getOldProductVersionFromConfigs(bundleUpgradeProperties, bundleProperties);
            boolean isRestore = Objects.equals(this.wizardBackendConfig.getProductFullVersion(), oldProductVersion);
            String oldListenPort = bundleProperties.getProperty(BundleProperty.LISTEN_PORT.getName());
            if (this.wizardBackendConfig.getInstallationType() == BundleInstallationType.DOCKER) {
                oldListenPort = null;
            }
            String oldListenAddress = bundleProperties.getProperty(BundleProperty.LISTEN_ADDRESS.getName());
            if (this.wizardBackendConfig.getInstallationType() == BundleInstallationType.DOCKER) {
                oldListenAddress = null;
            }
            String oldNonSecureRedirectListenPort = bundleProperties.getProperty(BundleProperty.TLS_REDIRECT_FROM_HTTP_LISTEN_PORT.getName());
            if (this.wizardBackendConfig.getInstallationType() == BundleInstallationType.DOCKER) {
                oldNonSecureRedirectListenPort = null;
            }
            String oldRedirectionFromHttpFlag = bundleProperties.getProperty(BundleProperty.TLS_REDIRECT_FROM_HTTP_FLAG.getName());
            if (this.wizardBackendConfig.getInstallationType() == BundleInstallationType.DOCKER) {
                oldRedirectionFromHttpFlag = null;
            }
            String suitableOldDataDir = this.getSuitableDirFromUpgradeSourceConfigs(bundleProperties, BundleProperty.DATA_DIR);
            String dataDir = this.getFromDefaultsIfNull(suitableOldDataDir, BundleProperty.DATA_DIR.getName());
            String suitableOldLogsDir = this.getSuitableDirFromUpgradeSourceConfigs(bundleProperties, BundleProperty.LOGS_DIR);
            String logsDir = this.getFromDefaultsIfNull(suitableOldLogsDir, BundleProperty.LOGS_DIR.getName());
            String suitableOldTempDir = this.getSuitableDirFromUpgradeSourceConfigs(bundleProperties, BundleProperty.TEMP_DIR);
            String tempDir = this.getFromDefaultsIfNull(suitableOldTempDir, BundleProperty.TEMP_DIR.getName());
            String suitableOldBackupsDir = this.getSuitableDirFromUpgradeSourceConfigs(bundleProperties, BundleProperty.BACKUPS_DIR);
            String backupsDir = this.getFromDefaultsIfNull(suitableOldBackupsDir, BundleProperty.BACKUPS_DIR.getName());
            String baseUrl = this.getFromDefaultsIfNull(bundleProperties.getProperty(BundleProperty.BASE_URL.getName()), BundleProperty.BASE_URL.getName());
            boolean isExternalHubUsed = !PropertiesBasedConfigurationHelper.getHelper().isServiceEnabled((Object)bundleProperties, HUB_FOLDER_NAME);
            String externalHubUrl = isExternalHubUsed ? bundleProperties.getProperty(BundleProperty.HUB_URL.getName()) : null;
            String secureMode = bundleProperties.getProperty(BundleProperty.SECURE_MODE.getName());
            this.extractConnectorSettings(upgradeSettings, oldListenAddress, oldListenPort, oldRedirectionFromHttpFlag, oldNonSecureRedirectListenPort, secureMode);
            this.extractKeystoreInfo(upgradeSettings, bundleProperties, upgradeSettings.getServerConnectorModeSettings().getSecureMode(), bundleEnv.getConfDir(), upgradeSettingsContext);
            upgradeSettings.setBaseUrl(baseUrl);
            upgradeSettings.setDataDir(PathInfo.ensureEndsAsDir(dataDir));
            upgradeSettings.setTempDir(PathInfo.ensureEndsAsDir(tempDir));
            upgradeSettings.setLogsDir(PathInfo.ensureEndsAsDir(logsDir));
            upgradeSettings.setBackupsDir(PathInfo.ensureEndsAsDir(backupsDir));
            upgradeSettingsContext.setExternalHubUsed(isExternalHubUsed);
            upgradeSettings.setExternalHubUrl(externalHubUrl);
            upgradeSettingsContext.setExtractedProperties(extractedProperties);
            upgradeSettingsContext.setOldProductVersion(oldProductVersion);
            upgradeSettingsContext.setIsRestore(isRestore);
            this.setHubServiceIdsAndSecretsFromHubProperties(upgradeSettingsContext, hubProperties);
            return upgradeSettings;
        }
        return this.extractSettingsFromDB(location, extractedProperties, UpgradeSource.Type.OLD_INSTALL_DIR);
    }

    private boolean isSpecialInstallation(Properties wizardConfiguredProperties) {
        if (wizardConfiguredProperties == null) {
            return false;
        }
        HashSet<String> propertyKeys = new HashSet<String>(wizardConfiguredProperties.stringPropertyNames());
        propertyKeys.retainAll(LEGACY_WIZARD_CONFIGURED_PROPERTIES);
        return !propertyKeys.isEmpty();
    }

    @Override
    protected UpgradeSettings extractSettingsFromBackup(@NotNull Path location, @NotNull Properties extractedProperties, UpgradeSource.Type type) throws UpgradeValidationException {
        return this.extractSettingsFromDB(location, extractedProperties, type);
    }

    private UpgradeSettings extractSettingsFromDB(@NotNull Path location, @NotNull Properties extractedProperties, @NotNull UpgradeSource.Type sourceType) throws UpgradeValidationException {
        String property = "sourceLocation";
        UpgradeSettings upgradeSettings = new UpgradeSettings();
        UpgradeSettingsContext upgradeSettingsContext = new UpgradeSettingsContext();
        upgradeSettings.setContext(upgradeSettingsContext);
        String baseUrl = extractedProperties.getProperty(PersistedYouTrackProperty.BUNDLE_BASE_URL_PROPERTY_NAME.getBundlePropName());
        String listenPort = extractedProperties.getProperty(PersistedYouTrackProperty.BUNDLE_LISTEN_PORT_PROPERTY_NAME.getBundlePropName());
        String listenAddress = extractedProperties.getProperty(PersistedYouTrackProperty.BUNDLE_LISTEN_ADDRESS_PROPERTY_NAME.getBundlePropName());
        String oldProductVersion = extractedProperties.getProperty(RESULTED_BUNDLE_OLD_PRODUCT_FULL_VERSION_PROPERTY_NAME);
        boolean isRestore = Objects.equals(this.wizardBackendConfig.getProductFullVersion(), oldProductVersion);
        baseUrl = this.getFromDefaultsIfNull(baseUrl, BundleProperty.BASE_URL.getName());
        upgradeSettings.setBaseUrl(baseUrl);
        boolean isExternalHubUsed = Boolean.valueOf(extractedProperties.getProperty(BundleProperty.constructDisableServiceProperty((String)HUB_FOLDER_NAME)));
        String externalHubUrl = isExternalHubUsed ? extractedProperties.getProperty(PersistedYouTrackProperty.HUB_URL.getBundlePropName()) : null;
        Path confDir = this.getConfDirectory(location, sourceType);
        Properties bundleProperties = this.loadBundlePropertiesFromConfDir(confDir, property);
        String suitableOldDataDir = this.getSuitableDir(bundleProperties, BundleProperty.DATA_DIR, null);
        String dataDir = this.getFromDefaultsIfNull(suitableOldDataDir, BundleProperty.DATA_DIR.getName());
        String suitableOldTempDir = this.getSuitableDir(bundleProperties, BundleProperty.TEMP_DIR, extractedProperties.getProperty(PersistedYouTrackProperty.SERVICE_YOUTRACK_TEMP_DIR.getBundlePropName()));
        String tempDir = this.getFromDefaultsIfNull(suitableOldTempDir, BundleProperty.TEMP_DIR.getName());
        String suitableOldLogsDir = this.getSuitableDir(bundleProperties, BundleProperty.LOGS_DIR, extractedProperties.getProperty(PersistedYouTrackProperty.SERVICE_YOUTRACK_LOGS_DIR.getBundlePropName()));
        String logsDir = this.getFromDefaultsIfNull(suitableOldLogsDir, BundleProperty.LOGS_DIR.getName());
        String suitableOldBackupsDir = this.getSuitableDir(bundleProperties, BundleProperty.BACKUPS_DIR, extractedProperties.getProperty(PersistedYouTrackProperty.SERVICE_YOUTRACK_BACKUPS_DIR.getBundlePropName()));
        String backupsDir = this.getFromDefaultsIfNull(suitableOldBackupsDir, BundleProperty.BACKUPS_DIR.getName());
        String redirectionFromHttpFlag = bundleProperties != null ? bundleProperties.getProperty(BundleProperty.TLS_REDIRECT_FROM_HTTP_FLAG.getName()) : null;
        String nonSecureRedirectListenPort = bundleProperties != null ? bundleProperties.getProperty(BundleProperty.TLS_REDIRECT_FROM_HTTP_LISTEN_PORT.getName()) : null;
        String secureMode = bundleProperties != null ? bundleProperties.getProperty(BundleProperty.SECURE_MODE.getName()) : null;
        this.extractConnectorSettings(upgradeSettings, listenAddress, listenPort, redirectionFromHttpFlag, nonSecureRedirectListenPort, secureMode);
        this.extractKeystoreInfo(upgradeSettings, bundleProperties, upgradeSettings.getServerConnectorModeSettings().getSecureMode(), confDir, upgradeSettingsContext);
        upgradeSettings.setDataDir(PathInfo.ensureEndsAsDir(dataDir));
        upgradeSettings.setTempDir(PathInfo.ensureEndsAsDir(tempDir));
        upgradeSettings.setLogsDir(PathInfo.ensureEndsAsDir(logsDir));
        upgradeSettings.setBackupsDir(PathInfo.ensureEndsAsDir(backupsDir));
        upgradeSettingsContext.setExternalHubUsed(isExternalHubUsed);
        upgradeSettings.setExternalHubUrl(externalHubUrl);
        upgradeSettingsContext.setExtractedProperties(extractedProperties);
        upgradeSettingsContext.setOldProductVersion(oldProductVersion);
        upgradeSettingsContext.setIsRestore(isRestore);
        HashMap<String, String> hubServiceIdToSecretMap = new HashMap<String, String>();
        hubServiceIdToSecretMap.put(extractedProperties.getProperty("hub_config.youtrack.service.id"), extractedProperties.getProperty("hub_config.youtrack.service.secret"));
        upgradeSettingsContext.setHubServiceIdsWithSecrets(hubServiceIdToSecretMap);
        return upgradeSettings;
    }

    private Path getConfDirectory(@NotNull Path location, @NotNull UpgradeSource.Type upgradeSourceType) throws UpgradeValidationException {
        if (upgradeSourceType.isBackup()) {
            return location.resolve(CONF_FOLDER_NAME);
        }
        if (upgradeSourceType == UpgradeSource.Type.OLD_INSTALL_DIR) {
            BundleEnvironment bundleEnv = new BundleEnvironment(location);
            return bundleEnv.getConfDir();
        }
        throw new UpgradeValidationException(ValidationError.UNSUPPORTED_UPGRADE_TYPE.toErrorInfo("type"));
    }

    @Nullable
    private String getSuitableDir(@Nullable Properties bundleProperties, @NotNull BundleProperty bundleProperty, @Nullable String valueFromDB) {
        String suitableDirFromOldConfigs = null;
        if (bundleProperties != null) {
            Path path;
            suitableDirFromOldConfigs = this.getSuitableDirFromUpgradeSourceConfigs(bundleProperties, bundleProperty);
            if (suitableDirFromOldConfigs != null && (path = Paths.get(suitableDirFromOldConfigs, new String[0])).endsWith("internal")) {
                suitableDirFromOldConfigs = path.getParent().toString();
            }
        } else {
            Path path;
            if (valueFromDB != null && this.checkIfDirResolvedFromUpgradeSourceIsReusable(valueFromDB)) {
                suitableDirFromOldConfigs = valueFromDB;
            }
            if (suitableDirFromOldConfigs != null && (path = Paths.get(suitableDirFromOldConfigs, new String[0])).endsWith(YOUTRACK_FOLDER_NAME)) {
                suitableDirFromOldConfigs = path.getParent().toString();
            }
        }
        return suitableDirFromOldConfigs;
    }

    private boolean extractFromOldInstallationConfigsRequired(Path sourceLocation) {
        Version previousVersion;
        Path bundleHome = Paths.get(this.wizardBackendConfig.getInstallationDirectory(), new String[0]);
        if (bundleHome.equals(sourceLocation) && (previousVersion = Version.parseVersion((String)this.wizardBackendConfig.getProductPreviousFullVersion())) != null && previousVersion.isGreaterOrEqual(YOUTRACK_7_0_LOWEST_VERSION)) {
            BundleEnvironment bundleEnv = new BundleEnvironment(bundleHome);
            boolean configsFound = Files.exists(bundleEnv.getBundleConfig(), new LinkOption[0]);
            return this.wizardBackendConfig.isUpgradeDetected() && configsFound;
        }
        return false;
    }

    private void checkYouTrackDatabaseLocation(@NotNull Path databaseLocation, @NotNull Properties extractedProperties, @NotNull String property, @NotNull UpgradeSource.Type type) throws UpgradeValidationException {
        boolean youTrackFolderExistsInLocation = Files.exists(databaseLocation.resolve(YOUTRACK_FOLDER_NAME), new LinkOption[0]);
        Path youTrackServiceDataBaseLocation = youTrackFolderExistsInLocation ? databaseLocation.resolve(YOUTRACK_FOLDER_NAME) : databaseLocation;
        this.checkIfValidExodusDB(youTrackServiceDataBaseLocation, property, type);
        String oldProductVersionString = this.exodusExplorer.getYouTrackFullVersion(youTrackServiceDataBaseLocation);
        Version oldProductVersion = Version.parseVersion((String)oldProductVersionString);
        if (oldProductVersion == null) {
            throw new UpgradeValidationException(ValidationError.CANNOT_UPGRADE_VERSION_NOT_RECOGNIZED.toErrorInfo("Old version of product is not recognized: " + oldProductVersionString, property));
        }
        this.checkYouTrackServiceDb(youTrackServiceDataBaseLocation, oldProductVersion, extractedProperties, property);
    }

    private void addProperty(@NotNull Properties properties, @NotNull PersistedYouTrackProperty property, @NotNull Path dbLocation) {
        String value;
        String string = value = property.isStoredInBlob() ? this.exodusExplorer.readStringBlobProperty(dbLocation, property) : this.exodusExplorer.readStringSimpleProperty(dbLocation, property);
        if (value != null) {
            properties.setProperty(property.getBundlePropName(), value);
        }
    }

    private void copyHubConfiguratorConfigFile(@NotNull Path confDirFromBackup, @Nullable String hubConfigSourceName, @Nullable String hubConfigTargetName, @NotNull String property) throws UpgradeValidationException {
        if (hubConfigTargetName == null || hubConfigSourceName == null) {
            return;
        }
        try {
            Path sourcePath = confDirFromBackup.resolve(hubConfigSourceName);
            if (Files.exists(sourcePath, new LinkOption[0]) && Files.isRegularFile(sourcePath, new LinkOption[0])) {
                Path targetPath = Paths.get(hubConfigTargetName, new String[0]);
                Files.createDirectories(targetPath.getParent(), new FileAttribute[0]);
                Files.copy(sourcePath, targetPath, StandardCopyOption.REPLACE_EXISTING);
                this.LOG.info("Config file was copied: {} ==> {}", (Object)sourcePath, (Object)targetPath);
            } else {
                this.LOG.debug("Config file not found: {}", (Object)sourcePath);
            }
        }
        catch (IOException e) {
            String message = "Cannot copy hub config from conf/ folder: " + e.getMessage();
            throw new UpgradeValidationException(ValidationError.UPGRADE_LOCATION_PROCESSING_ERROR.toErrorInfo(Collections.singletonMap("error", message), message, property));
        }
    }

    private void checkIfValidExodusDB(@NotNull Path databaseDir, @NotNull String property, @NotNull UpgradeSource.Type type) throws UpgradeValidationException {
        if (!this.exodusExplorer.isExodusDatabase(databaseDir)) {
            ErrorInfo errorInfo;
            if (type == UpgradeSource.Type.BACKUP_ARCHIVE) {
                String errorMessage = "YouTrack database not found in specified archive";
                errorInfo = ValidationError.BACKUP_ARCHIVE_DOES_NOT_CONTAIN_YOUTRACK_DB.toErrorInfo(errorMessage, property);
            } else {
                String errorMessage = "YouTrack database not found in " + databaseDir;
                errorInfo = ValidationError.LOCATION_DOES_NOT_CONTAIN_YOUTRACK_DB.toErrorInfo(Collections.singletonMap("path", databaseDir.toString()), errorMessage, property);
            }
            throw new UpgradeValidationException(errorInfo);
        }
        if (!this.exodusExplorer.canBeOpened(databaseDir)) {
            String errorMessage = "Can not open database at " + databaseDir.toString() + ". May be it's locked by another running YouTrack instance?";
            throw new UpgradeValidationException(ValidationError.CANNOT_OPEN_YOUTRACK_DB.toErrorInfo(Collections.singletonMap("path", databaseDir.toString()), errorMessage, property));
        }
    }

    @Override
    protected void prepareConfDir(@NotNull Path oldConfDir, @NotNull Path newConfDir, @NotNull UpgradeSettings upgradeSettings) throws UpgradeValidationException {
        super.prepareConfDir(oldConfDir, newConfDir, upgradeSettings);
        Path wizardConfiguredPropertiesPath = this.getWizardConfiguredPropertiesPath(newConfDir);
        Properties wizardConfiguredProperties = this.getWizardConfiguredProperties(wizardConfiguredPropertiesPath, "dataDir");
        if (wizardConfiguredProperties != null) {
            for (String legacyProperty : LEGACY_WIZARD_CONFIGURED_PROPERTIES) {
                wizardConfiguredProperties.remove(legacyProperty);
            }
            ConfiguratorUtils.savePropertiesFile((File)wizardConfiguredPropertiesPath.toFile(), (Properties)wizardConfiguredProperties);
        }
        this.patchLauncherConfig(newConfDir.resolve(YOUTRACK_FOLDER_NAME).resolve("youtrack.launch.config"), Paths.get(upgradeSettings.getLogsDir(), new String[0]).resolve(YOUTRACK_FOLDER_NAME));
    }

    @Override
    protected void prepareUpdateFromBackup(@NotNull UpgradeSettings upgradeSettings, @NotNull Path preparedLocation, @NotNull UpgradeSource.Type type) throws UpgradeValidationException {
        Path confSubfolder = preparedLocation.resolve(CONF_FOLDER_NAME);
        Path youTrackSubfolder = preparedLocation.resolve(YOUTRACK_FOLDER_NAME);
        boolean confExists = Files.exists(confSubfolder, new LinkOption[0]);
        this.checkIfValidExodusDB(youTrackSubfolder, "dataDir", type);
        Path newDataDir = Paths.get(upgradeSettings.getDataDir(), new String[0]);
        if (!preparedLocation.equals(newDataDir)) {
            this.assertDiskSpaceForDirCopy(preparedLocation, newDataDir);
        }
        if (confExists) {
            String hubConfiguratorConfigFileInBackup = this.wizardBackendConfig.getHubConfiguratorConfigFileInBackup();
            String hubConfiguratorConfigFile = this.wizardBackendConfig.getHubConfiguratorConfigFile();
            this.copyHubConfiguratorConfigFile(confSubfolder, hubConfiguratorConfigFileInBackup, hubConfiguratorConfigFile, "dataDir");
            if (YouTrackInstallationType.BUNDLE.name().equals(upgradeSettings.getContext().getExtractedProperties().getProperty(PersistedYouTrackProperty.BUNDLE_INSTALLATION_TYPE.getBundlePropName()))) {
                Path installationDirectory = Paths.get(this.wizardBackendConfig.getInstallationDirectory(), new String[0]);
                BundleEnvironment newBundleEnv = new BundleEnvironment(installationDirectory);
                Path newConfDir = newBundleEnv.getConfDir();
                this.prepareConfDir(confSubfolder, newConfDir, upgradeSettings);
            }
        }
        this.prepareDataDir(preparedLocation, newDataDir);
    }

    @Override
    public boolean canBeOldDataDir(@NotNull Path location) {
        boolean youTrackFolderExistsInLocation = Files.exists(location.resolve(YOUTRACK_FOLDER_NAME), new LinkOption[0]);
        Path youTrackServiceDataBaseLocation = youTrackFolderExistsInLocation ? location.resolve(YOUTRACK_FOLDER_NAME) : location;
        return this.exodusExplorer.isExodusDatabase(youTrackServiceDataBaseLocation);
    }

    static {
        HashSet<String> tmpSet = new HashSet<String>();
        tmpSet.add(PropertiesBasedConfigurationHelper.getHelper().getPrefixedPropertyName(YOUTRACK_FOLDER_NAME, ServiceProperties.LOGS_DIR_PROPERTY));
        tmpSet.add(PropertiesBasedConfigurationHelper.getHelper().getPrefixedPropertyName(YOUTRACK_FOLDER_NAME, ServiceProperties.DATA_DIR_PROPERTY));
        tmpSet.add(PropertiesBasedConfigurationHelper.getHelper().getPrefixedPropertyName(YOUTRACK_FOLDER_NAME, ServiceProperties.TEMP_DIR_PROPERTY));
        tmpSet.add(PropertiesBasedConfigurationHelper.getHelper().getPrefixedPropertyName(YOUTRACK_FOLDER_NAME, ServiceProperties.BACKUPS_DIR_PROPERTY));
        tmpSet.add(PropertiesBasedConfigurationHelper.getHelper().getPrefixedPropertyName(HUB_FOLDER_NAME, ServiceProperties.LOGS_DIR_PROPERTY));
        tmpSet.add(PropertiesBasedConfigurationHelper.getHelper().getPrefixedPropertyName(HUB_FOLDER_NAME, ServiceProperties.DATA_DIR_PROPERTY));
        tmpSet.add(PropertiesBasedConfigurationHelper.getHelper().getPrefixedPropertyName(HUB_FOLDER_NAME, ServiceProperties.TEMP_DIR_PROPERTY));
        tmpSet.add(PropertiesBasedConfigurationHelper.getHelper().getPrefixedPropertyName(HUB_FOLDER_NAME, ServiceProperties.BACKUPS_DIR_PROPERTY));
        LEGACY_WIZARD_CONFIGURED_PROPERTIES = Collections.unmodifiableSet(tmpSet);
    }
}

