/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.validation.folder.impl;

import com.jetbrains.bundle.BundleInstallationType;
import com.jetbrains.bundle.hub_client.util.validation.ErrorInfo;
import com.jetbrains.installer.model.BundleDefaults;
import com.jetbrains.installer.model.WizardBackendConfig;
import com.jetbrains.installer.validation.ValidationError;
import com.jetbrains.installer.validation.folder.InstallPathValidator;
import com.jetbrains.service.util.SystemUtil;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CleanDataFolderValidator
implements InstallPathValidator {
    @Autowired
    WizardBackendConfig wizardBackendConfig;
    @Autowired
    private BundleDefaults bundleDefaults;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public ErrorInfo checkPath(@NotNull String path, @NotNull String property) {
        Path folderPath;
        try {
            folderPath = Paths.get(path, new String[0]);
        }
        catch (InvalidPathException e) {
            return ValidationError.INVALID_LOCATION.toErrorInfo(Collections.singletonMap("message", e.getMessage()), e.getMessage(), property);
        }
        if (!Files.exists(folderPath, new LinkOption[0])) {
            return null;
        }
        if (BundleInstallationType.JAR != this.wizardBackendConfig.getInstallationType()) {
            String checkResult = SystemUtil.checkExistingEmptyFolder((Path)folderPath);
            if (checkResult != null) return ValidationError.INVALID_LOCATION.toErrorInfo(Collections.singletonMap("message", checkResult), checkResult, property);
            return null;
        }
        try (DirectoryStream<Path> dirStream = Files.newDirectoryStream(folderPath, (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) {
                return !"conf".equals(entry.toFile().getName()) || !Paths.get(CleanDataFolderValidator.this.bundleDefaults.getDataDir(), new String[0]).equals(folderPath);
            }
        });){
            String errorMessage = String.format("Failed to check %s", folderPath);
            ErrorInfo errorInfo = !dirStream.iterator().hasNext() ? null : ValidationError.INVALID_LOCATION.toErrorInfo(Collections.singletonMap("message", String.format("Directory %s contains unexpected entries", folderPath)), errorMessage, property);
            return errorInfo;
        }
        catch (IOException e) {
            String errorMessage = String.format("Failed to check %s", folderPath);
            return ValidationError.INVALID_LOCATION.toErrorInfo(Collections.singletonMap("message", e.getMessage()), errorMessage, property);
        }
    }
}

