/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.validation.folder.impl;

import com.jetbrains.bundle.hub_client.util.validation.ErrorInfo;
import com.jetbrains.installer.model.WizardBackendConfig;
import com.jetbrains.installer.validation.ValidationError;
import com.jetbrains.installer.validation.folder.InstallPathValidator;
import com.jetbrains.service.util.SystemUtil;
import java.io.File;
import java.util.HashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FolderWriteAccessValidator
implements InstallPathValidator {
    @Autowired
    WizardBackendConfig wizardBackendConfig;

    @Override
    @Nullable
    public ErrorInfo checkPath(@NotNull String path, @NotNull String property) {
        String error = SystemUtil.checkFolderIsWritable((File)new File(path));
        if (error != null) {
            return this.constructNoWriteAccessError(error, error, property);
        }
        return null;
    }

    @NotNull
    public ErrorInfo constructInaccessibleError(@NotNull String location, @NotNull String developerMessage, @NotNull String property) {
        String installationUser = this.wizardBackendConfig.getInstallationUser();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("location", location);
        if (installationUser != null) {
            parameters.put("user", installationUser);
            return ValidationError.LOCATION_NOT_ACCESSIBLE_BY_USER.toErrorInfo(parameters, developerMessage, property);
        }
        return ValidationError.LOCATION_NOT_ACCESSIBLE.toErrorInfo(parameters, developerMessage, property);
    }

    @NotNull
    public ErrorInfo constructInaccessibleOrNotExistError(@NotNull String location, @NotNull String developerMessage, @NotNull String property) {
        String installationUser = this.wizardBackendConfig.getInstallationUser();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("location", location);
        if (installationUser != null) {
            parameters.put("user", installationUser);
            return ValidationError.LOCATION_NOT_EXIST_OR_NOT_ACCESSIBLE_BY_USER.toErrorInfo(parameters, developerMessage, property);
        }
        return ValidationError.LOCATION_NOT_EXIST_OR_NOT_ACCESSIBLE.toErrorInfo(parameters, developerMessage, property);
    }

    @NotNull
    public ErrorInfo constructInaccessibleOrEmptyError(@NotNull String location, @NotNull String developerMessage, @NotNull String property) {
        String installationUser = this.wizardBackendConfig.getInstallationUser();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("location", location);
        if (installationUser != null) {
            parameters.put("user", installationUser);
            return ValidationError.LOCATION_IS_EMPTY_OR_NOT_ACCESSIBLE_BY_USER.toErrorInfo(parameters, developerMessage, property);
        }
        return ValidationError.LOCATION_IS_EMPTY_OR_NOT_ACCESSIBLE.toErrorInfo(parameters, developerMessage, property);
    }

    @NotNull
    public ErrorInfo constructNoWriteAccessError(@NotNull String message, @NotNull String developerMessage, @Nullable String property) {
        String installationUser = this.wizardBackendConfig.getInstallationUser();
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("message", message);
        if (installationUser != null) {
            parameters.put("user", installationUser);
            return ValidationError.LOCATION_NOT_WRITABLE_BY_USER.toErrorInfo(parameters, developerMessage, property);
        }
        return ValidationError.LOCATION_NOT_WRITABLE.toErrorInfo(parameters, developerMessage, property);
    }
}

