/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.validation.folder.impl;

import com.jetbrains.bundle.hub_client.util.validation.ErrorInfo;
import com.jetbrains.installer.validation.ValidationError;
import com.jetbrains.installer.validation.folder.InstallPathValidator;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.stereotype.Component;

@Component
public class NonRootPathValidator
implements InstallPathValidator {
    @Override
    @Nullable
    public ErrorInfo checkPath(@NotNull String pathString, @NotNull String property) {
        Path path;
        try {
            path = Paths.get(pathString, new String[0]);
        }
        catch (InvalidPathException e) {
            return ValidationError.INVALID_LOCATION.toErrorInfo(Collections.singletonMap("message", e.getMessage()), "Cannot check location: " + e.getMessage(), property);
        }
        if (path.getParent() == null) {
            return ValidationError.LOCATION_MUST_NOT_BE_FILE_SYSTEM_ROOT.toErrorInfo(property);
        }
        return null;
    }
}

