/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.installer.validation.folder.impl;

import com.jetbrains.bundle.hub_client.util.validation.ErrorInfo;
import com.jetbrains.installer.validation.BundleUpgradeHelper;
import com.jetbrains.installer.validation.ValidationError;
import com.jetbrains.installer.validation.folder.InstallPathValidator;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class OldDataPathValidator
implements InstallPathValidator {
    @Autowired
    BundleUpgradeHelper upgradeHelper;

    @Override
    @Nullable
    public ErrorInfo checkPath(@NotNull String pathString, @NotNull String property) {
        Path path;
        try {
            path = Paths.get(pathString, new String[0]);
        }
        catch (InvalidPathException e) {
            return ValidationError.INVALID_LOCATION.toErrorInfo(Collections.singletonMap("message", e.getMessage()), e.getMessage(), property);
        }
        if (Files.exists(path, new LinkOption[0]) && Files.isDirectory(path, new LinkOption[0]) && this.upgradeHelper.canBeOldDataDir(path)) {
            return ValidationError.TRY_TO_USE_UPGRADE_INSTEAD.toErrorInfo(Collections.singletonMap("dir", path.toString()), property);
        }
        return null;
    }
}

