/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.starting_page;

import com.jetbrains.bundle.api.internal.services.ServicesInformationProvider;
import com.jetbrains.bundle.api.internal.services.model.ProductState;
import com.jetbrains.bundle.starting_page.model.BundleInfo;
import com.jetbrains.bundle.starting_page.model.BundleState;
import com.jetbrains.service.util.UrlUtil;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import org.jetbrains.annotations.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping
public class BundleStateController {
    @Autowired
    ServicesInformationProvider myServicesInformationProvider;

    @RequestMapping(method={RequestMethod.GET}, value={"/bundle/state"})
    public BundleState getBundleState() {
        BundleState result = new BundleState();
        result.setIsStarting(this.myServicesInformationProvider.isBundleStarting());
        return result;
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/bundle/started"})
    public ResponseEntity<String> getBundleStarted() {
        BundleState result = this.getBundleState();
        if (result.isStarting()) {
            return new ResponseEntity((Object)"STARTING", HttpStatus.SERVICE_UNAVAILABLE);
        }
        return new ResponseEntity((Object)"OK", HttpStatus.OK);
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/bundle/info"})
    public BundleInfo getBundleInfo(HttpServletRequest request) {
        ProductState productState = this.myServicesInformationProvider.getProductState();
        return this.convert(productState, request);
    }

    @NotNull
    private String getBundleBackendUrl(HttpServletRequest request, ProductState productState) {
        String requestUrlString = request.getRequestURL().toString();
        try {
            URL requestUrl = new URL(requestUrlString);
            return new URL(requestUrl.getProtocol(), requestUrl.getHost(), requestUrl.getPort(), UrlUtil.combineContexts((String)productState.getBundleBaseContext(), (String)"bundle/backend")).toString();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("Request URL should has been valid: " + requestUrlString, e);
        }
    }

    protected BundleInfo convert(ProductState productState, HttpServletRequest request) {
        BundleInfo result = new BundleInfo();
        result.setProductPresentationName(productState.getProductPresentationName());
        result.setLogsDirectory(productState.getLogsDirectory().getPath());
        result.setBundleBackendUrl(this.getBundleBackendUrl(request, productState));
        return result;
    }
}

