/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.starting_page;

import com.jetbrains.bundle.api.internal.services.ServicesInformationProvider;
import com.jetbrains.bundle.api.internal.services.model.ServiceInfo;
import com.jetbrains.bundle.starting_page.model.Service;
import com.jetbrains.bundle.starting_page.model.ServiceStatus;
import com.jetbrains.bundle.starting_page.utils.ParamUtils;
import com.jetbrains.bundle.util.BundleUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/bundle/services"})
public class ServicesController {
    @Autowired
    ServicesInformationProvider myServicesInformationProvider;

    @RequestMapping(method={RequestMethod.GET})
    public List<Service> getAllServices(@RequestParam(value="fields", required=false) String fieldsParam, HttpServletRequest request) {
        List<String> fields = ParamUtils.parseFields(fieldsParam);
        List<ServiceInfo> servicesInfo = this.getServicesInfo();
        Map serviceStatusMap = new HashMap();
        if (fields.contains("status")) {
            serviceStatusMap = this.myServicesInformationProvider.getStatuses(this.deriveServiceIds(servicesInfo));
        }
        ArrayList<Service> resultServiceList = new ArrayList<Service>();
        for (ServiceInfo serviceInfo : servicesInfo) {
            com.jetbrains.bundle.api.internal.services.model.ServiceStatus status = (com.jetbrains.bundle.api.internal.services.model.ServiceStatus)serviceStatusMap.get(serviceInfo.getId());
            resultServiceList.add(this.getService(serviceInfo, status, request));
        }
        return resultServiceList;
    }

    private Collection<String> deriveServiceIds(List<ServiceInfo> servicesInfoList) {
        ArrayList<String> result = new ArrayList<String>();
        for (ServiceInfo serviceInfo : servicesInfoList) {
            result.add(serviceInfo.getId());
        }
        return result;
    }

    private List<ServiceInfo> getServicesInfo() {
        ArrayList<ServiceInfo> servicesInfo = new ArrayList<ServiceInfo>(this.myServicesInformationProvider.getAllServices());
        Iterator it = servicesInfo.iterator();
        while (it.hasNext()) {
            if (this.isVisibleOnStartingPage((ServiceInfo)it.next())) continue;
            it.remove();
        }
        return servicesInfo;
    }

    private boolean isVisibleOnStartingPage(ServiceInfo serviceInfo) {
        return !serviceInfo.isInternal() || "adminService".equals(serviceInfo.getId());
    }

    @RequestMapping(value={"/{id}"}, method={RequestMethod.GET})
    public Service getService(@PathVariable(value="id") String id, @RequestParam(value="fields", required=false) String fieldsParam, HttpServletRequest request) {
        List<String> fields = ParamUtils.parseFields(fieldsParam);
        com.jetbrains.bundle.api.internal.services.model.ServiceStatus serviceStatus = fields.contains("status") ? this.myServicesInformationProvider.getServiceStatus(id) : null;
        return this.getService(id, serviceStatus);
    }

    private Service getService(ServiceInfo serviceInfo, com.jetbrains.bundle.api.internal.services.model.ServiceStatus status, HttpServletRequest request) {
        Service service = new Service();
        service.setId(serviceInfo.getId());
        service.setName(serviceInfo.getName());
        service.setHomeUrl(BundleUtil.resolveServiceUrlForClient((HttpServletRequest)request, (String)serviceInfo.getHomeUrl()));
        service.setStatus(this.convert(status));
        service.setDefault(serviceInfo.isDefault());
        return service;
    }

    private Service getService(String id, com.jetbrains.bundle.api.internal.services.model.ServiceStatus status) {
        Service service = new Service();
        service.setId(id);
        service.setStatus(this.convert(status));
        return service;
    }

    private ServiceStatus convert(com.jetbrains.bundle.api.internal.services.model.ServiceStatus status) {
        if (status == null) {
            return null;
        }
        ServiceStatus serviceStatus = new ServiceStatus();
        serviceStatus.setStatus(status.getStatus());
        serviceStatus.setDescription(status.getDescription());
        return serviceStatus;
    }
}

