/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.starting_page.config;

import com.jetbrains.service.util.UrlUtil;
import java.io.IOException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import jetbrains.ring.servlet.LookupResult;
import jetbrains.ring.servlet.StaticServlet;
import jetbrains.ring.servlet.util.IndexFileHolder;

public class ForwardAwareStaticServlet
extends StaticServlet {
    protected IndexFileHolder createIndexFileHolder(URL welcomePage, String replacePattern, String contextTag, String cacheControl) {
        return new ForwardAwareIndexFileHolder(welcomePage, replacePattern, contextTag, cacheControl);
    }

    static class ForwardAwareIndexFileHolder
    extends IndexFileHolder {
        ForwardAwareIndexFileHolder(URL url, String replacePattern, String contextTag, String cacheControl) {
            super(url, replacePattern, contextTag, cacheControl);
        }

        public LookupResult.IndexResource getIndexResource(HttpServletRequest request) throws IOException {
            String forwardedContextPath = (String)request.getAttribute("javax.servlet.forward.context_path");
            String forwardedServletPath = (String)request.getAttribute("javax.servlet.forward.servlet_path");
            if (forwardedContextPath != null && forwardedServletPath != null) {
                return this.getIndexResource(UrlUtil.combineContexts((String)forwardedContextPath, (String)forwardedServletPath));
            }
            return super.getIndexResource(request);
        }
    }
}

