/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher;

import com.jetbrains.launcher.AppExitCode;
import com.jetbrains.launcher.AppFilesEx;
import com.jetbrains.launcher.AppFilesImpl;
import com.jetbrains.launcher.AppFixedFiles;
import com.jetbrains.launcher.AppName;
import com.jetbrains.launcher.AppNameImpl;
import com.jetbrains.launcher.AppProxy;
import com.jetbrains.launcher.AppProxyException;
import com.jetbrains.launcher.ApplicationFacade;
import com.jetbrains.launcher.CommandLine;
import com.jetbrains.launcher.ConfiguringService;
import com.jetbrains.launcher.Destroyer;
import com.jetbrains.launcher.InitException;
import com.jetbrains.launcher.JLThread;
import com.jetbrains.launcher.LauncherVersion;
import com.jetbrains.launcher.LauncherVersionImpl;
import com.jetbrains.launcher.LogLevel;
import com.jetbrains.launcher.LogSettings;
import com.jetbrains.launcher.RunningService;
import com.jetbrains.launcher.StartKind;
import com.jetbrains.launcher.SystemInfo;
import com.jetbrains.launcher.contexts.ApplicationContext;
import com.jetbrains.launcher.contexts.CommonContext;
import com.jetbrains.launcher.log.AppWrapperLoggerEx;
import com.jetbrains.launcher.log.AppWrapperLoggerImpl;
import com.jetbrains.launcher.log.LogInitializer;
import com.jetbrains.launcher.log.LoggerMode;
import com.jetbrains.launcher.transport.TransportConstants;
import com.jetbrains.launcher.util.AppRuntimeUtil;
import com.jetbrains.launcher.util.ClassLoaderUtil;
import com.jetbrains.launcher.util.JavaInfoUtil;
import com.jetbrains.launcher.util.ManifestUtil;
import com.jetbrains.launcher.util.ProcessUtil;
import com.jetbrains.launcher.util.RuntimeUtil;
import com.jetbrains.launcher.util.SystemUtil;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AppWrapperArguments
implements ApplicationFacade,
CommonContext,
CommandLine,
LogSettings {
    @NotNull
    private final LogLevel myLogLevel;
    @NotNull
    private final AppWrapperLoggerImpl myLogger;
    @NotNull
    private final AppName myAppName;
    @NotNull
    private final AppFilesEx myAppFiles;
    @NotNull
    private final AppProxy myAppProxy;
    @NotNull
    private final List<String> myAppWrapperArgs;
    @NotNull
    private final LauncherVersion myLauncherVersion;
    @NotNull
    private final StartKind myStartKind;
    private final boolean myIsService;

    public AppWrapperArguments(@NotNull String[] args) {
        if (args == null) {
            AppWrapperArguments.$$$reportNull$$$0(0);
        }
        JLThread.setPrefix((String)"[APP-WRAPPER] ");
        this.myLogLevel = this.detectLogLevel();
        this.myLogger = new AppWrapperLoggerImpl();
        this.myAppName = AppNameImpl.detectAppName();
        try {
            this.myAppFiles = this.detectAppFiles();
            RuntimeUtil.addRuntimeReplacements((AppFixedFiles)this.myAppFiles, (AppName)this.myAppName);
            LogInitializer.init((AppFixedFiles)this.myAppFiles, (File)this.myAppFiles.getLauncherLogsFolder(), (LoggerMode)LoggerMode.APP_WRAPPER, (LogLevel)this.myLogLevel, null, (boolean)true);
        }
        catch (InitException e) {
            this.myLogger.initError(e);
            AppWrapperArguments.exit();
            throw new IllegalStateException();
        }
        String appCapitalizedName = this.myAppName.getCapitalizedName();
        this.myLogger.debug(appCapitalizedName + " Java: " + JavaInfoUtil.printCurrentJavaInfo());
        this.myLogger.debug(appCapitalizedName + " process ID: " + ProcessUtil.getCurrentPidDescription());
        this.myLogger._debug(appCapitalizedName + " home directory: " + this.myAppFiles.getAppHome().getAbsolutePath());
        this.myLogger.debug("Command line: " + Arrays.toString(args));
        this.myLogger.debug("JetLauncher logs directory: " + this.myAppFiles.getLauncherLogsFolder().getAbsolutePath());
        if (args.length == 0) {
            this.myLogger.internalError("Application wrapper class is not specified");
            AppWrapperArguments.exit();
        }
        try {
            URLClassLoader appClassLoader = this.createAppClassLoader();
            this.logClassLoader(appClassLoader);
            this.myAppProxy = new AppProxy(appClassLoader, args[0]);
        }
        catch (AppProxyException e) {
            this.myLogger.internalError("Failed to create application wrapper proxy", e);
            AppWrapperArguments.exit();
            throw new IllegalStateException();
        }
        Destroyer.get().addStep(new Runnable(){

            @Override
            public void run() {
                AppWrapperArguments.this.myAppProxy.dispose();
            }
        });
        this.myAppWrapperArgs = new ArrayList<String>();
        this.myAppWrapperArgs.addAll(Arrays.asList(args).subList(1, args.length));
        this.myLauncherVersion = this.detectLauncherVersion();
        this.myLogger.debug("JetLauncher version: " + this.getLauncherVersion().asString());
        this.myStartKind = this.detectStartKind();
        this.myIsService = Boolean.getBoolean("launcher.is.service");
    }

    @NotNull
    public ConfiguringService createConfiguringService(@NotNull ApplicationContext context) {
        if (context == null) {
            AppWrapperArguments.$$$reportNull$$$0(1);
        }
        ConfiguringService configuringService = this.myAppProxy.createConfiguringService(context);
        if (configuringService == null) {
            AppWrapperArguments.$$$reportNull$$$0(2);
        }
        return configuringService;
    }

    @NotNull
    public RunningService createRunningService(@NotNull ApplicationContext context) {
        if (context == null) {
            AppWrapperArguments.$$$reportNull$$$0(3);
        }
        RunningService runningService = this.myAppProxy.createRunningService(context);
        if (runningService == null) {
            AppWrapperArguments.$$$reportNull$$$0(4);
        }
        return runningService;
    }

    @NotNull
    public AppName getAppName() {
        AppName appName = this.myAppName;
        if (appName == null) {
            AppWrapperArguments.$$$reportNull$$$0(5);
        }
        return appName;
    }

    @NotNull
    public AppFilesEx getAppFiles() {
        AppFilesEx appFilesEx = this.myAppFiles;
        if (appFilesEx == null) {
            AppWrapperArguments.$$$reportNull$$$0(6);
        }
        return appFilesEx;
    }

    @NotNull
    public LauncherVersion getLauncherVersion() {
        LauncherVersion launcherVersion = this.myLauncherVersion;
        if (launcherVersion == null) {
            AppWrapperArguments.$$$reportNull$$$0(7);
        }
        return launcherVersion;
    }

    @NotNull
    public StartKind getStartKind() {
        StartKind startKind = this.myStartKind;
        if (startKind == null) {
            AppWrapperArguments.$$$reportNull$$$0(8);
        }
        return startKind;
    }

    public boolean isService() {
        return this.myIsService;
    }

    @NotNull
    public AppWrapperLoggerEx getLogger() {
        AppWrapperLoggerImpl appWrapperLoggerImpl = this.myLogger;
        if (appWrapperLoggerImpl == null) {
            AppWrapperArguments.$$$reportNull$$$0(9);
        }
        return appWrapperLoggerImpl;
    }

    @NotNull
    public List<String> getApplicationArguments() {
        List<String> list = Collections.unmodifiableList(this.myAppWrapperArgs);
        if (list == null) {
            AppWrapperArguments.$$$reportNull$$$0(10);
        }
        return list;
    }

    @NotNull
    public LogLevel getLogLevel() {
        LogLevel logLevel = this.myLogLevel;
        if (logLevel == null) {
            AppWrapperArguments.$$$reportNull$$$0(11);
        }
        return logLevel;
    }

    @NotNull
    private LogLevel detectLogLevel() {
        String logLevelName = System.getProperty("launcher.log.level");
        if (logLevelName != null) {
            for (LogLevel logLevel : LogLevel.values()) {
                if (!logLevel.name().equals(logLevelName)) continue;
                LogLevel logLevel2 = logLevel;
                if (logLevel2 == null) {
                    AppWrapperArguments.$$$reportNull$$$0(12);
                }
                return logLevel2;
            }
        }
        LogLevel logLevel = TransportConstants.DEFAULT_LOG_LEVEL;
        if (logLevel == null) {
            AppWrapperArguments.$$$reportNull$$$0(13);
        }
        return logLevel;
    }

    @NotNull
    private AppFilesEx detectAppFiles() throws InitException {
        AppFilesEx appFiles = AppFilesImpl.detectFiles();
        if (appFiles == null) {
            throw new InitException("Failed to detect " + this.myAppName.getName() + " home (system property \"" + "launcher.app.home" + "\" is not specified)");
        }
        AppFilesEx appFilesEx = appFiles;
        if (appFilesEx == null) {
            AppWrapperArguments.$$$reportNull$$$0(14);
        }
        return appFilesEx;
    }

    @NotNull
    private URLClassLoader createAppClassLoader() {
        List appLibFolders = AppRuntimeUtil.detectLibDirs((File)this.myAppFiles.getAppLibFolder());
        URLClassLoader cl = ClassLoaderUtil.getClassLoaderByLibDirs(appLibFolders, ApplicationFacade.class.getClassLoader(), new String[0]);
        if (cl == null) {
            this.myLogger.internalError("Failed to create class loader. " + this.myAppName.getCapitalizedName() + " lib directories: " + appLibFolders);
            AppWrapperArguments.exit();
        }
        URLClassLoader uRLClassLoader = cl;
        if (uRLClassLoader == null) {
            AppWrapperArguments.$$$reportNull$$$0(15);
        }
        return uRLClassLoader;
    }

    private void logClassLoader(@NotNull URLClassLoader appClassLoader) {
        if (appClassLoader == null) {
            AppWrapperArguments.$$$reportNull$$$0(16);
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.myAppName.getCapitalizedName()).append(" class loader:").append(SystemInfo.EOL);
        this.appendURLClassLoaderInfo(sb, appClassLoader);
        this.myLogger.debug(sb.toString());
    }

    private void appendURLClassLoaderInfo(@NotNull StringBuilder sb, @NotNull URLClassLoader classLoader) {
        if (sb == null) {
            AppWrapperArguments.$$$reportNull$$$0(17);
        }
        if (classLoader == null) {
            AppWrapperArguments.$$$reportNull$$$0(18);
        }
        sb.append(classLoader.getClass().getName()).append(" {").append(SystemInfo.EOL);
        for (URL url : classLoader.getURLs()) {
            sb.append("    ").append(url.toExternalForm()).append(SystemInfo.EOL);
        }
        sb.append("}");
        this.appendParentClassLoaderInfo(sb, classLoader);
    }

    private void appendParentClassLoaderInfo(@NotNull StringBuilder sb, @NotNull ClassLoader classLoader) {
        ClassLoader parent;
        if (sb == null) {
            AppWrapperArguments.$$$reportNull$$$0(19);
        }
        if (classLoader == null) {
            AppWrapperArguments.$$$reportNull$$$0(20);
        }
        if ((parent = classLoader.getParent()) == null) {
            return;
        }
        sb.append(SystemInfo.EOL).append("with parent ");
        if (parent instanceof URLClassLoader) {
            this.appendURLClassLoaderInfo(sb, (URLClassLoader)parent);
        } else {
            sb.append(parent.getClass().getName());
            this.appendParentClassLoaderInfo(sb, parent);
        }
    }

    @NotNull
    private LauncherVersion detectLauncherVersion() {
        LauncherVersionImpl launcherVersionImpl;
        block3: {
            try {
                launcherVersionImpl = new LauncherVersionImpl(ManifestUtil.getVersion());
                if (launcherVersionImpl != null) break block3;
            }
            catch (IOException e) {
                this.myLogger.internalError("Failed to detect launcher version", e);
                AppWrapperArguments.exit();
                if (null == null) {
                    AppWrapperArguments.$$$reportNull$$$0(22);
                }
                return null;
            }
            AppWrapperArguments.$$$reportNull$$$0(21);
        }
        return launcherVersionImpl;
    }

    @NotNull
    private StartKind detectStartKind() {
        StartKind startKind;
        String startKindOrdinal = System.getProperty("launcher.start.kind");
        try {
            startKind = StartKind.values()[Integer.parseInt(startKindOrdinal)];
        }
        catch (Exception ignore) {
            StartKind startKind2 = TransportConstants.DEFAULT_START_KIND;
            if (startKind2 == null) {
                AppWrapperArguments.$$$reportNull$$$0(24);
            }
            return startKind2;
        }
        if (startKind == null) {
            AppWrapperArguments.$$$reportNull$$$0(23);
        }
        return startKind;
    }

    private static void exit() {
        SystemUtil.exit((int)AppExitCode.EXIT.getValue());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/AppWrapperArguments";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "appClassLoader";
                break;
            }
            case 17: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classLoader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/AppWrapperArguments";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createConfiguringService";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createRunningService";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAppFiles";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getLauncherVersion";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getStartKind";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getApplicationArguments";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogLevel";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "detectLogLevel";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "detectAppFiles";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createAppClassLoader";
                break;
            }
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "detectLauncherVersion";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "detectStartKind";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createConfiguringService";
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createRunningService";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "logClassLoader";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "appendURLClassLoaderInfo";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "appendParentClassLoaderInfo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

