/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.ep;

import com.jetbrains.launcher.ep.EntryPointsProvider;
import com.jetbrains.launcher.log.Console;
import com.jetbrains.launcher.util.CmdUtil;
import com.jetbrains.launcher.util.SystemUtil;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.ServiceLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppWrapperBootstrap2 {
    public static void main2(@NotNull String[] args) {
        if (args == null) {
            AppWrapperBootstrap2.$$$reportNull$$$0(0);
        }
        if (args.length == 0) {
            Console.getErr().println("At least one argument expected: " + Arrays.toString(args));
            SystemUtil.exit((int)-1);
        }
        CmdUtil.setSystemProperties();
        Class entryPointClass = AppWrapperBootstrap2.findEntryPoint(args[0]);
        if (entryPointClass == null) {
            Console.getErr().println("Entry point is not found for key: " + args[0]);
            SystemUtil.exit((int)-1);
        }
        Method entryPointMainMethod = AppWrapperBootstrap2.getMainMethod(entryPointClass);
        String[] entryPointArgs = new String[args.length - 1];
        System.arraycopy(args, 1, entryPointArgs, 0, entryPointArgs.length);
        try {
            entryPointMainMethod.invoke(null, new Object[]{entryPointArgs});
        }
        catch (Exception e) {
            Console.getErr().println("Failed to invoke \"main\" method of the class \"" + entryPointClass.getName() + "\": " + e.getMessage());
            e.printStackTrace(Console.getErr());
            SystemUtil.exit((int)-1);
        }
    }

    @Nullable
    private static Class findEntryPoint(@NotNull String entryPointKey) {
        if (entryPointKey == null) {
            AppWrapperBootstrap2.$$$reportNull$$$0(1);
        }
        for (EntryPointsProvider provider : ServiceLoader.load(EntryPointsProvider.class)) {
            Class<?> entryPointClass = provider.getEntryPoints().get(entryPointKey);
            if (entryPointClass == null) continue;
            return entryPointClass;
        }
        return null;
    }

    @NotNull
    private static Method getMainMethod(@NotNull Class<?> clazz) {
        Method method;
        if (clazz == null) {
            AppWrapperBootstrap2.$$$reportNull$$$0(2);
        }
        try {
            method = clazz.getMethod("main", String[].class);
        }
        catch (NoSuchMethodException e) {
            Console.getErr().println("There is no \"main\" method in entry point class: " + clazz.getName());
            e.printStackTrace(Console.getErr());
            SystemUtil.exit((int)-1);
            if (null == null) {
                AppWrapperBootstrap2.$$$reportNull$$$0(4);
            }
            return null;
        }
        if (method == null) {
            AppWrapperBootstrap2.$$$reportNull$$$0(3);
        }
        return method;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "args";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entryPointKey";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clazz";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/ep/AppWrapperBootstrap2";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/ep/AppWrapperBootstrap2";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getMainMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "main2";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "findEntryPoint";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMainMethod";
                break;
            }
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

