/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.launcher.transport;

import com.jetbrains.launcher.JLThread;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.jetbrains.annotations.NotNull;

public class StateAwareSocketOutputStream {
    @NotNull
    private final InputStream myInputStream;
    @NotNull
    private final OutputStream myOutputStream;
    private volatile boolean myClosed;

    public StateAwareSocketOutputStream(@NotNull Socket socket, @NotNull String description) throws IOException {
        if (socket == null) {
            StateAwareSocketOutputStream.$$$reportNull$$$0(0);
        }
        if (description == null) {
            StateAwareSocketOutputStream.$$$reportNull$$$0(1);
        }
        this.myClosed = false;
        this.myInputStream = socket.getInputStream();
        this.myOutputStream = socket.getOutputStream();
        socket.setSoTimeout(10000);
        new JLThread("Socket Observer (" + description + ")"){
            {
                this.setDaemon(true);
            }

            public void run() {
                try {
                    while (!StateAwareSocketOutputStream.this.myClosed) {
                        if (StateAwareSocketOutputStream.this.myInputStream.read() == 0) continue;
                        StateAwareSocketOutputStream.this.myClosed = true;
                    }
                }
                catch (IOException e) {
                    StateAwareSocketOutputStream.this.myClosed = true;
                }
            }
        }.start();
    }

    @NotNull
    public OutputStream getOutputStream() {
        OutputStream outputStream = this.myOutputStream;
        if (outputStream == null) {
            StateAwareSocketOutputStream.$$$reportNull$$$0(2);
        }
        return outputStream;
    }

    public boolean isClosed() {
        return this.myClosed;
    }

    public void finish() {
        try {
            this.myOutputStream.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "socket";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "description";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/launcher/transport/StateAwareSocketOutputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/launcher/transport/StateAwareSocketOutputStream";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputStream";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

