/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.bundle.util;

import com.jetbrains.service.util.UrlUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.servlet.http.HttpServletRequest;
import org.jetbrains.annotations.NotNull;

public class BundleUtil {
    public static final String EXODUS_FILE_EXT = ".xd";

    public static String resolveServiceUrlForClient(HttpServletRequest request, String serviceBaseUrl) {
        try {
            return UrlUtil.constructUrl((String)request.getScheme(), (String)request.getServerName(), (int)request.getServerPort(), (String)new URL(serviceBaseUrl).getPath());
        }
        catch (MalformedURLException e) {
            return serviceBaseUrl;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkEntropy() {
        ExecutorService ex = Executors.newSingleThreadExecutor();
        Future<?> f = ex.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    SecureRandom.getInstance("SHA1PRNG").nextInt();
                }
                catch (NoSuchAlgorithmException e) {
                    e.printStackTrace();
                }
            }
        });
        try {
            f.get(10L, TimeUnit.SECONDS);
            boolean bl = true;
            return bl;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            boolean bl = false;
            return bl;
        }
        finally {
            ex.shutdown();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isExodusDatabase(@NotNull Path databaseDir) {
        if (!Files.isDirectory(databaseDir, new LinkOption[0])) return false;
        DirectoryStream.Filter<Path> filter = new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) throws IOException {
                return entry.toString().toLowerCase().endsWith(BundleUtil.EXODUS_FILE_EXT);
            }
        };
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(databaseDir, (DirectoryStream.Filter<? super Path>)filter);){
            boolean bl = stream.iterator().hasNext();
            return bl;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }
}

