/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.scripts.model;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jetbrains.charisma.maintenance.MaintenanceUtil;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.api.workflow.wrappers.IterableWrapperFactory;
import jetbrains.youtrack.api.workflow.wrappers.PropertyValueResolver;
import jetbrains.youtrack.api.workflow.wrappers.WorkflowSequence;
import jetbrains.youtrack.scripts.wrappers.MutableIterableWrapper;
import jetbrains.youtrack.scripts.wrappers.PersistentEntityWrapper;
import org.joda.time.DateTimeZone;

public abstract class AbstractScriptingContext
implements IterableWrapperFactory {
    private static long streamBufferSize = Long.getLong("jetbrains.youtrack.scripts.maxHttpResponseSize", 0x500000L);
    private Map<String, MutableIterableWrapper> createdIterableWrappers;
    private Set<File> createdTmpFiles;
    private Map<String, Object> objects = MapSequence.fromMap(new HashMap());

    public WorkflowSequence getMutableIterableWrapper(Entity self, PropertyValueResolver valueResolver, Iterable iter) {
        if (this.createdIterableWrappers == null) {
            this.createdIterableWrappers = MapSequence.fromMap(new HashMap());
        }
        String key = self.getType() + "[" + self.toIdString() + "]." + valueResolver.getPropertyName();
        MutableIterableWrapper wrapper = (MutableIterableWrapper)MapSequence.fromMap(this.createdIterableWrappers).get((Object)key);
        if (wrapper == null) {
            wrapper = new MutableIterableWrapper(self, valueResolver, iter);
            MapSequence.fromMap(this.createdIterableWrappers).put((Object)key, (Object)wrapper);
        }
        return wrapper;
    }

    public void applyIterableChanges() {
        for (MutableIterableWrapper iter : Sequence.fromIterable((Iterable)MapSequence.fromMap(this.createdIterableWrappers).values())) {
            iter.applyChanges();
        }
    }

    public Object getObject(String key) {
        return MapSequence.fromMap(this.objects).get((Object)key);
    }

    public void setObject(String key, Object object) {
        MapSequence.fromMap(this.objects).put((Object)key, object);
    }

    public long getMaxNetworkBufferSize() {
        return streamBufferSize;
    }

    public String getNetworkBufferExceededMessage() {
        return ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("AbstractScriptingContext.Response_size_limit_exceeded_{0}", new Object[]{MaintenanceUtil.formatFileSizeNoParenthesis((long)this.getMaxNetworkBufferSize())});
    }

    public File createTempFile(String namePrefix, String nameSuffix) throws IOException {
        File tempFile = File.createTempFile(namePrefix, nameSuffix);
        if (this.createdTmpFiles == null) {
            this.createdTmpFiles = SetSequence.fromSet(new HashSet());
        }
        SetSequence.fromSet(this.createdTmpFiles).addElement((Object)tempFile);
        return tempFile;
    }

    public void clearTempFiles() {
        SetSequence.fromSet(this.createdTmpFiles).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<File>(){

            public void visit(File it) {
                it.delete();
            }
        });
        SetSequence.fromSet(this.createdTmpFiles).clear();
    }

    public PersistentEntityWrapper getLoggedInUser() {
        return new PersistentEntityWrapper(this, ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get());
    }

    public DateTimeZone getTimeZone() {
        return ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).getGeneralProfile().getTimeZone();
    }
}

