/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.scripts.persistence;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.youtrack.scripts.persistence.StringUtils;

public class ScriptFullName {
    private static final Pattern NEW_NAME_PATTERN = Pattern.compile("(.+/)+(.+)");
    private static final Pattern OLD_NAME_PATTERN = Pattern.compile("(.+->)+(.+)");
    public final boolean converted;
    private String myPkg;
    private String myName;
    private int myVersion;

    public ScriptFullName(String pkg, String name) {
        this(pkg, name, true);
    }

    public ScriptFullName(String pkg, String name, boolean converted) {
        this.setPkg(pkg);
        this.setName(name);
        this.converted = converted;
    }

    public ScriptFullName(String fullName) {
        int delimenterLength;
        Matcher matcher;
        if (fullName.contains("->")) {
            matcher = OLD_NAME_PATTERN.matcher(fullName);
            delimenterLength = 2;
            this.converted = false;
        } else {
            matcher = NEW_NAME_PATTERN.matcher(fullName);
            delimenterLength = 1;
            this.converted = true;
        }
        if (!matcher.find()) {
            throw new IllegalArgumentException("Invalid full name format");
        }
        String p = matcher.group(1);
        this.setPkg(StringUtils.substring(p, 0, p.length() - delimenterLength));
        this.setName(matcher.group(2));
    }

    public ScriptFullName(Entity s) {
        this(s, true);
    }

    public ScriptFullName(Entity s, boolean converted) {
        this((String)PrimitiveAssociationSemantics.get((Entity)AssociationSemantics.getToOne((Entity)s, (String)"workflow"), (String)"name", String.class, null), (String)PrimitiveAssociationSemantics.get((Entity)s, (String)"name", String.class, null), converted);
    }

    public String toString() {
        if (this.converted) {
            return this.getPkg() + "/" + this.getName();
        }
        return this.getPkg() + "->" + this.getName();
    }

    public boolean equals(Object object) {
        if (object instanceof ScriptFullName) {
            ScriptFullName that = (ScriptFullName)object;
            return this.converted == that.converted && ScriptFullName.eq_cbiyua_a0a0b0a0b(this.getPkg(), that.getPkg()) && ScriptFullName.eq_cbiyua_a0a1a0a1(this.getName(), that.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String getPkg() {
        return this.myPkg;
    }

    private void setPkg(String value) {
        this.myPkg = value;
    }

    public String getName() {
        return this.myName;
    }

    private void setName(String value) {
        this.myName = value;
    }

    public int getVersion() {
        return this.myVersion;
    }

    public void setVersion(int value) {
        this.myVersion = value;
    }

    private static boolean eq_cbiyua_a0a1a0a1(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }

    private static boolean eq_cbiyua_a0a0b0a0b(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }
}

