/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.scripts.persistence;

import jetbrains.charisma.main.ConfigurationParameter;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.youtrack.scripts.persistence.EvaluationException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.joda.time.DateTimeUtils;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.WrapFactory;

public class ScriptingContextFactory
extends ContextFactory {
    private static final String WORKFLOW_TIMEOUT_PROPERTY_NAME = "youtrack.workflow.timeout";
    private static final long TIMEOUT_DEFAULT_VALUE = 180000L;
    protected static Log log = LogFactory.getLog(ScriptingContextFactory.class);
    private ClassShutter classShutter;
    private WrapFactory wrapFactory;
    private long timeout = 180000L;
    private String timeoutPropertyName;

    public ScriptingContextFactory() {
        this(WORKFLOW_TIMEOUT_PROPERTY_NAME);
    }

    public ScriptingContextFactory(String timeoutPropertyName) {
        this.timeoutPropertyName = timeoutPropertyName;
        this.retrieveTimeoutParam(180000L);
    }

    protected Context makeContext() {
        TimedContext context = new TimedContext();
        context.setClassShutter(this.classShutter);
        context.setWrapFactory(this.wrapFactory);
        context.setInstructionObserverThreshold(10000);
        return context;
    }

    protected boolean hasFeature(Context context, int featureIndex) {
        switch (featureIndex) {
            case 10: {
                return true;
            }
        }
        return super.hasFeature(context, featureIndex);
    }

    protected void observeInstructionCount(Context context, int insrtCount) {
        if (context instanceof TimedContext) {
            TimedContext timedContext = (TimedContext)context;
            if (timedContext.stopped) {
                this.reportScriptWasForciblyStopped();
            }
            if (DateTimeUtils.currentTimeMillis() - timedContext.getStart() > this.getTimeout()) {
                this.reportScriptTimedOut();
            }
        }
    }

    public boolean hasBeenStopped(Context context) {
        if (context instanceof TimedContext) {
            TimedContext timedContext = (TimedContext)context;
            if (timedContext.stopped || DateTimeUtils.currentTimeMillis() - timedContext.getStart() > this.getTimeout()) {
                return true;
            }
        }
        return false;
    }

    protected void reportScriptWasForciblyStopped() {
        String msg = ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ScriptingContextFactory.Execution_of_the_script_was_forcebly_stopped", new Object[0]);
        throw new Error(msg);
    }

    protected void reportScriptTimedOut() {
        String msg = ((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("WorkflowContextFactory.Execution_of_a_rule_took_more_then_{0}_milliseconds", new Object[]{this.getTimeout()});
        throw new Error(msg);
    }

    public ClassShutter getClassShutter() {
        return this.classShutter;
    }

    public void setClassShutter(ClassShutter classShutter) {
        this.classShutter = classShutter;
    }

    public WrapFactory getWrapFactory() {
        return this.wrapFactory;
    }

    public void setWrapFactory(WrapFactory wrapFactory) {
        this.wrapFactory = wrapFactory;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        this.retrieveTimeoutParam(timeout);
    }

    private void retrieveTimeoutParam(long defaultValue) {
        String parameter = ConfigurationParameter.getParameter((String)this.timeoutPropertyName, (String)("" + defaultValue));
        try {
            this.timeout = Long.parseLong(parameter);
        }
        catch (NumberFormatException e) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Failed to parse " + this.timeoutPropertyName + " parameter, using default"), (Throwable)e);
            }
            this.timeout = defaultValue;
        }
    }

    public class TimedContext
    extends Context {
        private long start;
        volatile boolean stopped;

        public TimedContext() {
            super((ContextFactory)ScriptingContextFactory.this);
            this.start = DateTimeUtils.currentTimeMillis();
        }

        public long getStart() {
            return this.start;
        }

        public void stop() {
            this.stopped = true;
        }

        public void imAlive() {
            this.start = DateTimeUtils.currentTimeMillis();
        }
    }

    public static class ScriptTimeOutException
    extends EvaluationException {
        public ScriptTimeOutException(String p0) {
            super(p0);
        }

        public ScriptTimeOutException(Throwable p0) {
            super(p0.getMessage());
        }
    }
}

