/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.scripts.persistence;

import org.jetbrains.annotations.NotNull;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.WrapFactory;

public class ScriptingWrapFactory
extends WrapFactory {
    private static final String PROHIBIT_ACCESS_MESSAGE = "Access to Java class %s is prohibited.";
    private ClassShutter classShutter;

    public Scriptable wrapAsJavaObject(Context ctx, Scriptable scope, Object javaObject, Class<?> staticType) {
        if (javaObject != null) {
            this.checkClass(javaObject.getClass());
        }
        if (staticType != null) {
            this.checkClass(staticType);
        }
        return super.wrapAsJavaObject(ctx, scope, javaObject, staticType);
    }

    private void checkClass(@NotNull Class<?> clazz) {
        String className = clazz.getName();
        if (!this.classShutter.visibleToScripts(className)) {
            throw Context.reportRuntimeError((String)String.format(PROHIBIT_ACCESS_MESSAGE, className));
        }
    }

    public void setClassShutter(ClassShutter classShutter) {
        this.classShutter = classShutter;
    }
}

