/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.scripts.sandbox;

import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import org.apache.log4j.MDC;
import org.apache.logging.log4j.LogManager;
import org.jetbrains.annotations.NotNull;

public class Logger {
    public static String MDC_ROOT_SCRIPT_NAME_KEY = "script_name";
    private EntityId scriptId;
    private Class logClass;
    private String name;

    public Logger(String name, @NotNull Entity script2, Class logClass) {
        this.name = name;
        this.scriptId = script2.getId();
        this.logClass = logClass;
    }

    public void trace(final String s) {
        final org.apache.logging.log4j.Logger log = this.getLog();
        if (log.isTraceEnabled()) {
            this.executeInMdcContext(new Runnable(){

                @Override
                public void run() {
                    log.trace(s);
                }
            });
        }
    }

    public void debug(final String s) {
        final org.apache.logging.log4j.Logger log = this.getLog();
        if (log.isDebugEnabled()) {
            this.executeInMdcContext(new Runnable(){

                @Override
                public void run() {
                    log.debug(s);
                }
            });
        }
    }

    public void warn(final String s) {
        final org.apache.logging.log4j.Logger log = this.getLog();
        if (log.isWarnEnabled()) {
            this.executeInMdcContext(new Runnable(){

                @Override
                public void run() {
                    log.warn(s);
                }
            });
        }
    }

    public void info(final String s) {
        final org.apache.logging.log4j.Logger log = this.getLog();
        if (log.isInfoEnabled()) {
            this.executeInMdcContext(new Runnable(){

                @Override
                public void run() {
                    log.info(s);
                }
            });
        }
    }

    public void error(final String s) {
        final org.apache.logging.log4j.Logger log = this.getLog();
        if (log.isErrorEnabled()) {
            this.executeInMdcContext(new Runnable(){

                @Override
                public void run() {
                    log.error(s);
                }
            });
        }
    }

    public void fatal(final String s) {
        final org.apache.logging.log4j.Logger log = this.getLog();
        if (log.isFatalEnabled()) {
            this.executeInMdcContext(new Runnable(){

                @Override
                public void run() {
                    log.fatal(s);
                }
            });
        }
    }

    public void log(String s) {
        this.info(s);
    }

    private org.apache.logging.log4j.Logger getLog() {
        return LogManager.getLogger((Class)this.logClass);
    }

    private void executeInMdcContext(Runnable action) {
        boolean doSetContext;
        boolean bl = doSetContext = !this.name.equals(MDC.get((String)MDC_ROOT_SCRIPT_NAME_KEY));
        if (doSetContext) {
            MDC.put((String)MDC_ROOT_SCRIPT_NAME_KEY, (String)this.name);
        }
        try {
            action.run();
        }
        finally {
            if (doSetContext) {
                MDC.remove((String)MDC_ROOT_SCRIPT_NAME_KEY);
            }
        }
    }
}

