/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.scripts.sandbox;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import jetbrains.charisma.date.DateTimeFormattersImpl;
import jetbrains.charisma.persistent.BeansKt;
import jetbrains.charisma.plugins.GeneralUserProfile;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u00042\b\u0010\r\u001a\u0004\u0018\u00010\u0004H\u0007J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0004H\u0007J\u001a\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0004H\u0007J\u001a\u0010\u0016\u001a\n \u0018*\u0004\u0018\u00010\u00170\u00172\b\u0010\r\u001a\u0004\u0018\u00010\u0004H\u0002J/\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u00042\u000e\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u001c2\b\u0010\r\u001a\u0004\u0018\u00010\u0004H\u0007\u00a2\u0006\u0002\u0010\u001dR\u0016\u0010\u0003\u001a\u0004\u0018\u00010\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\u0006\u00a8\u0006\u001e"}, d2={"Ljetbrains/youtrack/scripts/sandbox/Utils;", "", "()V", "defaultDateFormat", "", "getDefaultDateFormat", "()Ljava/lang/String;", "defaultTimeZoneId", "getDefaultTimeZoneId", "formatTimestamp", "unixTimestamp", "", "format", "timeZoneId", "getLevenshteinDistance", "", "s1", "s2", "readString", "inputStream", "Ljava/io/InputStream;", "encoding", "timeZone", "Ljava/util/TimeZone;", "kotlin.jvm.PlatformType", "toUnixTimestamp", "timestamp", "formats", "", "(Ljava/lang/String;[Ljava/lang/String;Ljava/lang/String;)J", "youtrack-scripts"})
public final class Utils {
    public static final Utils INSTANCE;

    @JvmStatic
    public static final long toUnixTimestamp(@NotNull String timestamp, @Nullable String[] formats, @Nullable String timeZoneId) {
        Intrinsics.checkParameterIsNotNull((Object)timestamp, (String)"timestamp");
        String[] stringArray = formats;
        if (formats == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = INSTANCE.getDefaultDateFormat();
        }
        for (String format : stringArray) {
            try {
                SimpleDateFormat simpleDateFormat;
                SimpleDateFormat $receiver = simpleDateFormat = new SimpleDateFormat(format);
                boolean bl = false;
                $receiver.setTimeZone(INSTANCE.timeZone(timeZoneId));
                Date date = simpleDateFormat.parse(timestamp);
                Intrinsics.checkExpressionValueIsNotNull((Object)date, (String)"SimpleDateFormat(format)\u2026       }.parse(timestamp)");
                return date.getTime();
            }
            catch (ParseException parseException) {
            }
        }
        if (formats == null) {
            throw (Throwable)new RuntimeException("Timestamp " + timestamp + " does not match default date format (" + INSTANCE.getDefaultDateFormat() + ')');
        }
        throw (Throwable)new RuntimeException("Timestamp " + timestamp + " matches neither of the formats provided (" + ArraysKt.joinToString$default((Object[])formats, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null) + ')');
    }

    @JvmStatic
    @NotNull
    public static final String formatTimestamp(long unixTimestamp, @Nullable String format, @Nullable String timeZoneId) {
        SimpleDateFormat simpleDateFormat;
        String string = format;
        if (string == null) {
            string = INSTANCE.getDefaultDateFormat();
        }
        SimpleDateFormat $receiver = simpleDateFormat = new SimpleDateFormat(string);
        boolean bl = false;
        $receiver.setTimeZone(INSTANCE.timeZone(timeZoneId));
        String string2 = simpleDateFormat.format(unixTimestamp);
        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"SimpleDateFormat(format \u2026  }.format(unixTimestamp)");
        return string2;
    }

    private final TimeZone timeZone(String timeZoneId) {
        String string = timeZoneId;
        if (string == null) {
            string = this.getDefaultTimeZoneId();
        }
        return TimeZone.getTimeZone(string);
    }

    @JvmStatic
    @NotNull
    public static final String readString(@NotNull InputStream inputStream, @NotNull String encoding) throws IOException {
        Intrinsics.checkParameterIsNotNull((Object)inputStream, (String)"inputStream");
        Intrinsics.checkParameterIsNotNull((Object)encoding, (String)"encoding");
        String string = IOUtils.toString((InputStream)inputStream, (String)encoding);
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"IOUtils.toString(inputStream, encoding)");
        return string;
    }

    @JvmStatic
    @NotNull
    public static /* synthetic */ String readString$default(InputStream inputStream, String string, int n, Object object) throws IOException {
        if ((n & 2) != 0) {
            string = "UTF-8";
        }
        return Utils.readString(inputStream, string);
    }

    @JvmStatic
    public static final int getLevenshteinDistance(@NotNull String s1, @NotNull String s2) {
        Intrinsics.checkParameterIsNotNull((Object)s1, (String)"s1");
        Intrinsics.checkParameterIsNotNull((Object)s2, (String)"s2");
        return StringUtils.getLevenshteinDistance((String)s1, (String)s2);
    }

    private final String getDefaultDateFormat() {
        DateTimeFormattersImpl dateTimeFormattersImpl = jetbrains.charisma.date.BeansKt.getDateFormatter();
        GeneralUserProfile generalUserProfile = BeansKt.getCurrentUser().getGeneralProfile();
        Intrinsics.checkExpressionValueIsNotNull((Object)generalUserProfile, (String)"currentUser.generalProfile");
        String string = generalUserProfile.getDateFieldFormat();
        if (string == null) {
            String string2 = BeansKt.getXdApplicationMetaData().getDefaultDateFieldFormat();
            DateTimeFormattersImpl dateTimeFormattersImpl2 = dateTimeFormattersImpl;
            String string3 = string2;
            if (string3 == null) {
                string3 = "";
            }
            String string4 = string3;
            dateTimeFormattersImpl = dateTimeFormattersImpl2;
            string = string4;
        }
        return dateTimeFormattersImpl.getFormatDescriptorById(string).getDateTimePattern();
    }

    private final String getDefaultTimeZoneId() {
        GeneralUserProfile generalUserProfile = BeansKt.getCurrentUser().getGeneralProfile();
        Intrinsics.checkExpressionValueIsNotNull((Object)generalUserProfile, (String)"currentUser.generalProfile");
        TimeZone timeZone = generalUserProfile.getTimeZone().toTimeZone();
        Intrinsics.checkExpressionValueIsNotNull((Object)timeZone, (String)"currentUser.generalProfile.timeZone.toTimeZone()");
        String string = timeZone.getID();
        if (string == null) {
            string = BeansKt.getXdApplicationMetaData().getDefaultTimeZoneId();
        }
        return string;
    }

    private Utils() {
    }

    static {
        Utils utils;
        INSTANCE = utils = new Utils();
    }
}

