/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.scripts.wrappers;

import java.util.Iterator;
import jetbrains.youtrack.api.workflow.wrappers.WorkflowSequence;
import org.apache.commons.lang.ArrayUtils;

public class ArrayWrapper
implements WorkflowSequence {
    private Object[] array;

    public ArrayWrapper(Object[] array) {
        this.array = array;
    }

    public Object first() {
        return this.isNotEmpty() ? this.array[0] : null;
    }

    public Object last() {
        return this.isNotEmpty() ? this.array[this.array.length - 1] : null;
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public int size() {
        return this.array == null ? 0 : this.array.length;
    }

    public Object get(int index) {
        if (this.isEmpty()) {
            return null;
        }
        if (index < 0 || this.array.length <= index) {
            return null;
        }
        return this.array[index];
    }

    public boolean contains(Object value) {
        return ArrayUtils.contains((Object[])this.array, (Object)value);
    }

    public Iterator<Object> iterator() {
        return new Iterator(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return ArrayWrapper.this.array != null && this.index < ArrayWrapper.this.array.length;
            }

            public Object next() {
                Object element = ArrayWrapper.this.array[this.index];
                ++this.index;
                return element;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public static boolean isArray(Object arrayCandidate) {
        return arrayCandidate != null && arrayCandidate.getClass().isArray();
    }
}

