/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.scripts.wrappers;

import java.util.Iterator;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.youtrack.api.workflow.wrappers.ValueResolver;
import jetbrains.youtrack.api.workflow.wrappers.WorkflowSequence;

public class ImmutableIterableWrapper
implements WorkflowSequence {
    protected Iterable entityIterable;
    protected ValueResolver valueResolver;

    public ImmutableIterableWrapper(ValueResolver valueResolver, Iterable entityIterable) {
        this.valueResolver = valueResolver;
        this.entityIterable = entityIterable;
    }

    public Iterable getIterable() {
        return this.entityIterable;
    }

    public Object first() {
        return this.get(0);
    }

    public Object last() {
        Entity last = QueryOperations.getLast((Iterable)this.getIterable());
        return this.valueResolver.wrapEntity(last);
    }

    public boolean isEmpty() {
        return !this.isNotEmpty();
    }

    public boolean isNotEmpty() {
        return this.iterator().hasNext();
    }

    public int size() {
        return Sequence.fromIterable((Iterable)this.getIterable()).count();
    }

    public Object get(int index) {
        Iterator iterator = this.getIterable().iterator();
        Entity entity = null;
        for (int i = 0; i <= index; ++i) {
            if (!iterator.hasNext()) {
                return null;
            }
            entity = (Entity)iterator.next();
        }
        return this.valueResolver.wrapEntity(entity);
    }

    public boolean contains(Object value) {
        value = this.valueResolver.unwrap(value);
        Iterable values = this.getIterable();
        return Sequence.fromIterable((Iterable)values).contains(value);
    }

    public Iterator iterator() {
        final Iterator entityIterator = this.getIterable().iterator();
        return new Iterator(){
            private Entity current;

            @Override
            public boolean hasNext() {
                return entityIterator.hasNext();
            }

            public Object next() {
                this.current = (Entity)entityIterator.next();
                return ImmutableIterableWrapper.this.valueResolver.wrapEntity(this.current);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

