/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.scripts.wrappers;

import com.jetbrains.teamsys.dnq.database.EntityOperations;
import com.jetbrains.teamsys.dnq.database.TransientStoreUtil;
import jetbrains.exodus.database.TransientEntity;
import jetbrains.exodus.database.exceptions.EntityRemovedException;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.api.workflow.wrappers.ImmutableWrapperUtil;
import jetbrains.youtrack.api.workflow.wrappers.IterableWrapperFactory;
import jetbrains.youtrack.api.workflow.wrappers.PropertyValueResolver;
import jetbrains.youtrack.api.workflow.wrappers.ValueResolver;
import jetbrains.youtrack.api.workflow.wrappers.WorkflowSequence;
import jetbrains.youtrack.scripts.wrappers.ImmutableIterableWrapper;
import jetbrains.youtrack.scripts.wrappers.IssueWrapper;
import jetbrains.youtrack.scripts.wrappers.PersistentEntityWrapper;
import jetbrains.youtrack.scripts.wrappers.RemovedEntityWrapper;
import org.jetbrains.annotations.Nullable;
import org.mozilla.javascript.NativeObject;

public class ValueResolverImpl
implements ValueResolver {
    public static IterableWrapperFactory IMMUTABLE_WRAPPER_FACTORY = new IterableWrapperFactory(){

        public WorkflowSequence getMutableIterableWrapper(Entity self, PropertyValueResolver valueResolver, Iterable iter) {
            return ((ImmutableWrapperUtil)ServiceLocator.getBean((String)"immutableWrapperUtil")).wrapImmutable((ValueResolver)valueResolver, iter);
        }
    };
    protected IterableWrapperFactory iterableWrapperFactory;

    public ValueResolverImpl(IterableWrapperFactory iterableWrapperFactory) {
        this.iterableWrapperFactory = iterableWrapperFactory != null ? iterableWrapperFactory : IMMUTABLE_WRAPPER_FACTORY;
    }

    public Object unwrap(Object wrapper) {
        if (wrapper == null) {
            return null;
        }
        if (wrapper instanceof PersistentEntityWrapper) {
            return ((PersistentEntityWrapper)wrapper).getEntity();
        }
        if (wrapper instanceof ImmutableIterableWrapper) {
            return ((ImmutableIterableWrapper)wrapper).getIterable();
        }
        if (wrapper instanceof NativeObject) {
            Object wrapped = ((NativeObject)wrapper).get((Object)"_wrapped");
            if (wrapped instanceof PersistentEntityWrapper) {
                return ((PersistentEntityWrapper)wrapped).getEntity();
            }
            if (wrapped instanceof ImmutableIterableWrapper) {
                return ((ImmutableIterableWrapper)wrapped).getIterable();
            }
        }
        return wrapper;
    }

    public Object wrap(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Entity) {
            return this.wrapEntity((Entity)value);
        }
        if (value instanceof Iterable && !(value instanceof ImmutableIterableWrapper)) {
            return this.wrapImmutableIterable((Iterable)value);
        }
        return value;
    }

    public PersistentEntityWrapper wrapEntity(@Nullable Entity value) {
        if (EntityOperations.equals((Entity)value, null)) {
            return null;
        }
        if (value instanceof TransientEntity && EntityOperations.isRemoved((Entity)value)) {
            return new RemovedEntityWrapper(this.iterableWrapperFactory, (TransientEntity)value);
        }
        try {
            value = TransientStoreUtil.reattach((TransientEntity)((TransientEntity)value));
        }
        catch (EntityRemovedException e) {
            return null;
        }
        if (ValueResolverImpl.eq_xislgb_a0d0c(value.getType(), "Issue")) {
            return new IssueWrapper(this.iterableWrapperFactory, DnqUtils.cast((Object)value, (String)"Issue"));
        }
        return new PersistentEntityWrapper(this.iterableWrapperFactory, value);
    }

    protected WorkflowSequence wrapImmutableIterable(Iterable iterable) {
        return ((ImmutableWrapperUtil)ServiceLocator.getBean((String)"immutableWrapperUtil")).wrapImmutable((ValueResolver)this, iterable);
    }

    private static boolean eq_xislgb_a0d0c(Object a, Object b) {
        return a != null ? a.equals(b) : a == b;
    }
}

