/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.scripts.ydata;

import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import freemarker.cache.FileTemplateLoader;
import freemarker.cache.TemplateLoader;
import freemarker.template.Configuration;
import freemarker.template.SimpleHash;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import jetbrains.charisma.customfields.accessControl.AccessControlDomain;
import jetbrains.charisma.persistence.customfields.meta.MethodType;
import jetbrains.charisma.persistence.customfields.meta.YBundle;
import jetbrains.charisma.persistence.customfields.meta.YClazz;
import jetbrains.charisma.persistence.customfields.meta.YField;
import jetbrains.charisma.persistence.customfields.meta.YGroup;
import jetbrains.charisma.persistence.customfields.meta.YMethod;
import jetbrains.charisma.persistence.customfields.meta.YProject;
import jetbrains.charisma.persistence.customfields.meta.YProjects;
import jetbrains.charisma.persistence.customfields.meta.YType;
import jetbrains.charisma.persistence.security.UserGroupImpl;
import jetbrains.charisma.persistence.user.CurrentUserProvider;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.IListSequence;
import jetbrains.mps.internal.collections.runtime.IMapSequence;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.ISequence;
import jetbrains.mps.internal.collections.runtime.ISortedMapSequence;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.IWhereFilter;
import jetbrains.mps.internal.collections.runtime.ListSequence;
import jetbrains.mps.internal.collections.runtime.MapSequence;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internal.collections.runtime.SetSequence;
import jetbrains.mps.internal.collections.runtime.SortedMapSequence;
import jetbrains.mps.webr.rpc.rest.provider.exception.ForbiddenException;
import jetbrains.mps.webr.rpc.rest.provider.exception.RESTNotFoundException;
import jetbrains.mps.webr.runtime.freemarker.ClasspathTemplateLoader;
import jetbrains.mps.webr.runtime.util.ApplicationManager;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.core.persistent.ProjectImpl;
import jetbrains.youtrack.core.security.Operation;
import jetbrains.youtrack.scripts.ydata.ICustomFieldAccessControl;

public class YDataLoader {
    public YProjects getYProjects(String projectId) {
        YProjects yprojects = this.getYProjects(projectId, AccessControlDomain.WORKFLOW);
        ISequence ytypes = ListSequence.fromList((List)yprojects.getTypes()).where((_FunctionTypes._return_P1_E0)new IWhereFilter<YType>(){

            public boolean accept(YType it) {
                return !(it instanceof YClazz) || !((YClazz)it).isIgnoreInXml();
            }
        }).select((_FunctionTypes._return_P1_E0)new ISelector<YType, YType>(){

            public YType select(YType it) {
                return it instanceof YClazz ? ((YClazz)it).xmlSerializableCopy() : it;
            }
        });
        return new YProjects(yprojects.getBundles(), (List)Sequence.fromIterable((Iterable)ytypes).toListSequence(), yprojects.getProjects(), yprojects.getProjectDefaults(), yprojects.getGroups());
    }

    public YProjects getYProjects(String projectId, AccessControlDomain acd) {
        Entity project2 = ProjectImpl.findProject((String)projectId);
        if (projectId != null && EntityOperations.equals((Entity)project2, null)) {
            throw new RESTNotFoundException("Project not found.");
        }
        IListSequence projects = ListSequence.fromList(new ArrayList());
        ISortedMapSequence bundles = SortedMapSequence.fromMap(new TreeMap());
        if (!EntityOperations.equals((Entity)project2, null)) {
            if (!((ProjectImpl)DnqUtils.getPersistentClassInstance((Entity)project2, (String)"Project")).isAccessible(Operation.UPDATE, ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), project2)) {
                throw new ForbiddenException("No rights to access project [" + projectId + "]");
            }
            ListSequence.fromList((List)projects).addElement((Object)((ICustomFieldAccessControl)ServiceLocator.getBean((String)"customFieldsAccessControl")).loadProject(project2, (Map<String, YBundle>)bundles));
        } else {
            Sequence.fromIterable((Iterable)QueryOperations.queryGetAll((String)"Project")).where((_FunctionTypes._return_P1_E0)new IWhereFilter<Entity>(){

                public boolean accept(Entity it) {
                    return ((ProjectImpl)DnqUtils.getPersistentClassInstance((Entity)it, (String)"Project")).isAccessible(Operation.UPDATE, ((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), it);
                }
            }).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<Entity>((List)projects, (Map)bundles){
                final /* synthetic */ List val$projects;
                final /* synthetic */ Map val$bundles;
                {
                    this.val$projects = list;
                    this.val$bundles = map;
                }

                public void visit(Entity it) {
                    ListSequence.fromList((List)this.val$projects).addElement((Object)((ICustomFieldAccessControl)ServiceLocator.getBean((String)"customFieldsAccessControl")).loadProject(it, this.val$bundles));
                }
            });
        }
        YProject customFields = ((ICustomFieldAccessControl)ServiceLocator.getBean((String)"customFieldsAccessControl")).loadProjectDefaults((Map<String, YBundle>)bundles);
        IListSequence groups = Sequence.fromIterable((Iterable)((UserImpl)DnqUtils.getPersistentClassInstance((Entity)((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get(), (String)"User")).getVisibleUserGroupsSorted(((CurrentUserProvider)ServiceLocator.getBean((String)"currentUser")).get())).select((_FunctionTypes._return_P1_E0)new ISelector<Entity, YGroup>(){

            public YGroup select(Entity it) {
                return new YGroup((String)PrimitiveAssociationSemantics.get((Entity)it, (String)"name", String.class, (Object)UserGroupImpl.getAllUsersGroupNameInLocale()));
            }
        }).toListSequence();
        return new YProjects((List)Sequence.fromIterable((Iterable)MapSequence.fromMap((Map)bundles).values()).toListSequence(), ((ICustomFieldAccessControl)ServiceLocator.getBean((String)"customFieldsAccessControl")).getYTypes(acd, true), (List)projects, customFields, (List)groups);
    }

    public String getWorkflowJsStubs() throws IOException, TemplateException {
        return this.getJsStubs(AccessControlDomain.WORKFLOW);
    }

    public String getImportJsStubs() throws IOException, TemplateException {
        return this.getJsStubs(AccessControlDomain.IMPORT);
    }

    private String getJsStubs(AccessControlDomain acd) throws IOException, TemplateException {
        Configuration configuration = new Configuration();
        configuration.setLocalizedLookup(false);
        if (ApplicationManager.isDebugMode() && YDataLoader.isNotEmpty_gy9qyz_a0a2a4(this.getTemplatesSourceRoot())) {
            configuration.setTemplateLoader((TemplateLoader)new FileTemplateLoader(new File(this.getTemplatesSourceRoot() + "/youtrack-workflow/src/main/resources/jetbrains/youtrack/workflow/jsTemplates")));
        } else {
            configuration.setTemplateLoader((TemplateLoader)new ClasspathTemplateLoader(ICustomFieldAccessControl.class.getClassLoader()){

                protected URL getURL(String name) {
                    return super.getURL("jetbrains/youtrack/workflow/jsTemplates/" + name);
                }
            });
        }
        Template t = configuration.getTemplate("wf_entities_module.jst");
        StringWriter writer = new StringWriter();
        YProjects yProjects = this.getYProjects(null, acd);
        IMapSequence data = MapSequence.fromMap(new HashMap());
        MapSequence.fromMap((Map)data).put((Object)"ytypes", (Object)yProjects.getTypes());
        MapSequence.fromMap((Map)data).put((Object)"customFields", (Object)yProjects.getProjectDefaults().getFields());
        MapSequence.fromMap((Map)data).put((Object)"linkTypes", (Object)yProjects.getProjectDefaults().getLinks());
        MapSequence.fromMap((Map)data).put((Object)"YClass", YClazz.class);
        MapSequence.fromMap((Map)data).put((Object)"YField", YField.class);
        MapSequence.fromMap((Map)data).put((Object)"YMethod", YMethod.class);
        MapSequence.fromMap((Map)data).put((Object)"ignoredMethods", (Object)new IgnoredMethods());
        t.process((Object)new SimpleHash((Map)data, t.getConfiguration().getObjectWrapper()), (Writer)writer);
        return writer.getBuffer().toString();
    }

    private String getTemplatesSourceRoot() {
        return System.getProperty("jetbrains.youtrack.scriptSourceRoot");
    }

    public static boolean isNotEmpty_gy9qyz_a0a2a4(String str) {
        return str != null && str.length() > 0;
    }

    public static class IgnoredMethods {
        private Set<String> methods = SetSequence.fromSet(new HashSet());

        public boolean put(YClazz clazz, YMethod yMethod2) {
            if (yMethod2 == null) {
                return false;
            }
            SetSequence.fromSet(this.methods).addElement((Object)this.name(clazz, yMethod2));
            return true;
        }

        public boolean isIgnoredThenRemove(YClazz yClazz, YMethod yMethod2) {
            String name = this.name(yClazz, yMethod2);
            if (SetSequence.fromSet(this.methods).contains((Object)name)) {
                SetSequence.fromSet(this.methods).removeElement((Object)name);
                return true;
            }
            return false;
        }

        private String name(YClazz clazz, YMethod yMethod2) {
            return clazz.getName() + (yMethod2.getMethodType() == MethodType.INSTANCE ? "#" : ".") + yMethod2.getName();
        }
    }
}

