/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.gaprest;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.ForbiddenException;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import jetbrains.charisma.persistent.Issue;
import jetbrains.charisma.persistent.Project;
import jetbrains.charisma.plugin.PluginResource;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.gap.resource.components.impl.entity.RootEntitySequenceResource;
import jetbrains.gap.resource.components.impl.entity.RootSequenceElementResource;
import jetbrains.gap.resource.pojo.FieldException;
import jetbrains.youtrack.gaprest.db.DatabaseEntity;
import jetbrains.youtrack.gaprest.db.XodusDatabase;
import jetbrains.youtrack.gaprest.db.util.HelpersKt;
import jetbrains.youtrack.integration.gaprest.VcsChange;
import jetbrains.youtrack.integration.persistence.XdVcsChange;
import jetbrains.youtrack.integration.persistence.XdVcsChangeKt;
import jetbrains.youtrack.integration.persistence.XdVcsChangeProcessor;
import jetbrains.youtrack.integration.service.VcsMethodsKt;
import jetbrains.youtrack.integration.service.VcsService;
import jetbrains.youtrack.integration.service.VcsServiceFactoryImpl;
import jetbrains.youtrack.integration.vcs.BeansKt;
import jetbrains.youtrack.integration.vcs.CommonChangeDTO;
import jetbrains.youtrack.persistent.XdIssue;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.sequences.Sequence;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0011\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0002H\u0096\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000b"}, d2={"Ljetbrains/youtrack/integration/gaprest/IssueVcsChangesPluginResource;", "Ljetbrains/charisma/plugin/PluginResource;", "Ljetbrains/charisma/persistent/Issue;", "()V", "path", "", "getPath", "()Ljava/lang/String;", "invoke", "", "item", "youtrack-vcs-ci-integration"})
public final class IssueVcsChangesPluginResource
implements PluginResource<Issue> {
    @NotNull
    private final String path = "vcsChanges";

    @NotNull
    public String getPath() {
        return this.path;
    }

    @NotNull
    public Object invoke(@NotNull Issue item) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        return new RootEntitySequenceResource<VcsChange>(item){
            @NotNull
            private final KClass<? extends VcsChange> baseType;
            final /* synthetic */ Issue $item;

            @NotNull
            public KClass<? extends VcsChange> getBaseType() {
                return this.baseType;
            }

            @NotNull
            public VcsChange doApply(@NotNull VcsChange entity) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)entity), (String)"entity");
                if (entity.getState() == 2) {
                    XdVcsChange xdVcsChange = (XdVcsChange)XdExtensionsKt.toXd((Entity)((Entity)entity.getEntity()));
                    xdVcsChange.setState((byte)2);
                    return (VcsChange)HelpersKt.find$default((DatabaseEntity)((DatabaseEntity)entity), null, (int)1, null);
                }
                if (entity.getState() == 0) {
                    XdVcsChange xdVcsChange = (XdVcsChange)XdExtensionsKt.toXd((Entity)((Entity)entity.getEntity()));
                    if (xdVcsChange.getState() == 2) {
                        xdVcsChange.setState((byte)0);
                        return (VcsChange)HelpersKt.find$default((DatabaseEntity)((DatabaseEntity)entity), null, (int)1, null);
                    }
                    throw (Throwable)new BadRequestException(jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("IssueVcsChangesResource.This_change_has_never_been_autoattached_to_the_issue", new Object[0]));
                }
                if (entity.getState() == 1) {
                    this.checkAlreadyExists(entity);
                    Issue issue = entity.getIssue();
                    XdIssue anotherXdIssue = issue != null && (issue = (Issue)HelpersKt.find$default((DatabaseEntity)((DatabaseEntity)issue), null, (int)1, null)) != null ? issue.getXdEntity() : null;
                    XdIssue issue2 = this.$item.getXdEntity();
                    if (anotherXdIssue != null && Intrinsics.areEqual((Object)anotherXdIssue, (Object)issue2) ^ true) {
                        XdVcsChange xdVcsChange;
                        block7: {
                            Iterable<XdVcsChange> $receiver$iv = XdVcsChangeKt.getVcsChanges(anotherXdIssue);
                            Iterator<XdVcsChange> iterator = $receiver$iv.iterator();
                            while (iterator.hasNext()) {
                                XdVcsChange element$iv;
                                XdVcsChange it = element$iv = iterator.next();
                                boolean bl = false;
                                if (!Intrinsics.areEqual((Object)it.getVersion(), (Object)entity.getVersion())) continue;
                                xdVcsChange = element$iv;
                                break block7;
                            }
                            xdVcsChange = null;
                        }
                        XdVcsChange existing = xdVcsChange;
                        if (existing == null) {
                            throw (Throwable)new BadRequestException(jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("IssueVcsChangesResource.Issue_{0}_does_not_have_change_{1}_attached", new Object[]{anotherXdIssue.getIdReadable(), entity.getVersion()}));
                        }
                        existing.setState((byte)2);
                        VcsService<?> service = BeansKt.getServiceFactory().find(existing.getProcessor().getServer());
                        CommonChangeDTO dto = service.toDto(existing);
                        VcsMethodsKt.prepareToAttach(dto, issue2);
                        Iterable<Entity> iterable = dto.processors;
                        Intrinsics.checkExpressionValueIsNotNull(iterable, (String)"dto.processors");
                        Object object = CollectionsKt.first(iterable);
                        Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"dto.processors.first()");
                        XdVcsChange newChange = service.addChange((XdVcsChangeProcessor)XdExtensionsKt.toXd((Entity)((Entity)object)), dto, issue2);
                        XdQueryKt.addAll(newChange.getProcessors(), (XdQuery)((XdQuery)existing.getProcessors()));
                        XdEntity $receiver$iv = newChange;
                        boolean $i$f$kt = false;
                        Entity $receiver$iv$iv = $receiver$iv.getEntity();
                        return (VcsChange)XodusDatabase.INSTANCE.wrap(VcsChange.class, $receiver$iv$iv, new Object[0]);
                    }
                    return this.doCreate(entity);
                }
                throw (Throwable)new FieldException("state", VcsChange.class, "incorrect-value", null, 8, null);
            }

            @NotNull
            public VcsChange doCreate(@NotNull VcsChange entity) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)entity), (String)"entity");
                this.checkAlreadyExists(entity);
                CommonChangeDTO commonChangeDTO = VcsMethodsKt.findChange(this.$item.getXdEntity(), entity.getVersion());
                if (commonChangeDTO == null) {
                    throw (Throwable)new NotFoundException(jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("IssueVcsChangesResource.Could_not_find_change_with_version_{0}", new Object[]{entity.getVersion()}));
                }
                CommonChangeDTO dto = commonChangeDTO;
                VcsServiceFactoryImpl vcsServiceFactoryImpl = BeansKt.getServiceFactory();
                Iterable<Entity> iterable = dto.processors;
                Intrinsics.checkExpressionValueIsNotNull(iterable, (String)"dto.processors");
                Object object = CollectionsKt.first(iterable);
                Intrinsics.checkExpressionValueIsNotNull((Object)object, (String)"dto.processors.first()");
                VcsService<?> service = vcsServiceFactoryImpl.find(((XdVcsChangeProcessor)XdExtensionsKt.toXd((Entity)((Entity)object))).getServer());
                Iterable<Entity> iterable2 = dto.processors;
                Intrinsics.checkExpressionValueIsNotNull(iterable2, (String)"dto.processors");
                Object object2 = CollectionsKt.first(iterable2);
                Intrinsics.checkExpressionValueIsNotNull((Object)object2, (String)"dto.processors.first()");
                XdEntity $receiver$iv = service.addChange((XdVcsChangeProcessor)XdExtensionsKt.toXd((Entity)((Entity)object2)), dto, this.$item.getXdEntity());
                boolean $i$f$kt = false;
                Entity $receiver$iv$iv = $receiver$iv.getEntity();
                return (VcsChange)XodusDatabase.INSTANCE.wrap(VcsChange.class, $receiver$iv$iv, new Object[0]);
            }

            private final void checkAlreadyExists(VcsChange entity) {
                XdVcsChange xdVcsChange;
                block2: {
                    Iterable<XdVcsChange> $receiver$iv = XdVcsChangeKt.getVcsChanges(this.$item.getXdEntity());
                    Iterator<XdVcsChange> iterator = $receiver$iv.iterator();
                    while (iterator.hasNext()) {
                        XdVcsChange element$iv;
                        XdVcsChange it = element$iv = iterator.next();
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getVersion(), (Object)entity.getVersion())) continue;
                        xdVcsChange = element$iv;
                        break block2;
                    }
                    xdVcsChange = null;
                }
                XdVcsChange existing = xdVcsChange;
                if (existing != null) {
                    throw (Throwable)new BadRequestException(jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("IssueVcsChangesResource.Issue_is_already_associated_with_the_change", new Object[0]));
                }
            }

            public void doDelete(@NotNull VcsChange entity) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)entity), (String)"entity");
                entity.delete();
            }

            public void assertDeleteAccess(@Nullable VcsChange entity) {
                if (entity == null) {
                    throw (Throwable)new NotFoundException("No entity provided");
                }
                if (entity.getState() != 1) {
                    throw (Throwable)new BadRequestException(jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("IssueVcsChangesResource.Can_only_remove_a_manually_attached_change", new Object[0]));
                }
            }

            public void assertUpdateAccess() {
                if (!this.$item.canUpdatePrivate()) {
                    Object[] objectArray = new Object[1];
                    Project project = this.$item.getProject();
                    objectArray[0] = project != null ? project.getShortName() : null;
                    throw (Throwable)new ForbiddenException(jetbrains.youtrack.api.l10n.BeansKt.getLocalizer().localizedMsg("IssueVcsChangesResource.You_don_t_have_permission_to_update_issue_private_fields_in_project_{0}", objectArray));
                }
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public Sequence<VcsChange> getAll() {
                void var3_3;
                void $receiver$iv$iv;
                Iterable<XdVcsChange> $receiver$iv;
                Iterable<XdVcsChange> iterable = $receiver$iv = XdVcsChangeKt.getVcsChanges(this.$item.getXdEntity());
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault($receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    void it;
                    XdVcsChange xdVcsChange = (XdVcsChange)((Object)item$iv$iv);
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    XdEntity $receiver$iv2 = (XdEntity)it;
                    boolean $i$f$kt = false;
                    Entity $receiver$iv$iv2 = $receiver$iv2.getEntity();
                    VcsChange vcsChange = (VcsChange)XodusDatabase.INSTANCE.wrap(VcsChange.class, $receiver$iv$iv2, new Object[0]);
                    collection.add(vcsChange);
                }
                return CollectionsKt.asSequence((Iterable)((List)var3_3));
            }

            @NotNull
            public Object getElementResource(@NotNull VcsChange element) {
                Intrinsics.checkParameterIsNotNull((Object)((Object)element), (String)"element");
                return new RootSequenceElementResource((jetbrains.gap.resource.Entity)element, (RootEntitySequenceResource)this);
            }
            {
                this.$item = $captured_local_variable$0;
                this.baseType = Reflection.getOrCreateKotlinClass(VcsChange.class);
            }

            public int getDefaultTopValue() {
                return RootEntitySequenceResource.DefaultImpls.getDefaultTopValue((RootEntitySequenceResource)this);
            }

            @NotNull
            public Sequence<VcsChange> applySecurity(@NotNull Sequence<? extends VcsChange> values) {
                Intrinsics.checkParameterIsNotNull(values, (String)"values");
                return RootEntitySequenceResource.DefaultImpls.applySecurity((RootEntitySequenceResource)this, values);
            }

            public void assertAccess() {
                RootEntitySequenceResource.DefaultImpls.assertAccess((RootEntitySequenceResource)this);
            }

            @NotNull
            public VcsChange create(@NotNull Class<? extends VcsChange> clazz, Object ... args) {
                Intrinsics.checkParameterIsNotNull(clazz, (String)"clazz");
                Intrinsics.checkParameterIsNotNull((Object)args, (String)"args");
                return (VcsChange)RootEntitySequenceResource.DefaultImpls.create((RootEntitySequenceResource)this, clazz, (Object[])args);
            }

            @NotNull
            public WebApplicationException elementNotFound(@NotNull String id) {
                Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
                return RootEntitySequenceResource.DefaultImpls.elementNotFound((RootEntitySequenceResource)this, (String)id);
            }

            @NotNull
            public Sequence<VcsChange> filterAll(@Nullable String query) {
                return RootEntitySequenceResource.DefaultImpls.filterAll((RootEntitySequenceResource)this, (String)query);
            }

            @GET
            @Produces(value={"application/json"})
            @NotNull
            public List<jetbrains.gap.resource.Entity> get(@QueryParam(value="query") @Nullable String query, @QueryParam(value="$skip") @Nullable Integer skip, @QueryParam(value="$top") @Nullable Integer top) {
                return RootEntitySequenceResource.DefaultImpls.get((RootEntitySequenceResource)this, (String)query, (Integer)skip, (Integer)top);
            }

            @Path(value="{id}")
            @NotNull
            public Object getElementById(@PathParam(value="id") @NotNull String id) {
                Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
                return RootEntitySequenceResource.DefaultImpls.getElementById((RootEntitySequenceResource)this, (String)id);
            }

            @POST
            @Produces(value={"application/json"})
            @NotNull
            public jetbrains.gap.resource.Entity post(@NotNull jetbrains.gap.resource.Entity entity) {
                Intrinsics.checkParameterIsNotNull((Object)entity, (String)"entity");
                return RootEntitySequenceResource.DefaultImpls.post((RootEntitySequenceResource)this, (jetbrains.gap.resource.Entity)entity);
            }
        };
    }
}

