/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.misc;

import jetbrains.mps.internationalization.runtime.LocalizationObject;
import jetbrains.mps.webr.runtime.templateComponent.LogicException;

public class ExceptionOutputUtils {
    public static LocalizationObject createLocalizationObject(Exception e) {
        if (e instanceof NullPointerException) {
            return new LocalizationObject("TeamcityRest.Unknown_error", new Object[0]);
        }
        return new LocalizationObject("TeamcityRest.Error_caused_by_{0}", new Object[]{ExceptionOutputUtils.createExceptionPresentations(e)});
    }

    private static String createExceptionPresentations(Exception e) {
        Throwable deeperCause;
        if (e instanceof LogicException) {
            return e.getMessage();
        }
        if (e.getCause() == null) {
            return e.getMessage();
        }
        Throwable kindaCause = e.getCause().getCause();
        if (kindaCause == null) {
            return e.getCause().getMessage();
        }
        int i = 0;
        for (deeperCause = kindaCause; deeperCause.getCause() != null && deeperCause.getCause() != deeperCause && i++ < 10; deeperCause = deeperCause.getCause()) {
        }
        return ExceptionOutputUtils.isEmpty_mr1phc_a0a7a1(deeperCause.getMessage()) ? kindaCause.getMessage() : kindaCause.getClass().getName() + ":" + deeperCause.getMessage();
    }

    public static boolean isEmpty_mr1phc_a0a7a1(String str) {
        return str == null || str.length() == 0;
    }
}

