/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.youtrack.integration.vcs;

import com.jetbrains.teamsys.dnq.association.AssociationSemantics;
import com.jetbrains.teamsys.dnq.association.PrimitiveAssociationSemantics;
import com.jetbrains.teamsys.dnq.database.BasePersistentClassImpl;
import com.jetbrains.teamsys.dnq.database.EntityOperations;
import jetbrains.charisma.persistence.user.UserImpl;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.ISelector;
import jetbrains.mps.internal.collections.runtime.IVisitor;
import jetbrains.mps.internal.collections.runtime.IterableUtils;
import jetbrains.mps.internal.collections.runtime.Sequence;
import jetbrains.mps.internationalization.runtime.Localizer;
import jetbrains.springframework.configuration.runtime.ServiceLocator;
import jetbrains.teamsys.dnq.runtime.queries.QueryOperations;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import jetbrains.youtrack.integration.misc.ProgressStateHolder;
import jetbrains.youtrack.integration.vcs.CommonChangeDTO;
import jetbrains.youtrack.integration.vcs.VcsServerImpl;
import jetbrains.youtrack.integration.vcs.VcsService;
import jetbrains.youtrack.integration.vcs.VcsServiceFactory;

public class ChangesProcessorImpl
extends BasePersistentClassImpl {
    private static String __ENTITY_TYPE__ = "ChangesProcessor";

    public void run() {
        DnqUtils.setPersistentClassInstance((String)__ENTITY_TYPE__, (BasePersistentClassImpl)this);
    }

    protected Entity _constructor(String _entityType_) {
        Entity entity = super._constructor(_entityType_);
        PrimitiveAssociationSemantics.set((Entity)entity, (String)"enabled", (Comparable)Boolean.valueOf(true), Boolean.class);
        return entity;
    }

    protected void doProcess(_FunctionTypes._return_P1_E0<? extends Iterable<CommonChangeDTO>, ? super Entity> changesProvider, final Entity entity) {
        try {
            while (true) {
                Iterable changes = (Iterable)changesProvider.invoke((Object)entity);
                ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).logInfo("Processing changes " + IterableUtils.join((Iterable)Sequence.fromIterable((Iterable)changes).select((_FunctionTypes._return_P1_E0)new ISelector<CommonChangeDTO, String>(){

                    public String select(CommonChangeDTO it) {
                        return it.id;
                    }
                }), (String)" "), entity);
                if (Sequence.fromIterable((Iterable)changes).isEmpty()) {
                    this.setProgressMessage(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("ChangesProcessor.No_new_changes_found", new Object[0]), entity);
                    if (((Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"taxidermy", Boolean.class, null)).booleanValue()) {
                        ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).logInfo("Switching off taxidermy mode", entity);
                        PrimitiveAssociationSemantics.set((Entity)entity, (String)"taxidermy", (Comparable)Boolean.valueOf(false), Boolean.class);
                    }
                    break;
                }
                this.setProgressMessage(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("TeamcityBuildConfMapping.Link_issues_with_changes_Revisions_from_{0}_to_{1}", new Object[]{((CommonChangeDTO)Sequence.fromIterable((Iterable)changes).first()).version, ((CommonChangeDTO)Sequence.fromIterable((Iterable)changes).last()).version}), entity);
                Sequence.fromIterable((Iterable)changes).visitAll((_FunctionTypes._void_P1_E0)new IVisitor<CommonChangeDTO>(){

                    public void visit(CommonChangeDTO it) {
                        ChangesProcessorImpl.this.processChange(it, entity);
                    }
                });
                DnqUtils.getCurrentTransientSession().flush();
            }
        }
        catch (Exception e) {
            ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).logException(e, "Failed to process changes", true, true, entity);
        }
    }

    public void processChange(CommonChangeDTO c, Entity entity) {
        ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).getService(entity).processChange(entity, c);
    }

    public boolean isAccessible(Entity user2, Entity entity) {
        if (!this.isEnabled(entity)) {
            return false;
        }
        if (EntityOperations.equals((Entity)user2, null)) {
            return false;
        }
        if (QueryOperations.isEmpty((Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"visibleForGroups"))) {
            return true;
        }
        return !QueryOperations.isEmpty((Iterable)QueryOperations.intersect((Iterable)((UserImpl)DnqUtils.getPersistentClassInstance((Entity)user2, (String)"User")).getUserGroups(user2), (Iterable)AssociationSemantics.getToMany((Entity)entity, (String)"visibleForGroups")));
    }

    protected String getLogPrefix(Entity entity) {
        return ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).getService(entity).getLogPrefix(entity);
    }

    public void setProgressMessage(String message, Entity entity) {
        ((ProgressStateHolder)ServiceLocator.getBean((String)"progressStateHoder")).setProgressMessage(entity, message);
    }

    protected void addStateMessage(String message, Entity entity) {
        String stateMessage = ((ProgressStateHolder)ServiceLocator.getBean((String)"progressStateHoder")).getStateMessage(entity);
        ((ProgressStateHolder)ServiceLocator.getBean((String)"progressStateHoder")).setStateMessage(entity, stateMessage == null || stateMessage.length() == 0 ? message : stateMessage + "\n" + message);
    }

    public void logException(Exception e, String message, boolean asError, boolean addStateMessage, Entity entity) {
        ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).getService(entity).logException(entity, e, message, asError, addStateMessage);
    }

    public void logInfo(String message, Entity entity) {
        ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).getService(entity).logInfo(entity, message);
    }

    public void logDebug(String message, Entity entity) {
        ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).getService(entity).logDebug(entity, message);
    }

    public void logError(String message, Entity entity) {
        ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).getService(entity).logError(entity, message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(_FunctionTypes._return_P1_E0<? extends Iterable<CommonChangeDTO>, ? super Entity> changesProvider, Entity entity) {
        if (!this.isEnabled(entity)) {
            ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).logInfo("Mapping disabled. Return", entity);
            return;
        }
        ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).logInfo("Process configuration", entity);
        ProgressStateHolder stateHolder = (ProgressStateHolder)ServiceLocator.getBean((String)"progressStateHoder");
        if (!stateHolder.startRun(entity)) {
            ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).logInfo("Already in progress. Return.", entity);
            return;
        }
        try {
            this.initMessages(entity);
            ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).doProcess(changesProvider, entity);
            ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).setSynchrinizedAt(entity);
        }
        finally {
            stateHolder.endRun(entity);
        }
    }

    public void setSynchrinizedAt(Entity entity) {
        ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).getService(entity).setSynchronizedA(entity);
    }

    public void initMessages(Entity entity) {
        ((ProgressStateHolder)ServiceLocator.getBean((String)"progressStateHoder")).setStateMessage(entity, null);
        this.setProgressMessage(((Localizer)ServiceLocator.getBean((String)"localizer")).localizedMsg("TeamcityBuildConfMapping.Synchronizing", new Object[0]), entity);
    }

    public CommonChangeDTO toDto(Entity change, Entity entity) {
        return ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance((Entity)entity, (String)"ChangesProcessor")).getService(entity).toDto(change);
    }

    public boolean isEnabled(Entity entity) {
        return !EntityOperations.equals((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"server"), null) && ((VcsServerImpl)DnqUtils.getPersistentClassInstance((Entity)AssociationSemantics.getToOne((Entity)entity, (String)"server"), (String)"VcsServer")).isEnabled(AssociationSemantics.getToOne((Entity)entity, (String)"server")) && (Boolean)PrimitiveAssociationSemantics.get((Entity)entity, (String)"enabled", Boolean.class, null) != false;
    }

    VcsService getService(Entity entity) {
        return ((VcsServiceFactory)ServiceLocator.getBean((String)"vcsServiceFactory")).find(AssociationSemantics.getToOne((Entity)entity, (String)"server"));
    }

    public static Entity constructor() {
        return ((ChangesProcessorImpl)DnqUtils.getPersistentClassInstance(null, (String)__ENTITY_TYPE__))._constructor(__ENTITY_TYPE__);
    }
}

