/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.mps.internal.collections.runtime.impl;

import java.util.Iterator;
import java.util.NoSuchElementException;
import jetbrains.mps.baseLanguage.closures.runtime._FunctionTypes;
import jetbrains.mps.internal.collections.runtime.impl.AbstractChainedSequence;
import jetbrains.mps.internal.collections.runtime.impl.HasNextState;

public class SelectingSequence<U, V>
extends AbstractChainedSequence<U, V>
implements Iterable<V> {
    private final _FunctionTypes._return_P1_E0<? extends V, ? super U> selector;

    public SelectingSequence(Iterable<U> input, _FunctionTypes._return_P1_E0<? extends V, ? super U> selector) {
        super(input);
        this.selector = selector;
    }

    @Override
    public Iterator<V> iterator() {
        return new SelectingIterator();
    }

    private class SelectingIterator
    implements Iterator<V> {
        private Iterator<U> inputIterator = null;
        private HasNextState hasNext = HasNextState.UNKNOWN;
        private V next;

        private SelectingIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.inputIterator == null) {
                this.init();
            }
            if (this.hasNext.unknown()) {
                this.moveToNext();
            }
            return this.hasNext.hasNext();
        }

        @Override
        public V next() {
            if (this.inputIterator == null) {
                this.init();
            }
            if (this.hasNext.unknown()) {
                this.moveToNext();
            }
            if (!this.hasNext.hasNext()) {
                throw new NoSuchElementException();
            }
            return this.clearNext();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private void init() {
            this.inputIterator = SelectingSequence.this.getInput().iterator();
        }

        private void moveToNext() {
            block0: {
                this.hasNext = HasNextState.AT_END;
                this.next = null;
                if (!this.inputIterator.hasNext()) break block0;
                Object tmp = SelectingSequence.this.selector.invoke(this.inputIterator.next());
                this.hasNext = HasNextState.HAS_NEXT;
                this.next = tmp;
            }
        }

        private V clearNext() {
            Object tmp = this.next;
            this.next = null;
            this.hasNext = HasNextState.UNKNOWN;
            return tmp;
        }
    }
}

