/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.dao.dnq.api.authority;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.gap.filter.query.FilterQuery;
import jetbrains.jetpass.api.APIVersion;
import jetbrains.jetpass.api.IdItem;
import jetbrains.jetpass.api.authority.AuthorityHolder;
import jetbrains.jetpass.api.authority.ProjectTeam;
import jetbrains.jetpass.api.authority.User;
import jetbrains.jetpass.api.authority.UserGroup;
import jetbrains.jetpass.api.security.Permission;
import jetbrains.jetpass.api.security.Project;
import jetbrains.jetpass.api.security.ProjectRole;
import jetbrains.jetpass.api.security.Resource;
import jetbrains.jetpass.core.lang.NamesKt;
import jetbrains.jetpass.dao.api.DataAccessException;
import jetbrains.jetpass.dao.api.DataWriteException;
import jetbrains.jetpass.dao.api.ItemNotFoundException;
import jetbrains.jetpass.dao.api.Listener;
import jetbrains.jetpass.dao.api.authority.UserGroupDAO;
import jetbrains.jetpass.dao.dnq.api.APIInvocationContextKt;
import jetbrains.jetpass.dao.dnq.api.DataAccessExceptionUtilKt;
import jetbrains.jetpass.dao.dnq.api.JetPassDAOContainer;
import jetbrains.jetpass.dao.dnq.api.JetPassReadOnlyDAO;
import jetbrains.jetpass.dao.dnq.api.JetPassReadonlyDAOUtilKt;
import jetbrains.jetpass.dao.dnq.api.authority.JetPassProjectTeam;
import jetbrains.jetpass.dao.dnq.api.authority.JetPassProjectTeamKt;
import jetbrains.jetpass.dao.dnq.api.authority.JetPassUserGroupDAO;
import jetbrains.jetpass.dao.dnq.api.authority.JetPassUserGroupDelegatingDAO;
import jetbrains.jetpass.dao.dnq.api.authority.JetPassUserGroupDelegatingDAOKt;
import jetbrains.jetpass.dao.dnq.api.security.JetPassProjectTeamDAO;
import jetbrains.jetpass.dao.dnq.api.security.Security;
import jetbrains.jetpass.dao.dnq.api.sequence.SortingIterator;
import jetbrains.jetpass.dao.dnq.api.sequence.UnionSequence;
import jetbrains.jetpass.dao.dnq.query.QueryExecutor;
import jetbrains.jetpass.dao.dnq.query.executorBundle.GroupAndTeamFieldExecutorBundle;
import jetbrains.jetpass.dao.query.QueryAssistProvider;
import jetbrains.jetpass.dnq.TransactionKt;
import jetbrains.jetpass.sequence.impl.ListSequence;
import jetbrains.jetpass.userManagement.persistence.dnq.XdAuthorityHolder;
import jetbrains.jetpass.userManagement.persistence.dnq.XdBaseUser;
import jetbrains.jetpass.userManagement.persistence.dnq.XdBaseUserGroup;
import jetbrains.jetpass.userManagement.persistence.dnq.XdMergeAction;
import jetbrains.jetpass.userManagement.persistence.dnq.XdProjectTeam;
import jetbrains.jetpass.userManagement.persistence.dnq.XdUUIDObject;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KFunction;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.util.ReflectionUtilKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u00ce\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001c\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u00012\u00020\u0002:\u0003tuvB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016J\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001dH\u0016J\u0018\u0010!\u001a\u00020\u001b2\u0006\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u001fH\u0016J\u0018\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u001fH\u0016J(\u0010(\u001a\b\u0012\u0004\u0012\u00020*0)2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u001b0)2\f\u0010,\u001a\b\u0012\u0004\u0012\u00020-0)J\u0010\u0010.\u001a\u00020\u001b2\u0006\u0010/\u001a\u00020\u001bH\u0016J\u0010\u00100\u001a\u00020\u00182\u0006\u00101\u001a\u00020\u001fH\u0016J\u001a\u00100\u001a\u00020\u00182\u0006\u00101\u001a\u00020\u001f2\b\u00102\u001a\u0004\u0018\u00010\u001fH\u0016J\u0018\u00103\u001a\u00020\u00182\u0006\u00104\u001a\u00020\u001f2\u0006\u00105\u001a\u00020-H\u0002J/\u00106\u001a\u0002H7\"\u0004\b\u0000\u001072\u0006\u00108\u001a\u00020\u001f2\u0012\u00109\u001a\u000e\u0012\u0004\u0012\u00020;\u0012\u0004\u0012\u0002H70:H\u0016\u00a2\u0006\u0002\u0010<J\u0015\u0010=\u001a\u0004\u0018\u00010\u001b2\b\u00101\u001a\u0004\u0018\u00010\u001fH\u0096\u0002J\u000e\u0010>\u001a\b\u0012\u0004\u0012\u00020\u001b0)H\u0016J\f\u0010?\u001a\b\u0012\u0004\u0012\u00020*0)J\u0016\u0010@\u001a\b\u0012\u0004\u0012\u00020\u001b0)2\u0006\u0010A\u001a\u00020\u001fH\u0016J\u0012\u0010B\u001a\u0004\u0018\u00010\u001b2\u0006\u0010A\u001a\u00020\u001fH\u0016J\u0012\u0010C\u001a\u00020\u001b2\b\u00101\u001a\u0004\u0018\u00010\u001fH\u0016J\b\u0010D\u001a\u00020\u001bH\u0016J$\u0010E\u001a\u00020F2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010G\u001a\u0004\u0018\u00010H2\b\u0010I\u001a\u0004\u0018\u00010JH\u0016J$\u0010E\u001a\u00020F2\u0006\u0010\u001e\u001a\u00020\u001f2\b\u0010G\u001a\u0004\u0018\u00010H2\b\u0010K\u001a\u0004\u0018\u00010LH\u0016JY\u0010M\u001a\u00020\u001b2\u000e\u0010+\u001a\n\u0012\u0004\u0012\u00020\u001b\u0018\u00010N2\b\u0010A\u001a\u0004\u0018\u00010\u001f2\b\u0010O\u001a\u0004\u0018\u00010\u001f2\b\u0010P\u001a\u0004\u0018\u00010F2\b\u0010Q\u001a\u0004\u0018\u00010F2\b\u0010R\u001a\u0004\u0018\u00010\u001f2\b\u0010S\u001a\u0004\u0018\u00010\u001fH\u0016\u00a2\u0006\u0002\u0010TJ\u0016\u0010U\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0016J\u0018\u0010V\u001a\u00020\u00182\u0006\u0010W\u001a\u00020\u001f2\u0006\u0010X\u001a\u00020\u001fH\u0016J\u0018\u0010Y\u001a\u00020\u00182\u0006\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u001fH\u0016J\u0018\u0010Z\u001a\u00020\u00182\u0006\u0010&\u001a\u00020\u001f2\u0006\u0010'\u001a\u00020\u001fH\u0016J,\u0010[\u001a\u00020\n2\u0006\u00101\u001a\u00020\u001f2\b\b\u0002\u0010\\\u001a\u00020F2\b\b\u0002\u0010]\u001a\u00020F2\b\b\u0002\u0010^\u001a\u00020FJ\u0012\u0010_\u001a\u0004\u0018\u00010\n2\b\u00101\u001a\u0004\u0018\u00010\u001fJ@\u0010`\u001a\u00020a2\u0006\u00101\u001a\u00020\u001f2\b\b\u0002\u0010\\\u001a\u00020F2\b\b\u0002\u0010]\u001a\u00020F2\b\b\u0002\u0010^\u001a\u00020F2\u0012\u0010b\u001a\u000e\u0012\u0004\u0012\u00020c\u0012\u0004\u0012\u00020d0:J#\u0010e\u001a\u0004\u0018\u0001H7\"\u0004\b\u0000\u001072\f\u0010f\u001a\b\u0012\u0004\u0012\u0002H70gH\u0002\u00a2\u0006\u0002\u0010hJ\u0010\u0010i\u001a\u00020d2\u0006\u0010j\u001a\u00020kH\u0002J\u0016\u0010l\u001a\u00020\u00182\u0006\u00104\u001a\u00020\u001f2\u0006\u0010m\u001a\u00020nJ\u001a\u0010o\u001a\u00020\u00182\u0006\u00101\u001a\u00020\u001f2\b\u0010/\u001a\u0004\u0018\u00010\u001bH\u0016J\u000e\u0010p\u001a\u00020\u001b2\u0006\u0010j\u001a\u00020\nJ\u0010\u0010q\u001a\u00020\u0018*\u00060rj\u0002`sH\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R!\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\u00148F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006w"}, d2={"Ljetbrains/jetpass/dao/dnq/api/authority/JetPassUserGroupDelegatingDAO;", "Ljetbrains/jetpass/dao/api/authority/UserGroupDAO;", "Ljetbrains/jetpass/dao/query/QueryAssistProvider;", "container", "Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "(Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;)V", "getContainer", "()Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "mixedQueryExecutor", "Ljetbrains/jetpass/dao/dnq/query/QueryExecutor;", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdAuthorityHolder;", "getMixedQueryExecutor", "()Ljetbrains/jetpass/dao/dnq/query/QueryExecutor;", "mixedQueryExecutor$delegate", "Lkotlin/Lazy;", "projectTeamDAO", "Ljetbrains/jetpass/dao/dnq/api/security/JetPassProjectTeamDAO;", "getProjectTeamDAO", "()Ljetbrains/jetpass/dao/dnq/api/security/JetPassProjectTeamDAO;", "userGroupDAO", "Ljetbrains/jetpass/dao/dnq/api/authority/JetPassUserGroupDAO;", "getUserGroupDAO", "()Ljetbrains/jetpass/dao/dnq/api/authority/JetPassUserGroupDAO;", "addListener", "", "listener", "Ljetbrains/jetpass/dao/api/Listener;", "Ljetbrains/jetpass/api/authority/UserGroup;", "addRole", "Ljetbrains/jetpass/api/security/ProjectRole;", "authorityHolderId", "", "projectRole", "addSubgroup", "parentId", "childId", "addUser", "Ljetbrains/jetpass/api/authority/User;", "groupID", "userID", "combineSequences", "Ljetbrains/jetpass/sequence/Sequence;", "Ljetbrains/jetpass/api/authority/AuthorityHolder;", "groups", "teams", "Ljetbrains/jetpass/api/authority/ProjectTeam;", "create", "item", "delete", "id", "successor", "deleteGroupWithTeamSuccessor", "groupId", "team", "evalWithQueryAssist", "T", "query", "eval", "Lkotlin/Function1;", "Ljetbrains/gap/filter/query/FilterQuery;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "get", "getAllItems", "getAllItemsMixed", "getByName", "name", "getFirstByName", "getNotNull", "getRootUserGroup", "hasPermission", "", "permission", "Ljetbrains/jetpass/api/security/Permission;", "project", "Ljetbrains/jetpass/api/security/Project;", "resource", "Ljetbrains/jetpass/api/security/Resource;", "merge", "", "description", "authJoin", "required2FA", "projectUUID", "parentGroupUUID", "(Ljava/lang/Iterable;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljava/lang/Boolean;Ljava/lang/String;Ljava/lang/String;)Ljetbrains/jetpass/api/authority/UserGroup;", "removeListener", "removeRole", "authorityHolderID", "projectRoleID", "removeSubgroup", "removeUser", "resolve", "canRead", "canUpdate", "canDelete", "resolveOrNull", "resolveOrThrowIfTeam", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdBaseUserGroup;", "ifTeam", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdProjectTeam;", "", "takeIfInitialApi", "body", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "throwEntityIsNotSupported", "xd", "Lkotlinx/dnq/XdEntity;", "uniformlyAddUser", "xdUser", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdBaseUser;", "update", "wrapEntityAsGroup", "rethrowIfNotInitialApi", "Ljava/lang/Exception;", "Lkotlin/Exception;", "GroupsAndTeamsQueryExecutor", "GroupsAndTeamsSecurity", "GroupsAndTeamsUnionSequence", "jetbrains.jetpass.dao.dnq"})
public final class JetPassUserGroupDelegatingDAO
implements UserGroupDAO,
QueryAssistProvider {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @NotNull
    private final Lazy mixedQueryExecutor$delegate;
    @NotNull
    private final JetPassDAOContainer container;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(JetPassUserGroupDelegatingDAO.class), "mixedQueryExecutor", "getMixedQueryExecutor()Ljetbrains/jetpass/dao/dnq/query/QueryExecutor;"))};
    }

    @NotNull
    public final JetPassUserGroupDAO getUserGroupDAO() {
        return this.container.getJetPassUserGroupDAO();
    }

    @NotNull
    public final JetPassProjectTeamDAO getProjectTeamDAO() {
        return this.container.getJetPassProjectTeamDAO();
    }

    @NotNull
    public final QueryExecutor<XdAuthorityHolder> getMixedQueryExecutor() {
        Lazy lazy = this.mixedQueryExecutor$delegate;
        JetPassUserGroupDelegatingDAO jetPassUserGroupDelegatingDAO = this;
        KProperty kProperty = $$delegatedProperties[0];
        return (QueryExecutor)lazy.getValue();
    }

    public void addListener(@NotNull Listener<UserGroup> listener) {
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        throw (Throwable)new UnsupportedOperationException("Add the listener to the jetPassUserGroupDAO or jetPassProjectTeamDAO directly");
    }

    public void removeListener(@NotNull Listener<UserGroup> listener) {
        Intrinsics.checkParameterIsNotNull(listener, (String)"listener");
        throw (Throwable)new UnsupportedOperationException();
    }

    @NotNull
    public jetbrains.jetpass.sequence.Sequence<UserGroup> getAllItems() {
        UnionSequence unionSequence = (UnionSequence)((Object)this.takeIfInitialApi((Function0)new Function0<UnionSequence<? extends UserGroup>>(this){
            final /* synthetic */ JetPassUserGroupDelegatingDAO this$0;

            @NotNull
            public final UnionSequence<UserGroup> invoke() {
                return new UnionSequence<UserGroup>(this.this$0.getUserGroupDAO().getAllItems(), JetPassUserGroupDelegatingDAOKt.access$asGroupSafeSequence(this.this$0.getProjectTeamDAO().getAllItems()));
            }
            {
                this.this$0 = jetPassUserGroupDelegatingDAO;
                super(0);
            }
        }));
        return unionSequence != null ? (jetbrains.jetpass.sequence.Sequence)unionSequence : this.getUserGroupDAO().getAllItems();
    }

    @NotNull
    public final jetbrains.jetpass.sequence.Sequence<AuthorityHolder> getAllItemsMixed() {
        return this.combineSequences(this.getUserGroupDAO().getAllItems(), this.getProjectTeamDAO().getAllItems());
    }

    @Nullable
    public UserGroup get(@Nullable String id) {
        UserGroup userGroup = (UserGroup)this.getUserGroupDAO().get(id);
        if (userGroup == null) {
            userGroup = (UserGroup)this.takeIfInitialApi((Function0)new Function0<UserGroup>(this, id){
                final /* synthetic */ JetPassUserGroupDelegatingDAO this$0;
                final /* synthetic */ String $id;

                @Nullable
                public final UserGroup invoke() {
                    ProjectTeam projectTeam = (ProjectTeam)this.this$0.getProjectTeamDAO().get(this.$id);
                    return projectTeam != null ? JetPassUserGroupDelegatingDAOKt.asGroup(projectTeam) : null;
                }
                {
                    this.this$0 = jetPassUserGroupDelegatingDAO;
                    this.$id = string;
                    super(0);
                }
            });
        }
        return userGroup;
    }

    @NotNull
    public UserGroup getNotNull(@Nullable String id) {
        UserGroup userGroup = this.get(id);
        if (userGroup == null) {
            throw (Throwable)new ItemNotFoundException(UserGroup.class.getSimpleName(), id);
        }
        return userGroup;
    }

    @NotNull
    public jetbrains.jetpass.sequence.Sequence<UserGroup> getByName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        UnionSequence unionSequence = (UnionSequence)((Object)this.takeIfInitialApi((Function0)new Function0<UnionSequence<? extends UserGroup>>(this, name){
            final /* synthetic */ JetPassUserGroupDelegatingDAO this$0;
            final /* synthetic */ String $name;

            @NotNull
            public final UnionSequence<UserGroup> invoke() {
                return new UnionSequence<UserGroup>(this.this$0.getUserGroupDAO().getByName(this.$name), JetPassUserGroupDelegatingDAOKt.access$asGroupSafeSequence(this.this$0.getProjectTeamDAO().getByName(this.$name)));
            }
            {
                this.this$0 = jetPassUserGroupDelegatingDAO;
                this.$name = string;
                super(0);
            }
        }));
        return unionSequence != null ? (jetbrains.jetpass.sequence.Sequence)unionSequence : this.getUserGroupDAO().getByName(name);
    }

    @Nullable
    public UserGroup getFirstByName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        UserGroup userGroup = (UserGroup)this.getUserGroupDAO().getFirstByName(name);
        if (userGroup == null) {
            userGroup = (UserGroup)this.takeIfInitialApi((Function0)new Function0<UserGroup>(this, name){
                final /* synthetic */ JetPassUserGroupDelegatingDAO this$0;
                final /* synthetic */ String $name;

                @Nullable
                public final UserGroup invoke() {
                    ProjectTeam projectTeam = (ProjectTeam)this.this$0.getProjectTeamDAO().getFirstByName(this.$name);
                    return projectTeam != null ? JetPassUserGroupDelegatingDAOKt.asGroup(projectTeam) : null;
                }
                {
                    this.this$0 = jetPassUserGroupDelegatingDAO;
                    this.$name = string;
                    super(0);
                }
            });
        }
        return userGroup;
    }

    @NotNull
    public UserGroup create(@NotNull UserGroup item) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        return (UserGroup)this.getUserGroupDAO().create((IdItem)item);
    }

    public void update(@NotNull String id, @Nullable UserGroup item) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        try {
            this.getUserGroupDAO().update(id, (IdItem)item);
        }
        catch (ItemNotFoundException ex) {
            this.rethrowIfNotInitialApi((Exception)((Object)ex));
            ProjectTeam team = (ProjectTeam)this.getProjectTeamDAO().get(id);
            if (team != null) {
                throw (Throwable)new DataWriteException("Updates of project teams are not supported");
            }
            throw (Throwable)ex;
        }
    }

    public void delete(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        try {
            this.getUserGroupDAO().delete(id);
        }
        catch (ItemNotFoundException ex) {
            this.rethrowIfNotInitialApi((Exception)((Object)ex));
            ProjectTeam team = (ProjectTeam)this.getProjectTeamDAO().get(id);
            if (team != null) {
                throw (Throwable)new DataWriteException("Deletion of teams is not supported");
            }
            throw (Throwable)ex;
        }
    }

    public void delete(@NotNull String id, @Nullable String successor) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        try {
            ProjectTeam teamSuccessor2 = (ProjectTeam)this.takeIfInitialApi((Function0)new Function0<ProjectTeam>(this, successor){
                final /* synthetic */ JetPassUserGroupDelegatingDAO this$0;
                final /* synthetic */ String $successor;

                @Nullable
                public final ProjectTeam invoke() {
                    ProjectTeam projectTeam;
                    String string = this.$successor;
                    if (string != null) {
                        String string2;
                        String it = string2 = string;
                        projectTeam = (ProjectTeam)this.this$0.getProjectTeamDAO().get(it);
                    } else {
                        projectTeam = null;
                    }
                    return projectTeam;
                }
                {
                    this.this$0 = jetPassUserGroupDelegatingDAO;
                    this.$successor = string;
                    super(0);
                }
            });
            if (teamSuccessor2 == null) {
                this.getUserGroupDAO().delete(id, successor);
            } else {
                this.deleteGroupWithTeamSuccessor(id, teamSuccessor2);
            }
        }
        catch (ItemNotFoundException ex) {
            this.rethrowIfNotInitialApi((Exception)((Object)ex));
            ProjectTeam team = (ProjectTeam)this.getProjectTeamDAO().get(id);
            if (team != null) {
                throw (Throwable)new DataWriteException("Deletion of teams is not supported");
            }
            throw (Throwable)ex;
        }
    }

    private final void deleteGroupWithTeamSuccessor(String groupId, ProjectTeam team) {
        DataAccessExceptionUtilKt.daoTransaction$default(this.container, false, (Function1)new Function1<TransientStoreSession, Unit>(this, groupId, team){
            final /* synthetic */ JetPassUserGroupDelegatingDAO this$0;
            final /* synthetic */ String $groupId;
            final /* synthetic */ ProjectTeam $team;

            public final void invoke(@NotNull TransientStoreSession it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                XdBaseUserGroup xdGroup2 = (XdBaseUserGroup)JetPassReadOnlyDAO.resolve$default(this.this$0.getUserGroupDAO(), this.$groupId, true, false, true, 4, null);
                XdProjectTeam xdTeam = (XdProjectTeam)this.this$0.getProjectTeamDAO().resolve((IdItem)this.$team, true, true);
                xdGroup2.delete((XdUUIDObject)xdTeam, XdMergeAction.Companion.getDELETE());
            }
            {
                this.this$0 = jetPassUserGroupDelegatingDAO;
                this.$groupId = string;
                this.$team = projectTeam;
                super(1);
            }
        }, 1, null);
    }

    @NotNull
    public ProjectRole addRole(@NotNull String authorityHolderId, @NotNull ProjectRole projectRole) {
        ProjectRole projectRole2;
        Intrinsics.checkParameterIsNotNull((Object)authorityHolderId, (String)"authorityHolderId");
        Intrinsics.checkParameterIsNotNull((Object)projectRole, (String)"projectRole");
        try {
            projectRole2 = this.getUserGroupDAO().addRole(authorityHolderId, projectRole);
        }
        catch (ItemNotFoundException ex1) {
            ProjectRole projectRole3;
            this.rethrowIfNotInitialApi((Exception)((Object)ex1));
            try {
                projectRole3 = this.getProjectTeamDAO().addRole(authorityHolderId, projectRole);
            }
            catch (ItemNotFoundException ex2) {
                throw (Throwable)ex1;
            }
            projectRole2 = projectRole3;
        }
        return projectRole2;
    }

    public void removeRole(@NotNull String authorityHolderID, @NotNull String projectRoleID) {
        Intrinsics.checkParameterIsNotNull((Object)authorityHolderID, (String)"authorityHolderID");
        Intrinsics.checkParameterIsNotNull((Object)projectRoleID, (String)"projectRoleID");
        try {
            this.getUserGroupDAO().removeRole(authorityHolderID, projectRoleID);
        }
        catch (ItemNotFoundException ex) {
            this.rethrowIfNotInitialApi((Exception)((Object)ex));
            ProjectTeam team = (ProjectTeam)this.getProjectTeamDAO().get(authorityHolderID);
            if (team != null) {
                this.getProjectTeamDAO().removeRole(authorityHolderID, projectRoleID);
            }
            throw (Throwable)ex;
        }
    }

    @NotNull
    public UserGroup addSubgroup(@NotNull String parentId, @NotNull String childId) {
        Intrinsics.checkParameterIsNotNull((Object)parentId, (String)"parentId");
        Intrinsics.checkParameterIsNotNull((Object)childId, (String)"childId");
        try {
            return this.getUserGroupDAO().addSubgroup(parentId, childId);
        }
        catch (ItemNotFoundException ex) {
            this.rethrowIfNotInitialApi((Exception)((Object)ex));
            ProjectTeam parent = (ProjectTeam)this.getProjectTeamDAO().get(parentId);
            if (parent != null) {
                throw (Throwable)new DataWriteException("Adding subgroups to teams is not supported");
            }
            ProjectTeam child = (ProjectTeam)this.getProjectTeamDAO().get(childId);
            if (child != null) {
                throw (Throwable)new DataWriteException("Adding teams as subgroups is not supported");
            }
            throw (Throwable)ex;
        }
    }

    public void removeSubgroup(@NotNull String parentId, @NotNull String childId) {
        Intrinsics.checkParameterIsNotNull((Object)parentId, (String)"parentId");
        Intrinsics.checkParameterIsNotNull((Object)childId, (String)"childId");
        try {
            this.getUserGroupDAO().removeSubgroup(parentId, childId);
        }
        catch (ItemNotFoundException ex) {
            this.rethrowIfNotInitialApi((Exception)((Object)ex));
            ProjectTeam parent = (ProjectTeam)this.getProjectTeamDAO().get(parentId);
            if (parent != null) {
                throw (Throwable)new DataWriteException("Removing subgroups from teams is not supported");
            }
            ProjectTeam child = (ProjectTeam)this.getProjectTeamDAO().get(childId);
            if (child != null) {
                throw (Throwable)new DataWriteException("Removing teams from subgroups is not supported");
            }
            throw (Throwable)ex;
        }
    }

    @NotNull
    public User addUser(@NotNull String groupID, @NotNull String userID) {
        User user2;
        Intrinsics.checkParameterIsNotNull((Object)groupID, (String)"groupID");
        Intrinsics.checkParameterIsNotNull((Object)userID, (String)"userID");
        try {
            user2 = this.getUserGroupDAO().addUser(groupID, userID);
        }
        catch (ItemNotFoundException ex) {
            this.rethrowIfNotInitialApi((Exception)((Object)ex));
            ProjectTeam team = (ProjectTeam)this.getProjectTeamDAO().get(groupID);
            if (team == null) {
                throw (Throwable)ex;
            }
            user2 = this.getProjectTeamDAO().includeUser(groupID, userID);
        }
        return user2;
    }

    public void removeUser(@NotNull String groupID, @NotNull String userID) {
        Intrinsics.checkParameterIsNotNull((Object)groupID, (String)"groupID");
        Intrinsics.checkParameterIsNotNull((Object)userID, (String)"userID");
        try {
            this.getUserGroupDAO().removeUser(groupID, userID);
        }
        catch (ItemNotFoundException ex) {
            this.rethrowIfNotInitialApi((Exception)((Object)ex));
            ProjectTeam team = (ProjectTeam)this.getProjectTeamDAO().get(groupID);
            if (team != null) {
                this.getProjectTeamDAO().removeUser(groupID, userID);
            }
            throw (Throwable)ex;
        }
    }

    @NotNull
    public UserGroup getRootUserGroup() {
        return this.getUserGroupDAO().getRootUserGroup();
    }

    public boolean hasPermission(@NotNull String authorityHolderId, @Nullable Permission permission2, @Nullable Resource resource) {
        Intrinsics.checkParameterIsNotNull((Object)authorityHolderId, (String)"authorityHolderId");
        return this.getUserGroupDAO().hasPermission(authorityHolderId, permission2, resource);
    }

    public boolean hasPermission(@NotNull String authorityHolderId, @Nullable Permission permission2, @Nullable Project project) {
        Intrinsics.checkParameterIsNotNull((Object)authorityHolderId, (String)"authorityHolderId");
        return this.getUserGroupDAO().hasPermission(authorityHolderId, permission2, project);
    }

    @NotNull
    public UserGroup merge(@Nullable Iterable<? extends UserGroup> groups, @Nullable String name, @Nullable String description, @Nullable Boolean authJoin, @Nullable Boolean required2FA, @Nullable String projectUUID, @Nullable String parentGroupUUID) {
        boolean hasTeams;
        List groupsOrTeams;
        block8: {
            boolean bl;
            Iterable<? extends UserGroup> iterable = groups;
            List list = groupsOrTeams = iterable != null ? CollectionsKt.toList(iterable) : null;
            if (list != null) {
                Iterable $receiver$iv = list;
                if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $receiver$iv) {
                        UserGroup it = (UserGroup)element$iv;
                        if (!(it instanceof ProjectTeam || this.getProjectTeamDAO().get(it.getId()) != null)) continue;
                        bl = true;
                        break block8;
                    }
                    bl = false;
                }
            } else {
                bl = hasTeams = false;
            }
        }
        if (hasTeams) {
            throw (Throwable)new DataWriteException("Merge of teams is not supported");
        }
        String string = parentGroupUUID;
        if (string != null) {
            String string2;
            String it = string2 = string;
            string = (ProjectTeam)this.getProjectTeamDAO().get(it);
            if (string != null) {
                it = string2 = string;
                throw (Throwable)new DataWriteException("Using a team as a parent group is not supported");
            }
        }
        return this.getUserGroupDAO().merge((Iterable)groupsOrTeams, name, description, authJoin, required2FA, projectUUID, parentGroupUUID);
    }

    public <T> T evalWithQueryAssist(@NotNull String query2, @NotNull Function1<? super FilterQuery, ? extends T> eval2) {
        Intrinsics.checkParameterIsNotNull((Object)query2, (String)"query");
        Intrinsics.checkParameterIsNotNull(eval2, (String)"eval");
        return this.getUserGroupDAO().evalWithQueryAssist(query2, eval2);
    }

    @Nullable
    public final XdAuthorityHolder resolveOrNull(@Nullable String id) {
        XdAuthorityHolder xdAuthorityHolder;
        String string = id;
        if (string != null) {
            String string2;
            String it = string2 = string;
            XdBaseUserGroup xdBaseUserGroup = this.getUserGroupDAO().resolveOrNull(it);
            xdAuthorityHolder = xdBaseUserGroup != null ? (XdAuthorityHolder)xdBaseUserGroup : (XdAuthorityHolder)this.takeIfInitialApi((Function0)new Function0<XdProjectTeam>(it, this){
                final /* synthetic */ String $it;
                final /* synthetic */ JetPassUserGroupDelegatingDAO this$0;
                {
                    this.$it = string;
                    this.this$0 = jetPassUserGroupDelegatingDAO;
                    super(0);
                }

                @Nullable
                public final XdProjectTeam invoke() {
                    return this.this$0.getProjectTeamDAO().resolveOrNull(this.$it);
                }
            });
        } else {
            xdAuthorityHolder = null;
        }
        return xdAuthorityHolder;
    }

    @NotNull
    public final XdBaseUserGroup resolveOrThrowIfTeam(@NotNull String id, boolean canRead, boolean canUpdate, boolean canDelete2, @NotNull Function1 ifTeam) {
        XdAuthorityHolder xdHolder;
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        Intrinsics.checkParameterIsNotNull((Object)ifTeam, (String)"ifTeam");
        XdAuthorityHolder xdAuthorityHolder = xdHolder = this.resolve(id, canRead, canUpdate, canDelete2);
        if (!(xdAuthorityHolder instanceof XdBaseUserGroup)) {
            if (xdAuthorityHolder instanceof XdProjectTeam) {
                Object object = ifTeam.invoke((Object)xdHolder);
                throw null;
            }
            Void void_ = this.throwEntityIsNotSupported((XdEntity)xdHolder);
            throw null;
        }
        return (XdBaseUserGroup)xdHolder;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ XdBaseUserGroup resolveOrThrowIfTeam$default(JetPassUserGroupDelegatingDAO jetPassUserGroupDelegatingDAO, String string, boolean bl, boolean bl2, boolean bl3, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        return jetPassUserGroupDelegatingDAO.resolveOrThrowIfTeam(string, bl, bl2, bl3, function1);
    }

    @NotNull
    public final XdAuthorityHolder resolve(@NotNull String id, boolean canRead, boolean canUpdate, boolean canDelete2) {
        XdAuthorityHolder xdAuthorityHolder;
        block15: {
            block14: {
                Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
                xdAuthorityHolder = this.resolveOrNull(id);
                if (xdAuthorityHolder == null) break block14;
                XdAuthorityHolder xdAuthorityHolder2 = xdAuthorityHolder;
                XdAuthorityHolder $receiver = xdAuthorityHolder2;
                XdAuthorityHolder xdAuthorityHolder3 = $receiver;
                if (xdAuthorityHolder3 instanceof XdProjectTeam) {
                    if (canRead) {
                        JetPassReadonlyDAOUtilKt.checkReadable((XdEntity)$receiver, this.getProjectTeamDAO());
                    }
                    if (canUpdate) {
                        JetPassReadonlyDAOUtilKt.checkUpdatable((XdEntity)$receiver, this.getProjectTeamDAO());
                    }
                    if (canDelete2) {
                        JetPassReadonlyDAOUtilKt.checkDeletable((XdEntity)$receiver, this.getProjectTeamDAO());
                    }
                } else if (xdAuthorityHolder3 instanceof XdBaseUserGroup) {
                    if (canRead) {
                        JetPassReadonlyDAOUtilKt.checkReadable((XdEntity)$receiver, this.getUserGroupDAO());
                    }
                    if (canUpdate) {
                        JetPassReadonlyDAOUtilKt.checkUpdatable((XdEntity)$receiver, this.getUserGroupDAO());
                    }
                    if (canDelete2) {
                        JetPassReadonlyDAOUtilKt.checkDeletable((XdEntity)$receiver, this.getUserGroupDAO());
                    }
                } else {
                    Void void_ = this.throwEntityIsNotSupported((XdEntity)$receiver);
                    throw null;
                }
                if ((xdAuthorityHolder = xdAuthorityHolder2) != null) break block15;
            }
            throw (Throwable)new ItemNotFoundException(UserGroup.class.getSimpleName(), id);
        }
        return xdAuthorityHolder;
    }

    @NotNull
    public static /* bridge */ /* synthetic */ XdAuthorityHolder resolve$default(JetPassUserGroupDelegatingDAO jetPassUserGroupDelegatingDAO, String string, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = false;
        }
        if ((n & 8) != 0) {
            bl3 = false;
        }
        return jetPassUserGroupDelegatingDAO.resolve(string, bl, bl2, bl3);
    }

    @NotNull
    public final UserGroup wrapEntityAsGroup(@NotNull XdAuthorityHolder xd) {
        UserGroup userGroup;
        Intrinsics.checkParameterIsNotNull((Object)xd, (String)"xd");
        XdAuthorityHolder xdAuthorityHolder = xd;
        if (xdAuthorityHolder instanceof XdProjectTeam) {
            ProjectTeam projectTeam = this.getProjectTeamDAO().wrapEntity((XdProjectTeam)xd);
            if (projectTeam == null) {
                throw new TypeCastException("null cannot be cast to non-null type jetbrains.jetpass.dao.dnq.api.authority.JetPassProjectTeam");
            }
            userGroup = JetPassProjectTeamKt.toTeamGroup((JetPassProjectTeam)projectTeam);
        } else if (xdAuthorityHolder instanceof XdBaseUserGroup) {
            userGroup = this.getUserGroupDAO().wrapEntity((XdBaseUserGroup)xd);
        } else {
            Void void_ = this.throwEntityIsNotSupported((XdEntity)xd);
            throw null;
        }
        return userGroup;
    }

    public final void uniformlyAddUser(@NotNull String groupId, @NotNull XdBaseUser xdUser) {
        block0: {
            boolean alreadyContainedTransitiveUser;
            XdAuthorityHolder xdAuthorityHolder;
            XdAuthorityHolder xd;
            block1: {
                Intrinsics.checkParameterIsNotNull((Object)groupId, (String)"groupId");
                Intrinsics.checkParameterIsNotNull((Object)xdUser, (String)"xdUser");
                XdAuthorityHolder xdAuthorityHolder2 = this.resolveOrNull(groupId);
                if (xdAuthorityHolder2 == null) break block0;
                XdAuthorityHolder xdAuthorityHolder3 = xdAuthorityHolder2;
                xd = xdAuthorityHolder3;
                xdAuthorityHolder = xd;
                if (!(xdAuthorityHolder instanceof XdBaseUserGroup)) break block1;
                ((XdBaseUserGroup)xd).addUser(xdUser);
                break block0;
            }
            if (!(xdAuthorityHolder instanceof XdProjectTeam) || (alreadyContainedTransitiveUser = ((Boolean)TransactionKt.legacyTransactional$default((boolean)false, null, (boolean)true, (Function1)((Function1)new Function1<TransientStoreSession, Boolean>(xd, xdUser){
                final /* synthetic */ XdAuthorityHolder $xd;
                final /* synthetic */ XdBaseUser $xdUser$inlined;
                {
                    this.$xd = xdAuthorityHolder;
                    this.$xdUser$inlined = xdBaseUser;
                    super(1);
                }

                public final boolean invoke(@NotNull TransientStoreSession it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return XdQueryKt.contains((XdQuery)((XdQuery)((XdProjectTeam)this.$xd).getTransitiveUsers()), (XdEntity)((XdEntity)this.$xdUser$inlined));
                }
            }), (int)3, null)).booleanValue())) break block0;
            ((XdProjectTeam)xd).getUsers().add((XdEntity)xdUser);
        }
    }

    @NotNull
    public final jetbrains.jetpass.sequence.Sequence<AuthorityHolder> combineSequences(@NotNull jetbrains.jetpass.sequence.Sequence<? extends UserGroup> groups, @NotNull jetbrains.jetpass.sequence.Sequence<? extends ProjectTeam> teams) {
        Intrinsics.checkParameterIsNotNull(groups, (String)"groups");
        Intrinsics.checkParameterIsNotNull(teams, (String)"teams");
        QueryExecutor<XdAuthorityHolder> queryExecutor = this.getMixedQueryExecutor();
        if (queryExecutor == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.jetpass.dao.dnq.api.authority.JetPassUserGroupDelegatingDAO.GroupsAndTeamsQueryExecutor");
        }
        return (jetbrains.jetpass.sequence.Sequence)new GroupsAndTeamsUnionSequence((GroupsAndTeamsQueryExecutor)queryExecutor, this.getUserGroupDAO(), this.getProjectTeamDAO(), groups, teams);
    }

    private final Void throwEntityIsNotSupported(XdEntity xd) {
        throw (Throwable)new DataAccessException("Entity type [" + ReflectionUtilKt.getEntityType(xd.getClass()).getEntityType() + "] as user group is not supported");
    }

    private final <T> T takeIfInitialApi(Function0<? extends T> body) {
        return (T)(APIInvocationContextKt.isApiRequested(APIVersion.NEW_TEAMS) ? null : body.invoke());
    }

    private final void rethrowIfNotInitialApi(@NotNull Exception $receiver) {
        if (APIInvocationContextKt.isApiRequested(APIVersion.NEW_TEAMS)) {
            throw (Throwable)$receiver;
        }
    }

    @NotNull
    public final JetPassDAOContainer getContainer() {
        return this.container;
    }

    public JetPassUserGroupDelegatingDAO(@NotNull JetPassDAOContainer container) {
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        this.container = container;
        this.mixedQueryExecutor$delegate = LazyKt.lazy((Function0)((Function0)new Function0<GroupsAndTeamsQueryExecutor>(this){
            final /* synthetic */ JetPassUserGroupDelegatingDAO this$0;

            @NotNull
            public final GroupsAndTeamsQueryExecutor invoke() {
                return new GroupsAndTeamsQueryExecutor(this.this$0.getUserGroupDAO().getSecurity(), this.this$0.getProjectTeamDAO().getSecurity());
            }
            {
                this.this$0 = jetPassUserGroupDelegatingDAO;
                super(0);
            }
        }));
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u0004\u00a2\u0006\u0002\u0010\b\u00a8\u0006\t"}, d2={"Ljetbrains/jetpass/dao/dnq/api/authority/JetPassUserGroupDelegatingDAO$GroupsAndTeamsQueryExecutor;", "Ljetbrains/jetpass/dao/dnq/query/QueryExecutor;", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdAuthorityHolder;", "groupsSecurity", "Ljetbrains/jetpass/dao/dnq/api/security/Security;", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdBaseUserGroup;", "teamsSecurity", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdProjectTeam;", "(Ljetbrains/jetpass/dao/dnq/api/security/Security;Ljetbrains/jetpass/dao/dnq/api/security/Security;)V", "jetbrains.jetpass.dao.dnq"})
    private static final class GroupsAndTeamsQueryExecutor
    extends QueryExecutor<XdAuthorityHolder> {
        public GroupsAndTeamsQueryExecutor(@NotNull Security<XdBaseUserGroup> groupsSecurity, @NotNull Security<XdProjectTeam> teamsSecurity) {
            Intrinsics.checkParameterIsNotNull(groupsSecurity, (String)"groupsSecurity");
            Intrinsics.checkParameterIsNotNull(teamsSecurity, (String)"teamsSecurity");
            super((XdEntityType)XdAuthorityHolder.Companion, new GroupsAndTeamsSecurity(groupsSecurity, teamsSecurity));
            this.setFieldExecutorBundles(CollectionsKt.listOf((Object)((Object)new GroupAndTeamFieldExecutorBundle())));
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001\u00a2\u0006\u0002\u0010\u0007J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0002H\u0016J\u001a\u0010\u000b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u00022\u0006\u0010\f\u001a\u00020\tH\u0016J\u0012\u0010\r\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u0002H\u0016J\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u000fH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00040\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ljetbrains/jetpass/dao/dnq/api/authority/JetPassUserGroupDelegatingDAO$GroupsAndTeamsSecurity;", "Ljetbrains/jetpass/dao/dnq/api/security/Security;", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdAuthorityHolder;", "groupsSecurity", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdBaseUserGroup;", "teamsSecurity", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdProjectTeam;", "(Ljetbrains/jetpass/dao/dnq/api/security/Security;Ljetbrains/jetpass/dao/dnq/api/security/Security;)V", "canDelete", "", "xd", "canRead", "full", "canUpdate", "filter", "Lkotlinx/dnq/query/XdQuery;", "unsecured", "jetbrains.jetpass.dao.dnq"})
    private static final class GroupsAndTeamsSecurity
    implements Security<XdAuthorityHolder> {
        private final Security<XdBaseUserGroup> groupsSecurity;
        private final Security<XdProjectTeam> teamsSecurity;

        @Override
        public boolean canRead(@Nullable XdAuthorityHolder xd, boolean full) {
            XdAuthorityHolder xdAuthorityHolder = xd;
            return xdAuthorityHolder instanceof XdBaseUserGroup ? this.groupsSecurity.canRead((XdBaseUserGroup)((XdEntity)xd), full) : (xdAuthorityHolder instanceof XdProjectTeam ? this.teamsSecurity.canRead((XdProjectTeam)((XdEntity)xd), full) : false);
        }

        @Override
        public boolean canUpdate(@Nullable XdAuthorityHolder xd) {
            XdAuthorityHolder xdAuthorityHolder = xd;
            return xdAuthorityHolder instanceof XdBaseUserGroup ? this.groupsSecurity.canUpdate((XdBaseUserGroup)((XdEntity)xd)) : (xdAuthorityHolder instanceof XdProjectTeam ? this.teamsSecurity.canUpdate((XdProjectTeam)((XdEntity)xd)) : false);
        }

        @Override
        public boolean canDelete(@Nullable XdAuthorityHolder xd) {
            XdAuthorityHolder xdAuthorityHolder = xd;
            return xdAuthorityHolder instanceof XdBaseUserGroup ? this.groupsSecurity.canDelete((XdBaseUserGroup)((XdEntity)xd)) : (xdAuthorityHolder instanceof XdProjectTeam ? this.teamsSecurity.canDelete((XdProjectTeam)((XdEntity)xd)) : false);
        }

        @Override
        @NotNull
        public XdQuery<XdAuthorityHolder> filter(@NotNull XdQuery<? extends XdAuthorityHolder> unsecured) {
            Intrinsics.checkParameterIsNotNull(unsecured, (String)"unsecured");
            return XdQueryKt.union(this.groupsSecurity.filter((XdQuery<XdBaseUserGroup>)XdQueryKt.filterIsInstance(unsecured, (XdEntityType)((XdEntityType)XdBaseUserGroup.Companion))), this.teamsSecurity.filter((XdQuery<XdProjectTeam>)XdQueryKt.filterIsInstance(unsecured, (XdEntityType)((XdEntityType)XdProjectTeam.Companion))));
        }

        public GroupsAndTeamsSecurity(@NotNull Security<XdBaseUserGroup> groupsSecurity, @NotNull Security<XdProjectTeam> teamsSecurity) {
            Intrinsics.checkParameterIsNotNull(groupsSecurity, (String)"groupsSecurity");
            Intrinsics.checkParameterIsNotNull(teamsSecurity, (String)"teamsSecurity");
            this.groupsSecurity = groupsSecurity;
            this.teamsSecurity = teamsSecurity;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B9\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u0012\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\n\u00a2\u0006\u0002\u0010\u000eJ%\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\u0006\u0010\u0012\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\n2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0010H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Ljetbrains/jetpass/dao/dnq/api/authority/JetPassUserGroupDelegatingDAO$GroupsAndTeamsUnionSequence;", "Ljetbrains/jetpass/dao/dnq/api/sequence/UnionSequence;", "Ljetbrains/jetpass/api/authority/AuthorityHolder;", "executor", "Ljetbrains/jetpass/dao/dnq/api/authority/JetPassUserGroupDelegatingDAO$GroupsAndTeamsQueryExecutor;", "groupDAO", "Ljetbrains/jetpass/dao/dnq/api/authority/JetPassUserGroupDAO;", "teamsDAO", "Ljetbrains/jetpass/dao/dnq/api/security/JetPassProjectTeamDAO;", "groups", "Ljetbrains/jetpass/sequence/Sequence;", "Ljetbrains/jetpass/api/authority/UserGroup;", "teams", "Ljetbrains/jetpass/api/authority/ProjectTeam;", "(Ljetbrains/jetpass/dao/dnq/api/authority/JetPassUserGroupDelegatingDAO$GroupsAndTeamsQueryExecutor;Ljetbrains/jetpass/dao/dnq/api/authority/JetPassUserGroupDAO;Ljetbrains/jetpass/dao/dnq/api/security/JetPassProjectTeamDAO;Ljetbrains/jetpass/sequence/Sequence;Ljetbrains/jetpass/sequence/Sequence;)V", "nameProp", "", "orderBy", "fieldName", "asc", "", "(Ljava/lang/String;Ljava/lang/Boolean;)Ljetbrains/jetpass/sequence/Sequence;", "query", "jetbrains.jetpass.dao.dnq"})
    private static final class GroupsAndTeamsUnionSequence
    extends UnionSequence<AuthorityHolder> {
        private final String nameProp;
        private final GroupsAndTeamsQueryExecutor executor;
        private final JetPassUserGroupDAO groupDAO;
        private final JetPassProjectTeamDAO teamsDAO;

        @Override
        @NotNull
        public jetbrains.jetpass.sequence.Sequence<AuthorityHolder> query(@Nullable String query2) {
            return (jetbrains.jetpass.sequence.Sequence)TransactionKt.legacyTransactional$default((boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, GroupsAndTeamsUnionSequence>(this, query2){
                final /* synthetic */ GroupsAndTeamsUnionSequence this$0;
                final /* synthetic */ String $query;

                @NotNull
                public final GroupsAndTeamsUnionSequence invoke(@NotNull TransientStoreSession it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    QueryExecutor.ParseResult result = GroupsAndTeamsUnionSequence.access$getExecutor$p(this.this$0).parse(this.$query);
                    XdQuery<XD> queried = result.execute();
                    return new GroupsAndTeamsUnionSequence(GroupsAndTeamsUnionSequence.access$getExecutor$p(this.this$0), GroupsAndTeamsUnionSequence.access$getGroupDAO$p(this.this$0), GroupsAndTeamsUnionSequence.access$getTeamsDAO$p(this.this$0), JetPassReadonlyDAOUtilKt.toSequence(XdQueryKt.filterIsInstance(queried, (XdEntityType)((XdEntityType)XdBaseUserGroup.Companion)), GroupsAndTeamsUnionSequence.access$getGroupDAO$p(this.this$0)), JetPassReadonlyDAOUtilKt.toSequence(XdQueryKt.filterIsInstance(queried, (XdEntityType)((XdEntityType)XdProjectTeam.Companion)), GroupsAndTeamsUnionSequence.access$getTeamsDAO$p(this.this$0)));
                }
                {
                    this.this$0 = groupsAndTeamsUnionSequence;
                    this.$query = string;
                    super(1);
                }
            }), (int)7, null);
        }

        @Override
        @NotNull
        public jetbrains.jetpass.sequence.Sequence<AuthorityHolder> orderBy(@NotNull String fieldName, @Nullable Boolean asc) {
            jetbrains.jetpass.sequence.Sequence sequence;
            Intrinsics.checkParameterIsNotNull((Object)fieldName, (String)"fieldName");
            String string = fieldName;
            if (Intrinsics.areEqual((Object)string, (Object)this.nameProp)) {
                Boolean bl = asc;
                SortingIterator iterator2 = new SortingIterator(this.getLeft().orderBy(fieldName, asc).iterator(), this.getRight().orderBy(fieldName, asc).iterator(), orderBy.iterator.1.INSTANCE, bl != null ? bl : true);
                sequence = (jetbrains.jetpass.sequence.Sequence)new ListSequence(SequencesKt.toList((Sequence)SequencesKt.asSequence((Iterator)iterator2)));
            } else {
                sequence = super.orderBy(fieldName, asc);
            }
            return sequence;
        }

        public GroupsAndTeamsUnionSequence(@NotNull GroupsAndTeamsQueryExecutor executor, @NotNull JetPassUserGroupDAO groupDAO, @NotNull JetPassProjectTeamDAO teamsDAO, @NotNull jetbrains.jetpass.sequence.Sequence<? extends UserGroup> groups, @NotNull jetbrains.jetpass.sequence.Sequence<? extends ProjectTeam> teams) {
            Intrinsics.checkParameterIsNotNull((Object)executor, (String)"executor");
            Intrinsics.checkParameterIsNotNull((Object)groupDAO, (String)"groupDAO");
            Intrinsics.checkParameterIsNotNull((Object)teamsDAO, (String)"teamsDAO");
            Intrinsics.checkParameterIsNotNull(groups, (String)"groups");
            Intrinsics.checkParameterIsNotNull(teams, (String)"teams");
            super(groups, teams);
            this.executor = executor;
            this.groupDAO = groupDAO;
            this.teamsDAO = teamsDAO;
            this.nameProp = NamesKt.getStrippedName((KFunction)nameProp.1.INSTANCE);
        }

        @NotNull
        public static final /* synthetic */ GroupsAndTeamsQueryExecutor access$getExecutor$p(GroupsAndTeamsUnionSequence $this) {
            return $this.executor;
        }

        @NotNull
        public static final /* synthetic */ JetPassUserGroupDAO access$getGroupDAO$p(GroupsAndTeamsUnionSequence $this) {
            return $this.groupDAO;
        }

        @NotNull
        public static final /* synthetic */ JetPassProjectTeamDAO access$getTeamsDAO$p(GroupsAndTeamsUnionSequence $this) {
            return $this.teamsDAO;
        }
    }
}

