/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.dao.dnq.api.authority.login;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.env.ReadonlyTransactionException;
import jetbrains.jetpass.api.IdItem;
import jetbrains.jetpass.api.Service;
import jetbrains.jetpass.api.authority.User;
import jetbrains.jetpass.api.authority.details.UserDetails;
import jetbrains.jetpass.api.authority.login.TransientAuthAttempt;
import jetbrains.jetpass.api.authority.module.AuthModule;
import jetbrains.jetpass.api.authority.module.Credentials;
import jetbrains.jetpass.api.authority.module.LoginContext;
import jetbrains.jetpass.api.authority.module.UserCreationAuthModule;
import jetbrains.jetpass.auth.module.dnq.authentication.AuthenticationException;
import jetbrains.jetpass.auth.module.dnq.authentication.ResolveResult;
import jetbrains.jetpass.auth.module.dnq.authentication.UsernamePasswordCredentials;
import jetbrains.jetpass.auth.module.dnq.authentication.login.ErrorMessage;
import jetbrains.jetpass.auth.module.dnq.authentication.login.LoginHandler;
import jetbrains.jetpass.auth.module.dnq.authentication.login.OneTimeMessage;
import jetbrains.jetpass.core.lang.Either;
import jetbrains.jetpass.core.lang.Try;
import jetbrains.jetpass.core.throttling.RateLimiter;
import jetbrains.jetpass.dao.api.DataAccessException;
import jetbrains.jetpass.dao.api.LicenseViolationException;
import jetbrains.jetpass.dao.api.ServiceIsReadonlyException;
import jetbrains.jetpass.dao.dnq.LogMarkers;
import jetbrains.jetpass.dao.dnq.api.JetPassDAOContainer;
import jetbrains.jetpass.dao.dnq.api.JetPassReadOnlyDAO;
import jetbrains.jetpass.dao.dnq.api.JetPassServiceDAO;
import jetbrains.jetpass.dao.dnq.api.authority.JetPassUser;
import jetbrains.jetpass.dao.dnq.api.authority.JetPassUserDAO;
import jetbrains.jetpass.dao.dnq.api.authority.details.JetPassUserDetailsDAO;
import jetbrains.jetpass.dao.dnq.api.authority.login.AggregateAuthenticationException;
import jetbrains.jetpass.dao.dnq.api.authority.login.AuthBadCredentials;
import jetbrains.jetpass.dao.dnq.api.authority.login.AuthError;
import jetbrains.jetpass.dao.dnq.api.authority.login.BadCredentialsException;
import jetbrains.jetpass.dao.dnq.api.authority.login.LoginError;
import jetbrains.jetpass.dao.dnq.api.authority.login.LoginHandlerImpl;
import jetbrains.jetpass.dao.dnq.api.authority.login.LoginHandlerImplKt;
import jetbrains.jetpass.dao.dnq.api.authority.login.LoginResult;
import jetbrains.jetpass.dao.dnq.api.authority.login.LoginSuccess;
import jetbrains.jetpass.dao.dnq.api.authority.login.ResolveError;
import jetbrains.jetpass.dao.dnq.api.authority.login.TransientAuthAttemptImpl;
import jetbrains.jetpass.dao.dnq.api.authority.module.AuthModuleProvider;
import jetbrains.jetpass.dao.dnq.api.authority.module.JetPassAuthModuleDAO;
import jetbrains.jetpass.dao.dnq.api.authority.module.UserCreationAuthModuleProvider;
import jetbrains.jetpass.dao.dnq.authModule.AuthModuleProviderManager;
import jetbrains.jetpass.dao.dnq.throttling.FailedLoginIP;
import jetbrains.jetpass.dao.dnq.throttling.ThrottlingException;
import jetbrains.jetpass.dao.dnq.throttling.ThrottlingUtilsKt;
import jetbrains.jetpass.dnq.TransactionKt;
import jetbrains.jetpass.spring.SpringUtils;
import jetbrains.jetpass.userManagement.persistence.dnq.XdBaseUser;
import jetbrains.jetpass.userManagement.persistence.dnq.XdBaseUserDetails;
import jetbrains.jetpass.userManagement.persistence.dnq.XdInternalSettings;
import jetbrains.jetpass.userManagement.persistence.dnq.XdService;
import jetbrains.jetpass.userManagement.persistence.dnq.XdUser;
import jetbrains.jetpass.userManagement.persistence.dnq.module.XdAuthModule;
import jetbrains.jetpass.userManagement.persistence.dnq.module.XdExternalAuthModule;
import jetbrains.jetpass.userManagement.persistence.dnq.module.XdUserCreationAuthModule;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdExtensionsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import mu.KLogger;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="loginHandler")
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u00f8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 j2\u00020\u0001:\u0002jkB\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010(\u001a\u0012\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020+0)j\u0002`,2\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200H\u0002J$\u00101\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u0002030)2\u0006\u00104\u001a\u00020*2\u0006\u00105\u001a\u000206H\u0002J\u0016\u00107\u001a\b\u0012\u0004\u0012\u00020.082\u0006\u0010/\u001a\u000200H\u0002J\u0018\u00109\u001a\n\u0012\u0004\u0012\u00020:\u0018\u0001082\u0006\u0010;\u001a\u00020\u0018H\u0016J\u001e\u0010<\u001a\u00020=2\u0006\u0010/\u001a\u0002002\f\u0010>\u001a\b\u0012\u0004\u0012\u00020.08H\u0002J\u0010\u0010?\u001a\u00020@2\u0006\u0010/\u001a\u000200H\u0016J0\u0010A\u001a\u0018\u0012\u0004\u0012\u00020@\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030C080B2\u0006\u0010/\u001a\u0002002\b\u0010D\u001a\u0004\u0018\u00010EH\u0002J0\u0010F\u001a\u0018\u0012\u0004\u0012\u00020@\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030C080B2\u0006\u0010/\u001a\u00020G2\b\u0010D\u001a\u0004\u0018\u00010EH\u0002J,\u0010H\u001a\u000e\u0012\u0004\u0012\u000202\u0012\u0004\u0012\u0002030)2\u0006\u00104\u001a\u00020*2\u0006\u0010I\u001a\u00020J2\u0006\u00105\u001a\u000206H\u0002J\u0016\u0010K\u001a\u00020\u00182\f\u0010L\u001a\b\u0012\u0004\u0012\u00020:08H\u0016J6\u0010M\u001a\u000e\u0012\u0004\u0012\u00020@\u0012\u0004\u0012\u0002030)2\u0006\u00104\u001a\u00020*2\u0006\u00105\u001a\u0002062\b\u0010D\u001a\u0004\u0018\u00010E2\u0006\u0010N\u001a\u00020OH\u0016J\"\u0010P\u001a\u0014\u0012\u0004\u0012\u00020R\u0012\u0004\u0012\u00020S\u0012\u0004\u0012\u00020@0Q2\u0006\u0010T\u001a\u00020SH\u0002J&\u0010U\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020+0)j\u0002`,0V2\u0006\u0010/\u001a\u000200H\u0016J&\u0010W\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020+0)j\u0002`,0V2\u0006\u0010/\u001a\u000200H\u0002J&\u0010X\u001a\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020+0)j\u0002`,0V2\u0006\u0010/\u001a\u00020GH\u0002J\u0018\u0010Y\u001a\u00020=2\u0006\u0010Z\u001a\u00020@2\u0006\u0010[\u001a\u00020@H\u0002J\u0018\u0010\\\u001a\u00020=2\u0006\u00104\u001a\u00020*2\u0006\u0010]\u001a\u000202H\u0002J\u001c\u0010\\\u001a\u00020=2\u0006\u00104\u001a\u00020*2\n\u0010^\u001a\u00060_j\u0002``H\u0002J\u0012\u0010a\u001a\u00020b*\b\u0012\u0004\u0012\u00020308H\u0002J\"\u0010c\u001a\u00020O*\u0018\u0012\u0004\u0012\u00020@\u0012\u000e\u0012\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030C080BH\u0002J\"\u0010c\u001a\u00020O*\u0018\u0012\u0014\u0012\u0012\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020+0)j\u0002`,0VH\u0002J2\u0010d\u001a\b\u0012\u0004\u0012\u0002He08\"\u0004\b\u0000\u0010e*\b\u0012\u0004\u0012\u0002He0f2\u0012\u0010g\u001a\u000e\u0012\u0004\u0012\u0002He\u0012\u0004\u0012\u00020O0hH\u0002J\f\u0010i\u001a\u00020b*\u000203H\u0002R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001b\u0010\t\u001a\u00020\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u000e\u001a\u0004\b\u0013\u0010\u0014R!\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00180\u00178BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u000e\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001c\u001a\u00020\u001d8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010 \u001a\u00020!8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0011\u0010$\u001a\u00020%8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010'\u00a8\u0006l"}, d2={"Ljetbrains/jetpass/dao/dnq/api/authority/login/LoginHandlerImpl;", "Ljetbrains/jetpass/auth/module/dnq/authentication/login/LoginHandler;", "daoContainer", "Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "(Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;)V", "authModuleDAO", "Ljetbrains/jetpass/dao/dnq/api/authority/module/JetPassAuthModuleDAO;", "getAuthModuleDAO", "()Ljetbrains/jetpass/dao/dnq/api/authority/module/JetPassAuthModuleDAO;", "authModuleProviderManager", "Ljetbrains/jetpass/dao/dnq/authModule/AuthModuleProviderManager;", "getAuthModuleProviderManager", "()Ljetbrains/jetpass/dao/dnq/authModule/AuthModuleProviderManager;", "authModuleProviderManager$delegate", "Lkotlin/properties/ReadOnlyProperty;", "getDaoContainer", "()Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "failedLoginIP", "Ljetbrains/jetpass/dao/dnq/throttling/FailedLoginIP;", "getFailedLoginIP", "()Ljetbrains/jetpass/dao/dnq/throttling/FailedLoginIP;", "failedLoginIP$delegate", "loginThrottler", "Ljetbrains/jetpass/core/throttling/RateLimiter;", "", "getLoginThrottler", "()Ljetbrains/jetpass/core/throttling/RateLimiter;", "loginThrottler$delegate", "serviceDAO", "Ljetbrains/jetpass/dao/dnq/api/JetPassServiceDAO;", "getServiceDAO", "()Ljetbrains/jetpass/dao/dnq/api/JetPassServiceDAO;", "userDAO", "Ljetbrains/jetpass/dao/dnq/api/authority/JetPassUserDAO;", "getUserDAO", "()Ljetbrains/jetpass/dao/dnq/api/authority/JetPassUserDAO;", "userDetailsDAO", "Ljetbrains/jetpass/dao/dnq/api/authority/details/JetPassUserDetailsDAO;", "getUserDetailsDAO", "()Ljetbrains/jetpass/dao/dnq/api/authority/details/JetPassUserDetailsDAO;", "authenticate", "Ljetbrains/jetpass/core/lang/Try;", "Ljetbrains/jetpass/api/authority/login/TransientAuthAttempt;", "Ljetbrains/jetpass/auth/module/dnq/authentication/AuthenticationException;", "Ljetbrains/jetpass/dao/dnq/api/authority/login/AuthAttemptTry;", "authModule", "Ljetbrains/jetpass/userManagement/persistence/dnq/module/XdAuthModule;", "credentials", "Ljetbrains/jetpass/api/authority/module/Credentials;", "createNewUser", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdBaseUserDetails;", "Ljetbrains/jetpass/dao/api/DataAccessException;", "authAttempt", "loginContext", "Ljetbrains/jetpass/api/authority/module/LoginContext;", "getApplicableModules", "", "getMessages", "Ljetbrains/jetpass/auth/module/dnq/authentication/login/OneTimeMessage;", "token", "logApplicableModules", "", "applicableModules", "login", "Ljetbrains/jetpass/api/authority/details/UserDetails;", "loginPlain", "Ljetbrains/jetpass/core/lang/Either;", "Ljetbrains/jetpass/dao/dnq/api/authority/login/LoginError;", "clientService", "Ljetbrains/jetpass/api/Service;", "loginThrottled", "Ljetbrains/jetpass/auth/module/dnq/authentication/UsernamePasswordCredentials;", "mergeDetailsToSimilarUser", "similarUser", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdUser;", "putMessages", "messages", "resolve", "mayCreateUsers", "", "resolveUserCreationProvider", "Ljetbrains/jetpass/dao/dnq/api/authority/module/UserCreationAuthModuleProvider;", "Ljetbrains/jetpass/api/authority/module/UserCreationAuthModule;", "Ljetbrains/jetpass/userManagement/persistence/dnq/module/XdUserCreationAuthModule;", "xdModule", "tryAuthenticate", "", "tryAuthenticatePlain", "tryAuthenticateThrottled", "tryUpdatePersistedDetails", "persistedDetails", "externalDetails", "writeLoginAudit", "xdDetails", "error", "Ljava/lang/Exception;", "Lkotlin/Exception;", "aggregate", "Ljetbrains/jetpass/dao/dnq/api/authority/login/AggregateAuthenticationException;", "hasErrors", "takeUntilInclusive", "T", "Lkotlin/sequences/Sequence;", "predicate", "Lkotlin/Function1;", "toAggregate", "Companion", "InternalAuthAttempt", "jetbrains.jetpass.dao.dnq"})
public final class LoginHandlerImpl
implements LoginHandler {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private final ReadOnlyProperty authModuleProviderManager$delegate;
    private final ReadOnlyProperty loginThrottler$delegate;
    private final ReadOnlyProperty failedLoginIP$delegate;
    @NotNull
    private final JetPassDAOContainer daoContainer;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(LoginHandlerImpl.class), "authModuleProviderManager", "getAuthModuleProviderManager()Ljetbrains/jetpass/dao/dnq/authModule/AuthModuleProviderManager;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(LoginHandlerImpl.class), "loginThrottler", "getLoginThrottler()Ljetbrains/jetpass/core/throttling/RateLimiter;")), (KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(LoginHandlerImpl.class), "failedLoginIP", "getFailedLoginIP()Ljetbrains/jetpass/dao/dnq/throttling/FailedLoginIP;"))};
        Companion = new Companion(null);
    }

    private final AuthModuleProviderManager getAuthModuleProviderManager() {
        return (AuthModuleProviderManager)this.authModuleProviderManager$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    private final RateLimiter<String> getLoginThrottler() {
        return (RateLimiter)this.loginThrottler$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    private final FailedLoginIP getFailedLoginIP() {
        return (FailedLoginIP)this.failedLoginIP$delegate.getValue((Object)this, $$delegatedProperties[2]);
    }

    @NotNull
    public final JetPassAuthModuleDAO getAuthModuleDAO() {
        return this.daoContainer.getJetPassAuthModuleDAO();
    }

    @NotNull
    public final JetPassServiceDAO getServiceDAO() {
        return this.daoContainer.getJetPassServiceDAO();
    }

    @NotNull
    public final JetPassUserDetailsDAO getUserDetailsDAO() {
        return this.daoContainer.getJetPassUserDetailsDAO();
    }

    @NotNull
    public final JetPassUserDAO getUserDAO() {
        return this.daoContainer.getJetPassUserDAO();
    }

    @NotNull
    public UserDetails login(@NotNull Credentials credentials) {
        Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
        JetPassServiceDAO jetPassServiceDAO = this.getServiceDAO();
        LoginContext loginContext = credentials.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)loginContext, (String)"credentials.context");
        Service clientService = (Service)jetPassServiceDAO.get(loginContext.getClientServiceId());
        Credentials credentials2 = credentials;
        Either<UserDetails, List<LoginError<?>>> result = credentials2 instanceof UsernamePasswordCredentials ? this.loginThrottled((UsernamePasswordCredentials)credentials, clientService) : this.loginPlain(credentials, clientService);
        return (UserDetails)result.unfoldOrThrow(new Function1(this){
            final /* synthetic */ LoginHandlerImpl this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final Void invoke(@NotNull List<? extends LoginError<?>> loginErrors) {
                Iterable $receiver$iv$iv;
                Iterable $receiver$iv;
                Intrinsics.checkParameterIsNotNull(loginErrors, (String)"loginErrors");
                Iterable iterable = $receiver$iv = (Iterable)loginErrors;
                Collection destination$iv$iv = new ArrayList<E>();
                for (T element$iv$iv : $receiver$iv$iv) {
                    if (!(element$iv$iv instanceof ResolveError)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $receiver$iv = loginErrors;
                Collection collection = (List)destination$iv$iv;
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv = new ArrayList<E>();
                for (T element$iv$iv : $receiver$iv$iv) {
                    if (!(element$iv$iv instanceof AuthError)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List<E> list = (List)destination$iv$iv;
                $receiver$iv = loginErrors;
                collection = CollectionsKt.plus((Collection)collection, (Iterable)list);
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv = new ArrayList<E>();
                for (T element$iv$iv : $receiver$iv$iv) {
                    if (!(element$iv$iv instanceof AuthBadCredentials)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
                $receiver$iv = CollectionsKt.plus((Collection)collection, (Iterable)CollectionsKt.listOfNotNull((Object)CollectionsKt.lastOrNull((List)list)));
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    void it;
                    LoginError $i$f$filterIsInstanceTo = (LoginError)item$iv$iv;
                    collection = destination$iv$iv;
                    list = it.getError();
                    collection.add(list);
                }
                List<E> list2 = (List<E>)destination$iv$iv;
                List<E> it = list2;
                List<E> list3 = !it.isEmpty() ? list2 : null;
                if (list3 == null) {
                    list3 = CollectionsKt.listOf((Object)((Object)AuthenticationException.Companion.noAuthModules()));
                }
                List<E> errors = list3;
                throw (Throwable)((Object)LoginHandlerImpl.access$aggregate(this.this$0, errors));
            }
            {
                this.this$0 = loginHandlerImpl;
                super(1);
            }
        });
    }

    @NotNull
    public Try<UserDetails, DataAccessException> resolve(@NotNull TransientAuthAttempt authAttempt, @NotNull LoginContext loginContext, @Nullable Service clientService, boolean mayCreateUsers) {
        Intrinsics.checkParameterIsNotNull((Object)authAttempt, (String)"authAttempt");
        Intrinsics.checkParameterIsNotNull((Object)loginContext, (String)"loginContext");
        return (Try)TransactionKt.legacyTransactional$default((boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Try<? extends UserDetails, ? extends DataAccessException>>(this, authAttempt, loginContext, mayCreateUsers, clientService){
            final /* synthetic */ LoginHandlerImpl this$0;
            final /* synthetic */ TransientAuthAttempt $authAttempt;
            final /* synthetic */ LoginContext $loginContext;
            final /* synthetic */ boolean $mayCreateUsers;
            final /* synthetic */ Service $clientService;

            @NotNull
            public final Try<UserDetails, DataAccessException> invoke(@NotNull TransientStoreSession $noName_0) {
                AuthenticationException ex;
                XdBaseUserDetails xdDetails;
                XdUser similarUser;
                XdUser xdUser;
                UserDetails it;
                Object object;
                XdBaseUserDetails persistedDetails;
                XdBaseUserDetails xdBaseUserDetails;
                UserDetails it2;
                Object object2;
                UserDetails $receiver;
                Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                UserDetails userDetails = this.$authAttempt.getPersistedUserDetails();
                if (userDetails != null) {
                    UserDetails userDetails2;
                    UserDetails userDetails3 = $receiver = (userDetails2 = userDetails);
                    Intrinsics.checkExpressionValueIsNotNull((Object)userDetails3, (String)"this");
                    UserDetails userDetails4 = this.$authAttempt.getExternalUserDetails();
                    Intrinsics.checkExpressionValueIsNotNull((Object)userDetails4, (String)"authAttempt.externalUserDetails");
                    LoginHandlerImpl.access$tryUpdatePersistedDetails(this.this$0, userDetails3, userDetails4);
                }
                if ((object2 = this.$authAttempt.getPersistedUserDetails()) != null && (object2 = object2.getId()) != null) {
                    it2 = $receiver = object2;
                    xdBaseUserDetails = (XdBaseUserDetails)XdBaseUserDetails.Companion.resolve((String)it2);
                } else {
                    xdBaseUserDetails = persistedDetails = null;
                }
                if ((object = this.$authAttempt.getSimilarUser()) != null && (object = object.getId()) != null) {
                    it = it2 = object;
                    xdUser = (XdUser)XdUser.Companion.resolve((String)it);
                } else {
                    xdUser = similarUser = null;
                }
                if (persistedDetails == null && similarUser != null) {
                    Try mergeDetailsTry = LoginHandlerImpl.access$mergeDetailsToSimilarUser(this.this$0, this.$authAttempt, similarUser, this.$loginContext);
                    it = mergeDetailsTry;
                    if (it instanceof Try.Failure) {
                        LoginHandlerImpl.access$writeLoginAudit(this.this$0, this.$authAttempt, ((Try.Failure)mergeDetailsTry).getError());
                        return (Try)Try.Companion.fail(((Try.Failure)mergeDetailsTry).getError());
                    }
                    if (it instanceof Try.Success) {
                        persistedDetails = (XdBaseUserDetails)((Try.Success)mergeDetailsTry).getValue();
                    }
                }
                if (persistedDetails == null && this.$mayCreateUsers) {
                    Try createUserTry = LoginHandlerImpl.access$createNewUser(this.this$0, this.$authAttempt, this.$loginContext);
                    it = createUserTry;
                    if (it instanceof Try.Failure) {
                        LoginHandlerImpl.access$writeLoginAudit(this.this$0, this.$authAttempt, ((Try.Failure)createUserTry).getError());
                        return (Try)Try.Companion.fail(((Try.Failure)createUserTry).getError());
                    }
                    if (it instanceof Try.Success) {
                        persistedDetails = (XdBaseUserDetails)((Try.Success)createUserTry).getValue();
                    }
                }
                if ((xdDetails = persistedDetails) != null) {
                    XdService xdService;
                    LoginHandlerImpl.Companion.getLogger().debug((Function0)new Function0<String>(this, xdDetails){
                        final /* synthetic */ resolve.1 this$0;
                        final /* synthetic */ XdBaseUserDetails $xdDetails;

                        @NotNull
                        public final String invoke() {
                            StringBuilder stringBuilder = new StringBuilder().append("Auth module ");
                            AuthModule authModule = this.this$0.$authAttempt.getAuthModule();
                            Intrinsics.checkExpressionValueIsNotNull((Object)authModule, (String)"authAttempt.authModule");
                            return stringBuilder.append(authModule.getName()).append(": resolved details ").append(this.$xdDetails.getUuid()).toString();
                        }
                        {
                            this.this$0 = var1_1;
                            this.$xdDetails = xdBaseUserDetails;
                            super(0);
                        }
                    });
                    if (xdDetails.getUser().getBanned()) {
                        ex = AuthenticationException.Companion.userBanned(xdDetails.getUser().getLogin());
                        LoginHandlerImpl.access$writeLoginAudit(this.this$0, this.$authAttempt, (Exception)((Object)ex));
                        return (Try)Try.Companion.fail((Exception)((Object)ex));
                    }
                    if (this.$clientService != null && !(xdService = (XdService)JetPassReadOnlyDAO.resolve$default(this.this$0.getServiceDAO(), (IdItem)this.$clientService, false, false, 6, null)).isLicensedFor((XdBaseUser)xdDetails.getUser())) {
                        AuthenticationException ex2 = AuthenticationException.Companion.noLicense("You have no license for " + this.$clientService.getName());
                        LoginHandlerImpl.access$writeLoginAudit(this.this$0, this.$authAttempt, (Exception)((Object)ex2));
                        return (Try)Try.Companion.fail((Exception)((Object)ex2));
                    }
                    XdAuthModule xdAuthModule = xdDetails.getAuthSetting();
                    if (!(xdAuthModule instanceof XdExternalAuthModule)) {
                        xdAuthModule = null;
                    }
                    XdExternalAuthModule xdExternalAuthModule = (XdExternalAuthModule)xdAuthModule;
                    if (xdExternalAuthModule != null) {
                        xdExternalAuthModule.syncGroups(xdDetails);
                    }
                    UserDetails foundDetails = this.this$0.getUserDetailsDAO().wrapEntity(xdDetails);
                    LoginHandlerImpl.access$writeLoginAudit(this.this$0, this.$authAttempt, xdDetails);
                    return (Try)Try.Companion.success((Object)foundDetails);
                }
                ex = AuthenticationException.Companion.cantCreateUserDisabled();
                LoginHandlerImpl.access$writeLoginAudit(this.this$0, this.$authAttempt, (Exception)((Object)ex));
                return (Try)Try.Companion.fail((Exception)((Object)ex));
            }
            {
                this.this$0 = loginHandlerImpl;
                this.$authAttempt = transientAuthAttempt;
                this.$loginContext = loginContext;
                this.$mayCreateUsers = bl;
                this.$clientService = service;
                super(1);
            }
        }), (int)7, null);
    }

    @Nullable
    public List<OneTimeMessage> getMessages(@NotNull String token) {
        Intrinsics.checkParameterIsNotNull((Object)token, (String)"token");
        return (List)LoginHandlerImplKt.access$getMessageListStore$p().get(token);
    }

    @NotNull
    public String putMessages(@NotNull List<? extends OneTimeMessage> messages) {
        Intrinsics.checkParameterIsNotNull(messages, (String)"messages");
        return LoginHandlerImplKt.access$getMessageListStore$p().put(messages);
    }

    @NotNull
    public Iterable<Try<TransientAuthAttempt, AuthenticationException>> tryAuthenticate(@NotNull Credentials credentials) {
        Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
        return (Iterable)TransactionKt.legacyTransactional$default((boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, Iterable<? extends Try<? extends TransientAuthAttempt, ? extends AuthenticationException>>>(this, credentials){
            final /* synthetic */ LoginHandlerImpl this$0;
            final /* synthetic */ Credentials $credentials;

            @NotNull
            public final Iterable<Try<TransientAuthAttempt, AuthenticationException>> invoke(@NotNull TransientStoreSession it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Credentials credentials = this.$credentials;
                return credentials instanceof UsernamePasswordCredentials ? LoginHandlerImpl.access$tryAuthenticateThrottled(this.this$0, (UsernamePasswordCredentials)this.$credentials) : LoginHandlerImpl.access$tryAuthenticatePlain(this.this$0, this.$credentials);
            }
            {
                this.this$0 = loginHandlerImpl;
                this.$credentials = credentials;
                super(1);
            }
        }), (int)7, null);
    }

    private final Either<UserDetails, List<LoginError<?>>> loginPlain(Credentials credentials, Service clientService) {
        return (Either)TransactionKt.legacyTransactional$default((boolean)false, null, (boolean)false, (Function1)new Function1<TransientStoreSession, Either<? extends UserDetails, ? extends List<? extends LoginError<?>>>>(this, credentials, clientService){
            final /* synthetic */ LoginHandlerImpl this$0;
            final /* synthetic */ Credentials $credentials;
            final /* synthetic */ Service $clientService;

            @NotNull
            public final Either<UserDetails, List<LoginError<?>>> invoke(@NotNull TransientStoreSession $noName_0) {
                Either either;
                Iterable $receiver$iv$iv;
                Iterable $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                List results2 = CollectionsKt.toList((Iterable)LoginHandlerImpl.access$takeUntilInclusive(this.this$0, SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)LoginHandlerImpl.access$getApplicableModules(this.this$0, this.$credentials)), (Function1)((Function1)new Function1<XdAuthModule, LoginResult>(this){
                    final /* synthetic */ loginPlain.1 this$0;

                    /*
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @NotNull
                    public final LoginResult invoke(@NotNull XdAuthModule authModule) {
                        LoginResult loginResult;
                        Try authTry;
                        Intrinsics.checkParameterIsNotNull((Object)authModule, (String)"authModule");
                        LoginHandlerImplKt.access$getAuthMetrics$p().incLoginMeter(authModule.getName());
                        Try try_ = authTry = LoginHandlerImpl.access$authenticate(this.this$0.this$0, authModule, this.this$0.$credentials);
                        if (try_ instanceof Try.Success) {
                            Try<UserDetails, DataAccessException> resolveTry;
                            LoginHandlerImpl loginHandlerImpl = this.this$0.this$0;
                            TransientAuthAttempt transientAuthAttempt = (TransientAuthAttempt)((Try.Success)authTry).getValue();
                            LoginContext loginContext = this.this$0.$credentials.getContext();
                            Intrinsics.checkExpressionValueIsNotNull((Object)loginContext, (String)"credentials.context");
                            Try<UserDetails, DataAccessException> try_2 = resolveTry = loginHandlerImpl.resolve(transientAuthAttempt, loginContext, this.this$0.$clientService, true);
                            if (try_2 instanceof Try.Success) {
                                loginResult = new LoginSuccess((UserDetails)((Try.Success)resolveTry).getValue());
                                return loginResult;
                            } else {
                                if (!(try_2 instanceof Try.Failure)) throw new NoWhenBranchMatchedException();
                                loginResult = new ResolveError((DataAccessException)((Try.Failure)resolveTry).getError());
                            }
                            return loginResult;
                        } else {
                            if (!(try_ instanceof Try.Failure)) throw new NoWhenBranchMatchedException();
                            LoginHandlerImplKt.access$getAuthMetrics$p().incFailedLoginMeter(authModule.getName());
                            AuthenticationException error2 = (AuthenticationException)((Object)((Try.Failure)authTry).getError());
                            loginResult = error2 instanceof BadCredentialsException ? (LoginError)new AuthBadCredentials((BadCredentialsException)error2) : (LoginError)new AuthError(error2);
                        }
                        return loginResult;
                    }
                    {
                        this.this$0 = var1_1;
                        super(1);
                    }
                })), loginPlain.results.2.INSTANCE));
                Iterable iterable = $receiver$iv = (Iterable)results2;
                Collection destination$iv$iv = new ArrayList<E>();
                for (T element$iv$iv : $receiver$iv$iv) {
                    if (!(element$iv$iv instanceof LoginSuccess)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                LoginSuccess success = (LoginSuccess)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
                if (success != null) {
                    either = (Either)Either.Companion.success((Object)success.getDetails());
                } else {
                    LoginHandlerImpl.access$getFailedLoginIP$p(this.this$0).recordFailure();
                    $receiver$iv = results2;
                    Either.Companion companion = Either.Companion;
                    $receiver$iv$iv = $receiver$iv;
                    destination$iv$iv = new ArrayList<E>();
                    for (T element$iv$iv : $receiver$iv$iv) {
                        if (!(element$iv$iv instanceof LoginError)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List list = (List)destination$iv$iv;
                    either = (Either)companion.fail((Object)list);
                }
                return either;
            }
            {
                this.this$0 = loginHandlerImpl;
                this.$credentials = credentials;
                this.$clientService = service;
                super(1);
            }
        }, (int)7, null);
    }

    private final Either<UserDetails, List<LoginError<?>>> loginThrottled(UsernamePasswordCredentials credentials, Service clientService) {
        Either either;
        try {
            boolean isCaptchaVerified = credentials.isReCaptchaVerified();
            String captchaPublicKey = ((XdInternalSettings)XdInternalSettings.Companion.getInstance()).getCaptchaPublicKey();
            either = (Either)ThrottlingUtilsKt.throttled(this.getLoginThrottler(), credentials.getUsername(), captchaPublicKey, isCaptchaVerified, (Function1)new Function1<RateLimiter.LimiterSession, Either<? extends UserDetails, ? extends List<? extends LoginError<?>>>>(this, credentials, clientService, isCaptchaVerified, captchaPublicKey){
                final /* synthetic */ LoginHandlerImpl this$0;
                final /* synthetic */ UsernamePasswordCredentials $credentials;
                final /* synthetic */ Service $clientService;
                final /* synthetic */ boolean $isCaptchaVerified;
                final /* synthetic */ String $captchaPublicKey;

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Either<UserDetails, List<LoginError<?>>> invoke(@NotNull RateLimiter.LimiterSession throttling) {
                    Either either;
                    Intrinsics.checkParameterIsNotNull((Object)throttling, (String)"throttling");
                    Either loginResult = LoginHandlerImpl.access$loginPlain(this.this$0, (Credentials)this.$credentials, this.$clientService);
                    if (!LoginHandlerImpl.access$hasErrors(this.this$0, loginResult)) {
                        throttling.dontLimit();
                    }
                    if (this.$isCaptchaVerified && LoginHandlerImpl.access$hasErrors(this.this$0, loginResult)) {
                        AuthError error2 = new AuthError(ThrottlingException.Companion.failedWithCaptcha(this.$credentials.getUsername(), this.$captchaPublicKey));
                        Either either2 = loginResult;
                        if (either2 == null) {
                            throw new TypeCastException("null cannot be cast to non-null type jetbrains.jetpass.core.lang.Either.Failure<kotlin.collections.List<jetbrains.jetpass.dao.dnq.api.authority.login.LoginError<*>>>");
                        }
                        either = (Either)Either.Companion.fail((Object)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)error2), (Iterable)((Iterable)((Either.Failure)either2).getValue())));
                    } else {
                        void var2_2;
                        either = var2_2;
                    }
                    return either;
                }
                {
                    this.this$0 = loginHandlerImpl;
                    this.$credentials = usernamePasswordCredentials;
                    this.$clientService = service;
                    this.$isCaptchaVerified = bl;
                    this.$captchaPublicKey = string;
                    super(1);
                }
            });
        }
        catch (ThrottlingException ex) {
            Companion.getLogger().info((Function0)new Function0<String>(credentials, ex){
                final /* synthetic */ UsernamePasswordCredentials $credentials;
                final /* synthetic */ ThrottlingException $ex;

                @NotNull
                public final String invoke() {
                    return this.$credentials + " credentials were throttled: " + this.$ex.getMessage();
                }
                {
                    this.$credentials = usernamePasswordCredentials;
                    this.$ex = throttlingException;
                    super(0);
                }
            });
            throw (Throwable)((Object)this.toAggregate((DataAccessException)ex));
        }
        return either;
    }

    private final boolean hasErrors(@NotNull Either<? extends UserDetails, ? extends List<? extends LoginError<?>>> $receiver) {
        Collection collection;
        return $receiver instanceof Either.Failure && !(collection = (Collection)((Either.Failure)$receiver).getValue()).isEmpty();
    }

    private final <T> List<T> takeUntilInclusive(@NotNull Sequence<? extends T> $receiver, Function1<? super T, Boolean> predicate) {
        ArrayList result = new ArrayList();
        for (Object item : $receiver) {
            result.add(item);
            if (!((Boolean)predicate.invoke(item)).booleanValue()) continue;
            break;
        }
        return result;
    }

    private final Iterable<Try<TransientAuthAttempt, AuthenticationException>> tryAuthenticatePlain(Credentials credentials) {
        return (Iterable)TransactionKt.legacyTransactional$default((boolean)false, null, (boolean)false, (Function1)((Function1)new Function1<TransientStoreSession, List<? extends Try<? extends TransientAuthAttempt, ? extends AuthenticationException>>>(this, credentials){
            final /* synthetic */ LoginHandlerImpl this$0;
            final /* synthetic */ Credentials $credentials;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<Try<TransientAuthAttempt, AuthenticationException>> invoke(@NotNull TransientStoreSession it) {
                void $receiver$iv$iv;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                Iterable $receiver$iv = LoginHandlerImpl.access$getApplicableModules(this.this$0, this.$credentials);
                Iterable iterable = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                for (T item$iv$iv : $receiver$iv$iv) {
                    void it2;
                    XdAuthModule xdAuthModule = (XdAuthModule)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    Try try_ = LoginHandlerImpl.access$authenticate(this.this$0, (XdAuthModule)it2, this.$credentials);
                    collection.add(try_);
                }
                List list = (List)destination$iv$iv;
                List it3 = list;
                if (LoginHandlerImpl.access$hasErrors(this.this$0, it3)) {
                    LoginHandlerImpl.access$getFailedLoginIP$p(this.this$0).recordFailure();
                }
                return list;
            }
            {
                this.this$0 = loginHandlerImpl;
                this.$credentials = credentials;
                super(1);
            }
        }), (int)7, null);
    }

    private final Iterable<Try<TransientAuthAttempt, AuthenticationException>> tryAuthenticateThrottled(UsernamePasswordCredentials credentials) {
        return (Iterable)ThrottlingUtilsKt.throttled(this.getLoginThrottler(), credentials.getUsername(), ((XdInternalSettings)XdInternalSettings.Companion.getInstance()).getCaptchaPublicKey(), credentials.isReCaptchaVerified(), (Function1)new Function1<RateLimiter.LimiterSession, Iterable<? extends Try<? extends TransientAuthAttempt, ? extends AuthenticationException>>>(this, credentials){
            final /* synthetic */ LoginHandlerImpl this$0;
            final /* synthetic */ UsernamePasswordCredentials $credentials;

            @NotNull
            public final Iterable<Try<TransientAuthAttempt, AuthenticationException>> invoke(@NotNull RateLimiter.LimiterSession throttling) {
                Iterable iterable;
                Intrinsics.checkParameterIsNotNull((Object)throttling, (String)"throttling");
                Iterable authTries = iterable = LoginHandlerImpl.access$tryAuthenticatePlain(this.this$0, (Credentials)this.$credentials);
                if (!LoginHandlerImpl.access$hasErrors(this.this$0, authTries)) {
                    throttling.dontLimit();
                }
                return iterable;
            }
            {
                this.this$0 = loginHandlerImpl;
                this.$credentials = usernamePasswordCredentials;
                super(1);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean hasErrors(@NotNull Iterable<? extends Try<? extends TransientAuthAttempt, ? extends AuthenticationException>> $receiver) {
        Try<? extends TransientAuthAttempt, ? extends AuthenticationException> try_;
        Try<? extends TransientAuthAttempt, ? extends AuthenticationException> it;
        if (!CollectionsKt.any($receiver)) return false;
        Iterable<? extends Try<? extends TransientAuthAttempt, ? extends AuthenticationException>> $receiver$iv = $receiver;
        if ($receiver$iv instanceof Collection && ((Collection)$receiver$iv).isEmpty()) {
            return true;
        }
        Iterator<? extends Try<? extends TransientAuthAttempt, ? extends AuthenticationException>> iterator2 = $receiver$iv.iterator();
        do {
            if (!iterator2.hasNext()) return true;
        } while ((it = (try_ = iterator2.next())) instanceof Try.Failure);
        return false;
    }

    private final Try<TransientAuthAttempt, AuthenticationException> authenticate(XdAuthModule authModule, Credentials credentials) {
        JetPassUser jetPassUser;
        ResolveResult.SimilarUser similarUser;
        ResolveResult resolveResult;
        UserDetails userDetails;
        UserDetails userDetails2;
        ResolveResult.UserDetails it;
        Try.Companion companion;
        InternalAuthAttempt internalAuthAttempt;
        InternalAuthAttempt internalAuthAttempt2;
        TransientAuthAttemptImpl transientAuthAttemptImpl;
        TransientAuthAttemptImpl transientAuthAttemptImpl2;
        AuthModule authModule2;
        UserDetails userDetails3;
        ResolveResult.UserDetails userDetails4;
        ResolveResult.UserDetails userDetails5;
        TransientAuthAttemptImpl transientAuthAttemptImpl3;
        InternalAuthAttempt internalAuthAttempt3;
        UserDetails userDetails6;
        Companion.getLogger().debug((Function0)new Function0<String>(authModule, credentials){
            final /* synthetic */ XdAuthModule $authModule;
            final /* synthetic */ Credentials $credentials;

            @NotNull
            public final String invoke() {
                return "Auth module " + this.$authModule.getName() + ": try authenticate " + this.$credentials;
            }
            {
                this.$authModule = xdAuthModule;
                this.$credentials = credentials;
                super(0);
            }
        });
        try {
            userDetails6 = authModule.authenticate(credentials);
        }
        catch (AuthenticationException ex) {
            if (Companion.getLogger().isDebugEnabled()) {
                Companion.getLogger().debug((Throwable)ex, (Function0)new Function0<String>(authModule, credentials){
                    final /* synthetic */ XdAuthModule $authModule;
                    final /* synthetic */ Credentials $credentials;

                    @NotNull
                    public final String invoke() {
                        return "Auth module " + this.$authModule.getName() + ": cannot authenticate " + this.$credentials;
                    }
                    {
                        this.$authModule = xdAuthModule;
                        this.$credentials = credentials;
                        super(0);
                    }
                });
            } else {
                Companion.getLogger().info((Function0)new Function0<String>(authModule, credentials, ex){
                    final /* synthetic */ XdAuthModule $authModule;
                    final /* synthetic */ Credentials $credentials;
                    final /* synthetic */ AuthenticationException $ex;

                    @NotNull
                    public final String invoke() {
                        return "Auth module " + this.$authModule.getName() + ": cannot authenticate " + this.$credentials + ": " + this.$ex.getMessage();
                    }
                    {
                        this.$authModule = xdAuthModule;
                        this.$credentials = credentials;
                        this.$ex = authenticationException;
                        super(0);
                    }
                });
            }
            return (Try)Try.Companion.fail((Exception)((Object)ex));
        }
        catch (Exception ex) {
            Companion.getLogger().warn((Throwable)ex, (Function0)new Function0<String>(authModule, credentials){
                final /* synthetic */ XdAuthModule $authModule;
                final /* synthetic */ Credentials $credentials;

                @NotNull
                public final String invoke() {
                    return "Auth module " + this.$authModule.getName() + " produced unexpected error on the authentication of " + this.$credentials;
                }
                {
                    this.$authModule = xdAuthModule;
                    this.$credentials = credentials;
                    super(0);
                }
            });
            throw (Throwable)ex;
        }
        UserDetails details2 = userDetails6;
        if (details2 == null) {
            BadCredentialsException ex = new BadCredentialsException();
            Companion.getLogger().info((Function0)new Function0<String>(credentials, authModule, ex){
                final /* synthetic */ Credentials $credentials;
                final /* synthetic */ XdAuthModule $authModule;
                final /* synthetic */ BadCredentialsException $ex;

                @NotNull
                public final String invoke() {
                    return "Authentication of " + this.$credentials + " against " + this.$authModule.getName() + " module failed: " + this.$ex.getMessage();
                }
                {
                    this.$credentials = credentials;
                    this.$authModule = xdAuthModule;
                    this.$ex = badCredentialsException;
                    super(0);
                }
            });
            return (Try)Try.Companion.fail((Exception)((Object)ex));
        }
        Companion.getLogger().debug((Function0)new Function0<String>(authModule, credentials){
            final /* synthetic */ XdAuthModule $authModule;
            final /* synthetic */ Credentials $credentials;

            @NotNull
            public final String invoke() {
                return "Auth module " + this.$authModule.getName() + " authenticated: " + this.$credentials;
            }
            {
                this.$authModule = xdAuthModule;
                this.$credentials = credentials;
                super(0);
            }
        });
        AuthModuleProvider<AuthModule, XdAuthModule> authModuleProvider = this.getAuthModuleProviderManager().getProvider(authModule);
        JetPassUserDetailsDAO jetPassUserDetailsDAO = this.getUserDetailsDAO();
        LoginContext loginContext = credentials.getContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)loginContext, (String)"credentials.context");
        ResolveResult resolveResult2 = authModuleProvider.tryResolve(jetPassUserDetailsDAO, authModule, details2, loginContext);
        Try.Companion companion2 = Try.Companion;
        InternalAuthAttempt internalAuthAttempt4 = internalAuthAttempt3;
        InternalAuthAttempt internalAuthAttempt5 = internalAuthAttempt3;
        TransientAuthAttemptImpl transientAuthAttemptImpl4 = transientAuthAttemptImpl3;
        TransientAuthAttemptImpl transientAuthAttemptImpl5 = transientAuthAttemptImpl3;
        AuthModule authModule3 = this.getAuthModuleDAO().wrapEntity(authModule);
        UserDetails userDetails7 = details2;
        ResolveResult resolveResult3 = resolveResult2;
        if (!(resolveResult3 instanceof ResolveResult.UserDetails)) {
            resolveResult3 = null;
        }
        if ((userDetails5 = (ResolveResult.UserDetails)resolveResult3) != null && (userDetails5 = userDetails5.getUserDetails()) != null) {
            userDetails4 = userDetails5;
            userDetails3 = userDetails7;
            authModule2 = authModule3;
            transientAuthAttemptImpl2 = transientAuthAttemptImpl4;
            transientAuthAttemptImpl = transientAuthAttemptImpl5;
            internalAuthAttempt2 = internalAuthAttempt4;
            internalAuthAttempt = internalAuthAttempt5;
            companion = companion2;
            it = userDetails4;
            userDetails2 = this.getUserDetailsDAO().wrapEntity((XdBaseUserDetails)XdExtensionsKt.toXd((Entity)it));
            companion2 = companion;
            internalAuthAttempt5 = internalAuthAttempt;
            internalAuthAttempt4 = internalAuthAttempt2;
            transientAuthAttemptImpl5 = transientAuthAttemptImpl;
            transientAuthAttemptImpl4 = transientAuthAttemptImpl2;
            authModule3 = authModule2;
            userDetails7 = userDetails3;
            userDetails = userDetails2;
        } else {
            userDetails = null;
        }
        if (!((resolveResult = resolveResult2) instanceof ResolveResult.SimilarUser)) {
            resolveResult = null;
        }
        if ((similarUser = (ResolveResult.SimilarUser)resolveResult) != null && (similarUser = similarUser.getSimilarUser()) != null) {
            userDetails4 = similarUser;
            userDetails2 = userDetails;
            userDetails3 = userDetails7;
            authModule2 = authModule3;
            transientAuthAttemptImpl2 = transientAuthAttemptImpl4;
            transientAuthAttemptImpl = transientAuthAttemptImpl5;
            internalAuthAttempt2 = internalAuthAttempt4;
            internalAuthAttempt = internalAuthAttempt5;
            companion = companion2;
            it = userDetails4;
            JetPassUser jetPassUser2 = this.getUserDAO().wrapEntity((XdBaseUser)XdExtensionsKt.toXd((Entity)it));
            companion2 = companion;
            internalAuthAttempt5 = internalAuthAttempt;
            internalAuthAttempt4 = internalAuthAttempt2;
            transientAuthAttemptImpl5 = transientAuthAttemptImpl;
            transientAuthAttemptImpl4 = transientAuthAttemptImpl2;
            authModule3 = authModule2;
            userDetails7 = userDetails3;
            userDetails = userDetails2;
            jetPassUser = jetPassUser2;
        } else {
            jetPassUser = null;
        }
        transientAuthAttemptImpl4(authModule3, userDetails7, userDetails, jetPassUser);
        internalAuthAttempt4(transientAuthAttemptImpl5, credentials);
        return (Try)companion2.success((Object)internalAuthAttempt5);
    }

    private final void tryUpdatePersistedDetails(UserDetails persistedDetails, UserDetails externalDetails) {
        try {
            JetPassUserDetailsDAO jetPassUserDetailsDAO = this.getUserDetailsDAO();
            String string = persistedDetails.getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"persistedDetails.id");
            jetPassUserDetailsDAO.update(string, (IdItem)externalDetails, false);
        }
        catch (ServiceIsReadonlyException e) {
            Companion.getLogger().warn((Function0)new Function0<String>(persistedDetails){
                final /* synthetic */ UserDetails $persistedDetails;

                @NotNull
                public final String invoke() {
                    return "Can't update persistent details [" + this.$persistedDetails.getId() + "] because of the read-only mode is on. Skipped.";
                }
                {
                    this.$persistedDetails = userDetails;
                    super(0);
                }
            });
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<XdAuthModule> getApplicableModules(Credentials credentials) {
        void $receiver$iv$iv;
        Iterable $receiver$iv;
        Iterable iterable = $receiver$iv = XdAuthModule.Companion.getSorted();
        Collection destination$iv$iv = new ArrayList();
        for (Object element$iv$iv : $receiver$iv$iv) {
            XdAuthModule it = (XdAuthModule)element$iv$iv;
            if (!it.isApplicable(credentials)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List applicableModules = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        this.logApplicableModules(credentials, applicableModules);
        return applicableModules;
    }

    /*
     * WARNING - void declaration
     */
    private final void logApplicableModules(Credentials credentials, List<? extends XdAuthModule> applicableModules) {
        void $receiver$iv;
        StringBuilder initial$iv;
        Integer n = (Integer)SequencesKt.max((Sequence)SequencesKt.map((Sequence)XdQueryKt.asSequence((XdQuery)XdAuthModule.Companion.all()), (Function1)logApplicableModules.longestNameLength.1.INSTANCE));
        int longestNameLength2 = n != null ? n : 10;
        Sequence sequence = XdQueryKt.asSequence((XdQuery)XdAuthModule.Companion.all());
        StringBuilder accumulator$iv = initial$iv = new StringBuilder("Authentication of " + credentials + " (" + credentials.getClass().getSimpleName() + "):\n");
        for (Object element$iv : $receiver$iv) {
            void module;
            StringBuilder message;
            XdAuthModule xdAuthModule = (XdAuthModule)element$iv;
            StringBuilder stringBuilder = message = accumulator$iv;
            String string = "\t* " + StringsKt.padStart$default((String)module.getName(), (int)longestNameLength2, (char)'\u0000', (int)2, null) + ":\t " + (module.getDisabled() ? "disabled" : "enabled") + "\t " + (applicableModules.contains(module) ? "applicable" : "");
            StringBuilder stringBuilder2 = stringBuilder.append(string);
            Intrinsics.checkExpressionValueIsNotNull((Object)stringBuilder2, (String)"append(value)");
            accumulator$iv = StringsKt.appendln((StringBuilder)stringBuilder2);
        }
        StringBuilder message = accumulator$iv;
        Companion.getLogger().debug((Function0)new Function0<String>(message){
            final /* synthetic */ StringBuilder $message;

            @NotNull
            public final String invoke() {
                return this.$message.toString();
            }
            {
                this.$message = stringBuilder;
                super(0);
            }
        });
    }

    private final Try<XdBaseUserDetails, DataAccessException> mergeDetailsToSimilarUser(TransientAuthAttempt authAttempt, XdUser similarUser, LoginContext loginContext) {
        Try try_;
        try {
            JetPassUserDetailsDAO jetPassUserDetailsDAO = this.getUserDetailsDAO();
            UserDetails userDetails = authAttempt.getExternalUserDetails();
            Intrinsics.checkExpressionValueIsNotNull((Object)userDetails, (String)"authAttempt.externalUserDetails");
            XdBaseUserDetails xdDetails = jetPassUserDetailsDAO.persist(userDetails, similarUser);
            Companion.getLogger().debug((Function0)new Function0<String>(authAttempt, similarUser){
                final /* synthetic */ TransientAuthAttempt $authAttempt;
                final /* synthetic */ XdUser $similarUser;

                @NotNull
                public final String invoke() {
                    StringBuilder stringBuilder = new StringBuilder().append("Auth module ");
                    AuthModule authModule = this.$authAttempt.getAuthModule();
                    Intrinsics.checkExpressionValueIsNotNull((Object)authModule, (String)"authAttempt.authModule");
                    return stringBuilder.append(authModule.getName()).append(": found existing similar ").append("user ").append(this.$similarUser.getPresentation()).append(" and merged external details into him").toString();
                }
                {
                    this.$authAttempt = transientAuthAttempt;
                    this.$similarUser = xdUser;
                    super(0);
                }
            });
            xdDetails.access(loginContext);
            try_ = (Try)Try.Companion.success((Object)xdDetails);
        }
        catch (AuthenticationException ex) {
            Companion.getLogger().error((Throwable)ex, (Function0)new Function0<String>(authAttempt, similarUser){
                final /* synthetic */ TransientAuthAttempt $authAttempt;
                final /* synthetic */ XdUser $similarUser;

                @NotNull
                public final String invoke() {
                    StringBuilder stringBuilder = new StringBuilder().append("Auth module ");
                    AuthModule authModule = this.$authAttempt.getAuthModule();
                    Intrinsics.checkExpressionValueIsNotNull((Object)authModule, (String)"authAttempt.authModule");
                    return stringBuilder.append(authModule.getName()).append(": error in the merging of ").append("external user details to the found similar user ").append(this.$similarUser.getPresentation()).toString();
                }
                {
                    this.$authAttempt = transientAuthAttempt;
                    this.$similarUser = xdUser;
                    super(0);
                }
            });
            try_ = (Try)Try.Companion.fail((Exception)((Object)ex));
        }
        catch (ReadonlyTransactionException ex) {
            Companion.getLogger().warn((Throwable)ex, (Function0)new Function0<String>(authAttempt, similarUser){
                final /* synthetic */ TransientAuthAttempt $authAttempt;
                final /* synthetic */ XdUser $similarUser;

                @NotNull
                public final String invoke() {
                    StringBuilder stringBuilder = new StringBuilder().append("Auth module ");
                    AuthModule authModule = this.$authAttempt.getAuthModule();
                    Intrinsics.checkExpressionValueIsNotNull((Object)authModule, (String)"authAttempt.authModule");
                    StringBuilder stringBuilder2 = stringBuilder.append(authModule.getName()).append(": found existing similar Hub user ").append(this.$similarUser.getPresentation()).append(" for ").append("external user ");
                    UserDetails userDetails = this.$authAttempt.getExternalUserDetails();
                    Intrinsics.checkExpressionValueIsNotNull((Object)userDetails, (String)"authAttempt.externalUserDetails");
                    return stringBuilder2.append(userDetails.getEmail()).append(" but cannot save new user details because the Hub's database is in the readonly mode").toString();
                }
                {
                    this.$authAttempt = transientAuthAttempt;
                    this.$similarUser = xdUser;
                    super(0);
                }
            });
            String string = similarUser.getLogin();
            AuthModule authModule = authAttempt.getAuthModule();
            Intrinsics.checkExpressionValueIsNotNull((Object)authModule, (String)"authAttempt.authModule");
            String string2 = authModule.getName();
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"authAttempt.authModule.name");
            try_ = (Try)Try.Companion.fail((Exception)((Object)AuthenticationException.Companion.cantCreateUserDetailsReadonly(string, string2, (Exception)((Object)ex))));
        }
        return try_;
    }

    private final Try<XdBaseUserDetails, DataAccessException> createNewUser(TransientAuthAttempt authAttempt, LoginContext loginContext) {
        Try try_;
        JetPassAuthModuleDAO jetPassAuthModuleDAO = this.getAuthModuleDAO();
        AuthModule authModule = authAttempt.getAuthModule();
        Intrinsics.checkExpressionValueIsNotNull((Object)authModule, (String)"authAttempt.authModule");
        XdEntity xdEntity = JetPassReadOnlyDAO.resolve$default(jetPassAuthModuleDAO, (IdItem)authModule, false, false, 6, null);
        if (xdEntity == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.jetpass.userManagement.persistence.dnq.module.XdUserCreationAuthModule");
        }
        XdUserCreationAuthModule xdAuthModule = (XdUserCreationAuthModule)xdEntity;
        UserCreationAuthModuleProvider<UserCreationAuthModule, XdUserCreationAuthModule, UserDetails> provider = this.resolveUserCreationProvider(xdAuthModule);
        try {
            JetPassUserDetailsDAO jetPassUserDetailsDAO = this.getUserDetailsDAO();
            UserDetails userDetails = authAttempt.getExternalUserDetails();
            Intrinsics.checkExpressionValueIsNotNull((Object)userDetails, (String)"authAttempt.externalUserDetails");
            try_ = (Try)Try.Companion.success((Object)provider.createNewUser(jetPassUserDetailsDAO, xdAuthModule, userDetails, loginContext));
        }
        catch (AuthenticationException ex) {
            try_ = (Try)Try.Companion.fail((Exception)((Object)ex));
        }
        catch (LicenseViolationException ex) {
            Companion.getLogger().warn((Throwable)ex, (Function0)new Function0<String>(xdAuthModule){
                final /* synthetic */ XdUserCreationAuthModule $xdAuthModule;

                @NotNull
                public final String invoke() {
                    return "Auth module " + this.$xdAuthModule.getName() + ": authenticated successfully but failed to " + "create a new user because the creation violates the current license";
                }
                {
                    this.$xdAuthModule = xdUserCreationAuthModule;
                    super(0);
                }
            });
            try_ = (Try)Try.Companion.fail((Exception)((Object)ex));
        }
        return try_;
    }

    private final UserCreationAuthModuleProvider<UserCreationAuthModule, XdUserCreationAuthModule, UserDetails> resolveUserCreationProvider(XdUserCreationAuthModule xdModule) {
        AuthModuleProvider<AuthModule, XdAuthModule> authModuleProvider = this.getAuthModuleProviderManager().getProvider((XdAuthModule)xdModule);
        if (authModuleProvider == null) {
            throw new TypeCastException("null cannot be cast to non-null type jetbrains.jetpass.dao.dnq.api.authority.module.UserCreationAuthModuleProvider<jetbrains.jetpass.api.authority.module.UserCreationAuthModule, jetbrains.jetpass.userManagement.persistence.dnq.module.XdUserCreationAuthModule, jetbrains.jetpass.api.authority.details.UserDetails>");
        }
        return (UserCreationAuthModuleProvider)authModuleProvider;
    }

    /*
     * WARNING - void declaration
     */
    private final AggregateAuthenticationException aggregate(@NotNull List<? extends DataAccessException> $receiver) {
        Collection<ErrorMessage> collection;
        void $receiver$iv$iv;
        void $receiver$iv;
        Iterable iterable = $receiver;
        LoginHandlerImpl loginHandlerImpl = this;
        void var4_4 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            void it;
            DataAccessException dataAccessException = (DataAccessException)item$iv$iv;
            collection = destination$iv$iv;
            ErrorMessage errorMessage = new ErrorMessage((DataAccessException)it);
            collection.add(errorMessage);
        }
        collection = (List)destination$iv$iv;
        String token = loginHandlerImpl.putMessages((List<? extends OneTimeMessage>)collection);
        return new AggregateAuthenticationException(token, $receiver);
    }

    private final AggregateAuthenticationException toAggregate(@NotNull DataAccessException $receiver) {
        return this.aggregate(CollectionsKt.listOf((Object)$receiver));
    }

    private final void writeLoginAudit(TransientAuthAttempt authAttempt, XdBaseUserDetails xdDetails) {
        TransientAuthAttempt transientAuthAttempt = authAttempt;
        if (!(transientAuthAttempt instanceof InternalAuthAttempt)) {
            transientAuthAttempt = null;
        }
        InternalAuthAttempt internalAuthAttempt = (InternalAuthAttempt)transientAuthAttempt;
        if (internalAuthAttempt == null) {
            return;
        }
        InternalAuthAttempt attempt = internalAuthAttempt;
        Credentials credentials = attempt.getCredentials();
        XdUser user2 = xdDetails.getUser();
        KLogger kLogger = Companion.getLogger();
        Marker marker = LogMarkers.INSTANCE.getLOGIN_AUDIT();
        StringBuilder stringBuilder = new StringBuilder().append("User ").append(user2.getLogin()).append(" [").append(user2.getUuid()).append("] was logged in via ");
        AuthModule authModule = attempt.getAuthModule();
        Intrinsics.checkExpressionValueIsNotNull((Object)authModule, (String)"attempt.authModule");
        kLogger.info(marker, stringBuilder.append(authModule.getName()).append(" auth module with ").append(credentials).toString());
    }

    private final void writeLoginAudit(TransientAuthAttempt authAttempt, Exception error2) {
        TransientAuthAttempt transientAuthAttempt = authAttempt;
        if (!(transientAuthAttempt instanceof InternalAuthAttempt)) {
            transientAuthAttempt = null;
        }
        InternalAuthAttempt internalAuthAttempt = (InternalAuthAttempt)transientAuthAttempt;
        if (internalAuthAttempt == null) {
            return;
        }
        InternalAuthAttempt attempt = internalAuthAttempt;
        Credentials credentials = attempt.getCredentials();
        KLogger kLogger = Companion.getLogger();
        Marker marker = LogMarkers.INSTANCE.getLOGIN_AUDIT();
        StringBuilder stringBuilder = new StringBuilder().append("A user was authenticated via ");
        AuthModule authModule = attempt.getAuthModule();
        Intrinsics.checkExpressionValueIsNotNull((Object)authModule, (String)"attempt.authModule");
        kLogger.info(marker, stringBuilder.append(authModule.getName()).append(" auth module with ").append(credentials).append(" but wasn't able to login: ").append(error2.getMessage()).toString());
    }

    @NotNull
    public final JetPassDAOContainer getDaoContainer() {
        return this.daoContainer;
    }

    @Autowired
    public LoginHandlerImpl(@NotNull JetPassDAOContainer daoContainer) {
        ReadOnlyProperty readOnlyProperty;
        Intrinsics.checkParameterIsNotNull((Object)daoContainer, (String)"daoContainer");
        this.daoContainer = daoContainer;
        LoginHandlerImpl loginHandlerImpl = this;
        String name$iv = null;
        loginHandlerImpl.authModuleProviderManager$delegate = readOnlyProperty = SpringUtils.bean((String)name$iv, (boolean)false);
        loginHandlerImpl = this;
        name$iv = null;
        loginHandlerImpl.loginThrottler$delegate = readOnlyProperty = SpringUtils.bean((String)name$iv, (boolean)false);
        loginHandlerImpl = this;
        name$iv = null;
        loginHandlerImpl.failedLoginIP$delegate = readOnlyProperty = SpringUtils.bean((String)name$iv, (boolean)false);
    }

    @NotNull
    public static final /* synthetic */ AggregateAuthenticationException access$aggregate(LoginHandlerImpl $this, @NotNull List $receiver) {
        return $this.aggregate($receiver);
    }

    public static final /* synthetic */ void access$tryUpdatePersistedDetails(LoginHandlerImpl $this, @NotNull UserDetails persistedDetails, @NotNull UserDetails externalDetails) {
        $this.tryUpdatePersistedDetails(persistedDetails, externalDetails);
    }

    @NotNull
    public static final /* synthetic */ Try access$mergeDetailsToSimilarUser(LoginHandlerImpl $this, @NotNull TransientAuthAttempt authAttempt, @NotNull XdUser similarUser, @NotNull LoginContext loginContext) {
        return $this.mergeDetailsToSimilarUser(authAttempt, similarUser, loginContext);
    }

    public static final /* synthetic */ void access$writeLoginAudit(LoginHandlerImpl $this, @NotNull TransientAuthAttempt authAttempt, @NotNull Exception error2) {
        $this.writeLoginAudit(authAttempt, error2);
    }

    @NotNull
    public static final /* synthetic */ Try access$createNewUser(LoginHandlerImpl $this, @NotNull TransientAuthAttempt authAttempt, @NotNull LoginContext loginContext) {
        return $this.createNewUser(authAttempt, loginContext);
    }

    public static final /* synthetic */ void access$writeLoginAudit(LoginHandlerImpl $this, @NotNull TransientAuthAttempt authAttempt, @NotNull XdBaseUserDetails xdDetails) {
        $this.writeLoginAudit(authAttempt, xdDetails);
    }

    @NotNull
    public static final /* synthetic */ Iterable access$tryAuthenticateThrottled(LoginHandlerImpl $this, @NotNull UsernamePasswordCredentials credentials) {
        return $this.tryAuthenticateThrottled(credentials);
    }

    @NotNull
    public static final /* synthetic */ Iterable access$tryAuthenticatePlain(LoginHandlerImpl $this, @NotNull Credentials credentials) {
        return $this.tryAuthenticatePlain(credentials);
    }

    @NotNull
    public static final /* synthetic */ List access$takeUntilInclusive(LoginHandlerImpl $this, @NotNull Sequence $receiver, @NotNull Function1 predicate) {
        return $this.takeUntilInclusive($receiver, predicate);
    }

    @NotNull
    public static final /* synthetic */ List access$getApplicableModules(LoginHandlerImpl $this, @NotNull Credentials credentials) {
        return $this.getApplicableModules(credentials);
    }

    @NotNull
    public static final /* synthetic */ Try access$authenticate(LoginHandlerImpl $this, @NotNull XdAuthModule authModule, @NotNull Credentials credentials) {
        return $this.authenticate(authModule, credentials);
    }

    @NotNull
    public static final /* synthetic */ FailedLoginIP access$getFailedLoginIP$p(LoginHandlerImpl $this) {
        return $this.getFailedLoginIP();
    }

    @NotNull
    public static final /* synthetic */ Either access$loginPlain(LoginHandlerImpl $this, @NotNull Credentials credentials, @Nullable Service clientService) {
        return $this.loginPlain(credentials, clientService);
    }

    public static final /* synthetic */ boolean access$hasErrors(LoginHandlerImpl $this, @NotNull Either $receiver) {
        return $this.hasErrors($receiver);
    }

    public static final /* synthetic */ boolean access$hasErrors(LoginHandlerImpl $this, @NotNull Iterable $receiver) {
        return $this.hasErrors($receiver);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\t\u0010\b\u001a\u00020\tH\u0097\u0001J\t\u0010\n\u001a\u00020\u000bH\u0097\u0001J\u000b\u0010\f\u001a\u0004\u0018\u00010\u000bH\u0097\u0001J\u000b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0097\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u000f"}, d2={"Ljetbrains/jetpass/dao/dnq/api/authority/login/LoginHandlerImpl$InternalAuthAttempt;", "Ljetbrains/jetpass/api/authority/login/TransientAuthAttempt;", "authAttempt", "credentials", "Ljetbrains/jetpass/api/authority/module/Credentials;", "(Ljetbrains/jetpass/api/authority/login/TransientAuthAttempt;Ljetbrains/jetpass/api/authority/module/Credentials;)V", "getCredentials", "()Ljetbrains/jetpass/api/authority/module/Credentials;", "getAuthModule", "Ljetbrains/jetpass/api/authority/module/AuthModule;", "getExternalUserDetails", "Ljetbrains/jetpass/api/authority/details/UserDetails;", "getPersistedUserDetails", "getSimilarUser", "Ljetbrains/jetpass/api/authority/User;", "jetbrains.jetpass.dao.dnq"})
    private static final class InternalAuthAttempt
    implements TransientAuthAttempt {
        @NotNull
        private final Credentials credentials;
        private final /* synthetic */ TransientAuthAttempt $$delegate_0;

        @NotNull
        public final Credentials getCredentials() {
            return this.credentials;
        }

        public InternalAuthAttempt(@NotNull TransientAuthAttempt authAttempt, @NotNull Credentials credentials) {
            Intrinsics.checkParameterIsNotNull((Object)authAttempt, (String)"authAttempt");
            Intrinsics.checkParameterIsNotNull((Object)credentials, (String)"credentials");
            this.$$delegate_0 = authAttempt;
            this.credentials = credentials;
        }

        @NotNull
        public AuthModule getAuthModule() {
            return this.$$delegate_0.getAuthModule();
        }

        @NotNull
        public UserDetails getExternalUserDetails() {
            return this.$$delegate_0.getExternalUserDetails();
        }

        @Nullable
        public UserDetails getPersistedUserDetails() {
            return this.$$delegate_0.getPersistedUserDetails();
        }

        @Nullable
        public User getSimilarUser() {
            return this.$$delegate_0.getSimilarUser();
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Ljetbrains/jetpass/dao/dnq/api/authority/login/LoginHandlerImpl$Companion;", "Lmu/KLogging;", "()V", "jetbrains.jetpass.dao.dnq"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

