/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.dao.dnq.api.authority.module;

import com.nulabinc.zxcvbn.Strength;
import jetbrains.jetpass.api.authority.module.PasswordStrength;
import jetbrains.jetpass.userManagement.persistence.password.PasswordStrengthSuggester;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\b\u001a\u00020\u0003H\u0016J\n\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\b\u0010\u000b\u001a\u00020\u0003H\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016J\b\u0010\r\u001a\u00020\u0003H\u0016J\u000f\u0010\u000e\u001a\u0004\u0018\u00010\u0003H\u0016\u00a2\u0006\u0002\u0010\u000fJ\b\u0010\u0010\u001a\u00020\u0003H\u0016R\u0012\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Ljetbrains/jetpass/dao/dnq/api/authority/module/JetPassPasswordStrength;", "Ljetbrains/jetpass/api/authority/module/PasswordStrength;", "_referenceScore", "", "strength", "Lcom/nulabinc/zxcvbn/Strength;", "(Ljava/lang/Integer;Lcom/nulabinc/zxcvbn/Strength;)V", "Ljava/lang/Integer;", "getEntropy", "getFeedbackMessage", "", "getMaxEntropy", "getMaxScore", "getReferenceEntropy", "getReferenceScore", "()Ljava/lang/Integer;", "getScore", "jetbrains.jetpass.dao.dnq"})
public final class JetPassPasswordStrength
implements PasswordStrength {
    private final Integer _referenceScore;
    private final Strength strength;

    @Nullable
    public Integer getReferenceScore() {
        return this._referenceScore;
    }

    public int getScore() {
        return this.strength.getScore();
    }

    public int getReferenceEntropy() {
        Integer n = this._referenceScore;
        return n == null || n == 0 ? 0 : (n == 1 ? 3 : (n == 2 ? 6 : (n == 3 ? 8 : 10)));
    }

    public int getMaxScore() {
        return 4;
    }

    public int getEntropy() {
        double normalizedGuesses = Math.max(this.strength.getGuesses() - (double)5, 1.0);
        return MathKt.roundToInt((double)Math.floor(Math.log10(normalizedGuesses)));
    }

    public int getMaxEntropy() {
        return 10;
    }

    @Nullable
    public String getFeedbackMessage() {
        String string = PasswordStrengthSuggester.getMessageId((Strength)this.strength);
        String it = string;
        return !Intrinsics.areEqual((Object)it, (Object)PasswordStrengthSuggester.INSTANCE.getTOO_SHORT()) ? string : null;
    }

    public JetPassPasswordStrength(@Nullable Integer _referenceScore, @NotNull Strength strength) {
        Intrinsics.checkParameterIsNotNull((Object)strength, (String)"strength");
        this._referenceScore = _referenceScore;
        this.strength = strength;
    }
}

