/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.dao.dnq.api.authority.module;

import jetbrains.exodus.env.ReadonlyTransactionException;
import jetbrains.jetpass.api.IdItem;
import jetbrains.jetpass.api.authority.User;
import jetbrains.jetpass.api.authority.details.UserDetails;
import jetbrains.jetpass.api.authority.module.LoginContext;
import jetbrains.jetpass.api.authority.module.UserCreationAuthModule;
import jetbrains.jetpass.api.authority.profile.EmailContact;
import jetbrains.jetpass.auth.module.dnq.authentication.AuthenticationException;
import jetbrains.jetpass.auth.module.dnq.authentication.ResolveResult;
import jetbrains.jetpass.dao.api.DataAccessException;
import jetbrains.jetpass.dao.dnq.api.DataAccessExceptionUtilKt;
import jetbrains.jetpass.dao.dnq.api.JetPassReadOnlyDAO;
import jetbrains.jetpass.dao.dnq.api.authority.details.JetPassUserDetailsDAO;
import jetbrains.jetpass.dao.dnq.api.authority.module.BaseAuthModuleProvider;
import jetbrains.jetpass.dao.dnq.api.authority.module.UserCreationAuthModuleProvider;
import jetbrains.jetpass.dao.dnq.api.authority.module.UserCreationAuthModuleProviderKt;
import jetbrains.jetpass.pojo.api.authority.profile.LoginUtils;
import jetbrains.jetpass.userManagement.persistence.dnq.XdBaseUserDetails;
import jetbrains.jetpass.userManagement.persistence.dnq.XdEmailContact;
import jetbrains.jetpass.userManagement.persistence.dnq.XdUser;
import jetbrains.jetpass.userManagement.persistence.dnq.module.XdUserCreationAuthModule;
import jetbrains.ring.license.InvalidLicenseException;
import jetbrains.teamsys.dnq.runtime.util.DnqUtils;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.FilteringContext;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.query.XdSearchingNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u0004*\n\b\u0002\u0010\u0005 \u0000*\u00020\u00062\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0007B\u0005\u00a2\u0006\u0002\u0010\bJ+\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00028\u00012\u0006\u0010\u000e\u001a\u00028\u00022\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0011J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\u0017\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u000e\u001a\u00028\u0002H$\u00a2\u0006\u0002\u0010\u0019J\u001d\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\r\u001a\u00028\u00012\u0006\u0010\u000e\u001a\u00028\u0002H\u0014\u00a2\u0006\u0002\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u0014\u001a\u00020\u0006H\u0002J\u001d\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u00162\u0006\u0010\u000e\u001a\u00028\u0002H$\u00a2\u0006\u0002\u0010!J-\u0010\"\u001a\u00020#2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010$\u001a\u00028\u00012\u0006\u0010\u0014\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a2\u0006\u0002\u0010%\u00a8\u0006&"}, d2={"Ljetbrains/jetpass/dao/dnq/api/authority/module/UserCreationAuthModuleProvider;", "I", "Ljetbrains/jetpass/api/authority/module/UserCreationAuthModule;", "XdModule", "Ljetbrains/jetpass/userManagement/persistence/dnq/module/XdUserCreationAuthModule;", "D", "Ljetbrains/jetpass/api/authority/details/UserDetails;", "Ljetbrains/jetpass/dao/dnq/api/authority/module/BaseAuthModuleProvider;", "()V", "createNewUser", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdBaseUserDetails;", "dao", "Ljetbrains/jetpass/dao/dnq/api/authority/details/JetPassUserDetailsDAO;", "xdModule", "detail", "data", "Ljetbrains/jetpass/api/authority/module/LoginContext;", "(Ljetbrains/jetpass/dao/dnq/api/authority/details/JetPassUserDetailsDAO;Ljetbrains/jetpass/userManagement/persistence/dnq/module/XdUserCreationAuthModule;Ljetbrains/jetpass/api/authority/details/UserDetails;Ljetbrains/jetpass/api/authority/module/LoginContext;)Ljetbrains/jetpass/userManagement/persistence/dnq/XdBaseUserDetails;", "findMatchingVerifiedEmailContact", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdEmailContact;", "details", "findSimilarUser", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdUser;", "getNewUserLogin", "", "(Ljetbrains/jetpass/api/authority/details/UserDetails;)Ljava/lang/String;", "isCreateNewUserAllowed", "", "(Ljetbrains/jetpass/userManagement/persistence/dnq/module/XdUserCreationAuthModule;Ljetbrains/jetpass/api/authority/details/UserDetails;)Z", "isEmailVerified", "setupNewUser", "", "user", "(Ljetbrains/jetpass/userManagement/persistence/dnq/XdUser;Ljetbrains/jetpass/api/authority/details/UserDetails;)V", "tryResolve", "Ljetbrains/jetpass/auth/module/dnq/authentication/ResolveResult;", "authSettings", "(Ljetbrains/jetpass/dao/dnq/api/authority/details/JetPassUserDetailsDAO;Ljetbrains/jetpass/userManagement/persistence/dnq/module/XdUserCreationAuthModule;Ljetbrains/jetpass/api/authority/details/UserDetails;Ljetbrains/jetpass/api/authority/module/LoginContext;)Ljetbrains/jetpass/auth/module/dnq/authentication/ResolveResult;", "jetbrains.jetpass.dao.dnq"})
public abstract class UserCreationAuthModuleProvider<I extends UserCreationAuthModule, XdModule extends XdUserCreationAuthModule, D extends UserDetails>
extends BaseAuthModuleProvider<I, XdModule> {
    @Override
    @NotNull
    public ResolveResult tryResolve(@NotNull JetPassUserDetailsDAO dao, @NotNull XdModule authSettings, @NotNull UserDetails details2, @NotNull LoginContext data) {
        ResolveResult resolveResult;
        Intrinsics.checkParameterIsNotNull((Object)dao, (String)"dao");
        Intrinsics.checkParameterIsNotNull(authSettings, (String)"authSettings");
        Intrinsics.checkParameterIsNotNull((Object)details2, (String)"details");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        UserDetails resolvedDetails = dao.resolveUserDetails(details2);
        if (resolvedDetails != null) {
            XdBaseUserDetails xdResolvedDetails;
            this.getLogger().debug((Function0)new Function0<String>(authSettings, resolvedDetails){
                final /* synthetic */ XdUserCreationAuthModule $authSettings;
                final /* synthetic */ UserDetails $resolvedDetails;

                @NotNull
                public final String invoke() {
                    StringBuilder stringBuilder = new StringBuilder().append("Auth module ").append(this.$authSettings.getName()).append(" resolved user [");
                    User user2 = this.$resolvedDetails.getUser();
                    Intrinsics.checkExpressionValueIsNotNull((Object)user2, (String)"resolvedDetails.user");
                    return stringBuilder.append(user2.getLogin()).append(']').toString();
                }
                {
                    this.$authSettings = xdUserCreationAuthModule;
                    this.$resolvedDetails = userDetails;
                    super(0);
                }
            });
            try {
                xdResolvedDetails = (XdBaseUserDetails)JetPassReadOnlyDAO.resolve$default(dao, (IdItem)resolvedDetails, false, false, 6, null);
                xdResolvedDetails.access(data);
                xdResolvedDetails = (ResolveResult)new ResolveResult.UserDetails(xdResolvedDetails.getEntity());
            }
            catch (DataAccessException e) {
                this.getLogger().warn((Throwable)e, (Function0)new Function0<String>(authSettings, resolvedDetails){
                    final /* synthetic */ XdUserCreationAuthModule $authSettings;
                    final /* synthetic */ UserDetails $resolvedDetails;

                    @NotNull
                    public final String invoke() {
                        StringBuilder stringBuilder = new StringBuilder().append("Auth module ").append(this.$authSettings.getName()).append(" failed to load user details for [");
                        User user2 = this.$resolvedDetails.getUser();
                        Intrinsics.checkExpressionValueIsNotNull((Object)user2, (String)"resolvedDetails.user");
                        return stringBuilder.append(user2.getLogin()).append(']').toString();
                    }
                    {
                        this.$authSettings = xdUserCreationAuthModule;
                        this.$resolvedDetails = userDetails;
                        super(0);
                    }
                });
                xdResolvedDetails = (ResolveResult)ResolveResult.Empty.INSTANCE;
            }
            resolveResult = xdResolvedDetails;
        } else {
            XdUser similarUser = this.findSimilarUser(details2);
            if (similarUser != null) {
                this.getLogger().debug((Function0)new Function0<String>(authSettings, similarUser){
                    final /* synthetic */ XdUserCreationAuthModule $authSettings;
                    final /* synthetic */ XdUser $similarUser;

                    @NotNull
                    public final String invoke() {
                        return "Auth module " + this.$authSettings.getName() + " found existing Hub user " + this.$similarUser.getLogin();
                    }
                    {
                        this.$authSettings = xdUserCreationAuthModule;
                        this.$similarUser = xdUser;
                        super(0);
                    }
                });
                resolveResult = (ResolveResult)new ResolveResult.SimilarUser(similarUser.getEntity());
            } else {
                resolveResult = (ResolveResult)ResolveResult.Empty.INSTANCE;
            }
        }
        return resolveResult;
    }

    @NotNull
    public final XdBaseUserDetails createNewUser(@NotNull JetPassUserDetailsDAO dao, @NotNull XdModule xdModule, @NotNull D detail, @NotNull LoginContext data) throws AuthenticationException {
        XdBaseUserDetails xdBaseUserDetails;
        String login2;
        Intrinsics.checkParameterIsNotNull((Object)dao, (String)"dao");
        Intrinsics.checkParameterIsNotNull(xdModule, (String)"xdModule");
        Intrinsics.checkParameterIsNotNull(detail, (String)"detail");
        Intrinsics.checkParameterIsNotNull((Object)data, (String)"data");
        String string = this.getNewUserLogin(detail);
        if (string == null) {
            string = login2 = "User";
        }
        if (this.isCreateNewUserAllowed(xdModule, detail)) {
            try {
                UserCreationAuthModuleProviderKt.access$getLicenseCache$p().getHostLicenseChecker().checkAllowsMoreUsers();
            }
            catch (InvalidLicenseException e) {
                throw (Throwable)DataAccessExceptionUtilKt.wrapAsLicenseViolationException(e);
            }
            try {
                String effectiveLogin = LoginUtils.fix((String)login2);
                XdUser newUser = XdUser.Companion.new$default((XdUser.Companion)XdUser.Companion, (String)effectiveLogin, null, (int)2, null);
                this.setupNewUser(newUser, detail);
                XdBaseUserDetails resolvedUserDetails2 = dao.persist((UserDetails)detail, newUser);
                DnqUtils.getCurrentTransientSession().flush();
                this.getLogger().debug((Function0)new Function0<String>(xdModule, effectiveLogin){
                    final /* synthetic */ XdUserCreationAuthModule $xdModule;
                    final /* synthetic */ String $effectiveLogin;

                    @NotNull
                    public final String invoke() {
                        return "Auth module " + this.$xdModule.getName() + " created new user " + this.$effectiveLogin;
                    }
                    {
                        this.$xdModule = xdUserCreationAuthModule;
                        this.$effectiveLogin = string;
                        super(0);
                    }
                });
                xdBaseUserDetails = resolvedUserDetails2;
            }
            catch (ReadonlyTransactionException e) {
                this.getLogger().warn((Throwable)e, (Function0)new Function0<String>(xdModule, login2){
                    final /* synthetic */ XdUserCreationAuthModule $xdModule;
                    final /* synthetic */ String $login;

                    @NotNull
                    public final String invoke() {
                        return "Auth module " + this.$xdModule.getName() + " authenticated user " + this.$login + " but cannot create a new user because of the read-only state";
                    }
                    {
                        this.$xdModule = xdUserCreationAuthModule;
                        this.$login = string;
                        super(0);
                    }
                });
                throw (Throwable)AuthenticationException.Companion.cantCreateUserReadonly(login2, (Exception)((Object)e));
            }
        }
        this.getLogger().info((Function0)new Function0<String>(xdModule, login2){
            final /* synthetic */ XdUserCreationAuthModule $xdModule;
            final /* synthetic */ String $login;

            @NotNull
            public final String invoke() {
                return "Auth module " + this.$xdModule.getName() + " authenticated user [" + this.$login + "] but new user creation is disabled for the module, so the user cannot be authorized to Hub";
            }
            {
                this.$xdModule = xdUserCreationAuthModule;
                this.$login = string;
                super(0);
            }
        });
        throw (Throwable)AuthenticationException.Companion.registrationDisabled(login2, xdModule.getName());
        XdBaseUserDetails resolvedUserDetails3 = xdBaseUserDetails;
        resolvedUserDetails3.access(data);
        return resolvedUserDetails3;
    }

    protected boolean isCreateNewUserAllowed(@NotNull XdModule xdModule, @NotNull D detail) {
        Intrinsics.checkParameterIsNotNull(xdModule, (String)"xdModule");
        Intrinsics.checkParameterIsNotNull(detail, (String)"detail");
        return xdModule.getCreateNewUsers();
    }

    @Nullable
    protected abstract String getNewUserLogin(@NotNull D var1);

    protected abstract void setupNewUser(@NotNull XdUser var1, @NotNull D var2);

    private final XdUser findSimilarUser(UserDetails details2) {
        Object object;
        UserDetails userDetails = details2;
        UserDetails it = userDetails;
        Object object2 = this.isEmailVerified(it) ? userDetails : null;
        if (object2 != null) {
            it = userDetails = object2;
            XdEmailContact xdEmailContact = this.findMatchingVerifiedEmailContact(it);
            object = xdEmailContact != null ? xdEmailContact.getUser() : null;
        } else {
            object = null;
        }
        return object;
    }

    private final boolean isEmailVerified(UserDetails details2) {
        boolean bl;
        EmailContact emailContact = details2.getEmail();
        if (Intrinsics.areEqual((Object)(emailContact != null ? emailContact.isVerified() : null), (Object)true)) {
            bl = true;
        } else {
            this.getLogger().info((Function0)new Function0<String>(details2){
                final /* synthetic */ UserDetails $details;

                @NotNull
                public final String invoke() {
                    return "User details from [" + this.$details.getAuthModuleName() + "] contain no verified email data. " + "Matching with an existing user by email is skipped";
                }
                {
                    this.$details = userDetails;
                    super(0);
                }
            });
            bl = false;
        }
        return bl;
    }

    private final XdEmailContact findMatchingVerifiedEmailContact(UserDetails details2) {
        XdEmailContact xdEmailContact;
        String externalEmail;
        EmailContact emailContact = details2.getEmail();
        String string = externalEmail = emailContact != null ? emailContact.getEmail() : null;
        if (externalEmail != null) {
            XdQuery sameEmailContacts2 = XdFilteringQueryKt.filter((XdEntityType)((XdEntityType)XdEmailContact.Companion), (Function2)((Function2)new Function2<FilteringContext, XdEmailContact, XdSearchingNode>(externalEmail){
                final /* synthetic */ String $externalEmail;

                @NotNull
                public final XdSearchingNode invoke(@NotNull FilteringContext $receiver, @NotNull XdEmailContact it) {
                    Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    return $receiver.eq((Comparable)((Object)it.getEmail()), (Comparable)((Object)this.$externalEmail));
                }
                {
                    this.$externalEmail = string;
                    super(2);
                }
            }));
            XdEmailContact verifiedEmailContact2 = (XdEmailContact)XdQueryKt.firstOrNull((XdQuery)XdFilteringQueryKt.filter((XdQuery)sameEmailContacts2, (Function2)findMatchingVerifiedEmailContact.verifiedEmailContact.1.INSTANCE));
            if (verifiedEmailContact2 == null && XdQueryKt.isNotEmpty((XdQuery)sameEmailContacts2)) {
                this.getLogger().info((Function0)new Function0<String>(details2){
                    final /* synthetic */ UserDetails $details;

                    @NotNull
                    public final String invoke() {
                        EmailContact emailContact = this.$details.getEmail();
                        return "There is an existing user with matching email for external user " + "details " + (emailContact != null ? emailContact.getEmail() : null) + " [" + this.$details.getAuthModuleName() + "] but the email of " + "the user is not verified. Matching with an existing user by email is skipped";
                    }
                    {
                        this.$details = userDetails;
                        super(0);
                    }
                });
            }
            xdEmailContact = verifiedEmailContact2;
        } else {
            xdEmailContact = null;
        }
        return xdEmailContact;
    }
}

