/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.dao.dnq.api.permissionCache;

import java.util.HashSet;
import javax.inject.Inject;
import javax.inject.Named;
import jetbrains.jetpass.api.authority.AuthorityHolder;
import jetbrains.jetpass.api.security.Permission;
import jetbrains.jetpass.dao.api.API;
import jetbrains.jetpass.dao.api.permissionCache.filter.AllowedPermissionFilter;
import jetbrains.jetpass.dao.api.permissionCache.filter.AllowedPermissionFilterProvider;
import jetbrains.jetpass.dao.dnq.api.permissionCache.LicenseValidityBasedPermissionFilterFactory;
import jetbrains.jetpass.userManagement.persistence.license.HubLicenseCache;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.springframework.context.annotation.Scope;

@Named
@Scope(value="local")
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\n\u0010\u0011\u001a\u0004\u0018\u00010\rH\u0002J\u0006\u0010\u0012\u001a\u00020\u0013R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Ljetbrains/jetpass/dao/dnq/api/permissionCache/LicenseValidityBasedPermissionFilterFactory;", "Ljetbrains/jetpass/dao/api/permissionCache/filter/AllowedPermissionFilterProvider;", "licenseCache", "Ljetbrains/jetpass/userManagement/persistence/license/HubLicenseCache;", "api", "Ljetbrains/jetpass/dao/api/API;", "(Ljetbrains/jetpass/userManagement/persistence/license/HubLicenseCache;Ljetbrains/jetpass/dao/api/API;)V", "adminPermissionKeys", "Lkotlin/sequences/Sequence;", "", "dirty", "", "filter", "Ljetbrains/jetpass/dao/api/permissionCache/filter/AllowedPermissionFilter;", "getFilter", "authorityHolder", "Ljetbrains/jetpass/api/authority/AuthorityHolder;", "initialize", "setDirty", "", "jetbrains.jetpass.dao.dnq"})
public final class LicenseValidityBasedPermissionFilterFactory
implements AllowedPermissionFilterProvider {
    private final Sequence<String> adminPermissionKeys;
    private boolean dirty;
    private AllowedPermissionFilter filter;
    private final HubLicenseCache licenseCache;
    private final API api;

    public final void setDirty() {
        this.dirty = true;
    }

    @Nullable
    public AllowedPermissionFilter getFilter(@NotNull AuthorityHolder authorityHolder) {
        Intrinsics.checkParameterIsNotNull((Object)authorityHolder, (String)"authorityHolder");
        if (this.dirty) {
            this.filter = this.initialize();
            this.dirty = false;
        }
        return this.filter;
    }

    private final AllowedPermissionFilter initialize() {
        AllowedPermissionFilter allowedPermissionFilter;
        if (!this.licenseCache.isHubLicenseValid()) {
            HashSet adminPermissionSet2 = SequencesKt.toHashSet((Sequence)SequencesKt.map((Sequence)SequencesKt.flatMap(this.adminPermissionKeys, (Function1)((Function1)new Function1<String, Sequence<? extends Permission>>(this){
                final /* synthetic */ LicenseValidityBasedPermissionFilterFactory this$0;

                @NotNull
                public final Sequence<Permission> invoke(@NotNull String it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    jetbrains.jetpass.sequence.Sequence sequence = LicenseValidityBasedPermissionFilterFactory.access$getApi$p(this.this$0).getPermissionDAO().getByKey(it);
                    Intrinsics.checkExpressionValueIsNotNull((Object)sequence, (String)"api.permissionDAO.getByKey(it)");
                    return CollectionsKt.asSequence((Iterable)((Iterable)sequence));
                }
                {
                    this.this$0 = licenseValidityBasedPermissionFilterFactory;
                    super(1);
                }
            })), (Function1)initialize.adminPermissionSet.2.INSTANCE));
            allowedPermissionFilter = new AllowedPermissionFilter(adminPermissionSet2){
                final /* synthetic */ HashSet $adminPermissionSet;

                public boolean isPermissionAllowed(@NotNull String permissionUUID) {
                    Intrinsics.checkParameterIsNotNull((Object)permissionUUID, (String)"permissionUUID");
                    return this.$adminPermissionSet.contains(permissionUUID);
                }
                {
                    this.$adminPermissionSet = $captured_local_variable$0;
                }
            };
        } else {
            allowedPermissionFilter = null;
        }
        return allowedPermissionFilter;
    }

    @Inject
    public LicenseValidityBasedPermissionFilterFactory(@NotNull HubLicenseCache licenseCache, @NotNull API api) {
        Intrinsics.checkParameterIsNotNull((Object)licenseCache, (String)"licenseCache");
        Intrinsics.checkParameterIsNotNull((Object)api, (String)"api");
        this.licenseCache = licenseCache;
        this.api = api;
        this.adminPermissionKeys = SequencesKt.sequenceOf((Object[])new String[]{"jetbrains.jetpass.low-level-read", "jetbrains.jetpass.low-level", "jetbrains.jetpass.service-read", "jetbrains.jetpass.user-read", "jetbrains.jetpass.profile-readSelf", "jetbrains.jetpass.user-update", "jetbrains.jetpass.profile-updateSelf"});
        this.dirty = true;
    }

    @NotNull
    public static final /* synthetic */ API access$getApi$p(LicenseValidityBasedPermissionFilterFactory $this) {
        return $this.api;
    }
}

