/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.dao.dnq.api.permissionCache;

import javax.inject.Inject;
import javax.inject.Named;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.jetpass.api.Service;
import jetbrains.jetpass.api.authority.AuthorityHolder;
import jetbrains.jetpass.api.authority.User;
import jetbrains.jetpass.dao.api.DataAccessException;
import jetbrains.jetpass.dao.api.permissionCache.PermissionCache;
import jetbrains.jetpass.dao.api.permissionCache.PermissionQuery;
import jetbrains.jetpass.dao.dnq.api.JetPassDAOContainer;
import jetbrains.jetpass.dao.dnq.api.JetPassReadonlyDAOUtilKt;
import jetbrains.jetpass.dao.dnq.api.permissionCache.PermissionConstraints;
import jetbrains.jetpass.dao.dnq.api.permissionCache.PermissionConstraints$groupListener$1$assertHasGroupPermissions$1;
import jetbrains.jetpass.dao.dnq.api.permissionCache.PermissionConstraints$groupListener$1$assertHasGroupPermissions$3;
import jetbrains.jetpass.dao.dnq.api.permissionCache.PermissionConstraints$groupMappingListener$1$addedSyncBeforeConstraints$1;
import jetbrains.jetpass.dao.dnq.api.permissionCache.PermissionConstraints$groupMappingListener$1$updatedSyncBeforeConstraints$1;
import jetbrains.jetpass.dao.dnq.api.permissionCache.PermissionConstraints$groupMappingListener$1$updatedSyncBeforeConstraints$2;
import jetbrains.jetpass.dao.dnq.api.permissionCache.PermissionConstraints$roleListener$1$updatedSyncBeforeConstraints$addedPermissions$1;
import jetbrains.jetpass.dao.dnq.api.permissionCache.PermissionConstraints$roleListener$1$updatedSyncBeforeConstraints$projects$1;
import jetbrains.jetpass.dao.dnq.api.permissionCache.PermissionConstraints$teamListener$1$assertHasTeamPermissions$1;
import jetbrains.jetpass.dao.dnq.api.permissionCache.PermissionConstraints$teamListener$1$assertHasTeamPermissions$2;
import jetbrains.jetpass.dao.dnq.api.permissionCache.RestrictedOperationException;
import jetbrains.jetpass.dao.dnq.api.security.JetPassProjectRoleDAO;
import jetbrains.jetpass.dao.dnq.query.executorBundle.QueryUtilKt;
import jetbrains.jetpass.dnq.TransactionKt;
import jetbrains.jetpass.service.api.HubPrincipalManager;
import jetbrains.jetpass.service.api.JetPassMainApp;
import jetbrains.jetpass.userManagement.persistence.BaseConstraints;
import jetbrains.jetpass.userManagement.persistence.dnq.XdBaseUserDetails;
import jetbrains.jetpass.userManagement.persistence.dnq.XdBaseUserGroup;
import jetbrains.jetpass.userManagement.persistence.dnq.XdPasswordUserDetails;
import jetbrains.jetpass.userManagement.persistence.dnq.XdPermission;
import jetbrains.jetpass.userManagement.persistence.dnq.XdProject;
import jetbrains.jetpass.userManagement.persistence.dnq.XdProjectRole;
import jetbrains.jetpass.userManagement.persistence.dnq.XdProjectTeam;
import jetbrains.jetpass.userManagement.persistence.dnq.XdRole;
import jetbrains.jetpass.userManagement.persistence.dnq.XdUser;
import jetbrains.jetpass.userManagement.persistence.dnq.XdUserGroup;
import jetbrains.jetpass.userManagement.persistence.dnq.module.XdAuthModuleGroupMapping;
import jetbrains.mps.webr.runtime.listeners.EventsMultiplexerProxy;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KProperty1;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.listener.XdEntityListener;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.util.ReflectionUtilKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.springframework.context.annotation.Scope;

@Named
@Scope(value="local")
@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0087\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004*\u0007\f\u000f\u0012\u0015\u0018\u001b\u001e\b\u0007\u0018\u0000 62\u00020\u0001:\u00016B'\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ$\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020!0%H\u0002J\u0018\u0010'\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010(\u001a\u00020)H\u0002J\u0018\u0010'\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010*\u001a\u00020+H\u0002J\u0018\u0010'\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0006\u0010,\u001a\u00020-H\u0002J&\u0010.\u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\f\u0010/\u001a\b\u0012\u0004\u0012\u000201002\u0006\u00102\u001a\u000203H\u0002J\u0006\u00104\u001a\u00020!J\u0006\u00105\u001a\u00020!R\u0010\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\rR\u0010\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010R\u0010\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0013R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0019R\u0010\u0010\u001a\u001a\u00020\u001bX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u0010\u0010\u001d\u001a\u00020\u001eX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u001f\u00a8\u00067"}, d2={"Ljetbrains/jetpass/dao/dnq/api/permissionCache/PermissionConstraints;", "Ljetbrains/jetpass/userManagement/persistence/BaseConstraints;", "eventsMultiplexerProxy", "Ljetbrains/mps/webr/runtime/listeners/EventsMultiplexerProxy;", "jetPass", "Ljetbrains/jetpass/service/api/JetPassMainApp;", "permissionCache", "Ljetbrains/jetpass/dao/api/permissionCache/PermissionCache;", "principalManager", "Ljetbrains/jetpass/service/api/HubPrincipalManager;", "(Ljetbrains/mps/webr/runtime/listeners/EventsMultiplexerProxy;Ljetbrains/jetpass/service/api/JetPassMainApp;Ljetbrains/jetpass/dao/api/permissionCache/PermissionCache;Ljetbrains/jetpass/service/api/HubPrincipalManager;)V", "detailsListener", "jetbrains/jetpass/dao/dnq/api/permissionCache/PermissionConstraints$detailsListener$1", "Ljetbrains/jetpass/dao/dnq/api/permissionCache/PermissionConstraints$detailsListener$1;", "groupListener", "jetbrains/jetpass/dao/dnq/api/permissionCache/PermissionConstraints$groupListener$1", "Ljetbrains/jetpass/dao/dnq/api/permissionCache/PermissionConstraints$groupListener$1;", "groupMappingListener", "jetbrains/jetpass/dao/dnq/api/permissionCache/PermissionConstraints$groupMappingListener$1", "Ljetbrains/jetpass/dao/dnq/api/permissionCache/PermissionConstraints$groupMappingListener$1;", "passwordListener", "jetbrains/jetpass/dao/dnq/api/permissionCache/PermissionConstraints$passwordListener$1", "Ljetbrains/jetpass/dao/dnq/api/permissionCache/PermissionConstraints$passwordListener$1;", "projectRoleListener", "jetbrains/jetpass/dao/dnq/api/permissionCache/PermissionConstraints$projectRoleListener$1", "Ljetbrains/jetpass/dao/dnq/api/permissionCache/PermissionConstraints$projectRoleListener$1;", "roleListener", "jetbrains/jetpass/dao/dnq/api/permissionCache/PermissionConstraints$roleListener$1", "Ljetbrains/jetpass/dao/dnq/api/permissionCache/PermissionConstraints$roleListener$1;", "teamListener", "jetbrains/jetpass/dao/dnq/api/permissionCache/PermissionConstraints$teamListener$1", "Ljetbrains/jetpass/dao/dnq/api/permissionCache/PermissionConstraints$teamListener$1;", "assertForUserPrincipal", "", "operation", "Ljetbrains/jetpass/dao/dnq/api/permissionCache/RestrictedOperationException$Operation;", "fn", "Lkotlin/Function1;", "Ljetbrains/jetpass/api/authority/User;", "assertHasNotLessPermissions", "group", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdBaseUserGroup;", "team", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdProjectTeam;", "user", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdUser;", "assertHasPermission", "projects", "Lkotlin/sequences/Sequence;", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdProject;", "permission", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdPermission;", "startListen", "stopListen", "Companion", "jetbrains.jetpass.dao.dnq"})
public final class PermissionConstraints
extends BaseConstraints {
    private final roleListener.1 roleListener;
    private final groupListener.1 groupListener;
    private final teamListener.1 teamListener;
    private final projectRoleListener.1 projectRoleListener;
    private final passwordListener.1 passwordListener;
    private final detailsListener.1 detailsListener;
    private final groupMappingListener.1 groupMappingListener;
    private final JetPassMainApp jetPass;
    private final PermissionCache permissionCache;
    private final HubPrincipalManager principalManager;
    public static final Companion Companion = new Companion(null);

    public final void startListen() {
        this.subscribe((XdEntityType)XdRole.Companion, this.roleListener);
        this.subscribe((XdEntityType)XdBaseUserGroup.Companion, this.groupListener);
        this.subscribe((XdEntityType)XdProjectTeam.Companion, this.teamListener);
        this.subscribe((XdEntityType)XdProjectRole.Companion, this.projectRoleListener);
        this.subscribe((XdEntityType)XdPasswordUserDetails.Companion, this.passwordListener);
        this.subscribe((XdEntityType)XdBaseUserDetails.Companion, this.detailsListener);
        this.subscribe((XdEntityType)XdAuthModuleGroupMapping.Companion, this.groupMappingListener);
    }

    public final void stopListen() {
        this.unsubscribe((XdEntityType)XdAuthModuleGroupMapping.Companion, this.groupMappingListener);
        this.unsubscribe((XdEntityType)XdBaseUserDetails.Companion, this.detailsListener);
        this.unsubscribe((XdEntityType)XdPasswordUserDetails.Companion, this.passwordListener);
        this.unsubscribe((XdEntityType)XdProjectRole.Companion, this.projectRoleListener);
        this.unsubscribe((XdEntityType)XdProjectTeam.Companion, this.teamListener);
        this.unsubscribe((XdEntityType)XdBaseUserGroup.Companion, this.groupListener);
        this.unsubscribe((XdEntityType)XdRole.Companion, this.roleListener);
    }

    private final void assertHasPermission(RestrictedOperationException.Operation operation, Sequence<? extends XdProject> projects2, XdPermission permission2) {
        this.assertForUserPrincipal(operation, (Function1<? super User, Unit>)((Function1)new Function1<User, Unit>(this, permission2, projects2, operation){
            final /* synthetic */ PermissionConstraints this$0;
            final /* synthetic */ XdPermission $permission;
            final /* synthetic */ Sequence $projects;
            final /* synthetic */ RestrictedOperationException.Operation $operation;

            public final void invoke(@NotNull User principal) {
                Intrinsics.checkParameterIsNotNull((Object)principal, (String)"principal");
                PermissionCache permissionCache = PermissionConstraints.access$getPermissionCache$p(this.this$0);
                String string = principal.getId();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"principal.id");
                PermissionQuery query2 = permissionCache.user(string, true).withPermission(this.$permission.getUuid());
                if (!query2.canAccessGlobal()) {
                    Sequence $receiver$iv = this.$projects;
                    for (E element$iv : $receiver$iv) {
                        XdProject it = (XdProject)element$iv;
                        if (it.isRemoved()) {
                            PermissionConstraints.Companion.getLogger().warn((Function0)assertHasPermission.1.1.INSTANCE);
                            continue;
                        }
                        if (query2.toProject(it.getUuid()).canAccess()) continue;
                        throw (Throwable)((Object)new RestrictedOperationException(this.$operation, RestrictedOperationException.Companion.noPermissionInProject(this.$permission.getName(), it.getName())));
                    }
                }
            }
            {
                this.this$0 = permissionConstraints;
                this.$permission = xdPermission;
                this.$projects = sequence;
                this.$operation = operation;
                super(1);
            }
        }));
    }

    private final void assertHasNotLessPermissions(RestrictedOperationException.Operation operation, XdBaseUserGroup group) {
        this.assertForUserPrincipal(operation, (Function1<? super User, Unit>)((Function1)new Function1<User, Unit>(this, group, operation){
            final /* synthetic */ PermissionConstraints this$0;
            final /* synthetic */ XdBaseUserGroup $group;
            final /* synthetic */ RestrictedOperationException.Operation $operation;

            public final void invoke(@NotNull User principal) {
                Intrinsics.checkParameterIsNotNull((Object)principal, (String)"principal");
                PermissionCache permissionCache = PermissionConstraints.access$getPermissionCache$p(this.this$0);
                String string = principal.getId();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"principal.id");
                PermissionQuery principalQuery = permissionCache.user(string, true);
                PermissionQuery groupQuery = PermissionConstraints.access$getPermissionCache$p(this.this$0).group(this.$group.getUuid(), true);
                if (!principalQuery.contains(groupQuery)) {
                    throw (Throwable)((Object)new RestrictedOperationException(this.$operation, RestrictedOperationException.Companion.lessPermissionsThenGroup(this.$group.getName())));
                }
            }
            {
                this.this$0 = permissionConstraints;
                this.$group = xdBaseUserGroup;
                this.$operation = operation;
                super(1);
            }
        }));
    }

    private final void assertHasNotLessPermissions(RestrictedOperationException.Operation operation, XdProjectTeam team) {
        this.assertForUserPrincipal(operation, (Function1<? super User, Unit>)((Function1)new Function1<User, Unit>(this, team, operation){
            final /* synthetic */ PermissionConstraints this$0;
            final /* synthetic */ XdProjectTeam $team;
            final /* synthetic */ RestrictedOperationException.Operation $operation;

            public final void invoke(@NotNull User principal) {
                Intrinsics.checkParameterIsNotNull((Object)principal, (String)"principal");
                PermissionCache permissionCache = PermissionConstraints.access$getPermissionCache$p(this.this$0);
                String string = principal.getId();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"principal.id");
                PermissionQuery principalQuery = permissionCache.user(string, true);
                PermissionQuery teamQuery = PermissionConstraints.access$getPermissionCache$p(this.this$0).team(this.$team.getUuid(), true);
                if (!principalQuery.contains(teamQuery)) {
                    throw (Throwable)((Object)new RestrictedOperationException(this.$operation, RestrictedOperationException.Companion.lessPermissionsThenTeam(this.$team.getName())));
                }
            }
            {
                this.this$0 = permissionConstraints;
                this.$team = xdProjectTeam;
                this.$operation = operation;
                super(1);
            }
        }));
    }

    private final void assertHasNotLessPermissions(RestrictedOperationException.Operation operation, XdUser user2) {
        this.assertForUserPrincipal(operation, (Function1<? super User, Unit>)((Function1)new Function1<User, Unit>(this, user2, operation){
            final /* synthetic */ PermissionConstraints this$0;
            final /* synthetic */ XdUser $user;
            final /* synthetic */ RestrictedOperationException.Operation $operation;

            public final void invoke(@NotNull User principal) {
                Intrinsics.checkParameterIsNotNull((Object)principal, (String)"principal");
                PermissionCache permissionCache = PermissionConstraints.access$getPermissionCache$p(this.this$0);
                String string = principal.getId();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"principal.id");
                PermissionQuery principalQuery = permissionCache.user(string, true);
                PermissionQuery targetUserQuery = PermissionConstraints.access$getPermissionCache$p(this.this$0).user(this.$user.getUuid(), true);
                if (!principalQuery.contains(targetUserQuery)) {
                    throw (Throwable)((Object)new RestrictedOperationException(this.$operation, RestrictedOperationException.Companion.lessPermissionsThenUser(this.$user.getLogin())));
                }
            }
            {
                this.this$0 = permissionConstraints;
                this.$user = xdUser;
                this.$operation = operation;
                super(1);
            }
        }));
    }

    private final void assertForUserPrincipal(RestrictedOperationException.Operation operation, Function1<? super User, Unit> fn) {
        AuthorityHolder principal = this.principalManager.getCurrentPrincipal();
        AuthorityHolder authorityHolder = principal;
        if (authorityHolder instanceof Service) {
            if (!((Service)principal).isTrusted().booleanValue()) {
                throw (Throwable)((Object)new RestrictedOperationException(operation, RestrictedOperationException.Companion.untrustedService()));
            }
        } else if (authorityHolder instanceof User) {
            TransactionKt.legacyTransactional$default((boolean)false, null, (boolean)true, (Function1)((Function1)new Function1<TransientStoreSession, Unit>(fn, principal){
                final /* synthetic */ Function1 $fn;
                final /* synthetic */ AuthorityHolder $principal;

                public final void invoke(@NotNull TransientStoreSession it) {
                    Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                    this.$fn.invoke((Object)this.$principal);
                }
                {
                    this.$fn = function1;
                    this.$principal = authorityHolder;
                    super(1);
                }
            }), (int)3, null);
        } else {
            throw (Throwable)((Object)new RestrictedOperationException(operation, RestrictedOperationException.Companion.noPrincipal()));
        }
    }

    @Inject
    public PermissionConstraints(@NotNull EventsMultiplexerProxy eventsMultiplexerProxy, @NotNull JetPassMainApp jetPass, @NotNull PermissionCache permissionCache, @NotNull HubPrincipalManager principalManager) {
        Intrinsics.checkParameterIsNotNull((Object)eventsMultiplexerProxy, (String)"eventsMultiplexerProxy");
        Intrinsics.checkParameterIsNotNull((Object)jetPass, (String)"jetPass");
        Intrinsics.checkParameterIsNotNull((Object)permissionCache, (String)"permissionCache");
        Intrinsics.checkParameterIsNotNull((Object)principalManager, (String)"principalManager");
        super(eventsMultiplexerProxy);
        this.jetPass = jetPass;
        this.permissionCache = permissionCache;
        this.principalManager = principalManager;
        this.roleListener = new XdEntityListener<XdRole>(this){
            final /* synthetic */ PermissionConstraints this$0;

            public void updatedSyncBeforeConstraints(@NotNull XdRole old, @NotNull XdRole current) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                Sequence addedPermissions2 = XdQueryKt.asSequence((XdQuery)ReflectionUtilKt.getAddedLinks((XdEntity)((XdEntity)current), (KProperty1)PermissionConstraints$roleListener$1$updatedSyncBeforeConstraints$addedPermissions$1.INSTANCE));
                if (SequencesKt.any((Sequence)addedPermissions2)) {
                    boolean isUltimateRole = Intrinsics.areEqual((Object)current.getKey(), (Object)PermissionConstraints.access$getJetPass$p(this.this$0).getAuth().getUltimateRoleKey());
                    XdQuery projects2 = XdQueryKt.mapDistinct(QueryUtilKt.getProjectRolesOfRole(current), (KProperty1)((KProperty1)PermissionConstraints$roleListener$1$updatedSyncBeforeConstraints$projects$1.INSTANCE));
                    Sequence $receiver$iv = addedPermissions2;
                    for (E element$iv : $receiver$iv) {
                        XdPermission it = (XdPermission)element$iv;
                        if (it.isNew() && isUltimateRole) continue;
                        PermissionConstraints.access$assertHasPermission(this.this$0, RestrictedOperationException.Companion.addPermission(current.getName(), it.getName()), XdQueryKt.asSequence((XdQuery)projects2), it);
                    }
                }
            }
            {
                this.this$0 = $outer;
            }

            public void addedAsync(@NotNull XdRole added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.addedAsync((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            public void addedSync(@NotNull XdRole added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.addedSync((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            public void addedSyncAfterConstraints(@NotNull XdRole added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.addedSyncAfterConstraints((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            public void addedSyncBeforeConstraints(@NotNull XdRole added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.addedSyncBeforeConstraints((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="addedSyncAfterConstraints"), message="Use addedSyncAfterConstraints instead")
            public void addedSyncBeforeFlush(@NotNull XdRole added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.addedSyncBeforeFlush((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            public void removedAsync(@NotNull XdRole removed) {
                Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
                XdEntityListener.DefaultImpls.removedAsync((XdEntityListener)this, (XdEntity)((XdEntity)removed));
            }

            public void removedSync(@NotNull XdRole removed) {
                Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
                XdEntityListener.DefaultImpls.removedSync((XdEntityListener)this, (XdEntity)((XdEntity)removed));
            }

            public void removedSyncAfterConstraints(@NotNull XdRole removed) {
                Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
                XdEntityListener.DefaultImpls.removedSyncAfterConstraints((XdEntityListener)this, (XdEntity)((XdEntity)removed));
            }

            public void removedSyncBeforeConstraints(@NotNull XdRole removed) {
                Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
                XdEntityListener.DefaultImpls.removedSyncBeforeConstraints((XdEntityListener)this, (XdEntity)((XdEntity)removed));
            }

            @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="removedSyncAfterConstraints"), message="Use removedSyncAfterConstraints instead")
            public void removedSyncBeforeFlush(@NotNull XdRole added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.removedSyncBeforeFlush((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            public void updatedAsync(@NotNull XdRole old, @NotNull XdRole current) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                XdEntityListener.DefaultImpls.updatedAsync((XdEntityListener)this, (XdEntity)((XdEntity)old), (XdEntity)((XdEntity)current));
            }

            public void updatedSync(@NotNull XdRole old, @NotNull XdRole current) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                XdEntityListener.DefaultImpls.updatedSync((XdEntityListener)this, (XdEntity)((XdEntity)old), (XdEntity)((XdEntity)current));
            }

            public void updatedSyncAfterConstraints(@NotNull XdRole old, @NotNull XdRole current) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                XdEntityListener.DefaultImpls.updatedSyncAfterConstraints((XdEntityListener)this, (XdEntity)((XdEntity)old), (XdEntity)((XdEntity)current));
            }

            @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="updatedSyncAfterConstraints"), message="Use updatedSyncAfterConstraints instead")
            public void updatedSyncBeforeFlush(@NotNull XdRole old, @NotNull XdRole current) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                XdEntityListener.DefaultImpls.updatedSyncBeforeFlush((XdEntityListener)this, (XdEntity)((XdEntity)old), (XdEntity)((XdEntity)current));
            }
        };
        this.groupListener = new XdEntityListener<XdBaseUserGroup>(this){
            final /* synthetic */ PermissionConstraints this$0;

            public void updatedSyncBeforeConstraints(@NotNull XdBaseUserGroup old, @NotNull XdBaseUserGroup current) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                this.assertHasGroupPermissions(current);
            }

            private final void assertHasGroupPermissions(XdBaseUserGroup group) {
                block7: {
                    block6: {
                        if (!XdQueryKt.isNotEmpty((XdQuery)ReflectionUtilKt.getAddedLinks((XdEntity)((XdEntity)group), (KProperty1)PermissionConstraints$groupListener$1$assertHasGroupPermissions$1.INSTANCE))) break block6;
                        PermissionConstraints.access$assertHasNotLessPermissions(this.this$0, RestrictedOperationException.Companion.addGroupUser(group.getName()), group);
                        XdBaseUserGroup xdBaseUserGroup = group;
                        if (!(xdBaseUserGroup instanceof XdUserGroup)) {
                            xdBaseUserGroup = null;
                        }
                        XdUserGroup xdUserGroup = (XdUserGroup)xdBaseUserGroup;
                        if (xdUserGroup != null) {
                            xdUserGroup.assertNoSubGroupsCyclesWereIntroduced();
                        }
                        Sequence $receiver$iv = XdQueryKt.asSequence((XdQuery)group.getTransitiveTeams());
                        for (E element$iv : $receiver$iv) {
                            XdProjectTeam team = (XdProjectTeam)element$iv;
                            PermissionConstraints.access$assertHasNotLessPermissions(this.this$0, RestrictedOperationException.Companion.addTeamUser(team.getName()), team);
                        }
                        break block7;
                    }
                    if (!XdQueryKt.isNotEmpty((XdQuery)ReflectionUtilKt.getAddedLinks((XdEntity)((XdEntity)group), (KProperty1)PermissionConstraints$groupListener$1$assertHasGroupPermissions$3.INSTANCE))) break block7;
                    PermissionConstraints.access$assertHasNotLessPermissions(this.this$0, RestrictedOperationException.Companion.addGroupSubgroup(group.getName()), group);
                    XdBaseUserGroup xdBaseUserGroup = group;
                    if (!(xdBaseUserGroup instanceof XdUserGroup)) {
                        xdBaseUserGroup = null;
                    }
                    XdUserGroup xdUserGroup = (XdUserGroup)xdBaseUserGroup;
                    if (xdUserGroup != null) {
                        xdUserGroup.assertNoSubGroupsCyclesWereIntroduced();
                    }
                    Sequence $receiver$iv = XdQueryKt.asSequence((XdQuery)group.getTransitiveTeams());
                    for (E element$iv : $receiver$iv) {
                        XdProjectTeam team = (XdProjectTeam)element$iv;
                        PermissionConstraints.access$assertHasNotLessPermissions(this.this$0, RestrictedOperationException.Companion.addTeamGroup(team.getName()), team);
                    }
                }
            }
            {
                this.this$0 = $outer;
            }

            public void addedAsync(@NotNull XdBaseUserGroup added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.addedAsync((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            public void addedSync(@NotNull XdBaseUserGroup added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.addedSync((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            public void addedSyncAfterConstraints(@NotNull XdBaseUserGroup added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.addedSyncAfterConstraints((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            public void addedSyncBeforeConstraints(@NotNull XdBaseUserGroup added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.addedSyncBeforeConstraints((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="addedSyncAfterConstraints"), message="Use addedSyncAfterConstraints instead")
            public void addedSyncBeforeFlush(@NotNull XdBaseUserGroup added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.addedSyncBeforeFlush((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            public void removedAsync(@NotNull XdBaseUserGroup removed) {
                Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
                XdEntityListener.DefaultImpls.removedAsync((XdEntityListener)this, (XdEntity)((XdEntity)removed));
            }

            public void removedSync(@NotNull XdBaseUserGroup removed) {
                Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
                XdEntityListener.DefaultImpls.removedSync((XdEntityListener)this, (XdEntity)((XdEntity)removed));
            }

            public void removedSyncAfterConstraints(@NotNull XdBaseUserGroup removed) {
                Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
                XdEntityListener.DefaultImpls.removedSyncAfterConstraints((XdEntityListener)this, (XdEntity)((XdEntity)removed));
            }

            public void removedSyncBeforeConstraints(@NotNull XdBaseUserGroup removed) {
                Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
                XdEntityListener.DefaultImpls.removedSyncBeforeConstraints((XdEntityListener)this, (XdEntity)((XdEntity)removed));
            }

            @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="removedSyncAfterConstraints"), message="Use removedSyncAfterConstraints instead")
            public void removedSyncBeforeFlush(@NotNull XdBaseUserGroup added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.removedSyncBeforeFlush((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            public void updatedAsync(@NotNull XdBaseUserGroup old, @NotNull XdBaseUserGroup current) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                XdEntityListener.DefaultImpls.updatedAsync((XdEntityListener)this, (XdEntity)((XdEntity)old), (XdEntity)((XdEntity)current));
            }

            public void updatedSync(@NotNull XdBaseUserGroup old, @NotNull XdBaseUserGroup current) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                XdEntityListener.DefaultImpls.updatedSync((XdEntityListener)this, (XdEntity)((XdEntity)old), (XdEntity)((XdEntity)current));
            }

            public void updatedSyncAfterConstraints(@NotNull XdBaseUserGroup old, @NotNull XdBaseUserGroup current) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                XdEntityListener.DefaultImpls.updatedSyncAfterConstraints((XdEntityListener)this, (XdEntity)((XdEntity)old), (XdEntity)((XdEntity)current));
            }

            @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="updatedSyncAfterConstraints"), message="Use updatedSyncAfterConstraints instead")
            public void updatedSyncBeforeFlush(@NotNull XdBaseUserGroup old, @NotNull XdBaseUserGroup current) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                XdEntityListener.DefaultImpls.updatedSyncBeforeFlush((XdEntityListener)this, (XdEntity)((XdEntity)old), (XdEntity)((XdEntity)current));
            }
        };
        this.teamListener = new XdEntityListener<XdProjectTeam>(this){
            final /* synthetic */ PermissionConstraints this$0;

            public void updatedSyncBeforeConstraints(@NotNull XdProjectTeam old, @NotNull XdProjectTeam current) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                this.assertHasTeamPermissions(current);
            }

            private final void assertHasTeamPermissions(XdProjectTeam team) {
                if (XdQueryKt.isNotEmpty((XdQuery)ReflectionUtilKt.getAddedLinks((XdEntity)((XdEntity)team), (KProperty1)PermissionConstraints$teamListener$1$assertHasTeamPermissions$1.INSTANCE))) {
                    PermissionConstraints.access$assertHasNotLessPermissions(this.this$0, RestrictedOperationException.Companion.addTeamUser(team.getName()), team);
                } else if (XdQueryKt.isNotEmpty((XdQuery)ReflectionUtilKt.getAddedLinks((XdEntity)((XdEntity)team), (KProperty1)PermissionConstraints$teamListener$1$assertHasTeamPermissions$2.INSTANCE))) {
                    PermissionConstraints.access$assertHasNotLessPermissions(this.this$0, RestrictedOperationException.Companion.addTeamGroup(team.getName()), team);
                }
            }
            {
                this.this$0 = $outer;
            }

            public void addedAsync(@NotNull XdProjectTeam added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.addedAsync((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            public void addedSync(@NotNull XdProjectTeam added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.addedSync((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            public void addedSyncAfterConstraints(@NotNull XdProjectTeam added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.addedSyncAfterConstraints((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            public void addedSyncBeforeConstraints(@NotNull XdProjectTeam added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.addedSyncBeforeConstraints((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="addedSyncAfterConstraints"), message="Use addedSyncAfterConstraints instead")
            public void addedSyncBeforeFlush(@NotNull XdProjectTeam added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.addedSyncBeforeFlush((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            public void removedAsync(@NotNull XdProjectTeam removed) {
                Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
                XdEntityListener.DefaultImpls.removedAsync((XdEntityListener)this, (XdEntity)((XdEntity)removed));
            }

            public void removedSync(@NotNull XdProjectTeam removed) {
                Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
                XdEntityListener.DefaultImpls.removedSync((XdEntityListener)this, (XdEntity)((XdEntity)removed));
            }

            public void removedSyncAfterConstraints(@NotNull XdProjectTeam removed) {
                Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
                XdEntityListener.DefaultImpls.removedSyncAfterConstraints((XdEntityListener)this, (XdEntity)((XdEntity)removed));
            }

            public void removedSyncBeforeConstraints(@NotNull XdProjectTeam removed) {
                Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
                XdEntityListener.DefaultImpls.removedSyncBeforeConstraints((XdEntityListener)this, (XdEntity)((XdEntity)removed));
            }

            @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="removedSyncAfterConstraints"), message="Use removedSyncAfterConstraints instead")
            public void removedSyncBeforeFlush(@NotNull XdProjectTeam added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.removedSyncBeforeFlush((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            public void updatedAsync(@NotNull XdProjectTeam old, @NotNull XdProjectTeam current) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                XdEntityListener.DefaultImpls.updatedAsync((XdEntityListener)this, (XdEntity)((XdEntity)old), (XdEntity)((XdEntity)current));
            }

            public void updatedSync(@NotNull XdProjectTeam old, @NotNull XdProjectTeam current) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                XdEntityListener.DefaultImpls.updatedSync((XdEntityListener)this, (XdEntity)((XdEntity)old), (XdEntity)((XdEntity)current));
            }

            public void updatedSyncAfterConstraints(@NotNull XdProjectTeam old, @NotNull XdProjectTeam current) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                XdEntityListener.DefaultImpls.updatedSyncAfterConstraints((XdEntityListener)this, (XdEntity)((XdEntity)old), (XdEntity)((XdEntity)current));
            }

            @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="updatedSyncAfterConstraints"), message="Use updatedSyncAfterConstraints instead")
            public void updatedSyncBeforeFlush(@NotNull XdProjectTeam old, @NotNull XdProjectTeam current) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                XdEntityListener.DefaultImpls.updatedSyncBeforeFlush((XdEntityListener)this, (XdEntity)((XdEntity)old), (XdEntity)((XdEntity)current));
            }
        };
        this.projectRoleListener = new XdEntityListener<XdProjectRole>(this){
            final /* synthetic */ PermissionConstraints this$0;

            public void addedSyncBeforeConstraints(@NotNull XdProjectRole added) {
                boolean specialException;
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdProject project = added.getProject();
                XdRole role = added.getRole();
                boolean bl = specialException = added.getProject().isNew() && (this.isTeamDeveloperRole(added) || this.isOwnerProjectAdminRole(added));
                if (!specialException) {
                    Sequence $receiver$iv = XdQueryKt.asSequence((XdQuery)((XdQuery)role.getPermissions()));
                    for (E element$iv : $receiver$iv) {
                        XdPermission it = (XdPermission)element$iv;
                        PermissionConstraints.access$assertHasPermission(this.this$0, RestrictedOperationException.Companion.createProjectRole(project.getName(), role.getName()), SequencesKt.sequenceOf((Object[])new XdProject[]{project}), it);
                    }
                }
            }

            private final boolean isTeamDeveloperRole(@NotNull XdProjectRole $receiver) {
                return Intrinsics.areEqual((Object)$receiver.getRole().getKey(), (Object)"developer") && Intrinsics.areEqual((Object)$receiver.getHolder(), (Object)$receiver.getProject().getTeam());
            }

            private final boolean isOwnerProjectAdminRole(@NotNull XdProjectRole $receiver) {
                return Intrinsics.areEqual((Object)$receiver.getRole().getKey(), (Object)"project-admin") && Intrinsics.areEqual((Object)$receiver.getHolder(), (Object)$receiver.getProject().getOwner());
            }
            {
                this.this$0 = $outer;
            }

            public void addedAsync(@NotNull XdProjectRole added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.addedAsync((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            public void addedSync(@NotNull XdProjectRole added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.addedSync((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            public void addedSyncAfterConstraints(@NotNull XdProjectRole added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.addedSyncAfterConstraints((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="addedSyncAfterConstraints"), message="Use addedSyncAfterConstraints instead")
            public void addedSyncBeforeFlush(@NotNull XdProjectRole added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.addedSyncBeforeFlush((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            public void removedAsync(@NotNull XdProjectRole removed) {
                Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
                XdEntityListener.DefaultImpls.removedAsync((XdEntityListener)this, (XdEntity)((XdEntity)removed));
            }

            public void removedSync(@NotNull XdProjectRole removed) {
                Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
                XdEntityListener.DefaultImpls.removedSync((XdEntityListener)this, (XdEntity)((XdEntity)removed));
            }

            public void removedSyncAfterConstraints(@NotNull XdProjectRole removed) {
                Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
                XdEntityListener.DefaultImpls.removedSyncAfterConstraints((XdEntityListener)this, (XdEntity)((XdEntity)removed));
            }

            public void removedSyncBeforeConstraints(@NotNull XdProjectRole removed) {
                Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
                XdEntityListener.DefaultImpls.removedSyncBeforeConstraints((XdEntityListener)this, (XdEntity)((XdEntity)removed));
            }

            @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="removedSyncAfterConstraints"), message="Use removedSyncAfterConstraints instead")
            public void removedSyncBeforeFlush(@NotNull XdProjectRole added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.removedSyncBeforeFlush((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            public void updatedAsync(@NotNull XdProjectRole old, @NotNull XdProjectRole current) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                XdEntityListener.DefaultImpls.updatedAsync((XdEntityListener)this, (XdEntity)((XdEntity)old), (XdEntity)((XdEntity)current));
            }

            public void updatedSync(@NotNull XdProjectRole old, @NotNull XdProjectRole current) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                XdEntityListener.DefaultImpls.updatedSync((XdEntityListener)this, (XdEntity)((XdEntity)old), (XdEntity)((XdEntity)current));
            }

            public void updatedSyncAfterConstraints(@NotNull XdProjectRole old, @NotNull XdProjectRole current) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                XdEntityListener.DefaultImpls.updatedSyncAfterConstraints((XdEntityListener)this, (XdEntity)((XdEntity)old), (XdEntity)((XdEntity)current));
            }

            public void updatedSyncBeforeConstraints(@NotNull XdProjectRole old, @NotNull XdProjectRole current) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                XdEntityListener.DefaultImpls.updatedSyncBeforeConstraints((XdEntityListener)this, (XdEntity)((XdEntity)old), (XdEntity)((XdEntity)current));
            }

            @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="updatedSyncAfterConstraints"), message="Use updatedSyncAfterConstraints instead")
            public void updatedSyncBeforeFlush(@NotNull XdProjectRole old, @NotNull XdProjectRole current) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                XdEntityListener.DefaultImpls.updatedSyncBeforeFlush((XdEntityListener)this, (XdEntity)((XdEntity)old), (XdEntity)((XdEntity)current));
            }
        };
        this.passwordListener = new XdEntityListener<XdPasswordUserDetails>(this){
            final /* synthetic */ PermissionConstraints this$0;

            public void updatedSyncBeforeConstraints(@NotNull XdPasswordUserDetails old, @NotNull XdPasswordUserDetails current) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                if (current.hasPasswordChanged()) {
                    PermissionConstraints.access$assertHasNotLessPermissions(this.this$0, RestrictedOperationException.Companion.changePassword(current.getUser().getLogin()), current.getUser());
                }
            }
            {
                this.this$0 = $outer;
            }

            public void addedAsync(@NotNull XdPasswordUserDetails added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.addedAsync((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            public void addedSync(@NotNull XdPasswordUserDetails added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.addedSync((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            public void addedSyncAfterConstraints(@NotNull XdPasswordUserDetails added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.addedSyncAfterConstraints((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            public void addedSyncBeforeConstraints(@NotNull XdPasswordUserDetails added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.addedSyncBeforeConstraints((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="addedSyncAfterConstraints"), message="Use addedSyncAfterConstraints instead")
            public void addedSyncBeforeFlush(@NotNull XdPasswordUserDetails added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.addedSyncBeforeFlush((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            public void removedAsync(@NotNull XdPasswordUserDetails removed) {
                Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
                XdEntityListener.DefaultImpls.removedAsync((XdEntityListener)this, (XdEntity)((XdEntity)removed));
            }

            public void removedSync(@NotNull XdPasswordUserDetails removed) {
                Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
                XdEntityListener.DefaultImpls.removedSync((XdEntityListener)this, (XdEntity)((XdEntity)removed));
            }

            public void removedSyncAfterConstraints(@NotNull XdPasswordUserDetails removed) {
                Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
                XdEntityListener.DefaultImpls.removedSyncAfterConstraints((XdEntityListener)this, (XdEntity)((XdEntity)removed));
            }

            public void removedSyncBeforeConstraints(@NotNull XdPasswordUserDetails removed) {
                Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
                XdEntityListener.DefaultImpls.removedSyncBeforeConstraints((XdEntityListener)this, (XdEntity)((XdEntity)removed));
            }

            @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="removedSyncAfterConstraints"), message="Use removedSyncAfterConstraints instead")
            public void removedSyncBeforeFlush(@NotNull XdPasswordUserDetails added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.removedSyncBeforeFlush((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            public void updatedAsync(@NotNull XdPasswordUserDetails old, @NotNull XdPasswordUserDetails current) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                XdEntityListener.DefaultImpls.updatedAsync((XdEntityListener)this, (XdEntity)((XdEntity)old), (XdEntity)((XdEntity)current));
            }

            public void updatedSync(@NotNull XdPasswordUserDetails old, @NotNull XdPasswordUserDetails current) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                XdEntityListener.DefaultImpls.updatedSync((XdEntityListener)this, (XdEntity)((XdEntity)old), (XdEntity)((XdEntity)current));
            }

            public void updatedSyncAfterConstraints(@NotNull XdPasswordUserDetails old, @NotNull XdPasswordUserDetails current) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                XdEntityListener.DefaultImpls.updatedSyncAfterConstraints((XdEntityListener)this, (XdEntity)((XdEntity)old), (XdEntity)((XdEntity)current));
            }

            @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="updatedSyncAfterConstraints"), message="Use updatedSyncAfterConstraints instead")
            public void updatedSyncBeforeFlush(@NotNull XdPasswordUserDetails old, @NotNull XdPasswordUserDetails current) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                XdEntityListener.DefaultImpls.updatedSyncBeforeFlush((XdEntityListener)this, (XdEntity)((XdEntity)old), (XdEntity)((XdEntity)current));
            }
        };
        this.detailsListener = new XdEntityListener<XdBaseUserDetails>(this){
            final /* synthetic */ PermissionConstraints this$0;

            public void addedSyncBeforeConstraints(@NotNull XdBaseUserDetails added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                if (!added.getUser().isNew()) {
                    PermissionConstraints.access$assertHasNotLessPermissions(this.this$0, RestrictedOperationException.Companion.addDetails(added.getUser().getLogin()), added.getUser());
                }
            }
            {
                this.this$0 = $outer;
            }

            public void addedAsync(@NotNull XdBaseUserDetails added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.addedAsync((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            public void addedSync(@NotNull XdBaseUserDetails added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.addedSync((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            public void addedSyncAfterConstraints(@NotNull XdBaseUserDetails added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.addedSyncAfterConstraints((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="addedSyncAfterConstraints"), message="Use addedSyncAfterConstraints instead")
            public void addedSyncBeforeFlush(@NotNull XdBaseUserDetails added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.addedSyncBeforeFlush((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            public void removedAsync(@NotNull XdBaseUserDetails removed) {
                Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
                XdEntityListener.DefaultImpls.removedAsync((XdEntityListener)this, (XdEntity)((XdEntity)removed));
            }

            public void removedSync(@NotNull XdBaseUserDetails removed) {
                Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
                XdEntityListener.DefaultImpls.removedSync((XdEntityListener)this, (XdEntity)((XdEntity)removed));
            }

            public void removedSyncAfterConstraints(@NotNull XdBaseUserDetails removed) {
                Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
                XdEntityListener.DefaultImpls.removedSyncAfterConstraints((XdEntityListener)this, (XdEntity)((XdEntity)removed));
            }

            public void removedSyncBeforeConstraints(@NotNull XdBaseUserDetails removed) {
                Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
                XdEntityListener.DefaultImpls.removedSyncBeforeConstraints((XdEntityListener)this, (XdEntity)((XdEntity)removed));
            }

            @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="removedSyncAfterConstraints"), message="Use removedSyncAfterConstraints instead")
            public void removedSyncBeforeFlush(@NotNull XdBaseUserDetails added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.removedSyncBeforeFlush((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            public void updatedAsync(@NotNull XdBaseUserDetails old, @NotNull XdBaseUserDetails current) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                XdEntityListener.DefaultImpls.updatedAsync((XdEntityListener)this, (XdEntity)((XdEntity)old), (XdEntity)((XdEntity)current));
            }

            public void updatedSync(@NotNull XdBaseUserDetails old, @NotNull XdBaseUserDetails current) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                XdEntityListener.DefaultImpls.updatedSync((XdEntityListener)this, (XdEntity)((XdEntity)old), (XdEntity)((XdEntity)current));
            }

            public void updatedSyncAfterConstraints(@NotNull XdBaseUserDetails old, @NotNull XdBaseUserDetails current) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                XdEntityListener.DefaultImpls.updatedSyncAfterConstraints((XdEntityListener)this, (XdEntity)((XdEntity)old), (XdEntity)((XdEntity)current));
            }

            public void updatedSyncBeforeConstraints(@NotNull XdBaseUserDetails old, @NotNull XdBaseUserDetails current) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                XdEntityListener.DefaultImpls.updatedSyncBeforeConstraints((XdEntityListener)this, (XdEntity)((XdEntity)old), (XdEntity)((XdEntity)current));
            }

            @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="updatedSyncAfterConstraints"), message="Use updatedSyncAfterConstraints instead")
            public void updatedSyncBeforeFlush(@NotNull XdBaseUserDetails old, @NotNull XdBaseUserDetails current) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                XdEntityListener.DefaultImpls.updatedSyncBeforeFlush((XdEntityListener)this, (XdEntity)((XdEntity)old), (XdEntity)((XdEntity)current));
            }
        };
        this.groupMappingListener = new XdEntityListener<XdAuthModuleGroupMapping>(this){
            final /* synthetic */ PermissionConstraints this$0;

            /*
             * WARNING - void declaration
             */
            public void updatedSyncBeforeConstraints(@NotNull XdAuthModuleGroupMapping old, @NotNull XdAuthModuleGroupMapping current) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                if (ReflectionUtilKt.hasChanges((XdEntity)((XdEntity)current), (KProperty1)((KProperty1)PermissionConstraints$groupMappingListener$1$updatedSyncBeforeConstraints$1.INSTANCE))) {
                    void $receiver$iv;
                    XdEntity xdEntity = (XdEntity)current;
                    KProperty1 property$iv = (KProperty1)PermissionConstraints$groupMappingListener$1$updatedSyncBeforeConstraints$2.INSTANCE;
                    if (ReflectionUtilKt.isDefined((XdEntity)$receiver$iv, XdAuthModuleGroupMapping.class, (KProperty1)property$iv)) {
                        PermissionConstraints.access$assertHasNotLessPermissions(this.this$0, RestrictedOperationException.Companion.addGroupMapping(current.getGroup().getName()), (XdBaseUserGroup)current.getGroup());
                    }
                }
            }

            /*
             * WARNING - void declaration
             */
            public void addedSyncBeforeConstraints(@NotNull XdAuthModuleGroupMapping added) {
                void $receiver$iv;
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntity xdEntity = (XdEntity)added;
                KProperty1 property$iv = (KProperty1)PermissionConstraints$groupMappingListener$1$addedSyncBeforeConstraints$1.INSTANCE;
                if (ReflectionUtilKt.isDefined((XdEntity)$receiver$iv, XdAuthModuleGroupMapping.class, (KProperty1)property$iv)) {
                    PermissionConstraints.access$assertHasNotLessPermissions(this.this$0, RestrictedOperationException.Companion.addGroupMapping(added.getGroup().getName()), (XdBaseUserGroup)added.getGroup());
                }
            }
            {
                this.this$0 = $outer;
            }

            public void addedAsync(@NotNull XdAuthModuleGroupMapping added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.addedAsync((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            public void addedSync(@NotNull XdAuthModuleGroupMapping added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.addedSync((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            public void addedSyncAfterConstraints(@NotNull XdAuthModuleGroupMapping added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.addedSyncAfterConstraints((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="addedSyncAfterConstraints"), message="Use addedSyncAfterConstraints instead")
            public void addedSyncBeforeFlush(@NotNull XdAuthModuleGroupMapping added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.addedSyncBeforeFlush((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            public void removedAsync(@NotNull XdAuthModuleGroupMapping removed) {
                Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
                XdEntityListener.DefaultImpls.removedAsync((XdEntityListener)this, (XdEntity)((XdEntity)removed));
            }

            public void removedSync(@NotNull XdAuthModuleGroupMapping removed) {
                Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
                XdEntityListener.DefaultImpls.removedSync((XdEntityListener)this, (XdEntity)((XdEntity)removed));
            }

            public void removedSyncAfterConstraints(@NotNull XdAuthModuleGroupMapping removed) {
                Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
                XdEntityListener.DefaultImpls.removedSyncAfterConstraints((XdEntityListener)this, (XdEntity)((XdEntity)removed));
            }

            public void removedSyncBeforeConstraints(@NotNull XdAuthModuleGroupMapping removed) {
                Intrinsics.checkParameterIsNotNull((Object)removed, (String)"removed");
                XdEntityListener.DefaultImpls.removedSyncBeforeConstraints((XdEntityListener)this, (XdEntity)((XdEntity)removed));
            }

            @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="removedSyncAfterConstraints"), message="Use removedSyncAfterConstraints instead")
            public void removedSyncBeforeFlush(@NotNull XdAuthModuleGroupMapping added) {
                Intrinsics.checkParameterIsNotNull((Object)added, (String)"added");
                XdEntityListener.DefaultImpls.removedSyncBeforeFlush((XdEntityListener)this, (XdEntity)((XdEntity)added));
            }

            public void updatedAsync(@NotNull XdAuthModuleGroupMapping old, @NotNull XdAuthModuleGroupMapping current) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                XdEntityListener.DefaultImpls.updatedAsync((XdEntityListener)this, (XdEntity)((XdEntity)old), (XdEntity)((XdEntity)current));
            }

            public void updatedSync(@NotNull XdAuthModuleGroupMapping old, @NotNull XdAuthModuleGroupMapping current) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                XdEntityListener.DefaultImpls.updatedSync((XdEntityListener)this, (XdEntity)((XdEntity)old), (XdEntity)((XdEntity)current));
            }

            public void updatedSyncAfterConstraints(@NotNull XdAuthModuleGroupMapping old, @NotNull XdAuthModuleGroupMapping current) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                XdEntityListener.DefaultImpls.updatedSyncAfterConstraints((XdEntityListener)this, (XdEntity)((XdEntity)old), (XdEntity)((XdEntity)current));
            }

            @Deprecated(replaceWith=@ReplaceWith(imports={}, expression="updatedSyncAfterConstraints"), message="Use updatedSyncAfterConstraints instead")
            public void updatedSyncBeforeFlush(@NotNull XdAuthModuleGroupMapping old, @NotNull XdAuthModuleGroupMapping current) {
                Intrinsics.checkParameterIsNotNull((Object)old, (String)"old");
                Intrinsics.checkParameterIsNotNull((Object)current, (String)"current");
                XdEntityListener.DefaultImpls.updatedSyncBeforeFlush((XdEntityListener)this, (XdEntity)((XdEntity)old), (XdEntity)((XdEntity)current));
            }
        };
    }

    @NotNull
    public static final /* synthetic */ PermissionCache access$getPermissionCache$p(PermissionConstraints $this) {
        return $this.permissionCache;
    }

    @NotNull
    public static final /* synthetic */ JetPassMainApp access$getJetPass$p(PermissionConstraints $this) {
        return $this.jetPass;
    }

    public static final /* synthetic */ void access$assertHasPermission(PermissionConstraints $this, @NotNull RestrictedOperationException.Operation operation, @NotNull Sequence projects2, @NotNull XdPermission permission2) {
        $this.assertHasPermission(operation, (Sequence<? extends XdProject>)projects2, permission2);
    }

    public static final /* synthetic */ void access$assertHasNotLessPermissions(PermissionConstraints $this, @NotNull RestrictedOperationException.Operation operation, @NotNull XdBaseUserGroup group) {
        $this.assertHasNotLessPermissions(operation, group);
    }

    public static final /* synthetic */ void access$assertHasNotLessPermissions(PermissionConstraints $this, @NotNull RestrictedOperationException.Operation operation, @NotNull XdProjectTeam team) {
        $this.assertHasNotLessPermissions(operation, team);
    }

    public static final /* synthetic */ void access$assertHasNotLessPermissions(PermissionConstraints $this, @NotNull RestrictedOperationException.Operation operation, @NotNull XdUser user2) {
        $this.assertHasNotLessPermissions(operation, user2);
    }

    @JvmStatic
    public static final void assertProjectRolesDeletable(@NotNull JetPassDAOContainer container, @NotNull XdQuery<XdProjectRole> projectRoles2) throws DataAccessException {
        Companion.assertProjectRolesDeletable(container, projectRoles2);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0007\u00a8\u0006\n"}, d2={"Ljetbrains/jetpass/dao/dnq/api/permissionCache/PermissionConstraints$Companion;", "Lmu/KLogging;", "()V", "assertProjectRolesDeletable", "", "container", "Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "projectRoles", "Lkotlinx/dnq/query/XdQuery;", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdProjectRole;", "jetbrains.jetpass.dao.dnq"})
    public static final class Companion
    extends KLogging {
        @JvmStatic
        public final void assertProjectRolesDeletable(@NotNull JetPassDAOContainer container, @NotNull XdQuery<XdProjectRole> projectRoles2) throws DataAccessException {
            Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
            Intrinsics.checkParameterIsNotNull(projectRoles2, (String)"projectRoles");
            JetPassProjectRoleDAO projectRoleDAO = container.getJetPassProjectRoleDAO();
            Sequence $receiver$iv = XdQueryKt.asSequence(projectRoles2);
            for (Object element$iv : $receiver$iv) {
                XdProjectRole it = (XdProjectRole)element$iv;
                JetPassReadonlyDAOUtilKt.checkDeletable((XdEntity)it, projectRoleDAO);
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

