/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.dao.dnq.api.permissionCache;

import java.util.Map;
import java.util.Set;
import jetbrains.jetpass.dao.dnq.api.permissionCache.PermissionReduceDetector;
import jetbrains.jetpass.dao.dnq.api.permissionCache.PermissionReduceException;
import jetbrains.jetpass.userManagement.persistence.HubConstraintValidationException;
import jetbrains.jetpass.userManagement.persistence.dnq.XdBaseUserGroup;
import jetbrains.jetpass.userManagement.persistence.dnq.XdPermission;
import jetbrains.jetpass.userManagement.persistence.dnq.XdProjectRole;
import jetbrains.jetpass.userManagement.persistence.dnq.XdProjectTeam;
import jetbrains.jetpass.userManagement.persistence.dnq.XdRole;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007\u00a8\u0006\t"}, d2={"Ljetbrains/jetpass/dao/dnq/api/permissionCache/PermissionReduceException;", "Ljetbrains/jetpass/userManagement/persistence/HubConstraintValidationException;", "code", "", "message", "lostPermissions", "Ljetbrains/jetpass/dao/dnq/api/permissionCache/PermissionReduceDetector$Permissions;", "(Ljava/lang/String;Ljava/lang/String;Ljetbrains/jetpass/dao/dnq/api/permissionCache/PermissionReduceDetector$Permissions;)V", "Companion", "jetbrains.jetpass.dao.dnq"})
public final class PermissionReduceException
extends HubConstraintValidationException {
    public static final Companion Companion = new Companion(null);

    public PermissionReduceException(@NotNull String code, @NotNull String message, @NotNull PermissionReduceDetector.Permissions lostPermissions) {
        Intrinsics.checkParameterIsNotNull((Object)code, (String)"code");
        Intrinsics.checkParameterIsNotNull((Object)message, (String)"message");
        Intrinsics.checkParameterIsNotNull((Object)lostPermissions, (String)"lostPermissions");
        super(code, message, null, null, null, PermissionReduceException.Companion.toErrorParameters(lostPermissions), null, 92, null);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0016\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0010\u001a\u00020\u0011J\u0016\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000bJ\f\u0010\u0014\u001a\u00020\u0015*\u00020\u0006H\u0002J\f\u0010\u0016\u001a\u00020\u0015*\u00020\u0006H\u0002J\u0018\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020\u00150\u0018*\u00020\u0006H\u0002\u00a8\u0006\u0019"}, d2={"Ljetbrains/jetpass/dao/dnq/api/permissionCache/PermissionReduceException$Companion;", "", "()V", "cantDeleteProjectRole", "Ljetbrains/jetpass/dao/dnq/api/permissionCache/PermissionReduceException;", "lostPermissions", "Ljetbrains/jetpass/dao/dnq/api/permissionCache/PermissionReduceDetector$Permissions;", "removedProjectRole", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdProjectRole;", "cantRemoveGroupFromTeam", "team", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdProjectTeam;", "cantRemovePermissionFromRole", "role", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdRole;", "cantRemoveSubGroupFromGroup", "group", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdBaseUserGroup;", "cantRemoveUserFromGroup", "cantRemoveUserFromTeam", "permissionToProject", "", "permissions", "toErrorParameters", "", "jetbrains.jetpass.dao.dnq"})
    public static final class Companion {
        @NotNull
        public final PermissionReduceException cantRemovePermissionFromRole(@NotNull PermissionReduceDetector.Permissions lostPermissions, @NotNull XdRole role) {
            Intrinsics.checkParameterIsNotNull((Object)lostPermissions, (String)"lostPermissions");
            Intrinsics.checkParameterIsNotNull((Object)role, (String)"role");
            return new PermissionReduceException("reduce-permission-remove-permission-from-role", "You are trying to remove permission(s) " + this.permissions(lostPermissions) + " from role " + role.getKey() + ". " + "You will not be able to add them back because you will not have " + this.permissionToProject(lostPermissions) + " where the role is granted to you or some other users", lostPermissions);
        }

        @NotNull
        public final PermissionReduceException cantDeleteProjectRole(@NotNull PermissionReduceDetector.Permissions lostPermissions, @NotNull XdProjectRole removedProjectRole) {
            Intrinsics.checkParameterIsNotNull((Object)lostPermissions, (String)"lostPermissions");
            Intrinsics.checkParameterIsNotNull((Object)removedProjectRole, (String)"removedProjectRole");
            return new PermissionReduceException("reduce-permission-revoke-project-role", "You are trying to revoke role " + removedProjectRole.getRole() + " in project " + removedProjectRole.getProject() + ". " + "You will not be able to grant it back because you will not have permissions " + this.permissions(lostPermissions) + " in the project", lostPermissions);
        }

        @NotNull
        public final PermissionReduceException cantRemoveUserFromGroup(@NotNull PermissionReduceDetector.Permissions lostPermissions, @NotNull XdBaseUserGroup group) {
            Intrinsics.checkParameterIsNotNull((Object)lostPermissions, (String)"lostPermissions");
            Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
            return new PermissionReduceException("reduce-permission-remove-user-from-group", "You are trying to remove user(s) from group " + group.getName() + ". " + "You will not be able to add them back because you will not have " + this.permissionToProject(lostPermissions) + " that the group has", lostPermissions);
        }

        @NotNull
        public final PermissionReduceException cantRemoveSubGroupFromGroup(@NotNull PermissionReduceDetector.Permissions lostPermissions, @NotNull XdBaseUserGroup group) {
            Intrinsics.checkParameterIsNotNull((Object)lostPermissions, (String)"lostPermissions");
            Intrinsics.checkParameterIsNotNull((Object)group, (String)"group");
            return new PermissionReduceException("reduce-permission-remove-subgroup-from-group", "You are trying to remove sub-group(s) from group " + group.getName() + ". " + "You will not be able to add them back because you will not have " + this.permissionToProject(lostPermissions) + " that the group has", lostPermissions);
        }

        @NotNull
        public final PermissionReduceException cantRemoveUserFromTeam(@NotNull PermissionReduceDetector.Permissions lostPermissions, @NotNull XdProjectTeam team) {
            Intrinsics.checkParameterIsNotNull((Object)lostPermissions, (String)"lostPermissions");
            Intrinsics.checkParameterIsNotNull((Object)team, (String)"team");
            return new PermissionReduceException("reduce-permission-remove-user-from-team", "You are trying to remove user(s) from team of project " + team.getProject().getName() + ". " + "You will not be able to add them back because you will not have permissions " + this.permissions(lostPermissions) + " in the project that the group has", lostPermissions);
        }

        @NotNull
        public final PermissionReduceException cantRemoveGroupFromTeam(@NotNull PermissionReduceDetector.Permissions lostPermissions, @NotNull XdProjectTeam team) {
            Intrinsics.checkParameterIsNotNull((Object)lostPermissions, (String)"lostPermissions");
            Intrinsics.checkParameterIsNotNull((Object)team, (String)"team");
            return new PermissionReduceException("reduce-permission-remove-group-from-team", "You are trying to remove group(s) from team of project " + team.getProject().getName() + ". " + "You will not be able to add them back because you will not have permissions " + this.permissions(lostPermissions) + " in the project that the group has", lostPermissions);
        }

        private final String permissions(@NotNull PermissionReduceDetector.Permissions $receiver) {
            Set<XdPermission> set = $receiver.getMap().keySet();
            Intrinsics.checkExpressionValueIsNotNull(set, (String)"map.keys");
            return CollectionsKt.joinToString$default((Iterable)set, null, null, null, (int)0, null, (Function1)permissions.1.INSTANCE, (int)31, null);
        }

        private final String permissionToProject(@NotNull PermissionReduceDetector.Permissions $receiver) {
            StringBuilder stringBuilder;
            StringBuilder $receiver2 = stringBuilder = new StringBuilder();
            SequencesKt.joinTo$default((Sequence)MapsKt.asSequence((Map)$receiver.getMap()), (Appendable)$receiver2, (CharSequence)"; ", null, null, (int)0, null, (Function1)permissionToProject.1.1.INSTANCE, (int)60, null);
            String string = stringBuilder.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
            return string;
        }

        private final Map<String, String> toErrorParameters(@NotNull PermissionReduceDetector.Permissions $receiver) {
            Set<XdPermission> set = $receiver.getMap().keySet();
            Intrinsics.checkExpressionValueIsNotNull(set, (String)"map.keys");
            return MapsKt.mapOf((Pair)TuplesKt.to((Object)"permissions", (Object)CollectionsKt.joinToString$default((Iterable)set, null, null, null, (int)0, null, (Function1)toErrorParameters.1.INSTANCE, (int)31, null)));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

