/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.dao.dnq.api.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.exodus.query.NodeBase;
import jetbrains.jetpass.api.IdItem;
import jetbrains.jetpass.api.authority.AuthorityHolder;
import jetbrains.jetpass.api.authority.ProjectTeam;
import jetbrains.jetpass.api.authority.User;
import jetbrains.jetpass.api.authority.UserGroup;
import jetbrains.jetpass.api.security.Project;
import jetbrains.jetpass.api.security.ProjectRole;
import jetbrains.jetpass.api.security.Resource;
import jetbrains.jetpass.api.security.Role;
import jetbrains.jetpass.api.security.Team;
import jetbrains.jetpass.dao.api.DataAccessException;
import jetbrains.jetpass.dao.api.DataWriteException;
import jetbrains.jetpass.dao.api.EmptyFieldException;
import jetbrains.jetpass.dao.api.SecurityViolationException;
import jetbrains.jetpass.dao.api.security.ProjectDAO;
import jetbrains.jetpass.dao.dnq.api.DataAccessExceptionUtilKt;
import jetbrains.jetpass.dao.dnq.api.JetPassDAOContainer;
import jetbrains.jetpass.dao.dnq.api.JetPassDAOUtilKt;
import jetbrains.jetpass.dao.dnq.api.JetPassNamedMutableDAO;
import jetbrains.jetpass.dao.dnq.api.JetPassReadOnlyDAO;
import jetbrains.jetpass.dao.dnq.api.JetPassReadonlyDAOUtilKt;
import jetbrains.jetpass.dao.dnq.api.authority.JetPassAuthorityHolderMutableDAO;
import jetbrains.jetpass.dao.dnq.api.authority.JetPassUserDAO;
import jetbrains.jetpass.dao.dnq.api.permissionCache.PermissionConstraints;
import jetbrains.jetpass.dao.dnq.api.security.JetPassProject;
import jetbrains.jetpass.dao.dnq.api.security.JetPassProjectDAO;
import jetbrains.jetpass.dao.dnq.api.security.JetPassProjectDAO$addTeam$1$teamRoles$1;
import jetbrains.jetpass.dao.dnq.api.security.JetPassProjectDAO$addTeam$1$teamRoles$2;
import jetbrains.jetpass.dao.dnq.api.security.JetPassProjectDAO$deleteEntity$projectRoles$1;
import jetbrains.jetpass.dao.dnq.api.security.JetPassProjectDAO$deleteEntity$projectRoles$2;
import jetbrains.jetpass.dao.dnq.api.security.JetPassProjectDAO$getTeams$1$1;
import jetbrains.jetpass.dao.dnq.api.security.JetPassProjectDAO$nameFilter$1;
import jetbrains.jetpass.dao.dnq.api.security.JetPassProjectDAO$updateEntity$1;
import jetbrains.jetpass.dao.dnq.api.security.JetPassProjectDAO$updateEntity$2;
import jetbrains.jetpass.dao.dnq.api.security.JetPassProjectDAO$updateEntity$3;
import jetbrains.jetpass.dao.dnq.api.security.JetPassProjectDAO$updateEntity$4;
import jetbrains.jetpass.dao.dnq.api.security.JetPassProjectDAO$updateEntity$5;
import jetbrains.jetpass.dao.dnq.api.security.JetPassProjectDAO$updateEntity$6;
import jetbrains.jetpass.dao.dnq.api.security.JetPassProjectDAO$updateEntity$9;
import jetbrains.jetpass.dao.dnq.api.security.JetPassProjectDAOKt;
import jetbrains.jetpass.dao.dnq.api.security.JetPassProjectSecurity;
import jetbrains.jetpass.dao.dnq.api.security.JetPassProjectTeamDAO;
import jetbrains.jetpass.dao.dnq.api.security.JetPassResourceDAO;
import jetbrains.jetpass.dao.dnq.api.security.JetPassTeam;
import jetbrains.jetpass.dao.dnq.api.security.SecurityUtilKt;
import jetbrains.jetpass.dao.dnq.query.QueryExecutor;
import jetbrains.jetpass.pojo.api.security.ProjectRoleImpl;
import jetbrains.jetpass.sequence.Sequence;
import jetbrains.jetpass.sequence.impl.IterableSequence;
import jetbrains.jetpass.userManagement.persistence.PersistentFileDataURIUtilKt;
import jetbrains.jetpass.userManagement.persistence.dnq.XdAuthorityHolder;
import jetbrains.jetpass.userManagement.persistence.dnq.XdBaseUser;
import jetbrains.jetpass.userManagement.persistence.dnq.XdFile;
import jetbrains.jetpass.userManagement.persistence.dnq.XdGlobalProject;
import jetbrains.jetpass.userManagement.persistence.dnq.XdProject;
import jetbrains.jetpass.userManagement.persistence.dnq.XdProjectRole;
import jetbrains.jetpass.userManagement.persistence.dnq.XdResource;
import jetbrains.jetpass.userManagement.persistence.dnq.XdRole;
import jetbrains.jetpass.userManagement.persistence.dnq.XdRoots;
import jetbrains.jetpass.userManagement.persistence.dnq.XdUUIDObject;
import jetbrains.jetpass.userManagement.persistence.dnq.XdUser;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KClass;
import kotlin.reflect.KMutableProperty1;
import kotlin.reflect.KProperty1;
import kotlin.sequences.SequencesKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.NodeBaseOperationsKt;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.util.ReflectionUtilKt;
import mu.KLogging;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u00a2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001c\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 Q2\u00020\u00012\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00040\u0002:\u0002QRB\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J0\u0010\u001c\u001a\u00020\u001d2\u000e\u0010\u001e\u001a\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u001f2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020!2\u0006\u0010#\u001a\u00020$H\u0002J\u0018\u0010%\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020!2\u0006\u0010&\u001a\u00020!H\u0016J\u0018\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020!2\u0006\u0010*\u001a\u00020(H\u0016J\u000e\u0010+\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020-J\u0012\u0010.\u001a\u00020-2\b\u0010/\u001a\u0004\u0018\u00010\u0003H\u0016J\u0010\u00100\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u0003H\u0016J\u001a\u00101\u001a\u00020\u001d2\u0006\u00102\u001a\u00020\u00042\b\u00103\u001a\u0004\u0018\u00010\u0004H\u0014J\u000e\u00104\u001a\b\u0012\u0004\u0012\u00020\u000305H\u0016J\u0016\u00104\u001a\b\u0012\u0004\u0012\u00020\u0003052\u0006\u00106\u001a\u00020-H\u0016J\n\u00107\u001a\u0004\u0018\u00010\u0003H\u0016J\u0018\u00108\u001a\u0002092\u0006\u0010)\u001a\u00020!2\u0006\u0010:\u001a\u00020!H\u0016J\u0016\u0010;\u001a\b\u0012\u0004\u0012\u000209052\u0006\u0010)\u001a\u00020!H\u0016J\u0010\u0010<\u001a\u0002092\u0006\u0010)\u001a\u00020!H\u0016JM\u0010=\u001a\u00020\u00032\f\u0010>\u001a\b\u0012\u0004\u0012\u00020\u00030?2\b\u0010@\u001a\u0004\u0018\u00010!2\b\u0010A\u001a\u0004\u0018\u00010!2\b\u0010B\u001a\u0004\u0018\u00010!2\b\u0010C\u001a\u0004\u0018\u00010-2\b\u0010D\u001a\u0004\u0018\u00010EH\u0016\u00a2\u0006\u0002\u0010FJ\u0010\u0010G\u001a\u00020H2\u0006\u0010A\u001a\u00020!H\u0014J\u0018\u0010I\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020!2\u0006\u0010&\u001a\u00020!H\u0016J\u0012\u0010J\u001a\u0004\u0018\u00010\u00042\u0006\u0010K\u001a\u00020!H\u0016J\u0018\u0010L\u001a\u00020\u001d2\u0006\u00102\u001a\u00020\u00042\u0006\u0010/\u001a\u00020\u0003H\u0016J \u0010M\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020!2\u0006\u0010&\u001a\u00020!2\u0006\u0010N\u001a\u00020-H\u0002J\u0010\u0010O\u001a\u00020P2\u0006\u00102\u001a\u00020\u0004H\u0016R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00030\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001a\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00040\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006S"}, d2={"Ljetbrains/jetpass/dao/dnq/api/security/JetPassProjectDAO;", "Ljetbrains/jetpass/dao/api/security/ProjectDAO;", "Ljetbrains/jetpass/dao/dnq/api/JetPassNamedMutableDAO;", "Ljetbrains/jetpass/api/security/Project;", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdProject;", "container", "Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "(Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;)V", "apiType", "Ljava/lang/Class;", "getApiType", "()Ljava/lang/Class;", "defaultSuccessor", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdGlobalProject;", "getDefaultSuccessor", "()Ljetbrains/jetpass/userManagement/persistence/dnq/XdGlobalProject;", "entityType", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdProject$Companion;", "getEntityType", "()Ljetbrains/jetpass/userManagement/persistence/dnq/XdProject$Companion;", "queryExecutor", "Ljetbrains/jetpass/dao/dnq/query/QueryExecutor;", "getQueryExecutor", "()Ljetbrains/jetpass/dao/dnq/query/QueryExecutor;", "security", "Ljetbrains/jetpass/dao/dnq/api/security/JetPassProjectSecurity;", "getSecurity", "()Ljetbrains/jetpass/dao/dnq/api/security/JetPassProjectSecurity;", "addOwnRole", "", "authHolderDAO", "Ljetbrains/jetpass/dao/dnq/api/authority/JetPassAuthorityHolderMutableDAO;", "principalId", "", "projectID", "role", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdRole;", "addResource", "resourceID", "addTeam", "Ljetbrains/jetpass/api/security/Team;", "projectId", "team", "assertNotGlobal", "isGlobal", "", "canCreate", "item", "createEntity", "deleteEntity", "xd", "successor", "getAllItems", "Ljetbrains/jetpass/sequence/Sequence;", "withArchived", "getGlobal", "getTeam", "Ljetbrains/jetpass/dao/dnq/api/security/JetPassTeam;", "roleId", "getTeams", "getWholeTeam", "merge", "projects", "", "key", "name", "description", "archived", "owner", "Ljetbrains/jetpass/api/authority/User;", "(Ljava/lang/Iterable;Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;Ljava/lang/Boolean;Ljetbrains/jetpass/api/authority/User;)Ljetbrains/jetpass/api/security/Project;", "nameFilter", "Ljetbrains/exodus/query/NodeBase;", "removeResource", "resolveOrNull", "id", "updateEntity", "updateProject", "add", "wrapEntity", "Ljetbrains/jetpass/dao/dnq/api/security/JetPassProject;", "Companion", "ResourceUpdater", "jetbrains.jetpass.dao.dnq"})
public final class JetPassProjectDAO
extends JetPassNamedMutableDAO<Project, XdProject>
implements ProjectDAO {
    @NotNull
    private final XdProject.Companion entityType;
    @NotNull
    private final Class<Project> apiType;
    @NotNull
    private final JetPassProjectSecurity security;
    @NotNull
    private final QueryExecutor<XdProject> queryExecutor;
    private static final String QUERY_NOT_ARCHIVED = "not is: archived";
    public static final Companion Companion = new Companion(null);

    @NotNull
    public XdProject.Companion getEntityType() {
        return this.entityType;
    }

    @Override
    @NotNull
    public Class<Project> getApiType() {
        return this.apiType;
    }

    @NotNull
    public JetPassProjectSecurity getSecurity() {
        return this.security;
    }

    @Override
    @NotNull
    public QueryExecutor<XdProject> getQueryExecutor() {
        return this.queryExecutor;
    }

    @Override
    @NotNull
    public Sequence<Project> getAllItems() {
        return this.getAllItems(false);
    }

    @NotNull
    public Sequence<Project> getAllItems(boolean withArchived) {
        Sequence items = super.getAllItems();
        return withArchived ? items : items.query(QUERY_NOT_ARCHIVED);
    }

    @Override
    @NotNull
    public XdGlobalProject getDefaultSuccessor() {
        return XdRoots.INSTANCE.getGlobalProject();
    }

    @Override
    @NotNull
    public JetPassProject wrapEntity(@NotNull XdProject xd) {
        Intrinsics.checkParameterIsNotNull((Object)xd, (String)"xd");
        return new JetPassProject(xd, this.getContainer());
    }

    @Override
    @Nullable
    public XdProject resolveOrNull(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        return (XdProject)this.getEntityType().resolve(id);
    }

    @Nullable
    public Project getGlobal() {
        return (Project)DataAccessExceptionUtilKt.daoTransaction$default(this.getContainer(), false, (Function1)new Function1<TransientStoreSession, Project>(this){
            final /* synthetic */ JetPassProjectDAO this$0;

            @Nullable
            public final Project invoke(@NotNull TransientStoreSession it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return (Project)JetPassReadonlyDAOUtilKt.wrapIfCanReadOrNull((XdEntity)XdRoots.INSTANCE.getGlobalProject(), this.this$0);
            }
            {
                this.this$0 = jetPassProjectDAO;
                super(1);
            }
        }, 1, null);
    }

    @Override
    @NotNull
    protected NodeBase nameFilter(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        KProperty1 $receiver$iv = (KProperty1)JetPassProjectDAO$nameFilter$1.INSTANCE;
        return NodeBaseOperationsKt.eq((String)ReflectionUtilKt.getDBName((KProperty1)$receiver$iv, (KClass)Reflection.getOrCreateKotlinClass(XdProject.class)), (Comparable)((Comparable)((Object)name)));
    }

    public void addResource(@NotNull String projectID, @NotNull String resourceID) {
        Intrinsics.checkParameterIsNotNull((Object)projectID, (String)"projectID");
        Intrinsics.checkParameterIsNotNull((Object)resourceID, (String)"resourceID");
        this.updateProject(projectID, resourceID, true);
    }

    public void removeResource(@NotNull String projectID, @NotNull String resourceID) {
        Intrinsics.checkParameterIsNotNull((Object)projectID, (String)"projectID");
        Intrinsics.checkParameterIsNotNull((Object)resourceID, (String)"resourceID");
        this.updateProject(projectID, resourceID, false);
    }

    private final void updateProject(String projectID, String resourceID, boolean add) {
        JetPassDAOContainer container = this.getContainer();
        DataAccessExceptionUtilKt.daoTransaction$default(container, false, (Function1)new Function1<TransientStoreSession, Unit>(this, projectID, container, resourceID, add){
            final /* synthetic */ JetPassProjectDAO this$0;
            final /* synthetic */ String $projectID;
            final /* synthetic */ JetPassDAOContainer $container;
            final /* synthetic */ String $resourceID;
            final /* synthetic */ boolean $add;

            public final void invoke(@NotNull TransientStoreSession it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                XdProject project = (XdProject)JetPassReadOnlyDAO.resolve$default(this.this$0, this.$projectID, true, true, false, 8, null);
                JetPassResourceDAO resourceDAO = this.$container.getJetPassResourceDAO();
                XdResource resource = (XdResource)JetPassReadOnlyDAO.resolve$default(resourceDAO, this.$resourceID, true, true, false, 8, null);
                if (this.$add) {
                    project.getResources().add((XdEntity)resource);
                } else {
                    project.getResources().remove((XdEntity)resource);
                }
            }
            {
                this.this$0 = jetPassProjectDAO;
                this.$projectID = string;
                this.$container = jetPassDAOContainer;
                this.$resourceID = string2;
                this.$add = bl;
                super(1);
            }
        }, 1, null);
    }

    @NotNull
    public Project merge(@NotNull Iterable<? extends Project> projects2, @Nullable String key2, @Nullable String name, @Nullable String description, @Nullable Boolean archived, @Nullable User owner) {
        Intrinsics.checkParameterIsNotNull(projects2, (String)"projects");
        return (Project)DataAccessExceptionUtilKt.daoTransaction$default(this.getContainer(), false, (Function1)new Function1<TransientStoreSession, JetPassProject>(this, projects2, owner, key2, name, description, archived){
            final /* synthetic */ JetPassProjectDAO this$0;
            final /* synthetic */ Iterable $projects;
            final /* synthetic */ User $owner;
            final /* synthetic */ String $key;
            final /* synthetic */ String $name;
            final /* synthetic */ String $description;
            final /* synthetic */ Boolean $archived;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final JetPassProject invoke(@NotNull TransientStoreSession $noName_0) {
                void $receiver$iv$iv;
                XdProject xdProject;
                Object v3;
                Object element$iv2;
                XdUser xdOwner;
                List xdProjects;
                block10: {
                    void $receiver$iv;
                    XdUser xdUser;
                    Object it;
                    XdProject it2;
                    User $receiver$iv$iv2;
                    Iterable $receiver$iv2;
                    Intrinsics.checkParameterIsNotNull((Object)$noName_0, (String)"<anonymous parameter 0>");
                    XdGlobalProject globalProject = XdRoots.INSTANCE.getGlobalProject();
                    Iterable iterable = $receiver$iv2 = this.$projects;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv2, (int)10));
                    for (T item$iv$iv : $receiver$iv$iv2) {
                        String string;
                        void $receiver$iv3;
                        Project project = (Project)item$iv$iv;
                        Collection collection = destination$iv$iv;
                        IdItem idItem = (IdItem)it2;
                        JetPassProjectDAO jetPassProjectDAO = this.this$0;
                        if ($receiver$iv3.getId() == null) {
                            throw (Throwable)new EmptyFieldException(Project.class.getSimpleName(), "id");
                        }
                        XdProject xdProject2 = (XdProject)JetPassReadOnlyDAO.resolve$default(jetPassProjectDAO, string, true, true, false, 8, null);
                        collection.add(xdProject2);
                    }
                    xdProjects = (List)destination$iv$iv;
                    User user2 = this.$owner;
                    if (user2 != null) {
                        it = $receiver$iv$iv2 = user2;
                        XdBaseUser xdUser2 = (XdBaseUser)JetPassReadOnlyDAO.resolve$default(this.this$0.getContainer().getJetPassUserDAO(), (IdItem)it, true, false, 4, null);
                        XdBaseUser xdBaseUser = xdUser2;
                        if (!(xdBaseUser instanceof XdUser)) {
                            xdBaseUser = null;
                        }
                        if ((xdUser = (XdUser)xdBaseUser) == null) {
                            throw (Throwable)new DataAccessException("New project owner is not supposed to be a guest");
                        }
                    } else {
                        xdUser = null;
                    }
                    xdOwner = xdUser;
                    it = xdProjects;
                    for (Object element$iv2 : $receiver$iv) {
                        it2 = (XdProject)element$iv2;
                        if (!Intrinsics.areEqual((Object)it2, (Object)globalProject)) continue;
                        v3 = element$iv2;
                        break block10;
                    }
                    v3 = null;
                }
                if ((xdProject = (XdProject)v3) == null) {
                    xdProject = (XdProject)CollectionsKt.firstOrNull((List)xdProjects);
                }
                if (xdProject == null) {
                    throw (Throwable)new DataAccessException("Can't merge empty list of projects");
                }
                XdProject toStay = xdProject;
                Iterable $receiver$iv = xdProjects;
                element$iv2 = $receiver$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                for (E element$iv$iv : $receiver$iv$iv) {
                    XdProject it = (XdProject)element$iv$iv;
                    if (Intrinsics.areEqual((Object)it, (Object)toStay)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List toGo = (List)destination$iv$iv;
                toStay.merge((Iterable)toGo, this.$key, this.$name, this.$description, this.$archived, xdOwner);
                return this.this$0.wrapEntity(toStay);
            }
            {
                this.this$0 = jetPassProjectDAO;
                this.$projects = iterable;
                this.$owner = user2;
                this.$key = string;
                this.$name = string2;
                this.$description = string3;
                this.$archived = bl;
                super(1);
            }
        }, 1, null);
    }

    @Override
    public boolean canCreate(@Nullable Project item) {
        return this.getSecurity().canCreate();
    }

    @Override
    @NotNull
    public XdProject createEntity(@NotNull Project item) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        XdProject xdProject = XdProject.Companion.new(item.getId(), item.getKey(), item.getName());
        AuthorityHolder principal = JetPassProjectDAOKt.access$getHubPrincipalManager$p().getCurrentPrincipal();
        if (principal != null && principal instanceof User) {
            XdBaseUser user2;
            JetPassUserDAO jetPassUserDAO = this.getContainer().getJetPassUserDAO();
            String string = ((User)principal).getId();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"principal.id");
            XdEntity xdEntity = JetPassReadOnlyDAO.resolve$default(jetPassUserDAO, string, false, false, false, 14, null);
            XdBaseUser xdBaseUser = user2 = (XdBaseUser)xdEntity;
            if (xdBaseUser instanceof XdUser) {
                ((XdUser)user2).getFavoriteProjects().add((XdEntity)xdProject);
                xdProject.setOwner((XdUser)user2);
            } else {
                SecurityViolationException securityViolationException = SecurityViolationException.guestCantCreateProject();
                Intrinsics.checkExpressionValueIsNotNull((Object)securityViolationException, (String)"SecurityViolationExcepti\u2026.guestCantCreateProject()");
                throw (Throwable)securityViolationException;
            }
        }
        return xdProject;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void updateEntity(@NotNull XdProject xd, @NotNull Project item) {
        block33: {
            void field$iv;
            void $receiver$iv;
            Function0[] $receiver$iv$iv;
            void value$iv;
            KMutableProperty1 team;
            XdFile oldIcon$iv;
            int $i$a$2$takeUnless;
            Object object;
            Object it$iv;
            KMutableProperty1 kMutableProperty1;
            Function0[] function0Array;
            XdEntity it$iv2;
            XdEntity element$iv$iv;
            int n;
            Function0[] $i$f$isDefined;
            KMutableProperty1 field$iv2;
            Function0[] $receiver$iv2;
            Object $receiver$iv$iv2;
            String value$iv2;
            Intrinsics.checkParameterIsNotNull((Object)xd, (String)"xd");
            Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
            boolean isGlobal2 = Intrinsics.areEqual((Object)xd, (Object)XdRoots.INSTANCE.getGlobalProject());
            Function0 isNotGlobal2 = (Function0)new Function0<Unit>(this, isGlobal2){
                final /* synthetic */ JetPassProjectDAO this$0;
                final /* synthetic */ boolean $isGlobal;

                public final void invoke() {
                    this.this$0.assertNotGlobal(this.$isGlobal);
                }
                {
                    this.this$0 = jetPassProjectDAO;
                    this.$isGlobal = bl;
                    super(0);
                }
            };
            XdEntity xdEntity = (XdEntity)xd;
            KMutableProperty1 kMutableProperty12 = JetPassProjectDAO$updateEntity$1.INSTANCE;
            Object object2 = item.getKey();
            Function0[] assertions$iv = new Function0[]{isNotGlobal2};
            if (value$iv2 != null && (!ReflectionUtilKt.isDefined((XdEntity)($receiver$iv$iv2 = $receiver$iv2), XdProject.class, (KProperty1)((KProperty1)field$iv2)) || Intrinsics.areEqual((Object)value$iv2, (Object)field$iv2.get((Object)$receiver$iv2)) ^ true)) {
                $i$f$isDefined = $receiver$iv$iv2 = assertions$iv;
                n = $i$f$isDefined.length;
                for (int j = 0; j < n; ++j) {
                    it$iv2 = element$iv$iv = $i$f$isDefined[j];
                    it$iv2.invoke();
                }
                $receiver$iv$iv2 = value$iv2;
                function0Array = $receiver$iv2;
                kMutableProperty1 = field$iv2;
                it$iv = $receiver$iv$iv2;
                Object object3 = object = !false ? $receiver$iv$iv2 : null;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                kMutableProperty1.set((Object)function0Array, object);
            }
            $receiver$iv2 = (Function0[])xd;
            field$iv2 = JetPassProjectDAO$updateEntity$2.INSTANCE;
            value$iv2 = item.getName();
            assertions$iv = new Function0[]{};
            if (value$iv2 != null && (!ReflectionUtilKt.isDefined((XdEntity)($receiver$iv$iv2 = $receiver$iv2), XdProject.class, (KProperty1)((KProperty1)field$iv2)) || Intrinsics.areEqual((Object)value$iv2, (Object)field$iv2.get((Object)$receiver$iv2)) ^ true)) {
                $i$f$isDefined = $receiver$iv$iv2 = assertions$iv;
                n = $i$f$isDefined.length;
                for ($i$a$2$takeUnless = 0; $i$a$2$takeUnless < n; ++$i$a$2$takeUnless) {
                    it$iv2 = element$iv$iv = $i$f$isDefined[$i$a$2$takeUnless];
                    it$iv2.invoke();
                }
                $receiver$iv$iv2 = value$iv2;
                function0Array = $receiver$iv2;
                kMutableProperty1 = field$iv2;
                it$iv = $receiver$iv$iv2;
                Object object4 = object = !false ? $receiver$iv$iv2 : null;
                if (object == null) {
                    throw new TypeCastException("null cannot be cast to non-null type kotlin.String");
                }
                kMutableProperty1.set((Object)function0Array, object);
            }
            $receiver$iv2 = (XdEntity)xd;
            field$iv2 = JetPassProjectDAO$updateEntity$3.INSTANCE;
            value$iv2 = item.getDescription();
            assertions$iv = new Function0[]{};
            if (value$iv2 != null && (!ReflectionUtilKt.isDefined((XdEntity)($receiver$iv$iv2 = $receiver$iv2), XdProject.class, (KProperty1)((KProperty1)field$iv2)) || Intrinsics.areEqual((Object)value$iv2, (Object)field$iv2.get((Object)$receiver$iv2)) ^ true)) {
                $i$f$isDefined = $receiver$iv$iv2 = assertions$iv;
                n = $i$f$isDefined.length;
                for ($i$a$2$takeUnless = 0; $i$a$2$takeUnless < n; ++$i$a$2$takeUnless) {
                    it$iv2 = element$iv$iv = $i$f$isDefined[$i$a$2$takeUnless];
                    it$iv2.invoke();
                }
                $receiver$iv$iv2 = value$iv2;
                function0Array = $receiver$iv2;
                kMutableProperty1 = field$iv2;
                it$iv = $receiver$iv$iv2;
                CharSequence charSequence = (CharSequence)it$iv;
                object = !(charSequence.length() == 0) ? $receiver$iv$iv2 : null;
                kMutableProperty1.set((Object)function0Array, object);
            }
            $receiver$iv2 = (Function0[])xd;
            field$iv2 = JetPassProjectDAO$updateEntity$4.INSTANCE;
            Object iconDataURI$iv = item.getIconUrl();
            int maxWidth$iv = 128;
            int maxHeight$iv = 128;
            if (iconDataURI$iv != null) {
                CharSequence charSequence = (CharSequence)iconDataURI$iv;
                if (charSequence.length() > 0) {
                    XdFile icon$iv = PersistentFileDataURIUtilKt.fromDataURI$default((String)iconDataURI$iv, (boolean)false, (int)1, null);
                    if (icon$iv != null) {
                        Function0[] $receiver$iv$iv3;
                        if (Intrinsics.areEqual((Object)icon$iv.getMimeType(), (Object)"image/svg+xml") ^ true) {
                            XdFile.resize$default((XdFile)icon$iv, (int)maxWidth$iv, (int)maxHeight$iv, (boolean)false, (int)4, null);
                        }
                        XdFile xdFile = oldIcon$iv = ReflectionUtilKt.isDefined((XdEntity)($receiver$iv$iv3 = $receiver$iv2), XdProject.class, (KProperty1)((KProperty1)field$iv2)) ? (XdFile)field$iv2.get((Object)$receiver$iv2) : null;
                        if (oldIcon$iv == null || Intrinsics.areEqual((Object)PersistentFileDataURIUtilKt.toDataURI((XdFile)oldIcon$iv), (Object)PersistentFileDataURIUtilKt.toDataURI((XdFile)icon$iv)) ^ true) {
                            field$iv2.set((Object)$receiver$iv2, (Object)icon$iv);
                        } else {
                            icon$iv.delete();
                        }
                    }
                } else {
                    field$iv2.set((Object)$receiver$iv2, null);
                }
            }
            $receiver$iv2 = (XdEntity)xd;
            field$iv2 = JetPassProjectDAO$updateEntity$5.INSTANCE;
            iconDataURI$iv = item.getIcon();
            maxWidth$iv = 128;
            maxHeight$iv = 128;
            if (iconDataURI$iv != null) {
                CharSequence icon$iv = (CharSequence)iconDataURI$iv;
                if (icon$iv.length() > 0) {
                    icon$iv = PersistentFileDataURIUtilKt.fromDataURI$default((String)iconDataURI$iv, (boolean)false, (int)1, null);
                    if (icon$iv != null) {
                        Function0[] $receiver$iv$iv4;
                        if (Intrinsics.areEqual((Object)icon$iv.getMimeType(), (Object)"image/svg+xml") ^ true) {
                            XdFile.resize$default((XdFile)icon$iv, (int)maxWidth$iv, (int)maxHeight$iv, (boolean)false, (int)4, null);
                        }
                        XdFile xdFile = oldIcon$iv = ReflectionUtilKt.isDefined((XdEntity)($receiver$iv$iv4 = $receiver$iv2), XdProject.class, (KProperty1)((KProperty1)field$iv2)) ? (XdFile)field$iv2.get((Object)$receiver$iv2) : null;
                        if (oldIcon$iv == null || Intrinsics.areEqual((Object)PersistentFileDataURIUtilKt.toDataURI((XdFile)oldIcon$iv), (Object)PersistentFileDataURIUtilKt.toDataURI((XdFile)icon$iv)) ^ true) {
                            field$iv2.set((Object)$receiver$iv2, (Object)icon$iv);
                        } else {
                            icon$iv.delete();
                        }
                    }
                } else {
                    field$iv2.set((Object)$receiver$iv2, null);
                }
            }
            $receiver$iv2 = (XdEntity)xd;
            field$iv2 = JetPassProjectDAO$updateEntity$6.INSTANCE;
            iconDataURI$iv = item.isArchived();
            assertions$iv = new Function0[]{isNotGlobal2};
            if (value$iv2 != null && (!ReflectionUtilKt.isDefined((XdEntity)($receiver$iv$iv = $receiver$iv2), XdProject.class, (KProperty1)((KProperty1)field$iv2)) || Intrinsics.areEqual((Object)value$iv2, (Object)((Comparable)field$iv2.get((Object)$receiver$iv2))) ^ true)) {
                $i$f$isDefined = $receiver$iv$iv = assertions$iv;
                int icon$iv = $i$f$isDefined.length;
                for (int j = 0; j < icon$iv; ++j) {
                    it$iv2 = element$iv$iv = $i$f$isDefined[j];
                    it$iv2.invoke();
                }
                field$iv2.set((Object)$receiver$iv2, (Object)value$iv2);
            }
            ResourceUpdater resourceUpdater = new ResourceUpdater(xd, this.getContainer());
            JetPassDAOUtilKt.merge(xd.getResources(), resourceUpdater, item.getResources());
            User user2 = item.getOwner();
            if (user2 != null) {
                KMutableProperty1 user3 = field$iv2 = user2;
                XdBaseUser xdUser = (XdBaseUser)JetPassReadOnlyDAO.resolve$default(this.getContainer().getUserDAO(), (IdItem)user3, true, false, 4, null);
                XdBaseUser $receiver$iv$iv5 = xdUser;
                if ($receiver$iv$iv5 instanceof XdUser) {
                    xd.setOwner((XdUser)xdUser);
                } else {
                    SecurityViolationException securityViolationException = SecurityViolationException.guestCantOwnProject();
                    Intrinsics.checkExpressionValueIsNotNull((Object)securityViolationException, (String)"SecurityViolationException.guestCantOwnProject()");
                    throw (Throwable)securityViolationException;
                }
            }
            ProjectTeam projectTeam = item.getTeam();
            if (projectTeam != null) {
                team = field$iv2 = projectTeam;
                this.getContainer().getJetPassProjectTeamDAO().updateEntity(xd.getTeam(), (ProjectTeam)team);
            }
            field$iv2 = (XdEntity)xd;
            team = JetPassProjectDAO$updateEntity$9.INSTANCE;
            String $i$a$8$let = item.getDashboard();
            Function0[] assertions$iv2 = new Function0[]{};
            if (value$iv != null && (!ReflectionUtilKt.isDefined((XdEntity)($receiver$iv$iv = $receiver$iv), XdProject.class, (KProperty1)((KProperty1)field$iv)) || Intrinsics.areEqual((Object)value$iv, (Object)field$iv.get((Object)$receiver$iv)) ^ true)) {
                Function0[] $i$f$isDefined2 = $receiver$iv$iv = assertions$iv2;
                int n2 = $i$f$isDefined2.length;
                for (int element$iv$iv2 = 0; element$iv$iv2 < n2; ++element$iv$iv2) {
                    Function0 element$iv$iv3;
                    Function0 it$iv3 = element$iv$iv3 = $i$f$isDefined2[element$iv$iv2];
                    it$iv3.invoke();
                }
                void var10_17 = value$iv;
                kMutableProperty1 = $receiver$iv;
                object = field$iv;
                void it$iv4 = var10_17;
                CharSequence charSequence = (CharSequence)it$iv4;
                Object object5 = !(charSequence.length() == 0) ? var10_17 : null;
                object.set((Object)kMutableProperty1, object5);
            }
            XdAuthorityHolder xdPrincipal = SecurityUtilKt.getXdPrincipal(JetPassProjectDAOKt.access$getHubPrincipalManager$p());
            if (!(xdPrincipal instanceof XdUser)) break block33;
            Boolean bl = item.isMyFavorite();
            if (bl != null) {
                object2 = bl;
                boolean isFavorite2 = (Boolean)object2;
                if (isFavorite2) {
                    ((XdUser)xdPrincipal).getFavoriteProjects().add((XdEntity)xd);
                } else {
                    ((XdUser)xdPrincipal).getFavoriteProjects().remove((XdEntity)xd);
                }
            }
        }
    }

    @NotNull
    public Sequence<JetPassTeam> getTeams(@NotNull String projectId) {
        Intrinsics.checkParameterIsNotNull((Object)projectId, (String)"projectId");
        return (Sequence)DataAccessExceptionUtilKt.daoTransaction$default(this.getContainer(), false, (Function1)new Function1<TransientStoreSession, IterableSequence<JetPassTeam>>(this, projectId){
            final /* synthetic */ JetPassProjectDAO this$0;
            final /* synthetic */ String $projectId;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final IterableSequence<JetPassTeam> invoke(@NotNull TransientStoreSession it) {
                void $receiver$iv;
                IterableSequence iterableSequence;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                XdProject xdProject = (XdProject)JetPassReadOnlyDAO.resolve$default(this.this$0, this.$projectId, true, false, false, 12, null);
                kotlin.sequences.Sequence sequence = XdQueryKt.asSequence(this.this$0.getContainer().getRoleDAO().getSecurity().filter(XdQueryKt.mapDistinct((XdQuery)xdProject.getRoles(), (KProperty1)((KProperty1)JetPassProjectDAO$getTeams$1$1.INSTANCE))));
                IterableSequence iterableSequence2 = iterableSequence;
                IterableSequence iterableSequence3 = iterableSequence;
                void var4_6 = $receiver$iv;
                Comparator comparator = new Comparator<T>(){

                    public final int compare(T a, T b) {
                        XdRole it = (XdRole)b;
                        Comparable comparable = Integer.valueOf(XdQueryKt.size((XdQuery)((XdQuery)it.getPermissions())));
                        it = (XdRole)a;
                        Comparable comparable2 = comparable;
                        Integer n = XdQueryKt.size((XdQuery)((XdQuery)it.getPermissions()));
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)n);
                    }
                };
                kotlin.sequences.Sequence sequence2 = SequencesKt.sortedWith((kotlin.sequences.Sequence)var4_6, (Comparator)comparator);
                iterableSequence2(SequencesKt.asIterable((kotlin.sequences.Sequence)SequencesKt.map((kotlin.sequences.Sequence)sequence2, (Function1)((Function1)new Function1<XdRole, JetPassTeam>(this, xdProject){
                    final /* synthetic */ getTeams.1 this$0;
                    final /* synthetic */ XdProject $xdProject;

                    @NotNull
                    public final JetPassTeam invoke(@NotNull XdRole it) {
                        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                        return new JetPassTeam(this.$xdProject, it, this.this$0.this$0.getContainer());
                    }
                    {
                        this.this$0 = var1_1;
                        this.$xdProject = xdProject;
                        super(1);
                    }
                }))));
                return iterableSequence3;
            }
            {
                this.this$0 = jetPassProjectDAO;
                this.$projectId = string;
                super(1);
            }
        }, 1, null);
    }

    @NotNull
    public JetPassTeam getWholeTeam(@NotNull String projectId) {
        Intrinsics.checkParameterIsNotNull((Object)projectId, (String)"projectId");
        return (JetPassTeam)DataAccessExceptionUtilKt.daoTransaction$default(this.getContainer(), false, (Function1)new Function1<TransientStoreSession, JetPassTeam>(this, projectId){
            final /* synthetic */ JetPassProjectDAO this$0;
            final /* synthetic */ String $projectId;

            @NotNull
            public final JetPassTeam invoke(@NotNull TransientStoreSession it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                XdProject project = (XdProject)JetPassReadOnlyDAO.resolve$default(this.this$0, this.$projectId, true, false, false, 12, null);
                return new JetPassTeam(project, null, this.this$0.getContainer());
            }
            {
                this.this$0 = jetPassProjectDAO;
                this.$projectId = string;
                super(1);
            }
        }, 1, null);
    }

    @NotNull
    public JetPassTeam getTeam(@NotNull String projectId, @NotNull String roleId) {
        Intrinsics.checkParameterIsNotNull((Object)projectId, (String)"projectId");
        Intrinsics.checkParameterIsNotNull((Object)roleId, (String)"roleId");
        return (JetPassTeam)DataAccessExceptionUtilKt.daoTransaction$default(this.getContainer(), false, (Function1)new Function1<TransientStoreSession, JetPassTeam>(this, projectId, roleId){
            final /* synthetic */ JetPassProjectDAO this$0;
            final /* synthetic */ String $projectId;
            final /* synthetic */ String $roleId;

            @NotNull
            public final JetPassTeam invoke(@NotNull TransientStoreSession it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                XdProject project = (XdProject)JetPassReadOnlyDAO.resolve$default(this.this$0, this.$projectId, true, false, false, 12, null);
                XdRole role = (XdRole)JetPassReadOnlyDAO.resolve$default(this.this$0.getContainer().getJetPassRoleDAO(), this.$roleId, true, false, false, 12, null);
                return new JetPassTeam(project, role, this.this$0.getContainer());
            }
            {
                this.this$0 = jetPassProjectDAO;
                this.$projectId = string;
                this.$roleId = string2;
                super(1);
            }
        }, 1, null);
    }

    @NotNull
    public Team addTeam(@NotNull String projectId, @NotNull Team team) {
        Intrinsics.checkParameterIsNotNull((Object)projectId, (String)"projectId");
        Intrinsics.checkParameterIsNotNull((Object)team, (String)"team");
        return (Team)DataAccessExceptionUtilKt.daoTransaction$default(this.getContainer(), false, (Function1)new Function1<TransientStoreSession, JetPassTeam>(this, projectId, team){
            final /* synthetic */ JetPassProjectDAO this$0;
            final /* synthetic */ String $projectId;
            final /* synthetic */ Team $team;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final JetPassTeam invoke(@NotNull TransientStoreSession it) {
                Iterable $receiver$iv;
                void $receiver$iv2;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                XdProject xdProject = (XdProject)JetPassReadOnlyDAO.resolve$default(this.this$0, this.$projectId, false, true, false, 10, null);
                KProperty1 kProperty1 = (KProperty1)JetPassProjectDAO$addTeam$1$teamRoles$1.INSTANCE;
                XdQuery xdQuery = (XdQuery)xdProject.getTeam().getRoles();
                NodeBase nodeBase = NodeBaseOperationsKt.eq((KProperty1)$receiver$iv2, (KClass)Reflection.getOrCreateKotlinClass(XdProjectRole.class), (XdEntity)((XdEntity)xdProject));
                XdQuery teamRoles2 = XdQueryKt.mapDistinct((XdQuery)XdQueryKt.query((XdQuery)xdQuery, (NodeBase)nodeBase), (KProperty1)((KProperty1)JetPassProjectDAO$addTeam$1$teamRoles$2.INSTANCE));
                if (this.$team.getRole() == null) {
                    throw (Throwable)new DataAccessException("A role is required");
                }
                Role role = this.$team.getRole();
                if (role == null || (role = (XdRole)JetPassReadonlyDAOUtilKt.resolveOrNull((IdItem)role, this.this$0.getContainer().getJetPassRoleDAO())) == null) {
                    throw (Throwable)new DataAccessException("Cannot resolve the role");
                }
                Role xdRole = role;
                boolean isTeamRole = XdQueryKt.contains((XdQuery)teamRoles2, (XdEntity)((XdEntity)xdRole));
                Iterable iterable = this.$team.getGroups();
                if (iterable != null) {
                    $receiver$iv = iterable;
                    for (T element$iv : $receiver$iv) {
                        UserGroup group = (UserGroup)element$iv;
                        JetPassProjectTeamDAO jetPassProjectTeamDAO = this.this$0.getContainer().getJetPassProjectTeamDAO();
                        UserGroup userGroup = group;
                        Intrinsics.checkExpressionValueIsNotNull((Object)userGroup, (String)"group");
                        ProjectTeam projectTeam = (ProjectTeam)jetPassProjectTeamDAO.get(userGroup.getId());
                        if (projectTeam != null) {
                            ProjectTeam projectTeam2;
                            ProjectTeam it2 = projectTeam2 = projectTeam;
                            StringBuilder stringBuilder = new StringBuilder().append("Adding teams into teams is not supported. Can't add ");
                            ProjectTeam projectTeam3 = it2;
                            Intrinsics.checkExpressionValueIsNotNull((Object)projectTeam3, (String)"it");
                            throw (Throwable)new DataWriteException(stringBuilder.append(projectTeam3.getName()).append(" into ").append(xdProject.getName()).append(" project's team.").toString());
                        }
                        JetPassProjectTeamDAO jetPassProjectTeamDAO2 = this.this$0.getContainer().getJetPassProjectTeamDAO();
                        String string = xdProject.getTeam().getUuid();
                        String string2 = group.getId();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"group.id");
                        jetPassProjectTeamDAO2.includeGroup(string, string2);
                        if (isTeamRole) continue;
                        JetPassAuthorityHolderMutableDAO jetPassAuthorityHolderMutableDAO = this.this$0.getContainer().getJetPassUserGroupDAO();
                        String string3 = group.getId();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"group.id");
                        JetPassProjectDAO.access$addOwnRole(this.this$0, jetPassAuthorityHolderMutableDAO, string3, this.$projectId, (XdRole)xdRole);
                    }
                }
                Iterable iterable2 = this.$team.getUsers();
                if (iterable2 != null) {
                    $receiver$iv = iterable2;
                    for (T element$iv : $receiver$iv) {
                        User user2 = (User)element$iv;
                        JetPassProjectTeamDAO jetPassProjectTeamDAO = this.this$0.getContainer().getJetPassProjectTeamDAO();
                        String string = xdProject.getTeam().getUuid();
                        User user3 = user2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)user3, (String)"user");
                        String string4 = user3.getId();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"user.id");
                        jetPassProjectTeamDAO.includeUser(string, string4);
                        if (isTeamRole) continue;
                        JetPassAuthorityHolderMutableDAO jetPassAuthorityHolderMutableDAO = this.this$0.getContainer().getJetPassUserDAO();
                        String string5 = user2.getId();
                        Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"user.id");
                        JetPassProjectDAO.access$addOwnRole(this.this$0, jetPassAuthorityHolderMutableDAO, string5, this.$projectId, (XdRole)xdRole);
                    }
                }
                return new JetPassTeam(xdProject, (XdRole)xdRole, this.this$0.getContainer());
            }
            {
                this.this$0 = jetPassProjectDAO;
                this.$projectId = string;
                this.$team = team;
                super(1);
            }
        }, 1, null);
    }

    private final void addOwnRole(JetPassAuthorityHolderMutableDAO<?, ?> authHolderDAO, String principalId, String projectID, XdRole role) {
        ProjectRoleImpl projectRole = new ProjectRoleImpl();
        projectRole.setRole((Role)JetPassReadonlyDAOUtilKt.wrap((XdEntity)role, this.getContainer().getJetPassRoleDAO()));
        projectRole.setProject((Project)JetPassReadonlyDAOUtilKt.wrap(JetPassReadOnlyDAO.resolve$default(this, projectID, true, false, false, 12, null), this.getContainer().getJetPassProjectDAO()));
        authHolderDAO.addRole(principalId, (ProjectRole)projectRole);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void deleteEntity(@NotNull XdProject xd, @Nullable XdProject successor) {
        void value$iv;
        KProperty1 $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)xd, (String)"xd");
        KProperty1 kProperty1 = (KProperty1)JetPassProjectDAO$deleteEntity$projectRoles$1.INSTANCE;
        XdEntityType xdEntityType = (XdEntityType)XdProjectRole.Companion;
        NodeBase nodeBase = NodeBaseOperationsKt.eq((KProperty1)$receiver$iv, (KClass)Reflection.getOrCreateKotlinClass(XdProjectRole.class), (XdEntity)((XdEntity)xd));
        $receiver$iv = (KProperty1)JetPassProjectDAO$deleteEntity$projectRoles$2.INSTANCE;
        XdEntity $i$f$eq = (XdEntity)xd.getTeam();
        NodeBase nodeBase2 = NodeBaseOperationsKt.ne((KProperty1)$receiver$iv, (KClass)Reflection.getOrCreateKotlinClass(XdProjectRole.class), (XdEntity)value$iv);
        XdQuery projectRoles2 = XdQueryKt.query((XdEntityType)xdEntityType, (NodeBase)NodeBaseOperationsKt.and((NodeBase)nodeBase, (NodeBase)nodeBase2));
        PermissionConstraints.Companion.assertProjectRolesDeletable(this.getContainer(), (XdQuery<XdProjectRole>)projectRoles2);
        super.deleteEntity((XdUUIDObject)xd, (XdUUIDObject)successor);
    }

    public final void assertNotGlobal(boolean isGlobal2) {
        if (isGlobal2) {
            throw (Throwable)new DataWriteException("Global project is not updatable");
        }
    }

    public JetPassProjectDAO(@NotNull JetPassDAOContainer container) {
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        super(container);
        this.entityType = XdProject.Companion;
        this.apiType = Project.class;
        this.security = new JetPassProjectSecurity();
        this.queryExecutor = new QueryExecutor((XdEntityType)XdProject.Companion, this.getSecurity());
    }

    static {
        QUERY_NOT_ARCHIVED = QUERY_NOT_ARCHIVED;
    }

    public static final /* synthetic */ void access$addOwnRole(JetPassProjectDAO $this, @NotNull JetPassAuthorityHolderMutableDAO authHolderDAO, @NotNull String principalId, @NotNull String projectID, @NotNull XdRole role) {
        $this.addOwnRole(authHolderDAO, principalId, projectID, role);
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Ljetbrains/jetpass/dao/dnq/api/security/JetPassProjectDAO$ResourceUpdater;", "Ljetbrains/jetpass/dao/dnq/api/security/JetPassResourceDAO;", "xdProject", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdProject;", "container", "Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "(Ljetbrains/jetpass/userManagement/persistence/dnq/XdProject;Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;)V", "updateEntity", "", "xd", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdResource;", "item", "Ljetbrains/jetpass/api/security/Resource;", "jetbrains.jetpass.dao.dnq"})
    private static final class ResourceUpdater
    extends JetPassResourceDAO {
        private final XdProject xdProject;

        @Override
        public void updateEntity(@NotNull XdResource xd, @NotNull Resource item) {
            Intrinsics.checkParameterIsNotNull((Object)xd, (String)"xd");
            Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
            super.updateEntity(xd, item);
            this.xdProject.getResources().add((XdEntity)xd);
        }

        public ResourceUpdater(@NotNull XdProject xdProject, @NotNull JetPassDAOContainer container) {
            Intrinsics.checkParameterIsNotNull((Object)xdProject, (String)"xdProject");
            Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
            super(container, null, 2, null);
            this.xdProject = xdProject;
        }
    }

    @Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Ljetbrains/jetpass/dao/dnq/api/security/JetPassProjectDAO$Companion;", "Lmu/KLogging;", "()V", "QUERY_NOT_ARCHIVED", "", "jetbrains.jetpass.dao.dnq"})
    public static final class Companion
    extends KLogging {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

