/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.dao.dnq.api.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import jetbrains.jetpass.dao.api.permissionCache.PermissionQuery;
import jetbrains.jetpass.dao.dnq.api.security.JetPassCreateGlobalSecurity;
import jetbrains.jetpass.dao.dnq.api.security.SecurityUtilKt;
import jetbrains.jetpass.userManagement.persistence.dnq.XdBaseUser;
import jetbrains.jetpass.userManagement.persistence.dnq.XdProject;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u001a\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00022\u0006\u0010\u0011\u001a\u00020\u000fH\u0016J\u001c\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00020\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00020\u0013H\u0016J\u0014\u0010\u0015\u001a\u0004\u0018\u00010\u00022\b\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0014\u0010\n\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0014\u0010\f\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007\u00a8\u0006\u0016"}, d2={"Ljetbrains/jetpass/dao/dnq/api/security/JetPassProjectSecurity;", "Ljetbrains/jetpass/dao/dnq/api/security/JetPassCreateGlobalSecurity;", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdProject;", "()V", "createPermissionKey", "", "getCreatePermissionKey", "()Ljava/lang/String;", "deletePermissionKey", "getDeletePermissionKey", "readPermissionKey", "getReadPermissionKey", "updatePermissionKey", "getUpdatePermissionKey", "canRead", "", "xd", "full", "filter", "Lkotlinx/dnq/query/XdQuery;", "unsecured", "getProjectFor", "jetbrains.jetpass.dao.dnq"})
public final class JetPassProjectSecurity
extends JetPassCreateGlobalSecurity<XdProject> {
    @NotNull
    private final String createPermissionKey = "jetbrains.jetpass.project-create";
    @NotNull
    private final String readPermissionKey = "jetbrains.jetpass.project-read";
    @NotNull
    private final String updatePermissionKey = "jetbrains.jetpass.project-update";
    @NotNull
    private final String deletePermissionKey = "jetbrains.jetpass.project-delete";

    @Override
    @NotNull
    public String getCreatePermissionKey() {
        return this.createPermissionKey;
    }

    @Override
    @NotNull
    public String getReadPermissionKey() {
        return this.readPermissionKey;
    }

    @Override
    @NotNull
    public String getUpdatePermissionKey() {
        return this.updatePermissionKey;
    }

    @Override
    @NotNull
    public String getDeletePermissionKey() {
        return this.deletePermissionKey;
    }

    @Override
    public boolean canRead(@Nullable XdProject xd, boolean full) {
        return xd == null ? false : (SecurityUtilKt.hasPermission(this.getReadPermissionKey(), xd) ? true : !full && SecurityUtilKt.hasPermission("jetbrains.jetpass.project-read-basic", xd));
    }

    @Override
    @NotNull
    public XdQuery<XdProject> filter(@NotNull XdQuery<? extends XdProject> unsecured) {
        Intrinsics.checkParameterIsNotNull(unsecured, (String)"unsecured");
        return SecurityUtilKt.checkPermission(unsecured, (Function1)new Function1<XdBaseUser, XdQuery<? extends XdProject>>(this, unsecured){
            final /* synthetic */ JetPassProjectSecurity this$0;
            final /* synthetic */ XdQuery $unsecured;

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final XdQuery<XdProject> invoke(@NotNull XdBaseUser xdPrincipal) {
                XdQuery xdQuery;
                Intrinsics.checkParameterIsNotNull((Object)xdPrincipal, (String)"xdPrincipal");
                PermissionQuery permissionQuery = this.this$0.getDaoContainer().getJetPassUserDAO().getPermissionQuery(xdPrincipal.getUuid());
                String string = SecurityUtilKt.resolvePermission("jetbrains.jetpass.project-read-basic").getId();
                Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"resolvePermission(Builti\u2026cProjectPermissionKey).id");
                PermissionQuery basicReadPQ = permissionQuery.withPermission(string);
                PermissionQuery permissionQuery2 = this.this$0.getDaoContainer().getJetPassUserDAO().getPermissionQuery(xdPrincipal.getUuid());
                String string2 = SecurityUtilKt.resolvePermission("jetbrains.jetpass.project-read").getId();
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"resolvePermission(Builti\u2026dProjectPermissionKey).id");
                PermissionQuery fullReadPQ = permissionQuery2.withPermission(string2);
                if (basicReadPQ.canAccessGlobal() || fullReadPQ.canAccessGlobal()) {
                    xdQuery = this.$unsecured;
                } else {
                    Collection<XdProject> collection;
                    void $receiver$iv$iv;
                    Collection $receiver$iv;
                    Iterable iterable = CollectionsKt.union((Iterable)basicReadPQ.getAccessibleProjectsUnordered(), (Iterable)fullReadPQ.getAccessibleProjectsUnordered());
                    XdEntityType xdEntityType = (XdEntityType)XdProject.Companion;
                    void var6_6 = $receiver$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$receiver$iv, (int)10));
                    for (T item$iv$iv : $receiver$iv$iv) {
                        void projectID;
                        String string3 = (String)item$iv$iv;
                        collection = destination$iv$iv;
                        XdProject xdProject = (XdProject)XdProject.Companion.resolve((String)projectID);
                        collection.add(xdProject);
                    }
                    collection = (List)destination$iv$iv;
                    Collection thisCollection$iv = $receiver$iv = (Collection)collection;
                    XdProject[] xdProjectArray = thisCollection$iv.toArray(new XdProject[0]);
                    if (xdProjectArray == null) {
                        throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
                    }
                    collection = xdProjectArray;
                    XdProject[] xdProjectArray2 = (XdProject[])collection;
                    XdQuery accessibleProjects = XdQueryKt.queryOf((XdEntityType)xdEntityType, (XdEntity[])Arrays.copyOf(xdProjectArray2, xdProjectArray2.length));
                    xdQuery = XdQueryKt.intersect((XdQuery)accessibleProjects, (XdQuery)this.$unsecured);
                }
                return xdQuery;
            }
            {
                this.this$0 = jetPassProjectSecurity;
                this.$unsecured = xdQuery;
                super(1);
            }
        });
    }

    @Override
    @Nullable
    protected XdProject getProjectFor(@Nullable XdProject xd) {
        return xd;
    }
}

