/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.jetpass.dao.dnq.api.security;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import jetbrains.exodus.database.TransientStoreSession;
import jetbrains.jetpass.api.IdItem;
import jetbrains.jetpass.api.authority.AuthorityHolder;
import jetbrains.jetpass.api.authority.ProjectTeam;
import jetbrains.jetpass.api.authority.User;
import jetbrains.jetpass.api.authority.UserGroup;
import jetbrains.jetpass.api.security.ProjectRole;
import jetbrains.jetpass.core.lang.CollectionsExtKt;
import jetbrains.jetpass.dao.api.DataWriteException;
import jetbrains.jetpass.dao.api.authority.ProjectTeamDAO;
import jetbrains.jetpass.dao.api.permissionCache.PermissionQuery;
import jetbrains.jetpass.dao.dnq.api.DataAccessExceptionUtilKt;
import jetbrains.jetpass.dao.dnq.api.JetPassDAOContainer;
import jetbrains.jetpass.dao.dnq.api.JetPassReadOnlyDAO;
import jetbrains.jetpass.dao.dnq.api.JetPassReadonlyDAOUtilKt;
import jetbrains.jetpass.dao.dnq.api.authority.JetPassAuthorityHolderMutableDAO;
import jetbrains.jetpass.dao.dnq.api.authority.JetPassProjectTeam;
import jetbrains.jetpass.dao.dnq.api.authority.JetPassUserDAO;
import jetbrains.jetpass.dao.dnq.api.authority.JetPassUserGroup;
import jetbrains.jetpass.dao.dnq.api.authority.JetPassUserGroupDAO;
import jetbrains.jetpass.dao.dnq.api.security.JetPassProjectTeamDAO;
import jetbrains.jetpass.dao.dnq.api.security.JetPassProjectTeamDAOKt;
import jetbrains.jetpass.dao.dnq.api.security.JetPassProjectTeamSecurity;
import jetbrains.jetpass.dao.dnq.api.security.ProjectTeamDaoException;
import jetbrains.jetpass.dao.dnq.query.QueryExecutor;
import jetbrains.jetpass.sequence.Sequence;
import jetbrains.jetpass.userManagement.persistence.dnq.XdAllUsersGroup;
import jetbrains.jetpass.userManagement.persistence.dnq.XdAuthorityHolder;
import jetbrains.jetpass.userManagement.persistence.dnq.XdBaseUser;
import jetbrains.jetpass.userManagement.persistence.dnq.XdBaseUserGroup;
import jetbrains.jetpass.userManagement.persistence.dnq.XdProject;
import jetbrains.jetpass.userManagement.persistence.dnq.XdProjectRole;
import jetbrains.jetpass.userManagement.persistence.dnq.XdProjectTeam;
import jetbrains.jetpass.userManagement.persistence.dnq.XdRole;
import jetbrains.jetpass.userManagement.persistence.dnq.XdRoots;
import jetbrains.jetpass.userManagement.persistence.dnq.XdUserGroup;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.dnq.XdEntity;
import kotlinx.dnq.XdEntityType;
import kotlinx.dnq.query.FilteringContext;
import kotlinx.dnq.query.XdFilteringQueryKt;
import kotlinx.dnq.query.XdMutableQuery;
import kotlinx.dnq.query.XdQuery;
import kotlinx.dnq.query.XdQueryKt;
import kotlinx.dnq.query.XdSearchingNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u00012\u00020\u0004B\r\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J(\u0010#\u001a\u00020\u00022\u0006\u0010$\u001a\u00020\u00022\u0006\u0010%\u001a\u00020&2\u000e\u0010'\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010)0(H\u0016J\u0012\u0010*\u001a\u00020&2\b\u0010+\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010,\u001a\u00020\u00022\u0006\u0010+\u001a\u00020\u0002H\u0016J\u0010\u0010-\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u0002H\u0016J\u001a\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020\u00032\b\u00101\u001a\u0004\u0018\u00010\u0003H\u0014J\u0016\u00102\u001a\b\u0012\u0004\u0012\u00020\u0002032\u0006\u00104\u001a\u000205H\u0016J\u0010\u00106\u001a\u0002072\u0006\u00108\u001a\u000205H\u0016J\u0018\u00109\u001a\u00020/2\u0006\u0010$\u001a\u00020\u00032\u0006\u0010:\u001a\u00020;H\u0002J\u0018\u00109\u001a\u00020<2\u0006\u0010=\u001a\u0002052\u0006\u0010>\u001a\u000205H\u0016J\u0018\u0010?\u001a\u00020@2\u0006\u0010=\u001a\u0002052\u0006\u0010A\u001a\u000205H\u0016J\u0010\u0010B\u001a\u00020C2\u0006\u00104\u001a\u000205H\u0014J\u0018\u0010D\u001a\u00020/2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u00020HH\u0002J\u0018\u0010I\u001a\u00020/2\u0006\u0010=\u001a\u0002052\u0006\u0010>\u001a\u000205H\u0016J \u0010I\u001a\u00020/2\u0006\u0010=\u001a\u0002052\u0006\u0010>\u001a\u0002052\u0006\u0010J\u001a\u00020&H\u0016J\u0018\u0010K\u001a\u00020/2\u0006\u0010=\u001a\u0002052\u0006\u0010A\u001a\u000205H\u0016J\u0012\u0010L\u001a\u0004\u0018\u00010\u00032\u0006\u0010M\u001a\u000205H\u0016J\u0018\u0010N\u001a\u00020/2\u0006\u00100\u001a\u00020\u00032\u0006\u0010+\u001a\u00020\u0002H\u0016J \u0010O\u001a\u00020/2\u0006\u0010$\u001a\u00020\u00032\u0006\u0010P\u001a\u00020Q2\u0006\u0010R\u001a\u00020&H\u0002J \u0010O\u001a\u00020@2\u0006\u0010=\u001a\u0002052\u0006\u0010A\u001a\u0002052\u0006\u0010R\u001a\u00020&H\u0002J\u0010\u0010S\u001a\u00020\u00022\u0006\u00100\u001a\u00020\u0003H\u0016J\u0014\u0010T\u001a\u00020/*\u00020\u00032\u0006\u0010P\u001a\u00020QH\u0002R\u001a\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\u00038VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0010X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00030\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020 8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006U"}, d2={"Ljetbrains/jetpass/dao/dnq/api/security/JetPassProjectTeamDAO;", "Ljetbrains/jetpass/dao/dnq/api/authority/JetPassAuthorityHolderMutableDAO;", "Ljetbrains/jetpass/api/authority/ProjectTeam;", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdProjectTeam;", "Ljetbrains/jetpass/dao/api/authority/ProjectTeamDAO;", "container", "Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;", "(Ljetbrains/jetpass/dao/dnq/api/JetPassDAOContainer;)V", "apiType", "Ljava/lang/Class;", "getApiType", "()Ljava/lang/Class;", "defaultSuccessor", "getDefaultSuccessor", "()Ljetbrains/jetpass/userManagement/persistence/dnq/XdProjectTeam;", "entityType", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdProjectTeam$Companion;", "getEntityType", "()Ljetbrains/jetpass/userManagement/persistence/dnq/XdProjectTeam$Companion;", "queryExecutor", "Ljetbrains/jetpass/dao/dnq/query/QueryExecutor;", "getQueryExecutor", "()Ljetbrains/jetpass/dao/dnq/query/QueryExecutor;", "security", "Ljetbrains/jetpass/dao/dnq/api/security/JetPassProjectTeamSecurity;", "getSecurity", "()Ljetbrains/jetpass/dao/dnq/api/security/JetPassProjectTeamSecurity;", "userDAO", "Ljetbrains/jetpass/dao/dnq/api/authority/JetPassUserDAO;", "getUserDAO", "()Ljetbrains/jetpass/dao/dnq/api/authority/JetPassUserDAO;", "userGroupDAO", "Ljetbrains/jetpass/dao/dnq/api/authority/JetPassUserGroupDAO;", "getUserGroupDAO", "()Ljetbrains/jetpass/dao/dnq/api/authority/JetPassUserGroupDAO;", "absorbGroups", "team", "absorbMembers", "", "groups", "", "Ljetbrains/jetpass/api/authority/UserGroup;", "canCreate", "item", "create", "createEntity", "deleteEntity", "", "xd", "successor", "getByName", "Ljetbrains/jetpass/sequence/Sequence;", "name", "", "getPermissionQuery", "Ljetbrains/jetpass/dao/api/permissionCache/PermissionQuery;", "authorityHolderId", "includeGroup", "group", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdBaseUserGroup;", "Ljetbrains/jetpass/dao/dnq/api/authority/JetPassUserGroup;", "teamId", "groupId", "includeUser", "Ljetbrains/jetpass/api/authority/User;", "userId", "nameFilter", "", "removeExplicitDeveloperRole", "authorityHolder", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdAuthorityHolder;", "project", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdProject;", "removeGroup", "keepUsers", "removeUser", "resolveOrNull", "id", "updateEntity", "updateUsers", "user", "Ljetbrains/jetpass/userManagement/persistence/dnq/XdBaseUser;", "add", "wrapEntity", "assertNotTransitive", "jetbrains.jetpass.dao.dnq"})
public final class JetPassProjectTeamDAO
extends JetPassAuthorityHolderMutableDAO<ProjectTeam, XdProjectTeam>
implements ProjectTeamDAO {
    @NotNull
    private final XdProjectTeam.Companion entityType;
    @NotNull
    private final Class<ProjectTeam> apiType;
    @NotNull
    private final JetPassProjectTeamSecurity security;
    @NotNull
    private final QueryExecutor<XdProjectTeam> queryExecutor;

    @NotNull
    public XdProjectTeam.Companion getEntityType() {
        return this.entityType;
    }

    @Override
    @NotNull
    public Class<ProjectTeam> getApiType() {
        return this.apiType;
    }

    @NotNull
    public JetPassProjectTeamSecurity getSecurity() {
        return this.security;
    }

    @Override
    @NotNull
    public QueryExecutor<XdProjectTeam> getQueryExecutor() {
        return this.queryExecutor;
    }

    @Override
    @NotNull
    public XdProjectTeam getDefaultSuccessor() {
        return XdRoots.INSTANCE.getGlobalProject().getTeam();
    }

    private final JetPassUserGroupDAO getUserGroupDAO() {
        return this.getContainer().getJetPassUserGroupDAO();
    }

    private final JetPassUserDAO getUserDAO() {
        return this.getContainer().getJetPassUserDAO();
    }

    @Override
    @NotNull
    public ProjectTeam wrapEntity(@NotNull XdProjectTeam xd) {
        Intrinsics.checkParameterIsNotNull((Object)xd, (String)"xd");
        return new JetPassProjectTeam(xd, this.getContainer());
    }

    @Override
    @Nullable
    public XdProjectTeam resolveOrNull(@NotNull String id) {
        Intrinsics.checkParameterIsNotNull((Object)id, (String)"id");
        return (XdProjectTeam)this.getEntityType().resolve(id);
    }

    @NotNull
    public JetPassUserGroup includeGroup(@NotNull String teamId, @NotNull String groupId) {
        Intrinsics.checkParameterIsNotNull((Object)teamId, (String)"teamId");
        Intrinsics.checkParameterIsNotNull((Object)groupId, (String)"groupId");
        return (JetPassUserGroup)DataAccessExceptionUtilKt.daoTransaction$default(this.getContainer(), false, (Function1)new Function1<TransientStoreSession, JetPassUserGroup>(this, teamId, groupId){
            final /* synthetic */ JetPassProjectTeamDAO this$0;
            final /* synthetic */ String $teamId;
            final /* synthetic */ String $groupId;

            @NotNull
            public final JetPassUserGroup invoke(@NotNull TransientStoreSession it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                XdProjectTeam team = (XdProjectTeam)JetPassReadOnlyDAO.resolve$default(this.this$0, this.$teamId, true, true, false, 8, null);
                XdBaseUserGroup group = (XdBaseUserGroup)JetPassReadOnlyDAO.resolve$default(JetPassProjectTeamDAO.access$getUserGroupDAO$p(this.this$0), this.$groupId, true, false, false, 12, null);
                JetPassProjectTeamDAO.access$includeGroup(this.this$0, team, group);
                return JetPassProjectTeamDAO.access$getUserGroupDAO$p(this.this$0).wrapEntity(group);
            }
            {
                this.this$0 = jetPassProjectTeamDAO;
                this.$teamId = string;
                this.$groupId = string2;
                super(1);
            }
        }, 1, null);
    }

    public void removeGroup(@NotNull String teamId, @NotNull String groupId) {
        Intrinsics.checkParameterIsNotNull((Object)teamId, (String)"teamId");
        Intrinsics.checkParameterIsNotNull((Object)groupId, (String)"groupId");
        this.removeGroup(teamId, groupId, false);
    }

    public void removeGroup(@NotNull String teamId, @NotNull String groupId, boolean keepUsers) {
        Intrinsics.checkParameterIsNotNull((Object)teamId, (String)"teamId");
        Intrinsics.checkParameterIsNotNull((Object)groupId, (String)"groupId");
        DataAccessExceptionUtilKt.daoTransaction$default(this.getContainer(), false, (Function1)new Function1<TransientStoreSession, Unit>(this, teamId, groupId, keepUsers){
            final /* synthetic */ JetPassProjectTeamDAO this$0;
            final /* synthetic */ String $teamId;
            final /* synthetic */ String $groupId;
            final /* synthetic */ boolean $keepUsers;

            public final void invoke(@NotNull TransientStoreSession it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                XdProjectTeam team = (XdProjectTeam)JetPassReadOnlyDAO.resolve$default(this.this$0, this.$teamId, true, true, false, 8, null);
                XdBaseUserGroup group = (XdBaseUserGroup)JetPassReadOnlyDAO.resolve$default(JetPassProjectTeamDAO.access$getUserGroupDAO$p(this.this$0), this.$groupId, true, false, false, 12, null);
                team.getGroups().remove((XdEntity)group);
                if (this.$keepUsers) {
                    XdQueryKt.addAll((XdMutableQuery)team.getUsers(), (XdQuery)group.getTransitiveUsers());
                }
                JetPassProjectTeamDAO.access$getUserGroupDAO$p(this.this$0).wrapEntity(group);
            }
            {
                this.this$0 = jetPassProjectTeamDAO;
                this.$teamId = string;
                this.$groupId = string2;
                this.$keepUsers = bl;
                super(1);
            }
        }, 1, null);
    }

    @Override
    public void updateEntity(@NotNull XdProjectTeam xd, @NotNull ProjectTeam item) {
        Iterable iterable;
        Iterable $receiver$iv;
        Intrinsics.checkParameterIsNotNull((Object)xd, (String)"xd");
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        super.updateEntity((XdAuthorityHolder)xd, (AuthorityHolder)item);
        Iterable iterable2 = item.getProjectRoles();
        if (iterable2 != null && (iterable2 = CollectionsKt.filterNotNull((Iterable)iterable2)) != null) {
            $receiver$iv = iterable2;
            for (Object element$iv : $receiver$iv) {
                ProjectRole projectRole = (ProjectRole)element$iv;
                this.addRole(xd.getUuid(), projectRole);
            }
        }
        if ((iterable = item.getGroups()) != null && (iterable = CollectionsKt.filterNotNull((Iterable)iterable)) != null) {
            $receiver$iv = iterable;
            for (Object element$iv : $receiver$iv) {
                UserGroup group = (UserGroup)element$iv;
                XdBaseUserGroup xdGroup2 = (XdBaseUserGroup)JetPassReadOnlyDAO.resolve$default(this.getUserGroupDAO(), (IdItem)group, true, false, 4, null);
                this.includeGroup(xd, xdGroup2);
            }
        }
        $receiver$iv = CollectionsKt.filterNotNull((Iterable)CollectionsExtKt.joinNotNull((Iterable[])new Iterable[]{item.getUsers(), item.getOwnUsers()}));
        for (Object element$iv : $receiver$iv) {
            User user2 = (User)element$iv;
            XdBaseUser xdUser = (XdBaseUser)JetPassReadOnlyDAO.resolve$default(this.getUserDAO(), (IdItem)user2, true, false, 4, null);
            this.updateUsers(xd, xdUser, true);
        }
    }

    @NotNull
    public User includeUser(@NotNull String teamId, @NotNull String userId) {
        Intrinsics.checkParameterIsNotNull((Object)teamId, (String)"teamId");
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        return (User)DataAccessExceptionUtilKt.daoTransaction$default(this.getContainer(), false, (Function1)new Function1<TransientStoreSession, User>(this, teamId, userId){
            final /* synthetic */ JetPassProjectTeamDAO this$0;
            final /* synthetic */ String $teamId;
            final /* synthetic */ String $userId;

            @NotNull
            public final User invoke(@NotNull TransientStoreSession it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return JetPassProjectTeamDAO.access$updateUsers(this.this$0, this.$teamId, this.$userId, true);
            }
            {
                this.this$0 = jetPassProjectTeamDAO;
                this.$teamId = string;
                this.$userId = string2;
                super(1);
            }
        }, 1, null);
    }

    public void removeUser(@NotNull String teamId, @NotNull String userId) {
        Intrinsics.checkParameterIsNotNull((Object)teamId, (String)"teamId");
        Intrinsics.checkParameterIsNotNull((Object)userId, (String)"userId");
        DataAccessExceptionUtilKt.daoTransaction$default(this.getContainer(), false, (Function1)new Function1<TransientStoreSession, Unit>(this, teamId, userId){
            final /* synthetic */ JetPassProjectTeamDAO this$0;
            final /* synthetic */ String $teamId;
            final /* synthetic */ String $userId;

            public final void invoke(@NotNull TransientStoreSession it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                JetPassProjectTeamDAO.access$updateUsers(this.this$0, this.$teamId, this.$userId, false);
            }
            {
                this.this$0 = jetPassProjectTeamDAO;
                this.$teamId = string;
                this.$userId = string2;
                super(1);
            }
        }, 1, null);
    }

    private final void includeGroup(XdProjectTeam team, XdBaseUserGroup group) {
        team.getGroups().add((XdEntity)group);
        this.removeExplicitDeveloperRole((XdAuthorityHolder)group, team.getProject());
    }

    private final User updateUsers(String teamId, String userId, boolean add) {
        XdProjectTeam team = (XdProjectTeam)JetPassReadOnlyDAO.resolve$default(this, teamId, true, true, false, 8, null);
        XdBaseUser user2 = (XdBaseUser)JetPassReadOnlyDAO.resolve$default(this.getUserDAO(), userId, true, false, false, 12, null);
        this.updateUsers(team, user2, add);
        return this.getUserDAO().wrapEntity(user2);
    }

    private final void updateUsers(XdProjectTeam team, XdBaseUser user2, boolean add) {
        if (add) {
            team.getUsers().add((XdEntity)user2);
            this.removeExplicitDeveloperRole((XdAuthorityHolder)user2, team.getProject());
        } else {
            this.assertNotTransitive(team, user2);
            team.getUsers().remove((XdEntity)user2);
        }
    }

    @NotNull
    protected Void nameFilter(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        throw (Throwable)new UnsupportedOperationException();
    }

    @Override
    @NotNull
    public Sequence<ProjectTeam> getByName(@NotNull String name) {
        Intrinsics.checkParameterIsNotNull((Object)name, (String)"name");
        String projectName2 = StringsKt.removeSuffix((String)name, (CharSequence)" Team");
        return this.getContainer().getProjectDAO().getByName(projectName2).map((Function1)getByName.1.INSTANCE);
    }

    @NotNull
    public ProjectTeam absorbGroups(@NotNull ProjectTeam team, boolean absorbMembers, @NotNull Iterable<? extends UserGroup> groups) {
        Intrinsics.checkParameterIsNotNull((Object)team, (String)"team");
        Intrinsics.checkParameterIsNotNull(groups, (String)"groups");
        return (ProjectTeam)DataAccessExceptionUtilKt.daoTransaction$default(this.getContainer(), false, (Function1)new Function1<TransientStoreSession, ProjectTeam>(this, team, groups, absorbMembers){
            final /* synthetic */ JetPassProjectTeamDAO this$0;
            final /* synthetic */ ProjectTeam $team;
            final /* synthetic */ Iterable $groups;
            final /* synthetic */ boolean $absorbMembers;

            @NotNull
            public final ProjectTeam invoke(@NotNull TransientStoreSession it) {
                Iterable $receiver$iv$iv;
                Iterable $receiver$iv;
                ProjectTeam projectTeam;
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                ProjectTeam it2 = projectTeam = this.$team;
                XdProjectTeam xdTeam = (XdProjectTeam)this.this$0.resolve((IdItem)it2, true, true);
                Iterable $i$a$1$let = $receiver$iv = (Iterable)CollectionsKt.filterNotNull((Iterable)this.$groups);
                Collection destination$iv$iv = new ArrayList<E>();
                void $receiver$iv$iv$iv = $receiver$iv$iv;
                Iterator<T> iterator2 = $receiver$iv$iv$iv.iterator();
                while (iterator2.hasNext()) {
                    XdBaseUserGroup xdBaseUserGroup;
                    XdBaseUserGroup xdBaseUserGroup2;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator2.next();
                    UserGroup it3 = (UserGroup)element$iv$iv;
                    if ((XdBaseUserGroup)JetPassProjectTeamDAO.access$getUserGroupDAO$p(this.this$0).resolveOrNull((IdItem)it3) != null) {
                        XdBaseUserGroup xdBaseUserGroup3;
                        XdBaseUserGroup it4 = xdBaseUserGroup3;
                        if (it4 instanceof XdAllUsersGroup) {
                            throw (Throwable)((Object)ProjectTeamDaoException.Companion.unableToMerge(xdTeam.getName(), "All Users group"));
                        }
                        JetPassReadonlyDAOUtilKt.checkReadable((XdEntity)it4, JetPassProjectTeamDAO.access$getUserGroupDAO$p(this.this$0));
                        JetPassReadonlyDAOUtilKt.checkDeletable((XdEntity)it4, JetPassProjectTeamDAO.access$getUserGroupDAO$p(this.this$0));
                        xdBaseUserGroup2 = it4;
                    } else {
                        xdBaseUserGroup2 = null;
                    }
                    if (xdBaseUserGroup2 == null) continue;
                    XdBaseUserGroup it$iv$iv = xdBaseUserGroup = xdBaseUserGroup2;
                    destination$iv$iv.add(it$iv$iv);
                }
                $receiver$iv = (List)destination$iv$iv;
                $receiver$iv$iv = $receiver$iv;
                destination$iv$iv = new ArrayList<E>();
                for (T element$iv$iv : $receiver$iv$iv) {
                    if (!(element$iv$iv instanceof XdUserGroup)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                List xdGroups = (List)destination$iv$iv;
                if (CollectionsKt.any((Iterable)xdGroups)) {
                    Iterable iterable = xdGroups;
                    XdProjectTeam xdProjectTeam = xdTeam;
                    Iterable iterable2 = iterable;
                    xdProjectTeam.absorb(iterable2, this.$absorbMembers, false);
                }
                return this.this$0.wrapEntity(xdTeam);
            }
            {
                this.this$0 = jetPassProjectTeamDAO;
                this.$team = projectTeam;
                this.$groups = iterable;
                this.$absorbMembers = bl;
                super(1);
            }
        }, 1, null);
    }

    @Override
    @NotNull
    public PermissionQuery getPermissionQuery(@NotNull String authorityHolderId) {
        Intrinsics.checkParameterIsNotNull((Object)authorityHolderId, (String)"authorityHolderId");
        return JetPassProjectTeamDAOKt.access$getPermissionCache$p().team(authorityHolderId);
    }

    @Override
    public boolean canCreate(@Nullable ProjectTeam item) {
        return false;
    }

    @Override
    @NotNull
    public ProjectTeam create(@NotNull ProjectTeam item) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        throw (Throwable)new UnsupportedOperationException("Direct creation of teams is not supported. Teams are created with projects.");
    }

    @Override
    @NotNull
    public XdProjectTeam createEntity(@NotNull ProjectTeam item) {
        Intrinsics.checkParameterIsNotNull((Object)item, (String)"item");
        throw (Throwable)new UnsupportedOperationException("Direct creation of teams is not supported. Teams are created with projects.");
    }

    @Override
    protected void deleteEntity(@NotNull XdProjectTeam xd, @Nullable XdProjectTeam successor) {
        Intrinsics.checkParameterIsNotNull((Object)xd, (String)"xd");
        throw (Throwable)new UnsupportedOperationException("Direct deletion of teams is not supported. You need to delete the project of the team.");
    }

    private final void assertNotTransitive(@NotNull XdProjectTeam $receiver, XdBaseUser user2) {
        if (!XdQueryKt.contains((XdQuery)((XdQuery)$receiver.getUsers()), (XdEntity)((XdEntity)user2)) && XdQueryKt.contains((XdQuery)((XdQuery)$receiver.getTransitiveUsers()), (XdEntity)((XdEntity)user2))) {
            throw (Throwable)new DataWriteException("Can't exclude a transitive user [" + user2.getLogin() + "] from the [" + $receiver.getName() + "]. Transitive users should be excluded with groups.");
        }
    }

    private final void removeExplicitDeveloperRole(XdAuthorityHolder authorityHolder, XdProject project) {
        XdRole xdDevRole = XdRole.Companion.getDeveloperRole();
        if (xdDevRole == null || !project.getTeam().hasRole(xdDevRole)) {
            return;
        }
        XdQuery roles2 = XdFilteringQueryKt.filter((XdQuery)((XdQuery)authorityHolder.getRoles()), (Function2)((Function2)new Function2<FilteringContext, XdProjectRole, XdSearchingNode>(project, xdDevRole){
            final /* synthetic */ XdProject $project;
            final /* synthetic */ XdRole $xdDevRole;

            @NotNull
            public final XdSearchingNode invoke(@NotNull FilteringContext $receiver, @NotNull XdProjectRole it) {
                Intrinsics.checkParameterIsNotNull((Object)$receiver, (String)"$receiver");
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                return $receiver.eq((XdEntity)it.getProject(), (XdEntity)this.$project).and($receiver.eq((XdEntity)it.getRole(), (XdEntity)this.$xdDevRole));
            }
            {
                this.$project = xdProject;
                this.$xdDevRole = xdRole;
                super(2);
            }
        }));
        if (XdQueryKt.isNotEmpty((XdQuery)roles2)) {
            Iterable $receiver$iv = XdQueryKt.toList((XdQuery)roles2);
            for (Object element$iv : $receiver$iv) {
                XdProjectRole it = (XdProjectRole)element$iv;
                it.delete();
            }
        }
    }

    public JetPassProjectTeamDAO(@NotNull JetPassDAOContainer container) {
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        super(container);
        this.entityType = XdProjectTeam.Companion;
        this.apiType = ProjectTeam.class;
        this.security = new JetPassProjectTeamSecurity(container.getJetPassProjectDAO().getSecurity());
        this.queryExecutor = new QueryExecutor((XdEntityType)XdProjectTeam.Companion, this.getSecurity());
    }

    @NotNull
    public static final /* synthetic */ JetPassUserGroupDAO access$getUserGroupDAO$p(JetPassProjectTeamDAO $this) {
        return $this.getUserGroupDAO();
    }

    public static final /* synthetic */ void access$includeGroup(JetPassProjectTeamDAO $this, @NotNull XdProjectTeam team, @NotNull XdBaseUserGroup group) {
        $this.includeGroup(team, group);
    }

    @NotNull
    public static final /* synthetic */ User access$updateUsers(JetPassProjectTeamDAO $this, @NotNull String teamId, @NotNull String userId, boolean add) {
        return $this.updateUsers(teamId, userId, add);
    }
}

